/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;
import unbbayes.controller.ConfigurationsController;
import unbbayes.controller.FileHistoryController;
import unbbayes.controller.IconController;
import unbbayes.controller.JavaHelperController;
import unbbayes.controller.MainController;
import unbbayes.gui.AboutPane;
import unbbayes.gui.FileIcon;
import unbbayes.gui.MDIDesktopPane;
import unbbayes.gui.SimpleFileFilter;
import unbbayes.gui.resources.GuiResources;
import unbbayes.gui.util.SplitToggleButton;
import unbbayes.gui.util.TextAreaDialog;
import unbbayes.io.BaseIO;
import unbbayes.io.FileExtensionIODelegator;
import unbbayes.util.Debug;
import unbbayes.util.ResourceController;
import unbbayes.util.extension.UnBBayesModule;
import unbbayes.util.extension.UnBBayesModuleBuilder;
import unbbayes.util.extension.builder.NetworkWindowBuilder;
import unbbayes.util.extension.manager.UnBBayesPluginContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnBBayesFrame
extends JFrame {
    private static final long serialVersionUID = 0L;
    private MDIDesktopPane desktop;
    private JPanel topPanel;
    private JPanel bottomPanel;
    private JToolBar jtbFile;
    private JToolBar jtbView;
    private JToolBar jtbTools;
    private JToolBar jtbWindow;
    private JToolBar jtbHelp;
    private MainController controller;
    private JButton newNet;
    private JButton openNet;
    private JButton saveNet;
    private JButton metal;
    private JButton motif;
    private JButton homeSystem;
    private JButton tile;
    private JButton cascade;
    private JButton help;
    private JButton about;
    private URL helpSetURL;
    private HelpSet set;
    private JHelp jHelp;
    private ActionListener alNewBN;
    private ActionListener alOpen;
    private ActionListener alSave;
    private ActionListener alSaveAs;
    private ActionListener alExit;
    private ActionListener alTbFile;
    private ActionListener alTbView;
    private ActionListener alTbTools;
    private ActionListener alTbWindow;
    private ActionListener alTbHelp;
    private ActionListener alMetal;
    private ActionListener alMotif;
    private ActionListener alHomeSystem;
    private ActionListener alCascade;
    private ActionListener alTile;
    private ActionListener alHelp;
    private ActionListener alAbout;
    private JFileChooser chooser;
    private FileHistoryController fileHistoryController;
    protected IconController iconController = IconController.getInstance();
    private static UnBBayesFrame singleton = null;
    private static ResourceBundle resource = ResourceController.newInstance().getBundle(GuiResources.class.getName());
    private JMenuBar menu;
    private JToolBar pluginToolBar;
    private SplitToggleButton pluginSplitButton;
    private JMenu pluginMenu;
    private UnBBayesPluginContextHolder unbbayesPluginContextHolder = UnBBayesPluginContextHolder.newInstance();
    private String pluginModuleExtensionPoint = "Module";
    private Map<String, Class> pluginMap = null;
    private JMenuItem reloadPluginsMenuItem;
    private JMenu newMenu;
    private JMenu toolsMenu;
    private JMenu samplingMenu;
    private SplitToggleButton toolsSplitButton;
    private Map<String, List<JComponent>> moduleCategoryToComponentsMap = new HashMap<String, List<JComponent>>();
    private JPopupMenu.Separator pluginMenuSeparator;
    private Map<JComponent, JComponent> mapOfComponentsToBeRemovedAtPluginReload = new HashMap<JComponent, JComponent>();
    private JToolBar jtbNew;

    public UnBBayesFrame(MainController _controller) {
        super(resource.getString("unbbayesTitle"));
        this.controller = _controller;
        this.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new ListenerCloserFrame());
        this.fileHistoryController = FileHistoryController.getInstance();
        Container contentPane = this.getContentPane();
        this.desktop = new MDIDesktopPane();
        this.topPanel = new JPanel(new FlowLayout(0));
        this.bottomPanel = new JPanel(new FlowLayout(0, 5, 1));
        this.createActionListeners();
        this.createMenu();
        this.createToolBars();
        this.assignActionListeners();
        contentPane.add((Component)this.topPanel, "North");
        contentPane.add((Component)new JScrollPane(this.desktop), "Center");
        contentPane.add((Component)this.bottomPanel, "South");
        this.setIconImage(this.iconController.getUnBBayesIcon().getImage());
        this.setLocationByPlatform(true);
        this.setExtendedState(6);
        this.setVisible(true);
        singleton = this;
        this.setModuleCategoryToComponentsMap(this.buildModuleCategoryToComponentsMap());
        this.loadPlugins();
        this.updatePluginMenuVisibility();
    }

    protected void updatePluginMenuVisibility() {
        if (this.getPluginSplitButton().getMenu().getComponents() == null || this.getPluginSplitButton().getMenu().getComponents().length == 0) {
            this.getPluginToolBar().setVisible(false);
        } else {
            this.getPluginToolBar().setVisible(true);
        }
        if (this.getPluginMenu().getPopupMenu().getComponents() == null || this.getPluginMenu().getPopupMenu().getComponents().length <= 2) {
            this.getPluginMenuSeparator().setVisible(false);
        } else {
            this.getPluginMenuSeparator().setVisible(true);
        }
        if (this.getToolsSplitButton().getMenu().getComponents() == null || this.getToolsSplitButton().getMenu().getComponents().length == 0) {
            this.getJtbTools().setVisible(false);
        } else {
            this.getJtbTools().setVisible(true);
        }
        if (this.getToolsMenu().getPopupMenu().getComponents() == null || this.getToolsMenu().getPopupMenu().getComponents().length == 0) {
            this.getToolsMenu().setVisible(false);
        } else {
            this.getToolsMenu().setVisible(true);
        }
        if (this.getSamplingMenu().getPopupMenu().getComponents() == null || this.getSamplingMenu().getPopupMenu().getComponents().length == 0) {
            this.getSamplingMenu().setVisible(false);
        } else {
            this.getSamplingMenu().setVisible(true);
        }
        this.repaint();
    }

    private void setLnF(String lnfName) {
        try {
            if (lnfName.equals("system")) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(lnfName);
            }
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (UnsupportedLookAndFeelException ex1) {
            System.err.println(String.valueOf(resource.getString("LookAndFeelUnsupportedException")) + lnfName);
        }
        catch (ClassNotFoundException ex2) {
            System.err.println(String.valueOf(resource.getString("LookAndFeelClassNotFoundException")) + lnfName);
        }
        catch (InstantiationException ex3) {
            System.err.println(String.valueOf(resource.getString("LookAndFeelInstantiationException")) + lnfName);
        }
        catch (IllegalAccessException ex4) {
            System.err.println(String.valueOf(resource.getString("LookAndFeelIllegalAccessException")) + lnfName);
        }
    }

    public JInternalFrame getSelectedWindow() {
        return this.desktop.getSelectedFrame();
    }

    public void addWindow(JInternalFrame newWindow) {
        this.desktop.add(newWindow);
    }

    public void addWindow(UnBBayesModule newModule) {
        this.desktop.add(newModule);
        newModule.setUnbbayesFrame(this);
    }

    public void createActionListeners() {
        this.alNewBN = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UnBBayesFrame.this.setCursor(new Cursor(3));
                UnBBayesFrame.this.controller.newPN();
                UnBBayesFrame.this.setCursor(new Cursor(0));
            }
        };
        this.alOpen = new OpenFileUsingModulesActionListener(null);
        this.alSave = new ActionListener(){

            /*
             * Enabled aggressive block sorting
             */
            public void actionPerformed(ActionEvent ae) {
                UnBBayesFrame.this.setCursor(new Cursor(3));
                String[] nets = null;
                String filterMessage = null;
                String dialogueTitle = null;
                JInternalFrame focusedInnerFrame = UnBBayesFrame.this.desktop.getSelectedFrame();
                UnBBayesModule currentWindow = null;
                if (focusedInnerFrame == null) {
                    Debug.println(this.getClass(), "No focused window to save.");
                    UnBBayesFrame.this.setCursor(new Cursor(0));
                    return;
                }
                if (!(focusedInnerFrame instanceof UnBBayesModule)) {
                    UnBBayesFrame.this.setCursor(new Cursor(0));
                    return;
                }
                currentWindow = (UnBBayesModule)focusedInnerFrame;
                nets = currentWindow.getSupportedFileExtensions(false);
                filterMessage = currentWindow.getSupportedFilesDescription(false);
                File file = currentWindow.getFile();
                if (file == null) {
                    file = UnBBayesFrame.this.chooseFile(filterMessage, nets);
                    currentWindow.setFile(file);
                }
                dialogueTitle = currentWindow.getSavingMessage();
                if (file != null) {
                    UnBBayesFrame.this.saveNetwork(currentWindow, file);
                }
                UnBBayesFrame.this.setCursor(new Cursor(0));
            }
        };
        this.alSaveAs = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UnBBayesFrame.this.setCursor(new Cursor(3));
                String[] nets = null;
                String filterMessage = null;
                String dialogueTitle = null;
                JInternalFrame focusedInnerFrame = UnBBayesFrame.this.desktop.getSelectedFrame();
                UnBBayesModule currentWindow = null;
                if (focusedInnerFrame != null) {
                    if (!(focusedInnerFrame instanceof UnBBayesModule)) {
                        UnBBayesFrame.this.setCursor(new Cursor(0));
                        return;
                    }
                } else {
                    Debug.println(this.getClass(), "No focused window to save.");
                    UnBBayesFrame.this.setCursor(new Cursor(0));
                    return;
                }
                currentWindow = (UnBBayesModule)focusedInnerFrame;
                nets = currentWindow.getSupportedFileExtensions(false);
                filterMessage = currentWindow.getSupportedFilesDescription(false);
                dialogueTitle = currentWindow.getSavingMessage();
                File file = UnBBayesFrame.this.chooseFile(filterMessage, nets);
                currentWindow.setFile(file);
                if (file != null) {
                    UnBBayesFrame.this.saveNetwork(currentWindow, file);
                }
                UnBBayesFrame.this.setCursor(new Cursor(0));
            }
        };
        this.alExit = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    UnBBayesFrame.this.controller.saveConfigurations();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                UnBBayesFrame.this.setVisible(false);
                UnBBayesFrame.this.dispose();
                System.exit(0);
            }
        };
        this.alTbFile = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UnBBayesFrame.this.setCursor(new Cursor(3));
                if (((JCheckBoxMenuItem)e.getSource()).getState()) {
                    UnBBayesFrame.this.topPanel.add(UnBBayesFrame.this.jtbFile);
                } else {
                    UnBBayesFrame.this.topPanel.remove(UnBBayesFrame.this.jtbFile);
                }
                UnBBayesFrame.this.validate();
                UnBBayesFrame.this.setCursor(new Cursor(0));
            }
        };
        this.alTbView = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UnBBayesFrame.this.setCursor(new Cursor(3));
                if (((JCheckBoxMenuItem)e.getSource()).getState()) {
                    UnBBayesFrame.this.topPanel.add(UnBBayesFrame.this.jtbView);
                } else {
                    UnBBayesFrame.this.topPanel.remove(UnBBayesFrame.this.jtbView);
                }
                UnBBayesFrame.this.validate();
                UnBBayesFrame.this.setCursor(new Cursor(0));
            }
        };
        this.alTbTools = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UnBBayesFrame.this.setCursor(new Cursor(3));
                if (((JCheckBoxMenuItem)e.getSource()).getState()) {
                    UnBBayesFrame.this.topPanel.add(UnBBayesFrame.this.jtbTools);
                } else {
                    UnBBayesFrame.this.topPanel.remove(UnBBayesFrame.this.jtbTools);
                }
                UnBBayesFrame.this.validate();
                UnBBayesFrame.this.setCursor(new Cursor(0));
            }
        };
        this.alTbWindow = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UnBBayesFrame.this.setCursor(new Cursor(3));
                if (((JCheckBoxMenuItem)e.getSource()).getState()) {
                    UnBBayesFrame.this.topPanel.add(UnBBayesFrame.this.jtbWindow);
                } else {
                    UnBBayesFrame.this.topPanel.remove(UnBBayesFrame.this.jtbWindow);
                }
                UnBBayesFrame.this.validate();
                UnBBayesFrame.this.setCursor(new Cursor(0));
            }
        };
        this.alTbHelp = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UnBBayesFrame.this.setCursor(new Cursor(3));
                if (((JCheckBoxMenuItem)e.getSource()).getState()) {
                    UnBBayesFrame.this.topPanel.add(UnBBayesFrame.this.jtbHelp);
                } else {
                    UnBBayesFrame.this.topPanel.remove(UnBBayesFrame.this.jtbHelp);
                }
                UnBBayesFrame.this.validate();
                UnBBayesFrame.this.setCursor(new Cursor(0));
            }
        };
        this.alMetal = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UnBBayesFrame.this.setCursor(new Cursor(3));
                UnBBayesFrame.this.setLnF("javax.swing.plaf.metal.MetalLookAndFeel");
                MetalLookAndFeel.setCurrentTheme(new OceanTheme());
                UnBBayesFrame.this.setCursor(new Cursor(0));
            }
        };
        this.alMotif = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UnBBayesFrame.this.setCursor(new Cursor(3));
                UnBBayesFrame.this.setLnF("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                UnBBayesFrame.this.setCursor(new Cursor(0));
            }
        };
        this.alHomeSystem = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UnBBayesFrame.this.setCursor(new Cursor(3));
                UnBBayesFrame.this.setLnF("system");
                UnBBayesFrame.this.setCursor(new Cursor(0));
            }
        };
        this.alCascade = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UnBBayesFrame.this.desktop.cascadeFrames();
            }
        };
        this.alTile = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UnBBayesFrame.this.desktop.tileFrames();
            }
        };
        this.alHelp = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    JavaHelperController.getInstance().openHelp(singleton);
                }
                catch (Exception evt) {
                    evt.printStackTrace();
                }
            }
        };
        this.alAbout = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        UnBBayesFrame.this.showAboutPane();
                    }
                });
            }
        };
    }

    protected File chooseFile(String filterMessage, String[] nets) {
        this.chooser = new JFileChooser(this.fileHistoryController.getCurrentDirectory());
        this.chooser.setMultiSelectionEnabled(false);
        this.chooser.setFileSelectionMode(2);
        this.chooser.setFileView(new FileIcon(this));
        this.chooser.addChoosableFileFilter(new SimpleFileFilter(nets, filterMessage));
        int option = this.chooser.showSaveDialog(null);
        if (option == 0) {
            File file = this.chooser.getSelectedFile();
            return file;
        }
        return null;
    }

    protected void saveNetwork(UnBBayesModule currentWindow, File file) {
        try {
            if (this.controller.saveNet(file, currentWindow)) {
                JOptionPane.showMessageDialog(this, resource.getString("saveSucess"), resource.getString("sucess"), 1);
                ConfigurationsController.getInstance().addFileToListRecentFiles(file);
            }
        }
        catch (FileExtensionIODelegator.MoreThanOneCompatibleIOException more) {
            Object[] possibleValues = FileExtensionIODelegator.getNamesFromIOs(more.getIOs());
            String selectedValue = (String)JOptionPane.showInputDialog(this, resource.getString("IOConflictMessage"), resource.getString("IOConflictTitle"), 1, null, possibleValues, possibleValues[0]);
            if (selectedValue != null) {
                BaseIO io = FileExtensionIODelegator.findIOByName(more.getIOs(), selectedValue);
                try {
                    if (this.controller.saveNet(file, io, currentWindow.getPersistingGraph())) {
                        JOptionPane.showMessageDialog(this, resource.getString("saveSucess"), resource.getString("sucess"), 2);
                    }
                    ConfigurationsController.getInstance().addFileToListRecentFiles(file);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, e.getMessage(), resource.getString("error"), 0);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), resource.getString("error"), 0);
        }
    }

    private void showAboutPane() {
        AboutPane abourPane = new AboutPane();
        abourPane.pack();
        abourPane.setVisible(true);
    }

    public void createMenu() {
        this.menu = new JMenuBar();
        JMenu fileMenu = new JMenu(resource.getString("fileMenu"));
        JMenu recentFilesMenu = new JMenu(resource.getString("recentFilesMenu"));
        JMenu lafMenu = new JMenu(resource.getString("lafMenu"));
        JMenu viewMenu = new JMenu(resource.getString("viewMenu"));
        JMenu tbMenu = new JMenu(resource.getString("tbMenu"));
        this.newMenu = new JMenu(resource.getString("newMenu"));
        this.toolsMenu = new JMenu(resource.getString("toolsMenu"));
        this.samplingMenu = new JMenu(resource.getString("samplingMenu"));
        JMenu windowMenu = new JMenu(resource.getString("windowMenu"));
        JMenu helpMenu = new JMenu(resource.getString("helpMenu"));
        fileMenu.setMnemonic(resource.getString("fileMenuMn").charAt(0));
        recentFilesMenu.setMnemonic(resource.getString("recentFilesMn").charAt(0));
        this.newMenu.setMnemonic(resource.getString("newMenuMn").charAt(0));
        lafMenu.setMnemonic(resource.getString("lafMenuMn").charAt(0));
        viewMenu.setMnemonic(resource.getString("viewMenuMn").charAt(0));
        tbMenu.setMnemonic(resource.getString("tbMenuMn").charAt(0));
        this.toolsMenu.setMnemonic(resource.getString("toolsMenuMn").charAt(0));
        windowMenu.setMnemonic(resource.getString("windowMenuMn").charAt(0));
        helpMenu.setMnemonic(resource.getString("helpMenuMn").charAt(0));
        JMenuItem newBN = new JMenuItem(resource.getString("newBN"), this.iconController.getNewBNIcon());
        newBN.setMnemonic(resource.getString("newBNMn").charAt(0));
        JMenuItem openItem = new JMenuItem(resource.getString("openItem"), this.iconController.getOpenIcon());
        JMenuItem saveItem = new JMenuItem(resource.getString("saveItem"), this.iconController.getSaveIcon());
        JMenuItem saveAsItem = new JMenuItem(resource.getString("saveAsItem"), this.iconController.getSaveIcon());
        JMenuItem exitItem = new JMenuItem(resource.getString("exitItem"), 88);
        JCheckBoxMenuItem tbFile = new JCheckBoxMenuItem(resource.getString("tbFile"), true);
        JCheckBoxMenuItem tbNewProject = new JCheckBoxMenuItem(resource.getString("tbNewProject"), true);
        JCheckBoxMenuItem tbView = new JCheckBoxMenuItem(resource.getString("tbView"), true);
        JCheckBoxMenuItem tbTools = new JCheckBoxMenuItem(resource.getString("tbTools"), true);
        JCheckBoxMenuItem tbWindow = new JCheckBoxMenuItem(resource.getString("tbWindow"), true);
        JCheckBoxMenuItem tbHelp = new JCheckBoxMenuItem(resource.getString("tbHelp"), true);
        JCheckBoxMenuItem tbPlugin = new JCheckBoxMenuItem(resource.getString("tbPlugin"), true);
        JMenuItem metalItem = new JMenuItem(resource.getString("metalItem"), this.iconController.getMetalIcon());
        JMenuItem motifItem = new JMenuItem(resource.getString("motifItem"), this.iconController.getMotifIcon());
        JMenuItem homeItem = new JMenuItem(resource.getString("windowsItem"), this.iconController.getHomeIcon());
        JMenuItem cascadeItem = new JMenuItem(resource.getString("cascadeItem"), this.iconController.getCascadeIcon());
        JMenuItem tileItem = new JMenuItem(resource.getString("tileItem"), this.iconController.getTileIcon());
        JMenuItem helpItem = new JMenuItem(resource.getString("helpItem"), this.iconController.getHelpIcon());
        JMenuItem aboutItem = new JMenuItem(resource.getString("aboutItem"));
        openItem.setMnemonic(resource.getString("openItemMn").charAt(0));
        saveItem.setMnemonic(resource.getString("saveItemMn").charAt(0));
        saveAsItem.setMnemonic(resource.getString("saveAsItemMn").charAt(0));
        exitItem.setMnemonic(resource.getString("exitItemMn").charAt(0));
        metalItem.setMnemonic(resource.getString("metalItemMn").charAt(0));
        motifItem.setMnemonic(resource.getString("motifItemMn").charAt(0));
        homeItem.setMnemonic(resource.getString("windowsItemMn").charAt(0));
        cascadeItem.setMnemonic(resource.getString("cascadeItemMn").charAt(0));
        tileItem.setMnemonic(resource.getString("tileItemMn").charAt(0));
        helpItem.setMnemonic(resource.getString("helpItemMn").charAt(0));
        aboutItem.setMnemonic(resource.getString("aboutItemMn").charAt(0));
        newBN.setAccelerator(KeyStroke.getKeyStroke(resource.getString("newItemMn").charAt(0), 2, false));
        openItem.setAccelerator(KeyStroke.getKeyStroke(resource.getString("openItemMn").charAt(0), 2, false));
        saveItem.setAccelerator(KeyStroke.getKeyStroke(resource.getString("saveItemMn").charAt(0), 2, false));
        saveAsItem.setAccelerator(KeyStroke.getKeyStroke(resource.getString("saveAsItemMn").charAt(0), 2, false));
        helpItem.setAccelerator(KeyStroke.getKeyStroke(resource.getString("helpItemMn").charAt(0), 2, false));
        newBN.addActionListener(this.alNewBN);
        openItem.addActionListener(this.alOpen);
        saveItem.addActionListener(this.alSave);
        saveAsItem.addActionListener(this.alSaveAs);
        exitItem.addActionListener(this.alExit);
        tbFile.addActionListener(this.alTbFile);
        tbView.addActionListener(this.alTbView);
        tbTools.addActionListener(this.alTbTools);
        tbWindow.addActionListener(this.alTbWindow);
        tbHelp.addActionListener(this.alTbHelp);
        tbNewProject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UnBBayesFrame.this.setCursor(new Cursor(3));
                if (((JCheckBoxMenuItem)e.getSource()).getState()) {
                    UnBBayesFrame.this.topPanel.add(UnBBayesFrame.this.getJtbNew());
                } else {
                    UnBBayesFrame.this.topPanel.remove(UnBBayesFrame.this.getJtbNew());
                }
                UnBBayesFrame.this.validate();
                UnBBayesFrame.this.setCursor(new Cursor(0));
            }
        });
        tbPlugin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UnBBayesFrame.this.setCursor(new Cursor(3));
                if (((JCheckBoxMenuItem)e.getSource()).getState()) {
                    UnBBayesFrame.this.topPanel.add(UnBBayesFrame.this.getPluginToolBar());
                } else {
                    UnBBayesFrame.this.topPanel.remove(UnBBayesFrame.this.getPluginToolBar());
                }
                UnBBayesFrame.this.validate();
                UnBBayesFrame.this.setCursor(new Cursor(0));
            }
        });
        metalItem.addActionListener(this.alMetal);
        motifItem.addActionListener(this.alMotif);
        homeItem.addActionListener(this.alHomeSystem);
        cascadeItem.addActionListener(this.alCascade);
        tileItem.addActionListener(this.alTile);
        helpItem.addActionListener(this.alHelp);
        aboutItem.addActionListener(this.alAbout);
        this.newMenu.add(newBN);
        fileMenu.add(this.newMenu);
        fileMenu.add(openItem);
        fileMenu.add(saveItem);
        fileMenu.add(saveAsItem);
        fileMenu.addSeparator();
        fileMenu.add(recentFilesMenu);
        ConfigurationsController configController = ConfigurationsController.getInstance();
        for (String nameOfFile : configController.getConfigurations().getPreviewOpenFiles()) {
            File file = new File(nameOfFile);
            JMenuItem fileMenuItem = new JMenuItem(nameOfFile);
            fileMenuItem.addActionListener(new OpenFileUsingModulesActionListener(file));
            recentFilesMenu.add(fileMenuItem);
        }
        fileMenu.addSeparator();
        fileMenu.add(exitItem);
        lafMenu.add(metalItem);
        lafMenu.add(motifItem);
        lafMenu.add(homeItem);
        tbMenu.add(tbNewProject);
        tbMenu.add(tbFile);
        tbMenu.add(tbView);
        tbMenu.add(tbTools);
        tbMenu.add(tbWindow);
        tbMenu.add(tbHelp);
        tbMenu.add(tbPlugin);
        viewMenu.add(tbMenu);
        viewMenu.addSeparator();
        viewMenu.add(lafMenu);
        windowMenu.add(cascadeItem);
        windowMenu.add(tileItem);
        helpMenu.add(helpItem);
        helpMenu.add(aboutItem);
        this.menu.add(fileMenu);
        this.menu.add(viewMenu);
        this.menu.add(this.toolsMenu);
        this.menu.add(this.samplingMenu);
        this.menu.add(windowMenu);
        this.menu.add(helpMenu);
        this.setJMenuBar(this.menu);
    }

    protected Map<String, List<JComponent>> buildModuleCategoryToComponentsMap() {
        HashMap<String, List<JComponent>> newMap = new HashMap<String, List<JComponent>>();
        ArrayList<JComponent> componentList = new ArrayList<JComponent>();
        componentList.add(this.getNewMenu());
        componentList.add(this.getJtbNew());
        newMap.put("bn", componentList);
        componentList = new ArrayList();
        componentList.add(this.getSamplingMenu());
        newMap.put("sampling", componentList);
        componentList = new ArrayList();
        componentList.add(this.getToolsMenu());
        componentList.add(this.getToolsSplitButton());
        newMap.put("tool", componentList);
        return newMap;
    }

    protected void createPluginToolBars() {
        if (this.pluginToolBar != null) {
            this.topPanel.remove(this.pluginToolBar);
        }
        this.pluginToolBar = new JToolBar();
        this.pluginToolBar.setSize(this.pluginToolBar.getWidth(), this.jtbFile.getHeight());
        this.pluginToolBar.setToolTipText(resource.getString("pluginMenu"));
        this.setPluginSplitButton(new SplitToggleButton());
        this.pluginToolBar.add(this.getPluginSplitButton());
        this.getPluginSplitButton().setToolTipText(resource.getString("pluginMenu"));
        this.topPanel.add(this.pluginToolBar);
    }

    protected void createPluginMenu() {
        if (this.pluginMenu != null) {
            this.menu.remove(this.pluginMenu);
        }
        this.pluginMenu = new JMenu(resource.getString("pluginMenu"));
        this.pluginMenu.setMnemonic(resource.getString("pluginMenu").charAt(0));
        this.reloadPluginsMenuItem = new JMenuItem(resource.getString("reloadPlugin"));
        this.reloadPluginsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UnBBayesFrame.this.reloadPlugins();
            }
        });
        this.reloadPluginsMenuItem.setToolTipText(resource.getString("reloadPluginToolTip"));
        this.pluginMenu.add(this.reloadPluginsMenuItem);
        this.pluginMenuSeparator = new JPopupMenu.Separator();
        this.pluginMenu.add(this.pluginMenuSeparator);
        int menuItemsNumber = this.menu.getMenuCount();
        this.menu.add((Component)this.pluginMenu, menuItemsNumber - 1);
        ArrayList<JMenu> componentList = new ArrayList<JMenu>();
        componentList.add(this.pluginMenu);
        this.getModuleCategoryToComponentsMap().put("plugins", componentList);
    }

    protected void reloadPlugins() {
        this.createMenu();
        this.removePluginButtonsFromOtherComponents(this.getMapOfComponentsToBeRemovedAtPluginReload());
        this.setModuleCategoryToComponentsMap(this.buildModuleCategoryToComponentsMap());
        this.loadPlugins();
        this.updatePluginMenuVisibility();
        this.getUnbbayesPluginContextHolder().notifyReload(this);
        this.repaint();
    }

    public Map<String, Class> getCoreUnBBayesModulesClasses() {
        HashMap<String, Class> ret = new HashMap<String, Class>();
        try {
            ret.put(resource.getString("PNModuleName"), NetworkWindowBuilder.class);
        }
        catch (Exception e) {
            throw new RuntimeException(String.valueOf(resource.getString("moduleLoadingError")) + resource.getString("PNModuleName"));
        }
        return ret;
    }

    public void showPluginDependencyError() {
        try {
            Map<String, Set<String>> errorMap = this.getUnbbayesPluginContextHolder().getErroneousPluginIDDependencyMap();
            if (!errorMap.isEmpty()) {
                TextAreaDialog dialog = new TextAreaDialog(this, resource.getString("pluginDependencyLogTitle"), false);
                String dialogContent = "=============================================================\n";
                dialogContent = String.valueOf(dialogContent) + resource.getString("pluginDependencyLogKeyMessage");
                dialogContent = String.valueOf(dialogContent) + "\n=============================================================\n";
                for (String pluginID : errorMap.keySet()) {
                    dialogContent = String.valueOf(dialogContent) + "\n\n";
                    dialogContent = String.valueOf(dialogContent) + "-> " + resource.getString("pluginDependencyLogID");
                    dialogContent = String.valueOf(dialogContent) + " \"" + pluginID + "\"";
                    dialogContent = String.valueOf(dialogContent) + "\n     " + resource.getString("pluginDependencyLogDependencies");
                    for (String dependency : errorMap.get(pluginID)) {
                        dialogContent = String.valueOf(dialogContent) + "\n\t - \"" + dependency + "\";";
                    }
                    dialogContent = String.valueOf(dialogContent) + "\n\n";
                }
                dialogContent = String.valueOf(dialogContent) + "\n=============================================================\n";
                dialogContent = String.valueOf(dialogContent) + resource.getString("pluginDependencyLogPleaseCheck");
                dialogContent = String.valueOf(dialogContent) + "\n=============================================================\n";
                dialog.setTextContent(dialogContent);
                dialog.pack();
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
            }
        }
        catch (Throwable e) {
            System.err.println("Could not retrieve plugin dependency errors.");
            e.printStackTrace();
        }
    }

    public void loadPlugins() {
        this.setPluginList(this.getCoreUnBBayesModulesClasses());
        this.createPluginMenu();
        this.createPluginToolBars();
        try {
            this.getUnbbayesPluginContextHolder().publishPlugins();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.getPluginToolBar().setVisible(false);
            return;
        }
        PluginDescriptor core = this.getUnbbayesPluginContextHolder().getPluginManager().getRegistry().getPluginDescriptor(this.getUnbbayesPluginContextHolder().getPluginCoreID());
        ExtensionPoint point = this.getUnbbayesPluginContextHolder().getPluginManager().getRegistry().getExtensionPoint(core.getId(), this.getPluginModuleExtensionPoint());
        this.getPluginMap().putAll(this.fillCorePluginMenuAndButtons(this.getUnbbayesPluginContextHolder().getPluginManager(), point));
        this.showPluginDependencyError();
    }

    protected Map<String, Class> fillCorePluginMenuAndButtons(PluginManager pluginManager, ExtensionPoint point) {
        HashMap<String, Class> ret = new HashMap<String, Class>();
        for (Extension ext : point.getConnectedExtensions()) {
            try {
                PluginDescriptor descr = ext.getDeclaringPluginDescriptor();
                pluginManager.activatePlugin(descr.getId());
                Extension.Parameter nameParam = ext.getParameter("name");
                Extension.Parameter classParam = ext.getParameter("class");
                Extension.Parameter descriptionParam = ext.getParameter("description");
                Extension.Parameter iconParam = ext.getParameter("icon");
                Extension.Parameter builderParam = ext.getParameter("builder");
                Extension.Parameter categoryParam = ext.getParameter("category");
                PluginClassLoader classLoader = pluginManager.getPluginClassLoader(descr);
                Class<?> pluginOrBuilderCls = null;
                pluginOrBuilderCls = builderParam != null ? classLoader.loadClass(builderParam.valueAsString()) : classLoader.loadClass(classParam.valueAsString());
                ImageIcon icon = null;
                if (iconParam != null) {
                    URL iconUrl = pluginManager.getPluginClassLoader(ext.getDeclaringPluginDescriptor()).getResource(iconParam.valueAsString());
                    ImageIcon imageIcon = icon = iconUrl != null ? new ImageIcon(iconUrl) : null;
                }
                if (icon == null) {
                    icon = IconController.getInstance().getNewIcon();
                }
                JButton button = new JButton(icon);
                button.setToolTipText(descriptionParam.valueAsString());
                String moduleName = "";
                if (nameParam != null) {
                    moduleName = nameParam.valueAsString();
                } else {
                    moduleName = this.getUnBBayesModuleNameByPluginClass(pluginOrBuilderCls);
                    if (moduleName == null) {
                        moduleName = "UnBBayesModule";
                    }
                }
                JMenuItem menuItem = new JMenuItem(moduleName, icon);
                menuItem.setToolTipText(descriptionParam.valueAsString());
                ActionListenerSupportingConstructorParam listener = new ActionListenerSupportingConstructorParam(this, pluginOrBuilderCls){

                    public void actionPerformed(ActionEvent e) {
                        this.setCursor(new Cursor(3));
                        UnBBayesModule module = null;
                        try {
                            module = this.getUnBBayesModuleByPluginClass((Class)this.getParam());
                            this.addWindow(module);
                        }
                        catch (Throwable t) {
                            this.setCursor(new Cursor(0));
                            throw new RuntimeException(t);
                        }
                        this.setCursor(new Cursor(0));
                    }
                };
                button.addActionListener(listener);
                menuItem.addActionListener(listener);
                List<JComponent> mappedElements = this.getModuleCategoryToComponentsMap().get(categoryParam.valueAsString());
                if (mappedElements == null || mappedElements.isEmpty()) {
                    if (categoryParam.valueAsString() == null || categoryParam.valueAsString().length() == 0) {
                        mappedElements = new ArrayList<JComponent>();
                        mappedElements.add(this.getPluginMenu());
                    } else {
                        mappedElements = new ArrayList<JComponent>();
                        JMenu newMenu = new JMenu(categoryParam.valueAsString());
                        mappedElements.add(newMenu);
                        this.getMenu().add(newMenu);
                    }
                }
                boolean addToPluginMenuFlag = true;
                boolean addToSplitButton = true;
                for (JComponent comp : mappedElements) {
                    if (comp instanceof JMenu) {
                        ((JMenu)comp).add(menuItem);
                        addToPluginMenuFlag = false;
                        continue;
                    }
                    if (comp instanceof SplitToggleButton) {
                        SplitToggleButton spButton = (SplitToggleButton)comp;
                        JMenuItem splitButtonMenuItem = new JMenuItem(moduleName, icon);
                        splitButtonMenuItem.setToolTipText(descriptionParam.valueAsString());
                        splitButtonMenuItem.addActionListener(new SplitButtonMenuActionListener(spButton, button));
                        spButton.add(button, splitButtonMenuItem);
                        spButton.repaint();
                        addToSplitButton = false;
                        this.getMapOfComponentsToBeRemovedAtPluginReload().put(splitButtonMenuItem, spButton);
                        continue;
                    }
                    comp.add(button);
                    addToSplitButton = false;
                    this.getMapOfComponentsToBeRemovedAtPluginReload().put(button, comp);
                }
                if (addToPluginMenuFlag) {
                    this.getPluginMenu().add(menuItem);
                }
                if (addToSplitButton) {
                    JMenuItem splitButtonMenuItem = new JMenuItem(moduleName, icon);
                    splitButtonMenuItem.setToolTipText(descriptionParam.valueAsString());
                    splitButtonMenuItem.addActionListener(new SplitButtonMenuActionListener(this.getPluginSplitButton(), button));
                    this.getPluginSplitButton().add(button, splitButtonMenuItem);
                    this.getPluginSplitButton().repaint();
                }
                ret.put(moduleName, pluginOrBuilderCls);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    protected String getUnBBayesModuleNameByPluginClass(Class pluginOrBuilderCls) {
        try {
            if (UnBBayesModuleBuilder.class.isAssignableFrom(pluginOrBuilderCls)) {
                UnBBayesModuleBuilder builder = (UnBBayesModuleBuilder)pluginOrBuilderCls.newInstance();
                return builder.getName();
            }
            return ((UnBBayesModule)pluginOrBuilderCls.newInstance()).getName();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public UnBBayesModule getUnBBayesModuleByPluginClass(Class clazz) throws InstantiationException, IllegalAccessException {
        UnBBayesModule ret = null;
        if (clazz == null) {
            return ret;
        }
        if (UnBBayesModuleBuilder.class.isAssignableFrom(clazz)) {
            UnBBayesModuleBuilder builder = (UnBBayesModuleBuilder)clazz.newInstance();
            ret = builder.buildUnBBayesModule();
        } else {
            ret = (UnBBayesModule)clazz.newInstance();
        }
        return ret;
    }

    public void createToolBars() {
        this.createButtons();
        this.jtbNew = new JToolBar();
        this.jtbFile = new JToolBar();
        this.jtbView = new JToolBar();
        this.jtbTools = new JToolBar();
        this.jtbWindow = new JToolBar();
        this.jtbHelp = new JToolBar();
        this.setToolsSplitButton(new SplitToggleButton());
        this.jtbTools.add(this.getToolsSplitButton());
        this.getToolsSplitButton().setToolTipText(resource.getString("toolsMenu"));
        this.jtbNew.add(this.newNet);
        this.jtbFile.add(this.openNet);
        this.jtbFile.add(this.saveNet);
        this.jtbView.add(this.metal);
        this.jtbView.add(this.motif);
        this.jtbView.add(this.homeSystem);
        this.jtbWindow.add(this.cascade);
        this.jtbWindow.add(this.tile);
        this.jtbHelp.add(this.help);
        this.topPanel.add(this.jtbNew);
        this.topPanel.add(this.jtbFile);
        this.topPanel.add(this.jtbView);
        this.topPanel.add(this.jtbTools);
        this.topPanel.add(this.jtbWindow);
        this.topPanel.add(this.jtbHelp);
    }

    protected void removePluginButtonsFromOtherComponents(Map<JComponent, JComponent> map) {
        ArrayList<JComponent> removedKeys = new ArrayList<JComponent>();
        for (JComponent key : map.keySet()) {
            JComponent comp = map.get(key);
            comp.remove(key);
            removedKeys.add(key);
        }
        for (JComponent key : removedKeys) {
            map.remove(key);
        }
    }

    public void createButtons() {
        this.newNet = new JButton(this.iconController.getNewBNIcon());
        this.openNet = new JButton(this.iconController.getOpenIcon());
        this.saveNet = new JButton(this.iconController.getSaveIcon());
        this.metal = new JButton(this.iconController.getMetalIcon());
        this.motif = new JButton(this.iconController.getMotifIcon());
        this.homeSystem = new JButton(this.iconController.getHomeIcon());
        this.tile = new JButton(this.iconController.getTileIcon());
        this.cascade = new JButton(this.iconController.getCascadeIcon());
        this.help = new JButton(this.iconController.getHelpIcon());
        this.help.setToolTipText(resource.getString("helpToolTip"));
        this.newNet.setToolTipText(resource.getString("newToolTip"));
        this.openNet.setToolTipText(resource.getString("openToolTip"));
        this.saveNet.setToolTipText(resource.getString("saveToolTip"));
        this.metal.setToolTipText(resource.getString("metalToolTip"));
        this.motif.setToolTipText(resource.getString("motifToolTip"));
        this.homeSystem.setToolTipText(resource.getString("homeSystemToolTip"));
        this.tile.setToolTipText(resource.getString("tileToolTip"));
        this.cascade.setToolTipText(resource.getString("cascadeToolTip"));
    }

    public void assignActionListeners() {
        this.newNet.addActionListener(this.alNewBN);
        this.openNet.addActionListener(this.alOpen);
        this.saveNet.addActionListener(this.alSave);
        this.metal.addActionListener(this.alMetal);
        this.motif.addActionListener(this.alMotif);
        this.homeSystem.addActionListener(this.alHomeSystem);
        this.tile.addActionListener(this.alTile);
        this.cascade.addActionListener(this.alCascade);
        this.help.addActionListener(this.alHelp);
    }

    public static UnBBayesFrame getIUnBBayes() {
        return singleton;
    }

    public JToolBar getPluginToolBar() {
        return this.pluginToolBar;
    }

    public void setPluginToolBar(JToolBar pluginToolBar) {
        this.pluginToolBar = pluginToolBar;
    }

    public JMenu getPluginMenu() {
        return this.pluginMenu;
    }

    public void setPluginMenu(JMenu pluginMenu) {
        this.pluginMenu = pluginMenu;
    }

    public String getPluginModuleExtensionPoint() {
        return this.pluginModuleExtensionPoint;
    }

    public void setPluginModuleExtensionPoint(String pluginModuleExtensionPoint) {
        this.pluginModuleExtensionPoint = pluginModuleExtensionPoint;
    }

    public Map<String, Class> getPluginMap() {
        if (this.pluginMap == null) {
            this.pluginMap = new HashMap<String, Class>();
        }
        return this.pluginMap;
    }

    public void setPluginList(Map<String, Class> pluginMap) {
        this.pluginMap = pluginMap;
    }

    public JMenuBar getMenu() {
        return this.menu;
    }

    public void setMenu(JMenuBar menu) {
        this.menu = menu;
    }

    public JMenuItem getReloadPluginsItem() {
        return this.reloadPluginsMenuItem;
    }

    public void setReloadPluginsItem(JMenuItem reloadPluginsItem) {
        this.reloadPluginsMenuItem = reloadPluginsItem;
    }

    public Map<String, UnBBayesModule> getUnBBayesModulesByFile(File file, Map<String, Class> plugins) {
        HashMap<String, UnBBayesModule> ret = new HashMap<String, UnBBayesModule>();
        if (plugins != null) {
            for (String id : plugins.keySet()) {
                try {
                    UnBBayesModule module = this.getUnBBayesModuleByPluginClass(plugins.get(id));
                    module.setVisible(false);
                    if (module.getIO() == null || !module.getIO().supports(file, true)) continue;
                    ret.put(id, module);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    public String[] getAllSupportedFileExtensions(Collection<Class> plugins) {
        HashSet<String> ret = new HashSet<String>();
        if (plugins != null) {
            for (Class clazz : plugins) {
                try {
                    UnBBayesModule module = this.getUnBBayesModuleByPluginClass(clazz);
                    module.setVisible(false);
                    String[] extensions = module.getSupportedFileExtensions(true);
                    if (extensions != null) {
                        String[] stringArray = extensions;
                        int n = extensions.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String ext = stringArray[n2];
                            if (ext != null && ext.trim().length() > 0) {
                                ret.add(ext);
                            }
                            ++n2;
                        }
                    }
                    module.dispose();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return ret.toArray(new String[ret.size()]);
    }

    public UnBBayesPluginContextHolder getUnbbayesPluginContextHolder() {
        return this.unbbayesPluginContextHolder;
    }

    public void setUnbbayesPluginContextHolder(UnBBayesPluginContextHolder unbbayesPluginContextHolder) {
        this.unbbayesPluginContextHolder = unbbayesPluginContextHolder;
    }

    public SplitToggleButton getPluginSplitButton() {
        return this.pluginSplitButton;
    }

    public void setPluginSplitButton(SplitToggleButton pluginSplitButton) {
        this.pluginSplitButton = pluginSplitButton;
    }

    public JMenu getNewMenu() {
        return this.newMenu;
    }

    public JMenu getToolsMenu() {
        return this.toolsMenu;
    }

    public JMenu getSamplingMenu() {
        return this.samplingMenu;
    }

    public JToolBar getJtbFile() {
        return this.jtbFile;
    }

    public Map<String, List<JComponent>> getModuleCategoryToComponentsMap() {
        return this.moduleCategoryToComponentsMap;
    }

    public void setModuleCategoryToComponentsMap(Map<String, List<JComponent>> moduleCategoryToComponentsMap) {
        this.moduleCategoryToComponentsMap = moduleCategoryToComponentsMap;
    }

    public JPopupMenu.Separator getPluginMenuSeparator() {
        return this.pluginMenuSeparator;
    }

    public void setPluginMenuSeparator(JPopupMenu.Separator pluginMenuSeparator) {
        this.pluginMenuSeparator = pluginMenuSeparator;
    }

    public Map<JComponent, JComponent> getMapOfComponentsToBeRemovedAtPluginReload() {
        return this.mapOfComponentsToBeRemovedAtPluginReload;
    }

    public void setMapOfComponentsToBeRemovedAtPluginReload(Map<JComponent, JComponent> listOfBNModulesAtFileJTB) {
        this.mapOfComponentsToBeRemovedAtPluginReload = listOfBNModulesAtFileJTB;
    }

    public JToolBar getJtbNew() {
        return this.jtbNew;
    }

    public void setJtbNew(JToolBar jtbNew) {
        this.jtbNew = jtbNew;
    }

    public MainController getController() {
        return this.controller;
    }

    public void setController(MainController controller) {
        this.controller = controller;
    }

    public MDIDesktopPane getDesktop() {
        return this.desktop;
    }

    public void setDesktop(MDIDesktopPane desktop) {
        this.desktop = desktop;
    }

    public JToolBar getJtbTools() {
        return this.jtbTools;
    }

    public void setJtbTools(JToolBar jtbTools) {
        this.jtbTools = jtbTools;
    }

    public SplitToggleButton getToolsSplitButton() {
        return this.toolsSplitButton;
    }

    public void setToolsSplitButton(SplitToggleButton toolsSplitButton) {
        this.toolsSplitButton = toolsSplitButton;
    }

    protected abstract class ActionListenerSupportingConstructorParam
    implements ActionListener {
        private Object param;

        public ActionListenerSupportingConstructorParam(Object param) {
            this.param = param;
        }

        public Object getParam() {
            return this.param;
        }

        public void setParam(Object param) {
            this.param = param;
        }
    }

    public class ListenerCloserFrame
    implements WindowListener {
        public void windowOpened(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
            try {
                UnBBayesFrame.this.controller.saveConfigurations();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowDeactivated(WindowEvent e) {
        }
    }

    public class OpenFileUsingModulesActionListener
    implements ActionListener {
        private File file = null;

        public OpenFileUsingModulesActionListener(File file) {
            this.file = file;
        }

        public File showFileChooser() {
            UnBBayesFrame.this.chooser = new JFileChooser(UnBBayesFrame.this.fileHistoryController.getCurrentDirectory());
            UnBBayesFrame.this.chooser.setDialogTitle(resource.getString("openTitle"));
            UnBBayesFrame.this.chooser.setMultiSelectionEnabled(false);
            UnBBayesFrame.this.chooser.setFileSelectionMode(2);
            UnBBayesFrame.this.chooser.setFileView(new FileIcon(UnBBayesFrame.this));
            for (Class clazz : UnBBayesFrame.this.getPluginMap().values()) {
                UnBBayesModule mod;
                block5: {
                    mod = null;
                    try {
                        mod = UnBBayesFrame.this.getUnBBayesModuleByPluginClass(clazz);
                        if (mod == null) {
                        }
                        break block5;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                UnBBayesFrame.this.chooser.addChoosableFileFilter(new SimpleFileFilter(mod.getSupportedFileExtensions(true), mod.getSupportedFilesDescription(true)));
                mod.dispose();
            }
            UnBBayesFrame.this.chooser.addChoosableFileFilter(new SimpleFileFilter(UnBBayesFrame.this.getAllSupportedFileExtensions(UnBBayesFrame.this.getPluginMap().values()), resource.getString("allNetFileFilter")));
            int option = UnBBayesFrame.this.chooser.showOpenDialog(UnBBayesFrame.this);
            if (option == 0) {
                UnBBayesFrame.this.fileHistoryController.setCurrentDirectory(UnBBayesFrame.this.chooser.getCurrentDirectory());
                UnBBayesFrame.this.chooser.setVisible(false);
                UnBBayesFrame.this.chooser.setEnabled(false);
                return UnBBayesFrame.this.chooser.getSelectedFile();
            }
            UnBBayesFrame.this.chooser.setVisible(false);
            UnBBayesFrame.this.chooser.setEnabled(false);
            return null;
        }

        public void actionPerformed(ActionEvent ae) {
            UnBBayesFrame.this.setCursor(new Cursor(3));
            File currentFile = this.file;
            if (currentFile == null) {
                currentFile = this.showFileChooser();
            }
            if (currentFile != null) {
                UnBBayesFrame.this.repaint();
                Map<String, UnBBayesModule> moduleMap = UnBBayesFrame.this.getUnBBayesModulesByFile(currentFile, UnBBayesFrame.this.getPluginMap());
                UnBBayesModule selectedModule = null;
                if (moduleMap.size() == 1) {
                    selectedModule = moduleMap.values().iterator().next();
                } else if (moduleMap.size() > 1) {
                    Object[] possibleValues = moduleMap.keySet().toArray(new String[moduleMap.keySet().size()]);
                    Object selectedValue = JOptionPane.showInputDialog(UnBBayesFrame.this, resource.getString("moduleConflictMessage"), resource.getString("moduleConflict"), 1, null, possibleValues, possibleValues[0]);
                    if (selectedValue != null) {
                        selectedModule = moduleMap.get(selectedValue.toString());
                    } else {
                        UnBBayesFrame.this.setCursor(new Cursor(0));
                        return;
                    }
                }
                if (selectedModule == null) {
                    JOptionPane.showMessageDialog(UnBBayesFrame.this, resource.getString("unsupportedGraphFormat"), resource.getString("loadNetException"), 0);
                    UnBBayesFrame.this.setCursor(new Cursor(0));
                    return;
                }
                try {
                    UnBBayesModule mod = UnBBayesFrame.this.controller.loadNet(currentFile, selectedModule);
                    if (mod != null) {
                        mod.setFile(currentFile);
                        UnBBayesFrame.this.addWindow(mod);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(UnBBayesFrame.this, e.getMessage(), resource.getString("loadNetException"), 0);
                }
            }
            UnBBayesFrame.this.setCursor(new Cursor(0));
        }
    }

    protected class SplitButtonMenuActionListener
    implements ActionListener {
        private JButton mainButton;
        private SplitToggleButton splitButton;

        public SplitButtonMenuActionListener(SplitToggleButton splitButton, JButton mainButton) {
            this.mainButton = mainButton;
            this.splitButton = splitButton;
        }

        public void actionPerformed(ActionEvent e) {
            this.splitButton.setMainButton(this.mainButton);
            this.splitButton.getMenu().setVisible(false);
            this.splitButton.updateUI();
            this.splitButton.repaint();
            this.splitButton.getMainButton().doClick();
        }
    }
}

