/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.option;

import java.awt.GridLayout;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import unbbayes.controller.INetworkMediator;
import unbbayes.gui.ILikelihoodEvidenceDialogBuilder;
import unbbayes.gui.LikelihoodEvidenceDialogBuilder;
import unbbayes.gui.SoftEvidenceDialogBuilder;
import unbbayes.prs.bn.ILikelihoodExtractor;
import unbbayes.prs.bn.JeffreyRuleLikelihoodExtractor;
import unbbayes.prs.bn.JunctionTreeAlgorithm;
import unbbayes.prs.bn.LikelihoodExtractor;
import unbbayes.util.Debug;
import unbbayes.util.extension.bn.inference.IInferenceAlgorithm;
import unbbayes.util.extension.bn.inference.InferenceAlgorithmOptionPanel;

public class JunctionTreeOptionPanel
extends InferenceAlgorithmOptionPanel {
    private static final long serialVersionUID = 7734979988420335938L;
    private IInferenceAlgorithm inferenceAlgorithm;
    private AncestorListener clearVirtualNodesAncestorListener;
    private JCheckBox removeVirtualNodeCheckBox;
    private JCheckBox useSoftEvidenceCheckBox;
    private ILikelihoodExtractor softEvidenceLikelihoodExtractor = JeffreyRuleLikelihoodExtractor.newInstance();
    private ILikelihoodExtractor likelihoodEvidenceLikelihoodExtractor = LikelihoodExtractor.newInstance();
    private ILikelihoodEvidenceDialogBuilder likelihoodEvidenceDialogBuilder = new LikelihoodEvidenceDialogBuilder();
    private ILikelihoodEvidenceDialogBuilder softEvidenceDialogBuilder = new SoftEvidenceDialogBuilder();

    public JunctionTreeOptionPanel() {
        JunctionTreeAlgorithm alg = new JunctionTreeAlgorithm();
        alg.setOptionPanel(this);
        this.setInferenceAlgorithm(alg);
        this.initComponents();
        this.initListeners();
    }

    protected void initComponents() {
        this.setLayout(new GridLayout(0, 1));
        boolean isSelected = false;
        try {
            AncestorListener[] ancestorListenerArray = this.getMediator().getScreen().getNetWindowEdition().getAncestorListeners();
            int n = ancestorListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                AncestorListener listener = ancestorListenerArray[n2];
                if (listener.equals(this.getClearVirtualNodesAncestorListener())) {
                    isSelected = true;
                    break;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Debug.println(this.getClass(), e.getMessage(), e);
        }
        this.setRemoveVirtualNodeCheckBox(new JCheckBox("Delete virtual nodes when returning to edit mode", isSelected));
        this.add(this.getRemoveVirtualNodeCheckBox());
        isSelected = false;
        if (this.getInferenceAlgorithm() instanceof JunctionTreeAlgorithm) {
            JunctionTreeAlgorithm junctionTreeAlgorithm = (JunctionTreeAlgorithm)this.getInferenceAlgorithm();
            isSelected = this.getSoftEvidenceLikelihoodExtractor().equals(junctionTreeAlgorithm.getLikelihoodExtractor());
        }
        this.setUseSoftEvidenceCheckBox(new JCheckBox("Use soft evidence instead of likelihood evidence", isSelected));
        this.add(this.getUseSoftEvidenceCheckBox());
    }

    protected void initListeners() {
        this.setClearVirtualNodesAncestorListener(new AncestorListener(){

            public void ancestorRemoved(AncestorEvent event) {
            }

            public void ancestorMoved(AncestorEvent event) {
            }

            public void ancestorAdded(AncestorEvent event) {
                if (JunctionTreeOptionPanel.this.getInferenceAlgorithm() instanceof JunctionTreeAlgorithm) {
                    JunctionTreeAlgorithm junctionTreeAlgorithm = (JunctionTreeAlgorithm)JunctionTreeOptionPanel.this.getInferenceAlgorithm();
                    try {
                        junctionTreeAlgorithm.clearVirtualNodes();
                        JunctionTreeOptionPanel.this.getMediator().getScreen().changeToPNEditionPane();
                    }
                    catch (Exception t) {
                        t.printStackTrace();
                        try {
                            JOptionPane.showMessageDialog(JunctionTreeOptionPanel.this, "Could not clear virtual nodes: " + t.getMessage());
                        }
                        catch (Throwable t2) {
                            t2.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    public void commitChanges() {
        if (this.getMediator() != null && this.getClearVirtualNodesAncestorListener() != null) {
            this.getMediator().getScreen().getNetWindowEdition().removeAncestorListener(this.getClearVirtualNodesAncestorListener());
        }
        if (this.getRemoveVirtualNodeCheckBox().isSelected() && this.getMediator() != null && this.getClearVirtualNodesAncestorListener() != null) {
            this.getMediator().getScreen().getNetWindowEdition().addAncestorListener(this.getClearVirtualNodesAncestorListener());
        }
        if (this.getInferenceAlgorithm() instanceof JunctionTreeAlgorithm) {
            JunctionTreeAlgorithm junctionTreeAlgorithm = (JunctionTreeAlgorithm)this.getInferenceAlgorithm();
            if (this.getUseSoftEvidenceCheckBox().isSelected()) {
                junctionTreeAlgorithm.setLikelihoodExtractor(this.getSoftEvidenceLikelihoodExtractor());
                if (this.getMediator() != null) {
                    this.getMediator().getScreen().getEvidenceTree().setLikelihoodEvidenceDialogBuilder(this.getSoftEvidenceDialogBuilder());
                }
            } else {
                junctionTreeAlgorithm.setLikelihoodExtractor(this.getLikelihoodEvidenceLikelihoodExtractor());
                if (this.getMediator() != null) {
                    this.getMediator().getScreen().getEvidenceTree().setLikelihoodEvidenceDialogBuilder(this.getLikelihoodEvidenceDialogBuilder());
                }
            }
        }
    }

    public IInferenceAlgorithm getInferenceAlgorithm() {
        return this.inferenceAlgorithm;
    }

    public void setInferenceAlgorithm(IInferenceAlgorithm inferenceAlgorithm) {
        this.inferenceAlgorithm = inferenceAlgorithm;
    }

    public void revertChanges() {
    }

    public void setMediator(INetworkMediator mediator) {
        if (this.getMediator() != null && this.getClearVirtualNodesAncestorListener() != null) {
            this.getMediator().getScreen().getNetWindowEdition().removeAncestorListener(this.getClearVirtualNodesAncestorListener());
        }
        super.setMediator(mediator);
        if (this.getMediator() != null && this.getClearVirtualNodesAncestorListener() != null) {
            this.getMediator().getScreen().getNetWindowEdition().addAncestorListener(this.getClearVirtualNodesAncestorListener());
        }
    }

    public AncestorListener getClearVirtualNodesAncestorListener() {
        return this.clearVirtualNodesAncestorListener;
    }

    public void setClearVirtualNodesAncestorListener(AncestorListener clearVirtualNodesAncestorListener) {
        this.clearVirtualNodesAncestorListener = clearVirtualNodesAncestorListener;
    }

    public void setRemoveVirtualNodeCheckBox(JCheckBox removeVirtualNodeCheckBox) {
        this.removeVirtualNodeCheckBox = removeVirtualNodeCheckBox;
    }

    public JCheckBox getRemoveVirtualNodeCheckBox() {
        return this.removeVirtualNodeCheckBox;
    }

    public void setUseSoftEvidenceCheckBox(JCheckBox useSoftEvidenceCheckBox) {
        this.useSoftEvidenceCheckBox = useSoftEvidenceCheckBox;
    }

    public JCheckBox getUseSoftEvidenceCheckBox() {
        return this.useSoftEvidenceCheckBox;
    }

    public void setSoftEvidenceLikelihoodExtractor(ILikelihoodExtractor softEvidenceLikelihoodExtractor) {
        this.softEvidenceLikelihoodExtractor = softEvidenceLikelihoodExtractor;
    }

    public ILikelihoodExtractor getSoftEvidenceLikelihoodExtractor() {
        return this.softEvidenceLikelihoodExtractor;
    }

    public void setLikelihoodEvidenceLikelihoodExtractor(ILikelihoodExtractor previousLikelihoodExtractor) {
        this.likelihoodEvidenceLikelihoodExtractor = previousLikelihoodExtractor;
    }

    public ILikelihoodExtractor getLikelihoodEvidenceLikelihoodExtractor() {
        return this.likelihoodEvidenceLikelihoodExtractor;
    }

    public void setLikelihoodEvidenceDialogBuilder(ILikelihoodEvidenceDialogBuilder likelihoodEvidenceDialogBuilder) {
        this.likelihoodEvidenceDialogBuilder = likelihoodEvidenceDialogBuilder;
    }

    public ILikelihoodEvidenceDialogBuilder getLikelihoodEvidenceDialogBuilder() {
        return this.likelihoodEvidenceDialogBuilder;
    }

    public void setSoftEvidenceDialogBuilder(ILikelihoodEvidenceDialogBuilder softEvidenceDialogBuilder) {
        this.softEvidenceDialogBuilder = softEvidenceDialogBuilder;
    }

    public ILikelihoodEvidenceDialogBuilder getSoftEvidenceDialogBuilder() {
        return this.softEvidenceDialogBuilder;
    }
}

