/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.table;

import java.awt.Color;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import unbbayes.controller.resources.ControllerResources;
import unbbayes.gui.table.ColumnGroup;
import unbbayes.gui.table.ExcelAdapter;
import unbbayes.gui.table.GroupableTableCellRenderer;
import unbbayes.gui.table.GroupableTableColumnModel;
import unbbayes.gui.table.GroupableTableHeader;
import unbbayes.gui.table.GroupableTableHeaderUI;
import unbbayes.gui.table.ReplaceTextCellEditor;
import unbbayes.prs.INode;
import unbbayes.prs.Node;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.util.Debug;
import unbbayes.util.ResourceController;

public class GUIPotentialTable {
    private PotentialTable potentialTable;
    private boolean isToGroupHeaders = true;
    private static ResourceBundle resource = ResourceController.newInstance().getBundle(ControllerResources.class.getName(), Locale.getDefault(), GUIPotentialTable.class.getClassLoader());

    public GUIPotentialTable(PotentialTable potentialTable) {
        this(potentialTable, true);
    }

    public GUIPotentialTable(PotentialTable potentialTable, boolean isToGroupHeaders) {
        this.potentialTable = potentialTable;
        this.isToGroupHeaders = isToGroupHeaders;
    }

    public JTable makeTable() {
        int i;
        int nStates = 1;
        int nVariables = this.potentialTable.variableCount();
        Node node = (Node)this.potentialTable.getVariableAt(0);
        NumberFormat df = NumberFormat.getInstance(Locale.getDefault());
        df.setMaximumFractionDigits(4);
        nStates = this.potentialTable.tableSize() / node.getStatesSize();
        int rows = node.getStatesSize();
        int columns = nStates + 1;
        Object[][] data = new String[rows][columns];
        Object[] column = new String[data[0].length];
        if (nVariables == 1) {
            column[0] = "State";
            column[1] = "Probability";
        } else {
            Node firstHeaderNode = (Node)this.potentialTable.getVariableAt(1);
            column[0] = firstHeaderNode.getName();
            i = 0;
            while (i < data[0].length - 1) {
                if (nVariables > 1) {
                    column[i + 1] = firstHeaderNode.getStateAt(i % firstHeaderNode.getStatesSize());
                }
                ++i;
            }
        }
        int c = 1;
        int n = 0;
        while (c < columns) {
            int r = 0;
            while (r < rows) {
                data[r][c] = df.format(this.potentialTable.getValue(n + r));
                ++r;
            }
            ++c;
            n += rows;
        }
        i = 0;
        while (i < rows) {
            data[i][0] = node.getStateAt(i);
            ++i;
        }
        DefaultTableModel model = new DefaultTableModel();
        model.setDataVector(data, column);
        JTable table = new JTable();
        table.setColumnModel(new GroupableTableColumnModel());
        table.setTableHeader(new GroupableTableHeader((GroupableTableColumnModel)table.getColumnModel(), new GroupableTableHeaderUI(this.isToGroupHeaders())));
        table.setModel(model);
        GroupableTableColumnModel cModel = (GroupableTableColumnModel)table.getColumnModel();
        ColumnGroup cNodeGroup = null;
        ColumnGroup cNodeTempGroup = null;
        ColumnGroup cGroup = null;
        ArrayList<ColumnGroup> cGroupList = new ArrayList<ColumnGroup>();
        ArrayList previousCGroupList = new ArrayList();
        boolean firstNode = true;
        int sizeColumn = 1;
        cModel.getColumn(0).setHeaderRenderer(new GroupableTableCellRenderer());
        cModel.getColumn(0).setCellRenderer(new GroupableTableCellRenderer(Color.BLACK, Color.YELLOW));
        int k = 2;
        while (k < nVariables) {
            Node parent = (Node)this.potentialTable.getVariableAt(k);
            int nPreviousParentStates = this.potentialTable.getVariableAt(k - 1).getStatesSize();
            sizeColumn *= nPreviousParentStates;
            if (!firstNode) {
                cNodeTempGroup = cNodeGroup;
                cNodeGroup = new ColumnGroup(new GroupableTableCellRenderer(), parent.getName());
                cNodeGroup.add(cNodeTempGroup);
            } else {
                cNodeGroup = new ColumnGroup(new GroupableTableCellRenderer(), parent.getName());
                cNodeGroup.add(cModel.getColumn(0));
            }
            int columnIndex = 1;
            cGroup = null;
            while (columnIndex <= nStates) {
                int i2 = 0;
                while (i2 < parent.getStatesSize()) {
                    int j;
                    cGroup = new ColumnGroup(parent.getStateAt(i2));
                    if (!firstNode) {
                        j = 0;
                        while (j < nPreviousParentStates) {
                            ColumnGroup group = (ColumnGroup)previousCGroupList.get(columnIndex - 1);
                            cGroup.add(group);
                            ++columnIndex;
                            ++j;
                        }
                    } else {
                        j = 0;
                        while (j < sizeColumn) {
                            cGroup.add(cModel.getColumn(columnIndex++));
                            ++j;
                        }
                    }
                    cGroupList.add(cGroup);
                    ++i2;
                }
            }
            previousCGroupList = cGroupList;
            cGroupList = new ArrayList();
            firstNode = false;
            nStates /= nPreviousParentStates;
            ++k;
        }
        if (cNodeGroup != null) {
            cModel.addColumnGroup(cNodeGroup);
        }
        if (previousCGroupList != null) {
            for (ColumnGroup group : previousCGroupList) {
                cModel.addColumnGroup(group);
            }
        }
        table.setAutoResizeMode(0);
        new ExcelAdapter(table);
        table.setCellSelectionEnabled(true);
        table.setRowSelectionAllowed(true);
        ReplaceTextCellEditor cellEditor = new ReplaceTextCellEditor();
        int i3 = 0;
        while (i3 < table.getColumnModel().getColumnCount()) {
            table.getColumnModel().getColumn(i3).setCellEditor(cellEditor);
            ++i3;
        }
        table.setSurrendersFocusOnKeystroke(true);
        this.fillWithDefaultTableChangeListener(table);
        return table;
    }

    public void showTable(String title) {
        JDialog diag = new JDialog();
        diag.getContentPane().add(new JScrollPane(this.makeTable()));
        diag.setDefaultCloseOperation(2);
        diag.setTitle(title);
        diag.pack();
        diag.setVisible(true);
    }

    public void fillWithDefaultTableChangeListener(final JTable table) {
        table.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                if (GUIPotentialTable.this.getPotentialTable() == null || GUIPotentialTable.this.getPotentialTable().getVariablesSize() <= 0) {
                    Debug.println("No probabilistic table found");
                    return;
                }
                INode node = GUIPotentialTable.this.getPotentialTable().getVariableAt(0);
                if (e.getColumn() == 0) {
                    if (!table.getValueAt(e.getLastRow(), e.getColumn()).toString().trim().equals("")) {
                        node.setStateAt(table.getValueAt(e.getLastRow(), e.getColumn()).toString(), e.getLastRow() - (table.getRowCount() - node.getStatesSize()));
                    } else {
                        table.revalidate();
                        table.setValueAt(node.getStateAt(e.getLastRow() - (table.getRowCount() - node.getStatesSize())), e.getLastRow(), e.getColumn());
                    }
                } else if (GUIPotentialTable.this.getPotentialTable() != null) {
                    String valueText = table.getValueAt(e.getLastRow(), e.getColumn()).toString().replace(',', '.');
                    try {
                        float value = Float.parseFloat(valueText);
                        GUIPotentialTable.this.getPotentialTable().setValue((e.getColumn() - 1) * node.getStatesSize() + e.getLastRow(), value);
                    }
                    catch (NumberFormatException nfe) {
                        if (!valueText.trim().equals("")) {
                            JOptionPane.showMessageDialog(null, GUIPotentialTable.getResource().getString("numberFormatError"), GUIPotentialTable.getResource().getString("error"), 0);
                        }
                        table.revalidate();
                        table.setValueAt("" + GUIPotentialTable.this.getPotentialTable().getValue((e.getColumn() - 1) * node.getStatesSize() + e.getLastRow()), e.getLastRow(), e.getColumn());
                    }
                }
            }
        });
    }

    public static ResourceBundle getResource() {
        return resource;
    }

    public static void setResource(ResourceBundle resource) {
        GUIPotentialTable.resource = resource;
    }

    public PotentialTable getPotentialTable() {
        return this.potentialTable;
    }

    public void setPotentialTable(PotentialTable potentialTable) {
        this.potentialTable = potentialTable;
    }

    public boolean isToGroupHeaders() {
        return this.isToGroupHeaders;
    }

    public void setToGroupHeaders(boolean isToGroup) {
        this.isToGroupHeaders = isToGroup;
    }
}

