/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.table;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class NumberEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = 1L;
    JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
    NumberFormat numberFormat = NumberFormat.getNumberInstance();

    public NumberEditor() {
        super(new JFormattedTextField());
        this.numberFormat.setMinimumFractionDigits(2);
        this.numberFormat.setMaximumFractionDigits(2);
        this.numberFormat.setMinimumIntegerDigits(1);
        NumberFormatter numberFormatter = new NumberFormatter(this.numberFormat);
        numberFormatter.setFormat(this.numberFormat);
        this.ftf.setFormatterFactory(new DefaultFormatterFactory(numberFormatter));
        this.ftf.setHorizontalAlignment(11);
        this.ftf.setFocusLostBehavior(3);
        this.ftf.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "check");
        this.ftf.getActionMap().put("check", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (!NumberEditor.this.ftf.isEditValid()) {
                    if (NumberEditor.this.userSaysRevert()) {
                        NumberEditor.this.ftf.postActionEvent();
                    }
                } else {
                    try {
                        NumberEditor.this.ftf.commitEdit();
                        NumberEditor.this.ftf.postActionEvent();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JFormattedTextField ftf = (JFormattedTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
        ftf.setValue(value);
        return ftf;
    }

    public Object getCellEditorValue() {
        JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
        Object o = ftf.getValue();
        if (o instanceof Float || o instanceof Double) {
            return o;
        }
        if (o instanceof Number) {
            return new Float(((Number)o).floatValue());
        }
        try {
            return this.numberFormat.parseObject(o.toString());
        }
        catch (ParseException exc) {
            System.err.println("getCellEditorValue: can't parse o: " + o);
            return null;
        }
    }

    public boolean stopCellEditing() {
        JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
        if (ftf.isEditValid()) {
            try {
                ftf.commitEdit();
            }
            catch (ParseException parseException) {}
        } else if (!this.userSaysRevert()) {
            return false;
        }
        return super.stopCellEditing();
    }

    protected boolean userSaysRevert() {
        Toolkit.getDefaultToolkit().beep();
        this.ftf.selectAll();
        Object[] options = new Object[]{"Edit", "Revert"};
        int answer = JOptionPane.showOptionDialog(SwingUtilities.getWindowAncestor(this.ftf), "The value must be a number.\nYou can either continue editing or revert to the last valid value.", "Invalid Text Entered", 0, 0, null, options, options[1]);
        if (answer == 1) {
            this.ftf.setValue(this.ftf.getValue());
            return true;
        }
        return false;
    }
}

