/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.table;

import java.awt.Component;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;

public class NumberRenderer
implements TableCellRenderer,
UIResource {
    JFormattedTextField ftf;
    Border emptyBorder;

    public NumberRenderer() {
        this(2, 2);
    }

    public NumberRenderer(int minFracDigits, int maxFracDigits) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMinimumFractionDigits(minFracDigits);
        numberFormat.setMaximumFractionDigits(maxFracDigits);
        numberFormat.setMinimumIntegerDigits(1);
        this.ftf = new JFormattedTextField(numberFormat);
        this.ftf.setHorizontalAlignment(0);
        this.emptyBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        if (isSelected) {
            this.ftf.setBackground(table.getSelectionBackground());
            this.ftf.setForeground(table.getSelectionForeground());
        } else {
            this.ftf.setBackground(table.getBackground());
            this.ftf.setForeground(table.getForeground());
        }
        if (hasFocus) {
            this.ftf.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.ftf.setBorder(this.emptyBorder);
        }
        this.ftf.setValue((Float)value);
        return this.ftf;
    }
}

