/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.table;

import java.awt.Component;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;

public class PercentRenderer
implements TableCellRenderer,
UIResource {
    JFormattedTextField ftf;
    Border emptyBorder;

    public PercentRenderer() {
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setMinimumIntegerDigits(1);
        this.ftf = new JFormattedTextField(numberFormat);
        this.ftf.setHorizontalAlignment(0);
        this.emptyBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        if (isSelected) {
            this.ftf.setBackground(table.getSelectionBackground());
            this.ftf.setForeground(table.getSelectionForeground());
        } else {
            this.ftf.setBackground(table.getBackground());
            this.ftf.setForeground(table.getForeground());
        }
        if (hasFocus) {
            this.ftf.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.ftf.setBorder(this.emptyBorder);
        }
        this.ftf.setValue((Float)value);
        return this.ftf;
    }
}

