/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class RadioButtonCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 1L;
    JRadioButton radioButton = new JRadioButton();
    protected int clickCountToStart = 1;

    public RadioButtonCellEditor() {
        this.radioButton.setHorizontalAlignment(0);
        this.radioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!RadioButtonCellEditor.this.radioButton.isSelected()) {
                    RadioButtonCellEditor.this.cancelCellEditing();
                }
                RadioButtonCellEditor.this.stopCellEditing();
            }
        });
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.radioButton.setSelected((Boolean)value);
        return this.radioButton;
    }

    public Component getComponent() {
        return this.radioButton;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public Object getCellEditorValue() {
        return this.radioButton.isSelected();
    }

    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= this.clickCountToStart;
        }
        return true;
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public boolean stopCellEditing(EventObject anEvent) {
        this.fireEditingStopped();
        return true;
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }
}

