/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.plaf.basic.BasicArrowButton;

public class SplitToggleButton
extends JToggleButton
implements ActionListener {
    private static final long serialVersionUID = -7324436021762703938L;
    private AbstractButton mainButton;
    private JButton dropDownButton;
    private JPopupMenu dropDownMenu = new JPopupMenu();

    public SplitToggleButton() {
        this(" ");
    }

    public SplitToggleButton(String text) {
        this(new JToggleButton(text), 5);
    }

    public SplitToggleButton(String text, int orientation) {
        this(new JToggleButton(text), orientation);
    }

    public SplitToggleButton(JToggleButton mainButton, int orientation) {
        this.dropDownButton = new BasicArrowButton(orientation);
        this.dropDownButton.addActionListener(this);
        this.dropDownButton.setPreferredSize(new Dimension(15, 40));
        this.dropDownButton.setMaximumSize(this.dropDownButton.getPreferredSize());
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setBorderPainted(false);
        this.setPreferredSize(new Dimension(45, 30));
        this.setSize(this.getPreferredSize());
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.dropDownButton, "East");
        this.setMainButton(mainButton);
        this.setEnabled(false);
        this.setFocusPainted(false);
        this.setContentAreaFilled(false);
        this.setRolloverEnabled(false);
    }

    public void setMenu(JPopupMenu menu) {
        this.dropDownMenu = menu;
    }

    public AbstractButton getMainButton() {
        return this.mainButton;
    }

    public JButton getDropDownButton() {
        return this.dropDownButton;
    }

    public JPopupMenu getMenu() {
        return this.dropDownMenu;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.dropDownMenu == null) {
            return;
        }
        if (!this.dropDownMenu.isVisible()) {
            Point p = this.getLocationOnScreen();
            this.dropDownMenu.setLocation((int)p.getX(), (int)p.getY() + this.getHeight());
            this.dropDownMenu.setVisible(true);
        } else {
            this.dropDownMenu.setVisible(false);
        }
    }

    public void addActionListener(ActionListener al) {
        this.mainButton.addActionListener(al);
        this.addActionListener(al);
    }

    public void setMainButton(AbstractButton mainButton) {
        if (this.mainButton != null) {
            this.remove(this.mainButton);
        }
        this.mainButton = mainButton;
        if (this.mainButton != null) {
            this.mainButton.setContentAreaFilled(false);
            this.add((Component)this.mainButton, "Center");
        }
        this.repaint();
    }

    public void setDropDownButton(JButton dropDownButton) {
        this.dropDownButton = dropDownButton;
    }

    public boolean isSelected() {
        return this.getMainButton().isSelected();
    }

    public void setSelected(boolean b) {
        this.getMainButton().setSelected(b);
    }

    public void repaint() {
        super.repaint();
        if (this.getMainButton() != null) {
            this.getMainButton().repaint();
        }
        if (this.getMenu() != null) {
            this.getMenu().repaint();
        }
        if (this.getDropDownButton() != null) {
            this.getDropDownButton().repaint();
        }
    }

    public void add(AbstractButton mainButton) {
        this.setMainButton(mainButton);
        this.updateUI();
    }

    public void add(JMenuItem menuItem) {
        this.getMenu().add(menuItem);
        this.updateUI();
    }

    public void add(AbstractButton mainButton, JMenuItem menuItem) {
        this.setMainButton(mainButton);
        this.getMenu().add(menuItem);
        this.updateUI();
    }

    public void remove(JMenuItem menuItem) {
        this.getMenu().remove(menuItem);
        super.remove(menuItem);
    }

    public void remove(Component comp) {
        if (comp instanceof JMenuItem) {
            this.remove((JMenuItem)comp);
        } else {
            super.remove(comp);
        }
    }
}

