/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import unbbayes.controller.IconController;
import unbbayes.controller.PrintMonitor;
import unbbayes.controller.PrintPreviewer;
import unbbayes.controller.PrintText;
import unbbayes.gui.resources.GuiResources;
import unbbayes.util.ResourceController;

public class TextAreaDialog
extends JDialog {
    private JTextArea textArea;
    private ResourceBundle resource = ResourceController.newInstance().getBundle(GuiResources.class.getName());
    private JScrollPane jspText;
    private IconController iconController;
    private JPanel topPanel;
    private JButton printButton;
    private JButton previewButton;
    private JPanel buttonPanel;
    private JPanel bottomPanel;

    public TextAreaDialog() throws HeadlessException {
    }

    public TextAreaDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.initLog();
    }

    public TextAreaDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.initLog();
    }

    public TextAreaDialog(Frame owner, boolean modal) throws HeadlessException {
        super(owner, modal);
        this.initLog();
    }

    public TextAreaDialog(Frame owner, String title) throws HeadlessException {
        super(owner, title);
        this.initLog();
        this.setTitle(title);
    }

    public TextAreaDialog(Dialog owner, boolean modal) throws HeadlessException {
        super(owner, modal);
        this.initLog();
    }

    public TextAreaDialog(Dialog owner, String title) throws HeadlessException {
        super(owner, title);
        this.initLog();
        this.setTitle(title);
    }

    public TextAreaDialog(Frame owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.initLog();
        this.setTitle(title);
    }

    public TextAreaDialog(Dialog owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.initLog();
        this.setTitle(title);
    }

    public TextAreaDialog(Frame owner, String title, boolean modal, GraphicsConfiguration gc) {
        super(owner, title, modal, gc);
        this.initLog();
        this.setTitle(title);
    }

    public TextAreaDialog(Dialog owner, String title, boolean modal, GraphicsConfiguration gc) throws HeadlessException {
        super(owner, title, modal, gc);
        this.initLog();
        this.setTitle(title);
    }

    protected void initLog() {
        this.getOwner().setCursor(new Cursor(3));
        this.getTextArea().setEditable(false);
        this.getTextArea().moveCaretPosition(0);
        this.getTextArea().setSelectionEnd(0);
        this.getTextArea().setSize(this.getTextArea().getPreferredSize());
        this.getTextArea().append("\n");
        this.jspText = new JScrollPane(this.getTextArea());
        this.jspText.setPreferredSize(new Dimension(450, 400));
        this.iconController = IconController.getInstance();
        this.topPanel = new JPanel(new BorderLayout());
        this.printButton = new JButton(this.iconController.getPrintIcon());
        this.printButton.setToolTipText(this.resource.getString("printLogToolTip"));
        this.previewButton = new JButton(this.iconController.getVisualizeIcon());
        this.previewButton.setToolTipText(this.resource.getString("previewLogToolTip"));
        this.printButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TextAreaDialog.this.printText(TextAreaDialog.this.getTextArea());
            }
        });
        this.previewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TextAreaDialog.this.previewPrintText(TextAreaDialog.this.getTextArea(), TextAreaDialog.this);
            }
        });
        this.topPanel.add((Component)this.jspText, "Center");
        this.buttonPanel = new JPanel(new FlowLayout(1));
        this.buttonPanel.add(this.printButton);
        this.buttonPanel.add(this.previewButton);
        this.topPanel.add((Component)this.buttonPanel, "North");
        this.bottomPanel = new JPanel(new FlowLayout(1));
        JButton botaoOK = new JButton(this.resource.getString("closeButtonLabel"));
        botaoOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TextAreaDialog.this.dispose();
            }
        });
        this.bottomPanel.add(botaoOK);
        this.topPanel.add((Component)this.bottomPanel, "South");
        this.getContentPane().add(this.topPanel);
        this.setTitle(this.resource.getString("logDialogTitle"));
        this.getOwner().setCursor(new Cursor(0));
    }

    protected void previewPrintText(final JTextArea texto, final JDialog dialog) {
        this.setCursor(new Cursor(3));
        Thread t = new Thread(new Runnable(){

            public void run() {
                PrintText it = new PrintText(texto, new PageFormat());
                PrintPreviewer pp = new PrintPreviewer(it, 0);
                JDialog dlg = new JDialog((Dialog)dialog, TextAreaDialog.this.resource.getString("previewLogToolTip"));
                dlg.getContentPane().add(pp);
                dlg.setSize(640, 480);
                dlg.setVisible(true);
            }
        });
        t.start();
        this.setCursor(new Cursor(0));
    }

    public void printText(final JTextArea textArea) {
        Thread t = new Thread(new Runnable(){

            public void run() {
                PrintText it = new PrintText(textArea, new PageFormat());
                PrintMonitor pm = new PrintMonitor(it);
                try {
                    pm.performPrint(true);
                }
                catch (PrinterException pe) {
                    JOptionPane.showMessageDialog(TextAreaDialog.this.getOwner(), String.valueOf(TextAreaDialog.this.resource.getString("printException")) + pe.getMessage());
                }
            }
        });
        t.start();
    }

    public ResourceBundle getResource() {
        return this.resource;
    }

    public void setResource(ResourceBundle resource) {
        this.resource = resource;
    }

    public JTextArea getTextArea() {
        if (this.textArea == null) {
            this.textArea = new JTextArea();
        }
        return this.textArea;
    }

    public void setTextArea(JTextArea textArea) {
        this.textArea = textArea;
    }

    public String getTextContent() {
        return this.getTextArea().getText();
    }

    public void setTextContent(String textContent) {
        this.getTextArea().setText(textContent);
    }

    public JScrollPane getJspText() {
        return this.jspText;
    }

    public void setJspText(JScrollPane jspText) {
        this.jspText = jspText;
    }

    public IconController getIconController() {
        return this.iconController;
    }

    public void setIconController(IconController iconController) {
        this.iconController = iconController;
    }

    public JPanel getTopPanel() {
        return this.topPanel;
    }

    public void setTopPanel(JPanel topPanel) {
        this.topPanel = topPanel;
    }

    public JButton getPrintButton() {
        return this.printButton;
    }

    public void setPrintButton(JButton printButton) {
        this.printButton = printButton;
    }

    public JButton getPreviewButton() {
        return this.previewButton;
    }

    public void setPreviewButton(JButton previewButton) {
        this.previewButton = previewButton;
    }

    public JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public void setButtonPanel(JPanel buttonPanel) {
        this.buttonPanel = buttonPanel;
    }

    public JPanel getBottomPanel() {
        return this.bottomPanel;
    }

    public void setBottomPanel(JPanel bottomPanel) {
        this.bottomPanel = bottomPanel;
    }
}

