/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.ResourceBundle;
import unbbayes.io.BaseIO;
import unbbayes.io.exception.LoadException;
import unbbayes.io.resources.IoResources;
import unbbayes.prs.Edge;
import unbbayes.prs.Graph;
import unbbayes.prs.INode;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ExplanationPhrase;
import unbbayes.prs.bn.IRandomVariable;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.bn.SingleEntityNetwork;
import unbbayes.prs.builder.IProbabilisticNetworkBuilder;
import unbbayes.prs.builder.impl.DefaultProbabilisticNetworkBuilder;
import unbbayes.prs.exception.InvalidParentException;
import unbbayes.prs.hybridbn.ContinuousNode;
import unbbayes.prs.id.DecisionNode;
import unbbayes.prs.id.UtilityNode;
import unbbayes.util.ArrayMap;
import unbbayes.util.Debug;
import unbbayes.util.ResourceController;

public class DneIO
implements BaseIO {
    private static ResourceBundle resource = ResourceController.newInstance().getBundle(IoResources.class.getName());
    private static final String ERROR_NET = resource.getString("errorDne");
    protected long lineno = 1L;
    protected boolean isDiscreteNode;
    public static final String[] SUPPORTED_EXTENSIONS = new String[]{"dne"};
    private String name = "DNE";
    private boolean isToUseAbsurdState = false;
    private boolean isToAppendLevelsToState = false;

    public ProbabilisticNetwork load(File input) throws LoadException, IOException {
        ProbabilisticNetwork net = this.load(input, DefaultProbabilisticNetworkBuilder.newInstance());
        return net;
    }

    public ProbabilisticNetwork load(File input, IProbabilisticNetworkBuilder networkBuilder) throws LoadException, IOException {
        int index = input.getName().lastIndexOf(46);
        String id = input.getName().substring(0, index);
        ProbabilisticNetwork net = networkBuilder.buildNetwork(id);
        try {
            this.load(input, net, networkBuilder);
        }
        catch (HasImpossProbDeclarationException impossException) {
            boolean backup = this.isToUseAbsurdState();
            this.setToUseAbsurdState(true);
            try {
                net = networkBuilder.buildNetwork(id);
                this.load(input, net, networkBuilder);
            }
            catch (Exception e) {
                this.setToUseAbsurdState(backup);
                throw new IOException(e);
            }
            this.setToUseAbsurdState(backup);
        }
        return net;
    }

    public void save(File output, Graph graph) throws FileNotFoundException {
        Node auxNode1;
        PrintStream stream = new PrintStream(new FileOutputStream(output));
        SingleEntityNetwork net = (SingleEntityNetwork)graph;
        this.saveNetHeader(stream, net);
        int nodeSize = net.getNodeCount();
        int c1 = 0;
        while (c1 < nodeSize) {
            auxNode1 = net.getNodeAt(c1);
            this.saveNodeDeclaration(stream, auxNode1, net);
            ++c1;
        }
        c1 = 0;
        while (c1 < net.getNodeCount()) {
            auxNode1 = net.getNodeAt(c1);
            this.savePotentialDeclaration(stream, auxNode1, net);
            ++c1;
        }
        stream.close();
    }

    protected void load(File input, SingleEntityNetwork net, IProbabilisticNetworkBuilder networkBuilder) throws IOException, LoadException {
        BufferedReader r = new BufferedReader(new FileReader(input));
        StreamTokenizer st = new StreamTokenizer(r);
        this.setUpStreamTokenizer(st);
        while (this.getNext(st) != -1) {
            this.loadVisualDeclaration(st, net, networkBuilder);
            this.loadNodeDeclaration(st, net, networkBuilder);
        }
        r.close();
    }

    protected int getNext(StreamTokenizer st) throws IOException {
        do {
            st.nextToken();
            if (st.ttype == 10) {
                ++this.lineno;
            }
            if (st.ttype == 59) {
                st.sval = ";";
            }
            if (st.ttype == 125) {
                st.sval = "}";
            }
            if (st.ttype != 123) continue;
            st.sval = "{";
        } while (st.ttype != -3 && st.ttype != 34 && st.ttype != 59 && st.ttype != 123 && st.ttype != 125 && st.ttype != -1);
        return st.ttype;
    }

    protected void readTillEOL(StreamTokenizer tokenizer) throws IOException {
        while (tokenizer.nextToken() != 10) {
        }
        tokenizer.pushBack();
    }

    protected String formatString(String string) {
        return string.replace('\n', '#');
    }

    protected String unformatString(String string) {
        return string.replace('#', '\n');
    }

    protected void setUpStreamTokenizer(StreamTokenizer st) throws IOException {
        st.resetSyntax();
        st.wordChars(65, 90);
        st.wordChars(97, 125);
        st.wordChars(160, 255);
        st.wordChars(95, 95);
        st.wordChars(45, 45);
        st.wordChars(48, 57);
        st.wordChars(46, 46);
        st.wordChars(37, 37);
        st.ordinaryChars(40, 41);
        st.ordinaryChar(59);
        st.ordinaryChar(123);
        st.ordinaryChar(125);
        st.eolIsSignificant(false);
        st.quoteChar(34);
        st.slashSlashComments(true);
    }

    protected void loadNetHeader(StreamTokenizer st, SingleEntityNetwork net) throws IOException {
        this.getNext(st);
        if (st.sval.equals("{")) {
            this.getNext(st);
            while (!st.sval.equals("}")) {
                this.loadNetHeaderBody(st, net);
                this.getNext(st);
            }
        }
    }

    protected void loadNetHeaderBody(StreamTokenizer st, SingleEntityNetwork net) throws IOException {
        if (st.sval.equals("name")) {
            this.getNext(st);
            net.setName(st.sval);
        } else if (st.sval.equals("node_size")) {
            this.getNext(st);
            this.getNext(st);
            net.setRadius(Double.parseDouble(st.sval) / 2.0);
        } else if (st.sval.equals("UnBBayes_Color_Utility")) {
            this.getNext(st);
            UtilityNode.setStaticColor(Integer.parseInt(st.sval));
        } else if (st.sval.equals("UnBBayes_Color_Decision")) {
            this.getNext(st);
            DecisionNode.setStaticColor(Integer.parseInt(st.sval));
        } else if (st.sval.equals("UnBBayes_Color_Probabilistic_Description")) {
            this.getNext(st);
            ProbabilisticNode.setDescriptionColor(Integer.parseInt(st.sval));
        } else if (st.sval.equals("UnBBayes_Color_Probabilistic_Explanation")) {
            this.getNext(st);
            ProbabilisticNode.setExplanationColor(Integer.parseInt(st.sval));
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void loadVisualDeclaration(StreamTokenizer st, SingleEntityNetwork net, IProbabilisticNetworkBuilder networkBuilder) throws IOException {
        block4: {
            if (!st.sval.equals("visual")) break block4;
            if (this.getNext(st) != -3) {
                throw new LoadException(String.valueOf(DneIO.ERROR_NET) + " l." + ((long)st.lineno() < this.lineno ? this.lineno : (long)st.lineno()) + DneIO.resource.getString("LoadException3"));
            }
            this.getNext(st);
            if (st.sval.equals("{")) ** GOTO lbl15
            throw new LoadException(String.valueOf(DneIO.ERROR_NET) + " l." + ((long)st.lineno() < this.lineno ? this.lineno : (long)st.lineno()) + DneIO.resource.getString("LoadException3"));
lbl-1000:
            // 1 sources

            {
                if (st.sval.equals("}")) {
                    if (this.getNext(st) == 59) break;
                    throw new LoadException(String.valueOf(DneIO.ERROR_NET) + " l." + ((long)st.lineno() < this.lineno ? this.lineno : (long)st.lineno()) + DneIO.resource.getString("LoadException3"));
                }
                if (!st.sval.equals("{")) continue;
                while (this.getNext(st) != -1) {
                    if (st.sval.equals("}") && this.getNext(st) == 59) continue block0;
                }
lbl15:
                // 4 sources

                ** while (this.getNext((StreamTokenizer)st) != -1)
            }
        }
    }

    protected void loadNodeDeclaration(StreamTokenizer st, SingleEntityNetwork net, IProbabilisticNetworkBuilder networkBuilder) throws IOException, LoadException {
        if (st.sval.equals("node")) {
            Node auxNode = null;
            if (st.sval.equals("node")) {
                auxNode = networkBuilder.getProbabilisticNodeBuilder().buildNode();
            }
            this.getNext(st);
            auxNode.setName(st.sval);
            this.getNext(st);
            if (st.sval.equals("{")) {
                this.getNext(st);
                this.isDiscreteNode = true;
                this.loadNodeDeclarationBody(st, auxNode, net);
            } else {
                throw new LoadException(String.valueOf(ERROR_NET) + " l." + ((long)st.lineno() < this.lineno ? this.lineno : (long)st.lineno()) + resource.getString("LoadException3"));
            }
        }
    }

    protected void loadParents(StreamTokenizer st, Node node, SingleEntityNetwork net) throws IOException, LoadException {
        IRandomVariable auxTableVar = null;
        PotentialTable auxPotentialTable = null;
        if (node instanceof IRandomVariable) {
            auxTableVar = (IRandomVariable)((Object)node);
            auxPotentialTable = (PotentialTable)auxTableVar.getProbabilityFunction();
            auxPotentialTable.addVariable(node);
        }
        while (this.getNext(st) != 59) {
            Node parent = net.getNode(st.sval);
            Edge edge = new Edge(parent, node);
            try {
                net.addEdge(edge);
            }
            catch (InvalidParentException e) {
                throw new LoadException(e.getMessage());
            }
        }
        if (node instanceof IRandomVariable) {
            int sizeVetor = auxPotentialTable.variableCount() / 2;
            int k = 1;
            while (k <= sizeVetor) {
                INode temp = auxPotentialTable.getVariableAt(k);
                auxPotentialTable.setVariableAt(k, auxPotentialTable.getVariableAt(auxPotentialTable.variableCount() - k));
                auxPotentialTable.setVariableAt(auxPotentialTable.variableCount() - k, (Node)temp);
                ++k;
            }
        }
    }

    protected void loadNodeDeclarationBody(StreamTokenizer st, Node node, SingleEntityNetwork net) throws IOException, LoadException {
        boolean isConstantNode = false;
        boolean isProbDeclared = false;
        while (!st.sval.equals("}")) {
            if (st.sval.equals("whenchanged")) {
                while (this.getNext(st) != 59) {
                }
                this.getNext(st);
                continue;
            }
            if (st.sval.equals("title")) {
                this.getNext(st);
                node.setDescription(st.sval);
                this.getNext(st);
                continue;
            }
            if (st.sval.equals("discrete")) {
                this.getNext(st);
                this.isDiscreteNode = st.sval.equals("TRUE");
                this.getNext(st);
                continue;
            }
            if (st.sval.equals("states")) {
                int numStates = 0;
                while (this.getNext(st) != 59) {
                    node.appendState(st.sval);
                    ++numStates;
                }
                if (numStates <= 0) {
                    throw new IOException("Found node with 0 states: " + node);
                }
                if (numStates == 1) {
                    isConstantNode = true;
                }
                if (numStates <= 1 || !this.isToUseAbsurdState()) continue;
                String absurdState = "absurd";
                if (this.indexOfState(node, absurdState) >= 0) {
                    int i = 0;
                    while (i < Integer.MAX_VALUE) {
                        if (this.indexOfState(node, String.valueOf(absurdState) + i) < 0) {
                            absurdState = String.valueOf(absurdState) + i;
                            break;
                        }
                        ++i;
                    }
                }
                node.appendState(absurdState);
                continue;
            }
            if (st.sval.equals("levels")) {
                this.getNext(st);
                if (!this.isDiscreteNode) {
                    String stateBeginValue = st.sval;
                    while (this.getNext(st) != 59) {
                        node.appendState(String.valueOf(stateBeginValue) + "To" + st.sval);
                        stateBeginValue = st.sval;
                    }
                    continue;
                }
                do {
                    if (!this.isToAppendLevelsToState()) continue;
                    node.appendState(st.sval);
                } while (this.getNext(st) != 59);
                continue;
            }
            if (st.sval.equals("parents")) {
                this.loadParents(st, node, net);
                continue;
            }
            if (st.sval.equals("probs")) {
                this.loadPotentialDataOrdinal(st, node);
                isProbDeclared = true;
                continue;
            }
            if (st.sval.equals("belief")) {
                if (!isProbDeclared) {
                    this.loadPotentialDataOrdinal(st, node);
                    continue;
                }
                this.getNext(st);
                continue;
            }
            if (st.sval.equals("functable")) {
                this.loadPotentialDataFuncTable(st, node);
                isProbDeclared = true;
                continue;
            }
            if (st.sval.equals("visual")) {
                this.getNext(st);
                this.getNext(st);
                if (st.sval.equals("{")) {
                    this.getNext(st);
                    while (!st.sval.equals("}")) {
                        if (st.sval.equals("center")) {
                            this.getNext(st);
                            int x = Integer.parseInt(st.sval);
                            if (x <= 0) {
                                x = Node.getDefaultWidth();
                            }
                            this.getNext(st);
                            int y = Integer.parseInt(st.sval);
                            if (y <= 0) {
                                y = Node.getDefaultHeight();
                            }
                            node.setPosition(x, y);
                        }
                        this.getNext(st);
                    }
                    continue;
                }
                throw new LoadException(String.valueOf(ERROR_NET) + " l." + ((long)st.lineno() < this.lineno ? this.lineno : (long)st.lineno()) + resource.getString("LoadException3"));
            }
            if (st.sval.equals("kind")) {
                this.getNext(st);
                isConstantNode = isConstantNode || st.sval.equalsIgnoreCase("CONSTANT");
                this.getNext(st);
                continue;
            }
            this.getNext(st);
        }
        if (isConstantNode) {
            this.setConstantCPT(node);
        }
        net.addNode(node);
    }

    protected void setConstantCPT(Node node) {
        while (node.getStatesSize() > 1) {
            Debug.println(this.getClass(), "Found constant node " + node + " with more than 1 state.");
            node.removeLastState();
        }
        if (node instanceof ProbabilisticNode) {
            PotentialTable table = ((ProbabilisticNode)node).getProbabilityFunction();
            int i = 0;
            while (i < table.tableSize()) {
                table.setValue(i, 1.0f);
                ++i;
            }
        }
    }

    protected void loadPotentialDataOrdinal(StreamTokenizer st, Node node) throws LoadException, IOException {
        PotentialTable auxPotentialTable = (PotentialTable)((IRandomVariable)((Object)node)).getProbabilityFunction();
        if (node.getType() == 2) {
            throw new LoadException(String.valueOf(ERROR_NET) + " l." + ((long)st.lineno() < this.lineno ? this.lineno : (long)st.lineno()) + resource.getString("LoadException4"));
        }
        int nDim = 0;
        float probSum = 0.0f;
        while (this.getNext(st) != 59) {
            float value = Float.NaN;
            if (st.sval.equalsIgnoreCase("imposs")) {
                if (!this.isToUseAbsurdState()) {
                    throw new HasImpossProbDeclarationException(String.valueOf(ERROR_NET) + " l." + ((long)st.lineno() < this.lineno ? this.lineno : (long)st.lineno()) + resource.getString("LoadException4"));
                }
                value = 0.0f;
            } else {
                try {
                    value = Float.parseFloat(st.sval);
                }
                catch (NumberFormatException e) {
                    Debug.println(this.getClass(), e.getMessage(), e);
                }
            }
            auxPotentialTable.setValue(nDim++, value);
            probSum += value;
            if (this.isAbsurdStateLinearCoord(auxPotentialTable, nDim, false)) {
                auxPotentialTable.setValue(nDim++, 1.0f - probSum);
                probSum = 0.0f;
            }
            while (this.isAbsurdStateLinearCoord(auxPotentialTable, nDim, true)) {
                auxPotentialTable.setValue(nDim++, 0.0f);
                if (auxPotentialTable.getMultidimensionalCoord(nDim)[0] != auxPotentialTable.getVariableAt(0).getStatesSize() - 1) continue;
                auxPotentialTable.setValue(nDim++, 1.0f);
            }
        }
    }

    protected void loadPotentialDataFuncTable(StreamTokenizer st, Node node) throws LoadException, IOException {
        PotentialTable auxPotentialTable = (PotentialTable)((IRandomVariable)((Object)node)).getProbabilityFunction();
        if (node.getType() == 2) {
            throw new LoadException(String.valueOf(ERROR_NET) + " l." + ((long)st.lineno() < this.lineno ? this.lineno : (long)st.lineno()) + resource.getString("LoadException4"));
        }
        int cptIndex = 0;
        while (this.getNext(st) != 59) {
            int indexOfStateToSetTo1 = this.indexOfState(node, st.sval);
            if (indexOfStateToSetTo1 < 0) {
                throw new IOException(node + " does not have state " + st.sval);
            }
            int[] multidimensionalCoord = auxPotentialTable.getMultidimensionalCoord(cptIndex);
            multidimensionalCoord[0] = indexOfStateToSetTo1;
            auxPotentialTable.setValue(auxPotentialTable.getLinearCoord(multidimensionalCoord), 1.0f);
            multidimensionalCoord[0] = auxPotentialTable.getVariableAt(0).getStatesSize() - 1;
            cptIndex = auxPotentialTable.getLinearCoord(multidimensionalCoord) + 1;
            while (this.isAbsurdStateLinearCoord(auxPotentialTable, cptIndex, true)) {
                auxPotentialTable.setValue(cptIndex++, 0.0f);
                if (auxPotentialTable.getMultidimensionalCoord(cptIndex)[0] != auxPotentialTable.getVariableAt(0).getStatesSize() - 1) continue;
                auxPotentialTable.setValue(cptIndex++, 1.0f);
            }
        }
    }

    protected boolean isAbsurdStateLinearCoord(PotentialTable table, int linearCoord, boolean isToIgnoreMainNode) {
        if (!this.isToUseAbsurdState()) {
            return false;
        }
        if (table == null) {
            return false;
        }
        int[] multidimensionalCoord = table.getMultidimensionalCoord(linearCoord);
        int i = isToIgnoreMainNode ? 1 : 0;
        while (i < table.getVariablesSize()) {
            if (multidimensionalCoord[i] == table.getVariableAt(i).getStatesSize() - 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int indexOfState(Node node, String state) {
        int i = 0;
        while (i < node.getStatesSize()) {
            if (node.getStateAt(i).equalsIgnoreCase(state)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void saveNetHeader(PrintStream stream, SingleEntityNetwork net) {
        stream.println("net");
        stream.println("{");
        this.saveNetHeaderBody(stream, net);
        stream.println("}");
        stream.println();
    }

    protected void saveNetHeaderBody(PrintStream stream, SingleEntityNetwork net) {
        stream.println("     node_size = (" + (int)(net.getRadius() * 2.0) + " " + (int)(net.getRadius() * 2.0) + ");");
        stream.println("     name = \"" + net.getName() + "\";");
        stream.println("     UnBBayes_Color_Probabilistic_Description = \"" + ProbabilisticNode.getDescriptionColor().getRGB() + "\";");
        stream.println("     UnBBayes_Color_Probabilistic_Explanation = \"" + ProbabilisticNode.getExplanationColor().getRGB() + "\";");
        stream.println("     UnBBayes_Color_Utility = \"" + UtilityNode.getStaticColor().getRGB() + "\";");
        stream.println("     UnBBayes_Color_Decision = \"" + DecisionNode.getStaticColor().getRGB() + "\";");
    }

    protected void saveNodeDeclaration(PrintStream stream, Node node, SingleEntityNetwork net) {
        if (node instanceof ContinuousNode) {
            stream.print("continuous node");
        } else if (node.getType() == 0) {
            stream.print("node");
        } else if (node.getType() == 2) {
            stream.print("decision");
        } else {
            stream.print("utility");
        }
        stream.println(" " + node.getName());
        stream.println("{");
        this.saveNodeDeclarationBody(stream, node, net);
        stream.println("}");
        stream.println();
    }

    protected void saveNodeDeclarationBody(PrintStream stream, Node node, SingleEntityNetwork net) {
        this.saveNodeLabelAndPosition(stream, node);
        if (!(node instanceof ContinuousNode)) {
            if (node.getType() != 1) {
                if (node.getStatesSize() == 0) {
                    double[] mean = node.getMean();
                    double[] stdDev = node.getStandardDeviation();
                    StringBuffer auxString = new StringBuffer();
                    auxString.append("\"" + mean[0] + "\"");
                    int i = 1;
                    while (i < mean.length) {
                        auxString.append(" \"" + mean[i] + "\"");
                        ++i;
                    }
                    stream.println("     meanPerClass = (" + auxString.toString() + ");");
                    auxString = new StringBuffer();
                    auxString.append("\"" + stdDev[0] + "\"");
                    i = 1;
                    while (i < mean.length) {
                        auxString.append(" \"" + stdDev[i] + "\"");
                        ++i;
                    }
                    stream.println("     stdDevPerClass = (" + auxString.toString() + ");");
                } else {
                    StringBuffer auxString = new StringBuffer("\"" + node.getStateAt(0) + "\"");
                    int sizeEstados = node.getStatesSize();
                    int c2 = 1;
                    while (c2 < sizeEstados) {
                        auxString.append(" \"" + node.getStateAt(c2) + "\"");
                        ++c2;
                    }
                    stream.println("     states = (" + auxString.toString() + ");");
                }
            }
            if (node.getInformationType() == 4) {
                String explanationDescription = this.formatString(node.getExplanationDescription());
                stream.println("     %descricao \"" + explanationDescription + "\"");
                ArrayMap<String, ExplanationPhrase> arrayMap = node.getPhrasesMap();
                int size = arrayMap.size();
                ArrayList<String> keys = arrayMap.getKeys();
                int i = 0;
                while (i < size) {
                    String key = keys.get(i);
                    ExplanationPhrase explanationPhrase = arrayMap.get(key);
                    stream.println("     %frase \"" + explanationPhrase.getNode() + "\" " + "\"" + explanationPhrase.getEvidenceType() + "\" " + "\"" + this.formatString(explanationPhrase.getPhrase()) + "\"");
                    ++i;
                }
            }
        }
    }

    protected void savePotentialDeclaration(PrintStream stream, Node node, SingleEntityNetwork net) {
        ArrayList<Node> auxParentList = node.getParents();
        stream.print("potential (" + node.getName());
        int sizeVa = auxParentList.size();
        if (sizeVa > 0) {
            stream.print(" |");
            int c2 = 0;
            while (c2 < sizeVa) {
                Node auxNo2 = auxParentList.get(c2);
                stream.print(" " + auxNo2.getName());
                ++c2;
            }
        }
        stream.println(")");
        stream.println("{");
        this.savePotentialDeclarationBody(stream, node, net);
        stream.println("}");
        stream.println();
    }

    protected void savePotentialDeclarationBody(PrintStream stream, Node node, SingleEntityNetwork net) {
        if (node instanceof ContinuousNode) {
            Debug.println(this.getClass(), "TODO implement continuous node's potential treatment: " + node.getName());
            ContinuousNode continuous = (ContinuousNode)node;
            stream.print(" data = normal ( ");
            stream.print(continuous.getCnNormalDistribution().getMean(0));
            int i = 0;
            while (i < continuous.getParents().size()) {
                Debug.println(this.getClass(), "TODO implement continuous node's parent treatment: " + continuous.getParents().get(i).getName());
                stream.print(" + " + continuous.getCnNormalDistribution().getConstantAt(i, 0));
                stream.print(" * " + continuous.getParents().get(i).getName());
                ++i;
            }
            stream.print(", " + continuous.getCnNormalDistribution().getVariance(0));
            stream.println(" );");
        } else if (node instanceof IRandomVariable) {
            PotentialTable auxTabPot = (PotentialTable)((IRandomVariable)((Object)node)).getProbabilityFunction();
            int sizeVa1 = auxTabPot.variableCount();
            stream.print(" data = ");
            boolean[] paren = new boolean[sizeVa1];
            int sizeDados = auxTabPot.tableSize();
            int c2 = 0;
            while (c2 < sizeDados) {
                int[] coord = auxTabPot.getMultidimensionalCoord(c2);
                int c3 = 0;
                while (c3 < sizeVa1) {
                    if (coord[c3] == 0 && !paren[c3]) {
                        stream.print("(");
                        paren[c3] = true;
                    }
                    ++c3;
                }
                stream.print(" " + auxTabPot.getValue(c2));
                if (c2 % node.getStatesSize() == node.getStatesSize() - 1) {
                    stream.print(" ");
                }
                int celulas = 1;
                int c32 = 0;
                while (c32 < sizeVa1) {
                    Node auxNo2 = (Node)auxTabPot.getVariableAt(c32);
                    if ((c2 + 1) % (celulas *= auxNo2.getStatesSize()) == 0) {
                        stream.print(")");
                        if (c32 == sizeVa1 - 1) {
                            stream.print(";");
                        }
                        paren[c32] = false;
                    }
                    ++c32;
                }
                if ((c2 + 1) % node.getStatesSize() == 0) {
                    stream.println();
                }
                ++c2;
            }
        }
    }

    protected void saveNodeLabelAndPosition(PrintStream stream, Node node) {
        stream.println("     label = \"" + node.getDescription() + "\";");
        stream.println("     position = (" + (int)node.getPosition().getX() + " " + (int)node.getPosition().getY() + ");");
    }

    public boolean supports(String extension, boolean isLoadOnly) {
        return SUPPORTED_EXTENSIONS[0].equalsIgnoreCase(extension) && isLoadOnly;
    }

    public String[] getSupportedFileExtensions(boolean isLoadOnly) {
        return isLoadOnly ? SUPPORTED_EXTENSIONS : null;
    }

    public String getSupportedFilesDescription(boolean isLoadOnly) {
        return isLoadOnly ? "Netica (.dne)" : null;
    }

    public boolean supports(File file, boolean isLoadOnly) {
        String fileExtension = null;
        try {
            int index = file.getName().lastIndexOf(".");
            if (index >= 0) {
                fileExtension = file.getName().substring(index + 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return this.supports(fileExtension, isLoadOnly);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setToUseAbsurdState(boolean isToUseAbsurdState) {
        this.isToUseAbsurdState = isToUseAbsurdState;
    }

    public boolean isToUseAbsurdState() {
        return this.isToUseAbsurdState;
    }

    public boolean isToAppendLevelsToState() {
        return this.isToAppendLevelsToState;
    }

    public void setToAppendLevelsToState(boolean isToAppendLevelsToState) {
        this.isToAppendLevelsToState = isToAppendLevelsToState;
    }

    public class HasImpossProbDeclarationException
    extends IOException {
        private static final long serialVersionUID = 5193370925842884205L;

        public HasImpossProbDeclarationException() {
        }

        public HasImpossProbDeclarationException(String message, Throwable cause) {
            super(message, cause);
        }

        public HasImpossProbDeclarationException(String message) {
            super(message);
        }

        public HasImpossProbDeclarationException(Throwable cause) {
            super(cause);
        }
    }
}

