/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import unbbayes.io.BaseIO;
import unbbayes.io.exception.LoadException;
import unbbayes.prs.Graph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileExtensionIODelegator
implements BaseIO {
    private List<BaseIO> delegators;
    private String name = "Delegator by file extension";

    protected FileExtensionIODelegator() {
        this.setDelegators(new ArrayList<BaseIO>());
    }

    public static FileExtensionIODelegator newInstance() {
        return new FileExtensionIODelegator();
    }

    public List<BaseIO> getCompatibleIOs(File file, boolean isLoadOnly) {
        ArrayList<BaseIO> compatibleIOs = new ArrayList<BaseIO>();
        for (BaseIO io : this.getDelegators()) {
            if (!io.supports(file, isLoadOnly)) continue;
            compatibleIOs.add(io);
        }
        return compatibleIOs;
    }

    @Override
    public Graph load(File input) throws LoadException, IOException {
        if (this.getDelegators() == null || input == null) {
            throw new LoadException();
        }
        List<BaseIO> compatibleIOs = this.getCompatibleIOs(input, true);
        if (compatibleIOs.size() == 1) {
            return compatibleIOs.iterator().next().load(input);
        }
        if (compatibleIOs.size() > 1) {
            throw new MoreThanOneCompatibleIOException(compatibleIOs);
        }
        throw new LoadException();
    }

    @Override
    public void save(File output, Graph net) throws IOException {
        if (this.getDelegators() == null || output == null) {
            throw new IOException();
        }
        List<BaseIO> compatibleIOs = this.getCompatibleIOs(output, false);
        if (compatibleIOs.size() == 1) {
            compatibleIOs.iterator().next().save(output, net);
            return;
        }
        if (compatibleIOs.size() > 1) {
            throw new MoreThanOneCompatibleIOException(compatibleIOs);
        }
        throw new IOException();
    }

    @Override
    public boolean supports(File file, boolean isLoadOnly) {
        if (this.getDelegators() == null) {
            return false;
        }
        for (BaseIO io : this.getDelegators()) {
            if (!io.supports(file, isLoadOnly)) continue;
            return true;
        }
        return false;
    }

    public List<BaseIO> getDelegators() {
        return this.delegators;
    }

    public void setDelegators(List<BaseIO> delegators) {
        this.delegators = delegators;
    }

    @Override
    public String[] getSupportedFileExtensions(boolean isLoadOnly) {
        ArrayList<String> ret = new ArrayList<String>();
        List<BaseIO> delegators = this.getDelegators();
        if (delegators != null) {
            for (BaseIO io : delegators) {
                String[] delegatorExtensions = io.getSupportedFileExtensions(isLoadOnly);
                if (delegatorExtensions == null) continue;
                String[] stringArray = delegatorExtensions;
                int n = delegatorExtensions.length;
                int n2 = 0;
                while (n2 < n) {
                    String ext = stringArray[n2];
                    ret.add(ext);
                    ++n2;
                }
            }
        }
        return ret.toArray(new String[ret.size()]);
    }

    @Override
    public String getSupportedFilesDescription(boolean isLoadOnly) {
        String ret = new String();
        List<BaseIO> delegators = this.getDelegators();
        if (delegators != null) {
            for (BaseIO io : delegators) {
                String desc = io.getSupportedFilesDescription(isLoadOnly);
                if (desc == null || desc.trim().length() <= 0) continue;
                ret = String.valueOf(ret) + desc + ", ";
            }
        }
        if (ret.lastIndexOf(", ") < 0) {
            return ret;
        }
        return ret.substring(0, ret.lastIndexOf(", "));
    }

    public static String[] getNamesFromIOs(List<BaseIO> ios) {
        String[] ret = new String[ios.size()];
        int i = 0;
        while (i < ios.size()) {
            ret[i] = ios.get(i).getName();
            ++i;
        }
        return ret;
    }

    public static BaseIO findIOByName(List<BaseIO> ios, String name) {
        if (name == null) {
            for (BaseIO baseIO : ios) {
                if (baseIO.getName() != null) continue;
                return baseIO;
            }
        } else {
            for (BaseIO baseIO : ios) {
                if (!name.equals(baseIO.getName())) continue;
                return baseIO;
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MoreThanOneCompatibleIOException
    extends IOException {
        private static final long serialVersionUID = 2794093384529074900L;
        private List<BaseIO> ios;

        public MoreThanOneCompatibleIOException(List<BaseIO> ios) {
            this("More than one plausible I/O was found.", ios);
        }

        public MoreThanOneCompatibleIOException(String message, List<BaseIO> ios) {
            this(message, null, ios);
        }

        public MoreThanOneCompatibleIOException(String message, Throwable t, List<BaseIO> ios) {
            super(message);
            this.ios = ios;
            if (t != null) {
                this.setStackTrace(t.getStackTrace());
                this.initCause(t);
            }
        }

        public List<BaseIO> getIOs() {
            if (this.ios == null) {
                this.ios = new ArrayList<BaseIO>();
            }
            return this.ios;
        }
    }
}

