/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import unbbayes.io.BaseIO;
import unbbayes.io.exception.LoadException;
import unbbayes.prs.Graph;
import unbbayes.prs.Node;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.bn.SingleEntityNetwork;
import unbbayes.util.Debug;

public class LibDAIFactorGraphIO
implements BaseIO {
    public static final String[] SUPPORTED_EXTENSIONS = new String[]{"fg"};
    private String name = "LibDAI_Factor_Graph";

    public Graph load(File input) throws LoadException, IOException {
        throw new RuntimeException("Loading of " + this.getName() + " is not implemented yet");
    }

    public synchronized void save(File output, Graph graph) throws IOException {
        String lineSeparatorBkp = System.getProperty("line.separator");
        if (lineSeparatorBkp == null || !lineSeparatorBkp.equals("\n")) {
            System.setProperty("line.separator", "\n");
        }
        PrintStream stream = new PrintStream(new FileOutputStream(output));
        SingleEntityNetwork net = (SingleEntityNetwork)graph;
        stream.println(net.getNodeCount());
        for (Node node : net.getNodes()) {
            if (node == null || !(node instanceof ProbabilisticNode)) {
                Debug.println(this.getClass(), node + " is not a probabilistic node. Ignoring...");
                continue;
            }
            PotentialTable cpt = ((ProbabilisticNode)node).getProbabilityFunction();
            if (cpt == null || cpt.getVariablesSize() <= 0) {
                Debug.println(this.getClass(), node + " has an invalid CPT. Ignoring...");
                continue;
            }
            stream.println();
            stream.println(cpt.getVariablesSize());
            int i = 0;
            while (i < cpt.getVariablesSize()) {
                int nodeIndex = net.getNodeIndex(cpt.getVariableAt(i).getName());
                if (i < 0) {
                    System.setProperty("line.separator", lineSeparatorBkp);
                    throw new IllegalArgumentException("Indexes of nodes in " + net + " are inconsistent.");
                }
                stream.print(nodeIndex);
                if (i + 1 < cpt.getVariablesSize()) {
                    stream.print(" ");
                }
                ++i;
            }
            stream.println();
            i = 0;
            while (i < cpt.getVariablesSize()) {
                stream.print(cpt.getVariableAt(i).getStatesSize());
                if (i + 1 < cpt.getVariablesSize()) {
                    stream.print(" ");
                }
                ++i;
            }
            stream.println();
            stream.println(cpt.tableSize());
            i = 0;
            while (i < cpt.tableSize()) {
                stream.println(String.valueOf(i) + "\t" + cpt.getValue(i));
                ++i;
            }
        }
        System.setProperty("line.separator", lineSeparatorBkp);
    }

    public boolean supports(File file, boolean isLoadOnly) {
        return !isLoadOnly && file.getName().toUpperCase().endsWith("." + SUPPORTED_EXTENSIONS[0].toUpperCase());
    }

    public String[] getSupportedFileExtensions(boolean isLoadOnly) {
        if (isLoadOnly) {
            return null;
        }
        return SUPPORTED_EXTENSIONS;
    }

    public String getSupportedFilesDescription(boolean isLoadOnly) {
        return isLoadOnly ? null : "LibDAI's factor graph (.fg)";
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

