/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.io;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import unbbayes.io.log.TextLogManager;
import unbbayes.prs.Node;
import unbbayes.prs.bn.Clique;
import unbbayes.prs.bn.IJunctionTree;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.Separator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkCompilationLogManager
extends TextLogManager {
    private static final long serialVersionUID = 4774442720083112613L;

    @Override
    public void reset() {
        this.clear();
    }

    public void finishLog(IJunctionTree tree, ArrayList<Node> nodes) {
        Node node;
        int c2;
        PotentialTable auxTab;
        Clique auxClique;
        if (!this.isEnabled().booleanValue()) {
            return;
        }
        List<Clique> clicks = tree.getCliques();
        DecimalFormat df = new DecimalFormat();
        this.append(resource.getString("cliqueHeader"));
        int sizeclicks1 = clicks.size();
        int c = 0;
        while (c < sizeclicks1) {
            auxClique = clicks.get(c);
            int sizenodes1 = auxClique.getNodes().size();
            this.append(String.valueOf(resource.getString("cliqueName")) + c + " (" + auxClique.getNodesList().size() + ")" + "\n");
            int c22 = 0;
            while (c22 < sizenodes1) {
                this.append(String.valueOf(auxClique.getNodes().get(c22).getName()) + "-");
                ++c22;
            }
            this.append(resource.getString("potentialTableName"));
            auxTab = auxClique.getProbabilityFunction();
            int sizeDados = auxTab.tableSize();
            c2 = 0;
            while (c2 < sizeDados) {
                this.append(String.valueOf(df.format(auxTab.getValue(c2))) + " ");
                ++c2;
            }
            this.append(resource.getString("utilityTableName"));
            auxTab = auxClique.getUtilityTable();
            sizeDados = auxTab.tableSize();
            c2 = 0;
            while (c2 < sizeDados) {
                this.append(String.valueOf(df.format(auxTab.getValue(c2))) + " ");
                ++c2;
            }
            this.append("\n\n");
            ++c;
        }
        this.append(resource.getString("separatorHeader"));
        for (Separator auxSep : tree.getSeparators()) {
            this.append(String.valueOf(resource.getString("separatorName")) + auxSep + " ");
            this.append(String.valueOf(resource.getString("betweenName")) + clicks.indexOf(auxSep.getClique1()) + resource.getString("andName") + clicks.indexOf(auxSep.getClique2()) + "\n");
            this.append(resource.getString("nodeName"));
            int sizenodes2 = auxSep.getNodes().size();
            c2 = 0;
            while (c2 < sizenodes2) {
                node = auxSep.getNodes().get(c2);
                this.append(String.valueOf(node.getName()) + "-");
                ++c2;
            }
            this.append("\n");
            auxTab = auxSep.getProbabilityFunction();
            if (auxTab == null) continue;
            int sizeDados = auxTab.tableSize();
            int c23 = 0;
            while (c23 < sizeDados) {
                this.append(String.valueOf(df.format(auxTab.getValue(c23))) + " ");
                ++c23;
            }
            this.append("\n\n");
        }
        this.append(resource.getString("potentialAssociatedHeader"));
        int sizenodes3 = nodes.size();
        int c3 = 0;
        while (c3 < sizenodes3) {
            node = nodes.get(c3);
            int sizeclicks = clicks.size();
            c2 = 0;
            while (c2 < sizeclicks) {
                auxClique = clicks.get(c2);
                if (auxClique.getAssociatedProbabilisticNodes().contains(node) || auxClique.getAssociatedUtilityNodes().contains(node)) {
                    this.append(String.valueOf(resource.getString("nodeName")) + node.getName() + resource.getString("cliqueLabel") + c2 + "\n");
                    break;
                }
                ++c2;
            }
            ++c3;
        }
    }
}

