/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.io;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBException;
import unbbayes.io.BaseIO;
import unbbayes.io.exception.LoadException;
import unbbayes.io.exception.UBIOException;
import unbbayes.io.resources.IoResources;
import unbbayes.prs.Graph;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.SingleEntityNetwork;
import unbbayes.util.ResourceController;

public class XMLBIFIO
implements BaseIO {
    private static ResourceBundle resource = ResourceController.newInstance().getBundle(IoResources.class.getName());
    public static final String[] SUPPORTED_EXTENSIONS = new String[]{"xml"};
    private String name = "Core XMLBIF";

    public ProbabilisticNetwork load(File input) throws LoadException, IOException {
        int index = input.getName().lastIndexOf(46);
        String id = input.getName().substring(0, index);
        ProbabilisticNetwork pn = new ProbabilisticNetwork(id);
        try {
            unbbayes.io.xmlbif.version6.XMLBIFIO.loadXML(input, pn);
        }
        catch (Exception e) {
            try {
                unbbayes.io.xmlbif.version5.XMLBIFIO.loadXML(input, pn);
            }
            catch (Exception e2) {
                try {
                    unbbayes.io.xmlbif.version4.XMLBIFIO.loadXML(input, pn);
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                    throw new LoadException(resource.getString("UnsupportedError"));
                }
            }
        }
        return pn;
    }

    public void save(File output, Graph graph) throws IOException {
        SingleEntityNetwork net = (SingleEntityNetwork)graph;
        FileWriter outputxml = new FileWriter(output);
        try {
            unbbayes.io.xmlbif.version6.XMLBIFIO.saveXML(outputxml, net);
        }
        catch (JAXBException e) {
            throw new UBIOException(e);
        }
        outputxml.flush();
        outputxml.close();
    }

    public boolean supports(String extension, boolean isLoadOnly) {
        return SUPPORTED_EXTENSIONS[0].equalsIgnoreCase(extension);
    }

    public String[] getSupportedFileExtensions(boolean isLoadOnly) {
        return SUPPORTED_EXTENSIONS;
    }

    public String getSupportedFilesDescription(boolean isLoadOnly) {
        return "XMLBIF (.xml)";
    }

    public boolean supports(File file, boolean isLoadOnly) {
        String fileExtension = null;
        try {
            int index = file.getName().lastIndexOf(".");
            if (index >= 0) {
                fileExtension = file.getName().substring(index + 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return this.supports(fileExtension, isLoadOnly);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

