/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.io.exception;

import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import unbbayes.io.resources.IoResources;
import unbbayes.util.Debug;
import unbbayes.util.ResourceController;

public class UBIOException
extends IOException {
    private static final long serialVersionUID = -960272033310829358L;
    public static final String ED_OPEN_FILE = "OpenFileError";
    public static final String ED_CREATE_FILE = "CreationFileError";
    public static final String ED_READWRITE_FILE = "WriteReaderFileError";
    private String detailMessage = "";
    private static ResourceBundle resource = null;

    static {
        try {
            resource = ResourceController.newInstance().getBundle(IoResources.class.getName());
        }
        catch (Throwable t) {
            try {
                Debug.println(UBIOException.class, "Error obtaining UBIOException's classloader using plugins. Using UBIOException's classloader instead...", t);
                resource = ResourceController.newInstance().getBundle(IoResources.class.getName(), Locale.getDefault(), UBIOException.class.getClassLoader());
            }
            catch (Throwable t2) {
                Debug.println(UBIOException.class, "Error obtaining UBIOException's classloader using unbbayes.util.ResourceController. Using ResourceBundle instead...", t2);
                resource = ResourceBundle.getBundle(IoResources.class.getName());
            }
        }
    }

    public UBIOException(String key) {
        try {
            this.detailMessage = resource.getString(key);
        }
        catch (Throwable e) {
            this.detailMessage = key;
        }
    }

    public UBIOException(String key, String object) {
        try {
            this.detailMessage = String.valueOf(resource.getString(key)) + ": " + object;
        }
        catch (Throwable e) {
            this.detailMessage = String.valueOf(key) + ": " + object;
        }
    }

    public UBIOException(Throwable e) {
        this.setStackTrace(e.getStackTrace());
        this.initCause(e);
    }

    public UBIOException(String key, Throwable e) {
        this(key);
        this.setStackTrace(e.getStackTrace());
        this.initCause(e);
    }

    public String getMessage() {
        return this.detailMessage;
    }
}

