/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.io.extension.jpf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;
import unbbayes.io.BaseIO;
import unbbayes.io.FileExtensionIODelegator;
import unbbayes.util.extension.manager.UnBBayesPluginContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginAwareFileExtensionIODelegator
extends FileExtensionIODelegator {
    private String corePluginID;
    private String extensionPointID = "PNIO";
    private String extensionPointClassParam = "class";
    private String extensionPointNameParam = "name";
    private UnBBayesPluginContextHolder unbbayesPluginContextHolder = UnBBayesPluginContextHolder.newInstance();

    public PluginAwareFileExtensionIODelegator() {
        this.setCorePluginID(this.getUnbbayesPluginContextHolder().getPluginCoreID());
        UnBBayesPluginContextHolder.newInstance().addListener(new UnBBayesPluginContextHolder.OnReloadActionListener(){

            public void onReload(EventObject eventObject) {
                try {
                    PluginAwareFileExtensionIODelegator.this.reloadPlugins();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static PluginAwareFileExtensionIODelegator newInstance() {
        return PluginAwareFileExtensionIODelegator.newInstance(true);
    }

    public static PluginAwareFileExtensionIODelegator newInstance(boolean loadPlugins) {
        PluginAwareFileExtensionIODelegator ret = new PluginAwareFileExtensionIODelegator();
        ret.setDelegators(new ArrayList<BaseIO>());
        if (loadPlugins) {
            ret.getDelegators().addAll(ret.loadIOAsPlugins());
        }
        return ret;
    }

    public void reloadPlugins() {
        this.setDelegators(new ArrayList<BaseIO>());
        this.getDelegators().addAll(this.loadIOAsPlugins());
    }

    protected Collection<BaseIO> loadIOAsPlugins() {
        ArrayList<BaseIO> ret = new ArrayList<BaseIO>();
        try {
            PluginDescriptor core = this.getUnbbayesPluginContextHolder().getPluginManager().getRegistry().getPluginDescriptor(this.getCorePluginID());
            ExtensionPoint point = this.getUnbbayesPluginContextHolder().getPluginManager().getRegistry().getExtensionPoint(core.getId(), this.getExtensionPointID());
            for (Extension ext : point.getConnectedExtensions()) {
                try {
                    PluginDescriptor descr = ext.getDeclaringPluginDescriptor();
                    this.getUnbbayesPluginContextHolder().getPluginManager().activatePlugin(descr.getId());
                    Extension.Parameter classParam = ext.getParameter(this.getExtensionPointClassParam());
                    Extension.Parameter nameParam = ext.getParameter(this.getExtensionPointNameParam());
                    PluginClassLoader classLoader = this.getUnbbayesPluginContextHolder().getPluginManager().getPluginClassLoader(descr);
                    Class<?> pluginCls = null;
                    pluginCls = classLoader.loadClass(classParam.valueAsString());
                    BaseIO pluginIOObject = (BaseIO)pluginCls.newInstance();
                    pluginIOObject.setName(nameParam.valueAsString());
                    ret.add(pluginIOObject);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return ret;
    }

    public String getExtensionPointID() {
        return this.extensionPointID;
    }

    public void setExtensionPointID(String extensionPointID) {
        this.extensionPointID = extensionPointID;
    }

    public String getExtensionPointClassParam() {
        return this.extensionPointClassParam;
    }

    public void setExtensionPointClassParam(String extensionPointClassParam) {
        this.extensionPointClassParam = extensionPointClassParam;
    }

    public UnBBayesPluginContextHolder getUnbbayesPluginContextHolder() {
        return this.unbbayesPluginContextHolder;
    }

    public void setUnbbayesPluginContextHolder(UnBBayesPluginContextHolder unbbayesPluginContextHolder) {
        this.unbbayesPluginContextHolder = unbbayesPluginContextHolder;
    }

    public String getExtensionPointNameParam() {
        return this.extensionPointNameParam;
    }

    public void setExtensionPointNameParam(String extensionPointNameParam) {
        this.extensionPointNameParam = extensionPointNameParam;
    }

    public String getCorePluginID() {
        return this.corePluginID;
    }

    public void setCorePluginID(String corePluginID) {
        this.corePluginID = corePluginID;
    }

    public static /* bridge */ /* synthetic */ FileExtensionIODelegator newInstance() {
        return PluginAwareFileExtensionIODelegator.newInstance();
    }
}

