/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.io.log;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ResourceBundle;
import unbbayes.io.log.ILogManager;
import unbbayes.io.resources.IoResources;
import unbbayes.util.Debug;
import unbbayes.util.ResourceController;

public class TextLogManager
implements ILogManager,
Serializable {
    private static final long serialVersionUID = 0L;
    public static final int DEFAULT_BUFFER_SIZE = 10240;
    public static final String DEFAULT_FILENAME = "aj.txt";
    public static final int numColumn = 80;
    public static final String separator = "*";
    public static final String identationString = "  ";
    private StringBuffer log;
    protected static ResourceBundle resource = ResourceController.newInstance().getBundle(IoResources.class.getName());
    private Boolean enabled = true;

    public TextLogManager(int bufferSize) {
        this.log = new StringBuffer(bufferSize);
        this.reset();
    }

    public TextLogManager() {
        this(10240);
    }

    public void clear() {
        this.log.setLength(0);
    }

    public void reset() {
        this.clear();
    }

    public void append(String text) {
        this.log.append(text);
        Debug.print(text);
    }

    public void appendIfTrue(boolean debug, String text) {
        if (debug) {
            this.append(text);
        }
    }

    public void appendln(String text) {
        this.log.append(text);
        this.log.append("\n");
        Debug.println(text);
    }

    public void appendlnIfTrue(boolean debug, String text) {
        if (debug) {
            this.appendln(text);
        }
    }

    public void appendln(int identation, String text) {
        int i = 0;
        while (i < identation) {
            this.log.append(identationString);
            Debug.print(" ");
            ++i;
        }
        this.log.append(text);
        this.log.append("\n");
        Debug.println(text);
    }

    public void appendlnIfTrue(int identation, boolean debug, String text) {
        if (debug) {
            this.appendln(identation, text);
        }
    }

    public void appendSeparator() {
        int i = 0;
        while (i < 80) {
            this.append(separator);
            ++i;
        }
        this.append("\n\n");
    }

    public String getLog() {
        return this.log.toString();
    }

    public void writeToDisk(String fileName, boolean append) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(fileName, append));
        out.write(this.getLog());
        out.flush();
        out.close();
    }

    public void addTitle(String text) {
        this.appendSeparator();
        this.appendln(text);
        this.appendSeparator();
        this.appendln(" ");
    }

    public void appendSectionTitle(String text) {
        this.append("\n" + text.toUpperCase() + "\n");
    }

    public void appendSpecialTitle(String text) {
        this.appendln(".");
        this.appendln(".");
        this.appendln("................................................................................");
        this.appendln(". " + text);
        this.appendln("................................................................................");
        this.appendln(".");
        this.appendln(".");
        this.appendln("");
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }
}

