/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.io.xmlbif.version6;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.xml.sax.InputSource;
import unbbayes.gui.HierarchicTree;
import unbbayes.io.exception.LoadException;
import unbbayes.io.xmlbif.version5.VariableType;
import unbbayes.io.xmlbif.version6.DistributionType;
import unbbayes.io.xmlbif.version6.EvidenceType;
import unbbayes.io.xmlbif.version6.xmlclasses.ObjectFactory;
import unbbayes.io.xmlbif.version6.xmlclasses.XMLBIF;
import unbbayes.io.xmlbif.version6.xmlclasses.XMLBIFType;
import unbbayes.prs.Edge;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ExplanationPhrase;
import unbbayes.prs.bn.IProbabilityFunction;
import unbbayes.prs.bn.IRandomVariable;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.bn.SingleEntityNetwork;
import unbbayes.prs.exception.InvalidParentException;
import unbbayes.prs.hybridbn.CNNormalDistribution;
import unbbayes.prs.hybridbn.ContinuousNode;
import unbbayes.prs.id.DecisionNode;
import unbbayes.prs.id.UtilityNode;
import unbbayes.util.ArrayMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLBIFIO {
    public static void loadXML(File input, SingleEntityNetwork pn) throws LoadException, IOException, JAXBException {
        InputSource isource = new InputSource(new FileInputStream(input));
        JAXBContext context = JAXBContext.newInstance((String)"unbbayes.io.xmlbif.version6.xmlclasses");
        Unmarshaller unmarshaller = context.createUnmarshaller();
        unmarshaller.setValidating(true);
        XMLBIF XMLBIF2 = (XMLBIF)unmarshaller.unmarshal(isource);
        XMLBIFType.HeaderType header = XMLBIF2.getHeader();
        pn.setName(header.getName());
        XMLBIFType.StaticPropertyType staticProperty = XMLBIF2.getStaticProperty();
        pn.setRadius(staticProperty.getNodeSize() / 2);
        XMLBIFType.HierarchyType hierarchy = XMLBIF2.getHierarchy();
        if (hierarchy.getRoot().size() > 0) {
            DefaultMutableTreeNode root = XMLBIFIO.loadHierarchicTree(hierarchy);
            DefaultTreeModel model = new DefaultTreeModel(root);
            HierarchicTree hierarchicTree = new HierarchicTree(model);
            pn.setHierarchicTree(hierarchicTree);
        }
        XMLBIFType.NetworkType network = XMLBIF2.getNetwork();
        XMLBIFType.NetworkType.VariablesType variables = network.getVariables();
        List variableList = variables.getVariable();
        int i = 0;
        while (i < variableList.size()) {
            pn.addNode(XMLBIFIO.makeNode((XMLBIFType.NetworkType.VariablesType.VariableType)variableList.get(i)));
            ++i;
        }
        XMLBIFType.NetworkType.StructureType structure = network.getStructure();
        List edgeList = structure.getEdge();
        int i2 = 0;
        while (i2 < edgeList.size()) {
            XMLBIFType.NetworkType.StructureType.EdgeType edge = (XMLBIFType.NetworkType.StructureType.EdgeType)edgeList.get(i2);
            try {
                pn.addEdge(new Edge(pn.getNode(edge.getParent()), pn.getNode(edge.getChild())));
            }
            catch (InvalidParentException e) {
                throw new LoadException(e.getMessage());
            }
            ++i2;
        }
        XMLBIFType.NetworkType.ConditionalDistributionSetType conditionalDistributionSet = network.getConditionalDistributionSet();
        List distributionList = conditionalDistributionSet.getConditionalDistribution();
        int i3 = 0;
        while (i3 < distributionList.size()) {
            XMLBIFType.NetworkType.ConditionalDistributionSetType.ConditionalDistributionType distribution = (XMLBIFType.NetworkType.ConditionalDistributionSetType.ConditionalDistributionType)distributionList.get(i3);
            Node childNode = pn.getNode(distribution.getOwner().getName());
            XMLBIFType.NetworkType.ConditionalDistributionSetType.ConditionalDistributionType.ParentsType parents = distribution.getParents();
            XMLBIFType.NetworkType.ConditionalDistributionSetType.ConditionalDistributionType.CPTType cpt = distribution.getCPT();
            XMLBIFType.NetworkType.ConditionalDistributionSetType.ConditionalDistributionType.NormalType normal = distribution.getNormal();
            if (cpt != null) {
                List dpiList = cpt.getDependentParentIndex();
                PotentialTable table = (PotentialTable)((IRandomVariable)((Object)childNode)).getProbabilityFunction();
                if (parents != null) {
                    List parentList = parents.getParent();
                    int j = 0;
                    while (j < parentList.size()) {
                        XMLBIFType.NetworkType.ConditionalDistributionSetType.ConditionalDistributionType.ParentsType.ParentType parent = (XMLBIFType.NetworkType.ConditionalDistributionSetType.ConditionalDistributionType.ParentsType.ParentType)parentList.get(j);
                        table.setVariableAt(parent.getIndex() + 1, pn.getNode(parent.getName()));
                        ++j;
                    }
                }
                int dpiIndex = 0;
                while (dpiIndex < dpiList.size()) {
                    XMLBIFType.NetworkType.ConditionalDistributionSetType.ConditionalDistributionType.CPTType.DependentParentIndexType dpi = (XMLBIFType.NetworkType.ConditionalDistributionSetType.ConditionalDistributionType.CPTType.DependentParentIndexType)dpiList.get(dpiIndex);
                    table.setValue(dpi.getIndex(), (float)dpi.getValue());
                    ++dpiIndex;
                }
            } else if (normal != null) {
                CNNormalDistribution normalDistribution = ((ContinuousNode)childNode).getCnNormalDistribution();
                normalDistribution.refreshParents();
                List functionList = normal.getFunction();
                int functionIndex = 0;
                while (functionIndex < functionList.size()) {
                    XMLBIFType.NetworkType.ConditionalDistributionSetType.ConditionalDistributionType.NormalType.FunctionType function = (XMLBIFType.NetworkType.ConditionalDistributionSetType.ConditionalDistributionType.NormalType.FunctionType)functionList.get(functionIndex);
                    normalDistribution.setMean(function.getMean(), function.getIndex());
                    normalDistribution.setVariance(function.getVariance(), function.getIndex());
                    XMLBIFType.NetworkType.ConditionalDistributionSetType.ConditionalDistributionType.NormalType.FunctionType.ConstantsType constants = function.getConstants();
                    if (constants != null) {
                        List constantList = constants.getConstant();
                        int constantIndex = 0;
                        while (constantIndex < constantList.size()) {
                            XMLBIFType.NetworkType.ConditionalDistributionSetType.ConditionalDistributionType.NormalType.FunctionType.ConstantsType.ConstantType constant = (XMLBIFType.NetworkType.ConditionalDistributionSetType.ConditionalDistributionType.NormalType.FunctionType.ConstantsType.ConstantType)constantList.get(constantIndex);
                            normalDistribution.setConstantAt(constant.getIndex(), constant.getValue(), function.getIndex());
                            ++constantIndex;
                        }
                    }
                    ++functionIndex;
                }
            }
            ++i3;
        }
    }

    public static void saveXML(FileWriter arqoutput, SingleEntityNetwork net) throws JAXBException {
        PrintWriter arq = new PrintWriter(arqoutput);
        ObjectFactory of = new ObjectFactory();
        XMLBIF xmlBif = of.createXMLBIF();
        xmlBif.setVersion(0.6);
        XMLBIFType.HeaderType header = of.createXMLBIFTypeHeaderType();
        header.setName(net.getName());
        header.setVersion(1.0);
        header.setCreator("UnBBayes");
        xmlBif.setHeader(header);
        XMLBIFType.StaticPropertyType staticProperty = of.createXMLBIFTypeStaticPropertyType();
        staticProperty.setNodeSize((int)net.getRadius() * 2);
        xmlBif.setStaticProperty(staticProperty);
        HierarchicTree ht = net.getHierarchicTree();
        XMLBIFType.HierarchyType hierarchy = of.createXMLBIFTypeHierarchyType();
        TreeModel model = ht.getModel();
        TreeNode root = (TreeNode)model.getRoot();
        XMLBIFIO.processTreeNode(root, model, hierarchy);
        xmlBif.setHierarchy(hierarchy);
        XMLBIFType.NetworkType network = of.createXMLBIFTypeNetworkType();
        XMLBIFIO.writeXMLBIFNetwork(network, net);
        xmlBif.setNetwork(network);
        JAXBContext context = JAXBContext.newInstance((String)"unbbayes.io.xmlbif.version6.xmlclasses");
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"US-ASCII");
        marshaller.marshal((Object)xmlBif, (Writer)arq);
    }

    private static void writeXMLBIFNetwork(XMLBIFType.NetworkType XMLBIFNetwork, SingleEntityNetwork net) throws JAXBException {
        ObjectFactory of = new ObjectFactory();
        XMLBIFType.NetworkType.VariablesType networkVariables = of.createXMLBIFTypeNetworkTypeVariablesType();
        int i = 0;
        while (i < net.getNodeCount()) {
            Node node = net.getNodeAt(i);
            XMLBIFType.NetworkType.VariablesType.VariableType variable = of.createXMLBIFTypeNetworkTypeVariablesTypeVariableType();
            variable.setName(node.getName());
            if (node.getType() == 5) {
                variable.setType(VariableType.CONTINUOUSPROBABILISTIC.toString());
            } else if (node.getType() == 1) {
                variable.setType(VariableType.UTILITY.toString());
            } else if (node.getType() == 2) {
                variable.setType(VariableType.DECISION.toString());
            } else {
                variable.setType(VariableType.DISCRETEPROBABILISTIC.toString());
            }
            variable.setXPos((int)node.getPosition().getX());
            variable.setYPos((int)node.getPosition().getY());
            variable.setWidth(node.getWidth());
            variable.setHeight(node.getHeight());
            variable.setRgbColor(node.getColor().getRGB());
            variable.setDescription(node.getDescription());
            int j = 0;
            while (j < node.getStatesSize()) {
                XMLBIFType.NetworkType.VariablesType.VariableType.StateType state = of.createXMLBIFTypeNetworkTypeVariablesTypeVariableTypeStateType();
                state.setName(node.getStateAt(j));
                variable.getState().add(state);
                ++j;
            }
            if (node.getInformationType() == 4) {
                XMLBIFType.NetworkType.VariablesType.VariableType.MetaphoreType metaphore = of.createXMLBIFTypeNetworkTypeVariablesTypeVariableTypeMetaphoreType();
                String explanationDescription = node.getExplanationDescription();
                metaphore.setDescription(explanationDescription);
                ArrayMap<String, ExplanationPhrase> arrayMap = node.getPhrasesMap();
                int size = arrayMap.size();
                ArrayList<String> keys = arrayMap.getKeys();
                int k = 0;
                while (k < size) {
                    String key = keys.get(k);
                    ExplanationPhrase explanationPhrase = arrayMap.get(key);
                    XMLBIFType.NetworkType.VariablesType.VariableType.MetaphoreType.ExplanationType explanation = of.createXMLBIFTypeNetworkTypeVariablesTypeVariableTypeMetaphoreTypeExplanationType();
                    explanation.setEvidence(explanationPhrase.getNode());
                    explanation.setComments(explanationPhrase.getPhrase());
                    switch (explanationPhrase.getEvidenceType()) {
                        case 2: {
                            explanation.setEvidenceType(EvidenceType.COMPLEMENTARY.toString());
                            break;
                        }
                        case 3: {
                            explanation.setEvidenceType(EvidenceType.EXCLUSIVE.toString());
                            break;
                        }
                        case 1: {
                            explanation.setEvidenceType(EvidenceType.NECESSARY.toString());
                            break;
                        }
                        case 0: {
                            explanation.setEvidenceType(EvidenceType.TRIGGER.toString());
                            break;
                        }
                        case 4: {
                            explanation.setEvidenceType(EvidenceType.NA.toString());
                        }
                    }
                    metaphore.getExplanation().add(explanation);
                    ++k;
                }
                variable.setMetaphore(metaphore);
            }
            networkVariables.getVariable().add(variable);
            ++i;
        }
        XMLBIFNetwork.setVariables(networkVariables);
        XMLBIFType.NetworkType.StructureType networkStructure = of.createXMLBIFTypeNetworkTypeStructureType();
        for (Edge edge : net.getEdges()) {
            XMLBIFType.NetworkType.StructureType.EdgeType structureEdge = of.createXMLBIFTypeNetworkTypeStructureTypeEdgeType();
            structureEdge.setParent(edge.getOriginNode().getName());
            structureEdge.setChild(edge.getDestinationNode().getName());
            networkStructure.getEdge().add(structureEdge);
        }
        XMLBIFNetwork.setStructure(networkStructure);
        XMLBIFType.NetworkType.ConditionalDistributionSetType conditionalDistributionSet = of.createXMLBIFTypeNetworkTypeConditionalDistributionSetType();
        for (Node node : net.getNodes()) {
            if (node instanceof DecisionNode) continue;
            XMLBIFType.NetworkType.ConditionalDistributionSetType.ConditionalDistributionType conditionalDistribution = of.createXMLBIFTypeNetworkTypeConditionalDistributionSetTypeConditionalDistributionType();
            XMLBIFType.NetworkType.ConditionalDistributionSetType.ConditionalDistributionType.OwnerType owner = of.createXMLBIFTypeNetworkTypeConditionalDistributionSetTypeConditionalDistributionTypeOwnerType();
            owner.setName(node.getName());
            conditionalDistribution.setOwner(owner);
            XMLBIFType.NetworkType.ConditionalDistributionSetType.ConditionalDistributionType.ParentsType parents = of.createXMLBIFTypeNetworkTypeConditionalDistributionSetTypeConditionalDistributionTypeParentsType();
            int i2 = 0;
            while (i2 < node.getParents().size()) {
                XMLBIFType.NetworkType.ConditionalDistributionSetType.ConditionalDistributionType.ParentsType.ParentType parent = of.createXMLBIFTypeNetworkTypeConditionalDistributionSetTypeConditionalDistributionTypeParentsTypeParentType();
                parent.setIndex(i2);
                parent.setName(node.getParents().get(i2).getName());
                parents.getParent().add(parent);
                ++i2;
            }
            if (!parents.getParent().isEmpty()) {
                conditionalDistribution.setParents(parents);
            }
            if (node instanceof IRandomVariable) {
                XMLBIFType.NetworkType.ConditionalDistributionSetType.ConditionalDistributionType.CPTType cpt = of.createXMLBIFTypeNetworkTypeConditionalDistributionSetTypeConditionalDistributionTypeCPTType();
                PotentialTable potTable = (PotentialTable)((IRandomVariable)((Object)node)).getProbabilityFunction();
                parents = of.createXMLBIFTypeNetworkTypeConditionalDistributionSetTypeConditionalDistributionTypeParentsType();
                int i3 = 1;
                while (i3 < potTable.variableCount()) {
                    XMLBIFType.NetworkType.ConditionalDistributionSetType.ConditionalDistributionType.ParentsType.ParentType parent = of.createXMLBIFTypeNetworkTypeConditionalDistributionSetTypeConditionalDistributionTypeParentsTypeParentType();
                    Node parentNode = (Node)potTable.getVariableAt(i3);
                    parent.setIndex(i3 - 1);
                    parent.setName(parentNode.getName());
                    parents.getParent().add(parent);
                    ++i3;
                }
                if (!parents.getParent().isEmpty()) {
                    conditionalDistribution.setParents(parents);
                }
                i3 = 0;
                while (i3 < potTable.tableSize()) {
                    XMLBIFType.NetworkType.ConditionalDistributionSetType.ConditionalDistributionType.CPTType.DependentParentIndexType dpi = of.createXMLBIFTypeNetworkTypeConditionalDistributionSetTypeConditionalDistributionTypeCPTTypeDependentParentIndexType();
                    dpi.setIndex(i3);
                    dpi.setValue(potTable.getValue(i3));
                    cpt.getDependentParentIndex().add(dpi);
                    ++i3;
                }
                conditionalDistribution.setCPT(cpt);
                conditionalDistribution.setType(DistributionType.DISCRETE.toString());
            } else if (node instanceof ContinuousNode) {
                XMLBIFType.NetworkType.ConditionalDistributionSetType.ConditionalDistributionType.NormalType normal = of.createXMLBIFTypeNetworkTypeConditionalDistributionSetTypeConditionalDistributionTypeNormalType();
                CNNormalDistribution distribution = ((ContinuousNode)node).getCnNormalDistribution();
                int functionIndex = 0;
                while (functionIndex < distribution.functionSize()) {
                    XMLBIFType.NetworkType.ConditionalDistributionSetType.ConditionalDistributionType.NormalType.FunctionType function = of.createXMLBIFTypeNetworkTypeConditionalDistributionSetTypeConditionalDistributionTypeNormalTypeFunctionType();
                    function.setIndex(functionIndex);
                    function.setMean(distribution.getMean(functionIndex));
                    function.setVariance(distribution.getVariance(functionIndex));
                    XMLBIFType.NetworkType.ConditionalDistributionSetType.ConditionalDistributionType.NormalType.FunctionType.ConstantsType constants = of.createXMLBIFTypeNetworkTypeConditionalDistributionSetTypeConditionalDistributionTypeNormalTypeFunctionTypeConstantsType();
                    int constantIndex = 0;
                    while (constantIndex < distribution.getConstantListSize()) {
                        XMLBIFType.NetworkType.ConditionalDistributionSetType.ConditionalDistributionType.NormalType.FunctionType.ConstantsType.ConstantType constant = of.createXMLBIFTypeNetworkTypeConditionalDistributionSetTypeConditionalDistributionTypeNormalTypeFunctionTypeConstantsTypeConstantType();
                        constant.setIndex(constantIndex);
                        constant.setValue(distribution.getConstantAt(constantIndex, functionIndex));
                        constants.getConstant().add(constant);
                        ++constantIndex;
                    }
                    if (!constants.getConstant().isEmpty()) {
                        function.setConstants(constants);
                    }
                    normal.getFunction().add(function);
                    ++functionIndex;
                }
                conditionalDistribution.setNormal(normal);
                conditionalDistribution.setType(DistributionType.CONTINUOUS.toString());
            }
            conditionalDistributionSet.getConditionalDistribution().add(conditionalDistribution);
        }
        XMLBIFNetwork.setConditionalDistributionSet(conditionalDistributionSet);
    }

    private static Node makeNode(XMLBIFType.NetworkType.VariablesType.VariableType variable) {
        XMLBIFType.NetworkType.VariablesType.VariableType.MetaphoreType metaphore;
        Node node = null;
        VariableType nodeType = VariableType.valueOf(variable.getType().toUpperCase());
        if (nodeType == VariableType.DISCRETEPROBABILISTIC) {
            node = new ProbabilisticNode();
        } else if (nodeType == VariableType.CONTINUOUSPROBABILISTIC) {
            node = new ContinuousNode();
        } else if (nodeType == VariableType.DECISION) {
            node = new DecisionNode();
        } else if (nodeType == VariableType.UTILITY) {
            node = new UtilityNode();
        }
        node.setName(variable.getName());
        node.setDescription(variable.getDescription());
        node.setPosition(variable.getXPos(), variable.getYPos());
        node.setSize(variable.getWidth(), variable.getHeight());
        node.setColor(new Color(variable.getRgbColor()));
        if (nodeType != VariableType.CONTINUOUSPROBABILISTIC) {
            List stateList = variable.getState();
            int j = 0;
            while (j < stateList.size()) {
                XMLBIFType.NetworkType.VariablesType.VariableType.StateType state = (XMLBIFType.NetworkType.VariablesType.VariableType.StateType)stateList.get(j);
                node.appendState(state.getName());
                ++j;
            }
        }
        if ((metaphore = variable.getMetaphore()) != null) {
            node.setInformationType(4);
            node.setExplanationDescription(metaphore.getDescription());
            List explanationList = metaphore.getExplanation();
            if (!explanationList.isEmpty()) {
                int i = 0;
                while (i < explanationList.size()) {
                    XMLBIFType.NetworkType.VariablesType.VariableType.MetaphoreType.ExplanationType explanation = (XMLBIFType.NetworkType.VariablesType.VariableType.MetaphoreType.ExplanationType)explanationList.get(i);
                    ExplanationPhrase explanationPhrase = new ExplanationPhrase();
                    explanationPhrase.setNode(explanation.getEvidence());
                    explanationPhrase.setPhrase(explanation.getComments());
                    EvidenceType evidenceType = EvidenceType.valueOf(explanation.getEvidenceType().toUpperCase());
                    if (evidenceType == EvidenceType.TRIGGER) {
                        explanationPhrase.setEvidenceType(0);
                    } else if (evidenceType == EvidenceType.EXCLUSIVE) {
                        explanationPhrase.setEvidenceType(3);
                    } else if (evidenceType == EvidenceType.NECESSARY) {
                        explanationPhrase.setEvidenceType(1);
                    } else if (evidenceType == EvidenceType.COMPLEMENTARY) {
                        explanationPhrase.setEvidenceType(4);
                    }
                    node.addExplanationPhrase(explanationPhrase);
                    ++i;
                }
            }
        }
        if (node instanceof IRandomVariable) {
            IProbabilityFunction potTable = ((IRandomVariable)((Object)node)).getProbabilityFunction();
            potTable.addVariable(node);
        }
        return node;
    }

    private static void processTreeNode(TreeNode node, TreeModel model, XMLBIFType.HierarchyType hierarchy) throws JAXBException {
        ObjectFactory of = new ObjectFactory();
        ArrayList<TreeNode> childList = new ArrayList<TreeNode>();
        XMLBIFType.HierarchyType.RootType root = of.createXMLBIFTypeHierarchyTypeRootType();
        root.setName(node.toString());
        int childCount = model.getChildCount(node);
        if (!node.isLeaf()) {
            int i = 0;
            while (i < childCount) {
                XMLBIFType.HierarchyType.RootType.LevelType level = of.createXMLBIFTypeHierarchyTypeRootTypeLevelType();
                level.setName(((TreeNode)model.getChild(node, i)).toString());
                childList.add((TreeNode)model.getChild(node, i));
                root.getLevel().add(level);
                ++i;
            }
            hierarchy.getRoot().add(root);
            i = 0;
            while (i < childCount) {
                XMLBIFIO.processTreeNode((TreeNode)model.getChild(node, i), model, hierarchy);
                ++i;
            }
        }
    }

    private static DefaultMutableTreeNode loadHierarchicTree(XMLBIFType.HierarchyType hierarchy) {
        DefaultMutableTreeNode root;
        boolean out = false;
        ArrayList rootList = (ArrayList)hierarchy.getRoot();
        XMLBIFType.HierarchyType.RootType rootXML = (XMLBIFType.HierarchyType.RootType)rootList.get(0);
        DefaultMutableTreeNode actualNode = root = new DefaultMutableTreeNode(rootXML.getName());
        ArrayList<DefaultMutableTreeNode> rootsTree = new ArrayList<DefaultMutableTreeNode>();
        rootsTree.add(actualNode);
        int i = 0;
        while (i < rootList.size()) {
            XMLBIFType.HierarchyType.RootType actualRoot = (XMLBIFType.HierarchyType.RootType)rootList.get(i);
            actualNode = XMLBIFIO.getActualNode(rootsTree, actualRoot.getName());
            ArrayList childList = (ArrayList)actualRoot.getLevel();
            int j = 0;
            while (j < childList.size()) {
                XMLBIFType.HierarchyType.RootType.LevelType child = (XMLBIFType.HierarchyType.RootType.LevelType)childList.get(j);
                DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child.getName());
                actualNode.add(childNode);
                rootsTree.add(childNode);
                ++j;
            }
            ++i;
        }
        return root;
    }

    private static DefaultMutableTreeNode getActualNode(ArrayList<DefaultMutableTreeNode> rootsTree, String name) {
        boolean found = false;
        int index = 0;
        DefaultMutableTreeNode node = null;
        while (!found) {
            if (name.compareTo(rootsTree.get(index).toString()) != 0) {
                ++index;
                continue;
            }
            found = true;
            node = rootsTree.get(index);
        }
        rootsTree.remove(index);
        return node;
    }
}

