/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.Serializable;
import unbbayes.prs.INode;
import unbbayes.prs.Node;
import unbbayes.prs.bn.IProbabilityFunction;
import unbbayes.prs.bn.IRandomVariable;
import unbbayes.prs.exception.InvalidParentException;
import unbbayes.util.GeometricUtil;

public class Edge
implements Serializable {
    private static Color color = Color.black;
    private static final long serialVersionUID = -3912210617648282346L;
    private Node node1;
    private Node node2;
    private boolean bSelected;
    private boolean direction;

    public Edge(Node no1, Node no2) {
        this.node1 = no1;
        this.node2 = no2;
        this.direction = true;
    }

    public void setDirection(boolean direction) {
        this.direction = direction;
    }

    public Node getOriginNode() {
        return this.node1;
    }

    public Node getDestinationNode() {
        return this.node2;
    }

    public boolean hasDirection() {
        return this.direction;
    }

    public void changeDirection() {
        this.node1.removeChild(this.node2);
        this.node2.removeParent(this.node1);
        try {
            this.node1.addParent(this.node2);
            this.node2.addChild(this.node1);
        }
        catch (InvalidParentException e) {
            throw new IllegalArgumentException(e);
        }
        Node aux = this.node1;
        this.node1 = this.node2;
        this.node2 = aux;
        if (this.node2 instanceof IRandomVariable) {
            IRandomVariable v2 = (IRandomVariable)((Object)this.node2);
            IProbabilityFunction auxTab = v2.getProbabilityFunction();
            auxTab.addVariable(this.node1);
        }
        if (this.node1 instanceof IRandomVariable) {
            IRandomVariable auxTabledVariable = (IRandomVariable)((Object)this.node1);
            IProbabilityFunction auxPotentialTable = auxTabledVariable.getProbabilityFunction();
            auxPotentialTable.removeVariable(this.node2, true);
        }
    }

    public String toString() {
        return "Edge: " + this.node1.toString() + " -> " + this.node2.toString();
    }

    public static Color getColor() {
        return color;
    }

    public static void setColor(int rgb) {
        color = new Color(rgb);
    }

    public boolean isPointInDrawableArea(int x, int y) {
        double x1 = this.node1.getPosition().getX();
        double y1 = this.node1.getPosition().getY();
        double x2 = this.node2.getPosition().getX();
        double y2 = this.node2.getPosition().getY();
        double yTeste = (y2 - y1) / (x2 - x1) * (double)x + (y1 - x1 * ((y2 - y1) / (x2 - x1)));
        double xTeste = ((double)y - (y1 - x1 * ((y2 - y1) / (x2 - x1)))) / ((y2 - y1) / (x2 - x1));
        Point2D.Double ponto1 = GeometricUtil.getCircunferenceTangentPoint(this.node1.getPosition(), this.node2.getPosition(), (this.node1.getWidth() + this.node1.getHeight()) / 4);
        Point2D.Double ponto2 = GeometricUtil.getCircunferenceTangentPoint(this.node2.getPosition(), this.node1.getPosition(), (this.node1.getWidth() + this.node1.getHeight()) / 4);
        return ponto1.getX() < ponto2.getX() ? ((double)y <= yTeste + 5.0 && (double)y >= yTeste - 5.0 || (double)x <= xTeste + 5.0 && (double)x >= xTeste - 5.0) && (ponto1.getY() < ponto2.getY() ? (double)y >= ponto1.getY() - 5.0 && (double)y <= ponto2.getY() + 5.0 && (double)x >= ponto1.getX() - 5.0 && (double)x <= ponto2.getX() + 5.0 : (double)y >= ponto2.getY() - 5.0 && (double)y <= ponto1.getY() + 5.0 && (double)x >= ponto1.getX() - 5.0 && (double)x <= ponto2.getX() + 5.0) : ((double)y <= yTeste + 5.0 && (double)y >= yTeste - 5.0 || (double)x <= xTeste + 5.0 && (double)x >= xTeste - 5.0) && (ponto1.getY() < ponto2.getY() ? (double)y >= ponto1.getY() - 5.0 && (double)y <= ponto2.getY() + 5.0 && (double)x >= ponto2.getX() - 5.0 && (double)x <= ponto1.getX() + 5.0 : (double)y >= ponto2.getY() - 5.0 && (double)y <= ponto1.getY() + 5.0 && (double)x >= ponto2.getX() - 5.0 && (double)x <= ponto1.getX() + 5.0);
    }

    public boolean isSelected() {
        return this.bSelected;
    }

    public Point2D.Double getOriginPosition() {
        return this.node1.getPosition();
    }

    public void setOriginPosition(double x, double y) {
        this.node1.setPosition(x, y);
    }

    public Point2D.Double getDestinationPosition() {
        return this.node2.getPosition();
    }

    public void setDestinationPosition(double x, double y) {
        this.node2.setPosition(x, y);
    }

    public boolean isConnectingNodes(INode originNode, INode destinationNode, boolean isToIgnoreDirection) {
        if (this.getOriginNode().equals(originNode) && this.getDestinationNode().equals(destinationNode)) {
            return true;
        }
        return isToIgnoreDirection && this.getOriginNode().equals(destinationNode) && this.getDestinationNode().equals(originNode);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        boolean ret = false;
        if (obj instanceof Edge) {
            Edge ed = (Edge)obj;
            if (this.node1 != null && this.node2 != null) {
                boolean bl = ret = this.node1.equals(ed.node1) && this.node2.equals(ed.node2);
                if (!(ret || ed.hasDirection() || this.hasDirection())) {
                    ret = this.node1.equals(ed.node2) && this.node2.equals(ed.node1);
                }
            } else if (this.node1 != null) {
                boolean bl = ret = this.node1.equals(ed.node1) && ed.node2 == null;
                if (!(ret || ed.hasDirection() || this.hasDirection())) {
                    ret = this.node1.equals(ed.node2) && ed.node1 == null;
                }
            } else if (this.node2 != null) {
                boolean bl = ret = ed.node1 == null && this.node2.equals(ed.node2);
                if (!(ret || ed.hasDirection() || this.hasDirection())) {
                    ret = ed.node2 == null && this.node2.equals(ed.node1);
                }
            } else {
                ret = ed.node1 == null && ed.node2 == null;
            }
        }
        return ret;
    }
}

