/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import unbbayes.prs.Edge;
import unbbayes.prs.Graph;
import unbbayes.prs.Node;
import unbbayes.prs.bn.IProbabilityFunction;
import unbbayes.prs.bn.IRandomVariable;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.resources.BnResources;
import unbbayes.prs.exception.InvalidParentException;
import unbbayes.util.Debug;
import unbbayes.util.ResourceController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Network
implements Graph {
    private static ResourceBundle resource = ResourceController.newInstance().getBundle(BnResources.class.getName(), Locale.getDefault(), Network.class.getClassLoader());
    private Map<String, Object> properties = new HashMap<String, Object>();
    protected String id;
    protected String name;
    protected ArrayList<Node> nodeList;
    protected List<Edge> edgeList;
    protected Map<String, Integer> nodeIndexes;
    protected Node.NodeNameChangedListener nodeNameChangedListener;

    public Network(String name) {
        this.id = this.name = name;
        this.nodeList = new ArrayList();
        this.edgeList = new ArrayList<Edge>();
        this.nodeIndexes = new HashMap<String, Integer>();
        this.nodeNameChangedListener = new Node.NodeNameChangedListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void nodeNameChanged(Node.NodeNameChangedEvent event) {
                Integer index = Network.this.nodeIndexes.get(event.getOldName());
                if (index != null) {
                    Map<String, Integer> map = Network.this.nodeIndexes;
                    synchronized (map) {
                        Network.this.nodeIndexes.remove(event.getOldName());
                        Network.this.nodeIndexes.put(event.getNewName(), index);
                    }
                }
            }
        };
    }

    @Override
    public List<Edge> getEdges() {
        return this.edgeList;
    }

    public ArrayList<Node> getNodes() {
        return this.nodeList;
    }

    @Override
    public int getNodeCount() {
        return this.nodeList == null ? 0 : this.nodeList.size();
    }

    public Node getNodeAt(int index) {
        return this.nodeList.get(index);
    }

    public Node getNode(String name) {
        int index = this.getNodeIndex(name);
        if (index == -1) {
            return null;
        }
        return this.nodeList.get(index);
    }

    public int getNodeIndex(String name) {
        Integer index = this.nodeIndexes.get(name);
        if (index == null) {
            return -1;
        }
        return index;
    }

    @Override
    public void removeEdge(Edge edge) {
        edge.getOriginNode().removeChild(edge.getDestinationNode());
        edge.getDestinationNode().removeParent(edge.getOriginNode());
        this.removeArc(edge);
    }

    @Override
    public void addNode(Node node) {
        if (node.getName() == null || node.getName().trim().isEmpty()) {
            throw new IllegalArgumentException(String.valueOf(resource.getString("mandatoryNodeName")) + ": " + node.getName());
        }
        if (this.nodeIndexes.containsKey(node.getName())) {
            throw new IllegalArgumentException(String.valueOf(resource.getString("duplicateNodeName")) + ": " + node.getName());
        }
        this.nodeList.add(node);
        this.nodeIndexes.put(node.getName(), new Integer(this.nodeList.size() - 1));
        node.addNodeNameChangedListener(this.nodeNameChangedListener);
    }

    @Override
    public void addEdge(Edge edge) throws InvalidParentException {
        if (this.getEdges().contains(edge)) {
            Debug.println(this.getClass(), "Attempt to insert duplicate edge: " + edge.getOriginNode() + " -> " + edge.getDestinationNode());
            return;
        }
        edge.getOriginNode().addChild(edge.getDestinationNode());
        edge.getDestinationNode().addParent(edge.getOriginNode());
        this.edgeList.add(edge);
        if (edge.getDestinationNode() instanceof IRandomVariable) {
            IRandomVariable v2 = (IRandomVariable)((Object)edge.getDestinationNode());
            IProbabilityFunction auxTab = v2.getProbabilityFunction();
            auxTab.addVariable(edge.getOriginNode());
        }
    }

    @Override
    public void removeNode(Node element) {
        int c;
        Integer index = this.nodeIndexes.get(element.getName());
        if (index != null && index >= 0) {
            this.nodeList.remove(index);
            this.nodeIndexes.clear();
            c = 0;
            while (c < this.nodeList.size()) {
                Node node = this.nodeList.get(c);
                node.removeParent(element);
                node.removeChild(element);
                this.nodeIndexes.put(node.getName(), new Integer(c));
                ++c;
            }
        }
        if (!this.edgeList.isEmpty()) {
            Edge edge = this.edgeList.get(0);
            c = 0;
            while (edge != this.edgeList.get(this.edgeList.size() - 1)) {
                if (edge.getOriginNode() == element || edge.getDestinationNode() == element) {
                    this.removeArc(edge);
                } else {
                    ++c;
                }
                edge = this.edgeList.get(c);
            }
            if (edge.getOriginNode() == element || edge.getDestinationNode() == element) {
                this.removeArc(edge);
            }
        }
    }

    private void removeArc(Edge edge) {
        this.edgeList.remove(edge);
        Node auxNo = edge.getDestinationNode();
        if (auxNo instanceof IRandomVariable) {
            IRandomVariable auxTabledVariable = (IRandomVariable)((Object)auxNo);
            PotentialTable auxPotentialTable = (PotentialTable)auxTabledVariable.getProbabilityFunction();
            auxPotentialTable.removeVariable(edge.getOriginNode(), true);
        }
    }

    protected void clearNodes() {
        this.nodeList.clear();
    }

    protected void clearEdges() {
        this.edgeList.clear();
    }

    @Override
    public int hasEdge(Node node1, Node node2) {
        return this.hasEdge(node1, node2, this.edgeList);
    }

    public int hasEdge(Node node1, Node node2, List<Edge> vetArcos) {
        if (node1 == node2) {
            return 1;
        }
        int sizeArcos = vetArcos.size();
        int i = 0;
        while (i < sizeArcos) {
            Edge auxA = vetArcos.get(i);
            if (auxA.getOriginNode() == node1 && auxA.getDestinationNode() == node2 || auxA.getOriginNode() == node2 && auxA.getDestinationNode() == node1) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Edge getEdge(Node no1, Node no2) {
        List<Edge> vetArcos = this.edgeList;
        if (no1 == no2) {
            return null;
        }
        int sizeArcos = vetArcos.size();
        int i = 0;
        while (i < sizeArcos) {
            Edge auxA = vetArcos.get(i);
            if (auxA.getOriginNode() == no1 && auxA.getDestinationNode() == no2 || auxA.getOriginNode() == no2 && auxA.getDestinationNode() == no1) {
                return vetArcos.get(i);
            }
            ++i;
        }
        return null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return String.valueOf(this.name != null ? this.name : "") + '(' + this.id + ')';
    }

    public Map<String, Integer> getNodeIndexes() {
        return this.nodeIndexes;
    }

    public void setNodeIndexes(Map<String, Integer> nodeIndexes) {
        this.nodeIndexes = nodeIndexes;
    }

    @Override
    public void addProperty(String name, Object value) {
        this.getProperties().put(name, value);
    }

    @Override
    public void removeProperty(String name) {
        this.getProperties().remove(name);
    }

    @Override
    public void clearProperty() {
        this.getProperties().clear();
    }

    @Override
    public Object getProperty(String name) {
        return this.getProperties().get(name);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void clear() {
        if (this.getProperties() != null) {
            this.clearProperty();
        }
        if (this.nodeIndexes != null) {
            this.nodeIndexes.clear();
        }
        if (this.nodeList != null) {
            this.nodeList.clear();
        }
        if (this.edgeList != null) {
            this.edgeList.clear();
        }
    }
}

