/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.bn;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import unbbayes.prs.INode;
import unbbayes.prs.Network;
import unbbayes.prs.Node;
import unbbayes.prs.bn.IRandomVariable;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.bn.ProbabilisticTable;
import unbbayes.prs.bn.resources.BnResources;
import unbbayes.prs.id.DecisionNode;
import unbbayes.prs.id.UtilityTable;
import unbbayes.util.Debug;
import unbbayes.util.ResourceController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Clique
implements IRandomVariable,
Serializable {
    private static final long serialVersionUID = 0L;
    private static ResourceBundle resource = ResourceController.newInstance().getBundle(BnResources.class.getName());
    private int index;
    private Clique parent;
    private List<Clique> children = new ArrayList<Clique>(2);
    private PotentialTable potentialTable;
    private PotentialTable utilityTable;
    private List<Node> nodes = new ArrayList<Node>(2);
    private List<Node> associatedNodes = new ArrayList<Node>(0);
    private List<Node> associatedUtilNodes = new ArrayList<Node>(0);

    public Clique() {
        this(new ProbabilisticTable(), new UtilityTable());
    }

    public Clique(PotentialTable cliqueProb) {
        this(cliqueProb, new UtilityTable());
    }

    public Clique(PotentialTable cliqueProbability, PotentialTable cliqueUtility) {
        this.potentialTable = cliqueProbability;
        if (this.potentialTable == null) {
            this.potentialTable = new ProbabilisticTable();
        }
        this.utilityTable = cliqueUtility;
        if (this.utilityTable == null) {
            this.utilityTable = new UtilityTable();
        }
    }

    public float normalize() throws Exception {
        boolean[] fixo = new boolean[this.nodes.size()];
        ArrayList<Node> decisoes = new ArrayList<Node>();
        int i = 0;
        while (i < this.nodes.size()) {
            if (this.nodes.get(i).getType() == 2) {
                decisoes.add(this.nodes.get(i));
                fixo[i] = true;
            }
            ++i;
        }
        if (decisoes.size() == 0) {
            return this.potentialTable.normalize();
        }
        int[] index = new int[decisoes.size()];
        int i2 = 0;
        while (i2 < index.length) {
            index[i2] = this.nodes.indexOf(decisoes.get(i2));
            ++i2;
        }
        this.normalizeID(0, decisoes, fixo, index, new int[this.nodes.size()]);
        return 0.0f;
    }

    private void normalizeID(int control, ArrayList<Node> decisoes, boolean[] fixo, int[] index, int[] coord) throws Exception {
        if (control == decisoes.size()) {
            float soma = this.sum(0, fixo, coord);
            if ((double)soma == 0.0) {
                if (Debug.isDebugMode()) {
                    int k = 0;
                    while (k < decisoes.size()) {
                        Debug.println(decisoes.get(k) + " - " + decisoes.get(k).getStateAt(coord[index[k]]));
                        ++k;
                    }
                }
                return;
            }
            this.div(0, fixo, coord, soma);
            return;
        }
        DecisionNode node = (DecisionNode)decisoes.get(control);
        if (node.hasEvidence()) {
            coord[index[control]] = node.getEvidence();
            this.normalizeID(control + 1, decisoes, fixo, index, coord);
            return;
        }
        int i = 0;
        while (i < node.getStatesSize()) {
            coord[index[control]] = i++;
            this.normalizeID(control + 1, decisoes, fixo, index, coord);
        }
    }

    private float sum(int control, boolean[] fixo, int[] coord) {
        if (control == this.nodes.size()) {
            return this.potentialTable.getValue(coord);
        }
        if (fixo[control]) {
            return this.sum(control + 1, fixo, coord);
        }
        Node node = this.nodes.get(control);
        float retorno = 0.0f;
        int i = 0;
        while (i < node.getStatesSize()) {
            coord[control] = i++;
            retorno += this.sum(control + 1, fixo, coord);
        }
        return retorno;
    }

    private void div(int control, boolean[] fixo, int[] coord, float soma) {
        if (control == this.nodes.size()) {
            int cLinear = this.potentialTable.getLinearCoord(coord);
            this.potentialTable.setValue(cLinear, this.potentialTable.getValue(cLinear) / soma);
            return;
        }
        if (fixo[control]) {
            this.div(control + 1, fixo, coord, soma);
            return;
        }
        Node node = this.nodes.get(control);
        int i = 0;
        while (i < node.getStatesSize()) {
            coord[control] = i++;
            this.div(control + 1, fixo, coord, soma);
        }
    }

    public void setParent(Clique parent) {
        this.parent = parent;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int indice) {
        this.index = indice;
    }

    public int getChildrenSize() {
        return this.children.size();
    }

    public void addChild(Clique child) {
        this.children.add(child);
    }

    public void removeChild(Clique c) {
        this.children.remove(c);
    }

    public Clique getChildAt(int index) {
        return this.children.get(index);
    }

    @Deprecated
    public ArrayList<Node> getNodes() {
        if (this.nodes instanceof ArrayList) {
            return (ArrayList)this.nodes;
        }
        return new ArrayList<Node>(this.nodes);
    }

    public List<Node> getNodesList() {
        return this.nodes;
    }

    public void setNodesList(List<Node> nodes) {
        this.nodes = nodes;
    }

    @Deprecated
    public ArrayList<Node> getAssociatedProbabilisticNodes() {
        if (this.associatedNodes instanceof ArrayList) {
            return (ArrayList)this.associatedNodes;
        }
        return new ArrayList<Node>(this.associatedNodes);
    }

    public List<Node> getAssociatedProbabilisticNodesList() {
        return this.associatedNodes;
    }

    public void setAssociatedProbabilisticNodesList(List<Node> associatedNodes) {
        this.associatedNodes = associatedNodes;
    }

    @Deprecated
    public ArrayList<Node> getAssociatedUtilityNodes() {
        if (this.associatedUtilNodes instanceof ArrayList) {
            return (ArrayList)this.associatedUtilNodes;
        }
        return new ArrayList<Node>(this.associatedUtilNodes);
    }

    public List<Node> getAssociatedUtilityNodesList() {
        return this.associatedUtilNodes;
    }

    public void setAssociatedUtilityNodesList(List<Node> associatedUtilNodes) {
        this.associatedUtilNodes = associatedUtilNodes;
    }

    @Override
    public PotentialTable getProbabilityFunction() {
        return this.potentialTable;
    }

    protected void setProbabilityFunction(PotentialTable probabilityFunction) {
        this.potentialTable = probabilityFunction;
    }

    public PotentialTable getUtilityTable() {
        return this.utilityTable;
    }

    public Clique getParent() {
        return this.parent;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("C{");
        int j = this.nodes.size() - 1;
        while (j >= 0) {
            sb.append(this.nodes.get(j) + " ");
            --j;
        }
        sb.append("}");
        return sb.toString();
    }

    public List<Clique> getChildren() {
        return this.children;
    }

    public void setChildren(List<Clique> children) {
        this.children = children;
    }

    @Override
    public int getInternalIdentificator() {
        return this.index;
    }

    @Override
    public void setInternalIdentificator(int internalIdentificator) {
        this.index = internalIdentificator;
    }

    public Clique clone(Network net) {
        Node newNode;
        Clique newClique = new Clique();
        newClique.setInternalIdentificator(this.getInternalIdentificator());
        for (Node node : this.getNodes()) {
            newNode = null;
            if (net != null) {
                newNode = net.getNode(node.getName());
            }
            if (newNode == null) {
                if (node instanceof ProbabilisticNode) {
                    newNode = (ProbabilisticNode)((ProbabilisticNode)node).clone();
                } else {
                    throw new IllegalStateException("Unable to clone: " + node + ", " + this);
                }
            }
            newClique.getNodes().add(newNode);
        }
        for (Node node : this.getAssociatedProbabilisticNodes()) {
            newNode = null;
            if (net != null) {
                newNode = net.getNode(node.getName());
            }
            if (newNode == null) {
                if (node instanceof ProbabilisticNode) {
                    newNode = (ProbabilisticNode)((ProbabilisticNode)node).clone();
                } else {
                    throw new IllegalStateException("Unable to clone: " + node + ", " + this);
                }
            }
            newClique.getAssociatedProbabilisticNodes().add(newNode);
        }
        newClique.setIndex(this.getIndex());
        PotentialTable origPotential = this.getProbabilityFunction();
        PotentialTable copyPotential = newClique.getProbabilityFunction();
        int i = 0;
        while (i < origPotential.getVariablesSize()) {
            Node newNode2 = null;
            if (net != null) {
                newNode2 = net.getNode(origPotential.getVariableAt(i).getName());
            }
            if (newNode2 == null) {
                if (origPotential.getVariableAt(i) instanceof ProbabilisticNode) {
                    newNode2 = (ProbabilisticNode)((ProbabilisticNode)origPotential.getVariableAt(i)).clone();
                } else {
                    throw new IllegalStateException("Unable to clone: " + origPotential.getVariableAt(i) + ", " + this);
                }
            }
            copyPotential.addVariable(newNode2);
            ++i;
        }
        copyPotential.setValues(origPotential.getValues());
        copyPotential.copyData();
        return newClique;
    }

    public Object clone() throws CloneNotSupportedException {
        return this.clone(null);
    }

    public void join(Clique cliqueToJoin) {
        PotentialTable separatorTable;
        if (cliqueToJoin == null || cliqueToJoin.getNodesList() == null) {
            return;
        }
        ArrayList<Node> disjointNodes = new ArrayList<Node>(cliqueToJoin.getNodesList());
        disjointNodes.removeAll(this.getNodesList());
        if (cliqueToJoin.getProbabilityFunction() != null && (separatorTable = cliqueToJoin.getProbabilityFunction().getTemporaryClone()) != null) {
            for (INode iNode : disjointNodes) {
                separatorTable.removeVariable(iNode);
            }
            PotentialTable potentialTable = this.getProbabilityFunction();
            if (potentialTable != null) {
                for (INode iNode : disjointNodes) {
                    potentialTable.addVariable(iNode);
                }
                potentialTable.opTab(separatorTable, 1);
                potentialTable.opTab(cliqueToJoin.getProbabilityFunction(), 0);
            }
        }
        this.getNodesList().addAll(disjointNodes);
    }
}

