/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.bn;

import unbbayes.prs.Graph;
import unbbayes.prs.bn.IJunctionTree;
import unbbayes.prs.bn.IJunctionTreeBuilder;
import unbbayes.prs.bn.JunctionTree;
import unbbayes.prs.bn.SingleEntityNetwork;
import unbbayes.prs.id.JunctionTreeID;
import unbbayes.util.Debug;

public class DefaultJunctionTreeBuilder
implements IJunctionTreeBuilder {
    private Class junctionTreeClass;

    public DefaultJunctionTreeBuilder() {
        this(JunctionTree.class);
    }

    public DefaultJunctionTreeBuilder(Class junctionTreeClass) {
        try {
            this.setJunctionTreeClass(junctionTreeClass);
        }
        catch (Exception e) {
            Debug.println(this.getClass(), "Could not initialize junctionTreeClass, but it will continue.", e);
        }
    }

    public IJunctionTree buildJunctionTree(Graph network) throws InstantiationException, IllegalAccessException {
        SingleEntityNetwork singleEntityNetwork;
        if (network != null && network instanceof SingleEntityNetwork && (singleEntityNetwork = (SingleEntityNetwork)network).isID()) {
            this.setJunctionTreeClass(JunctionTreeID.class);
        }
        return (IJunctionTree)this.getJunctionTreeClass().newInstance();
    }

    public Class getJunctionTreeClass() {
        return this.junctionTreeClass;
    }

    public void setJunctionTreeClass(Class junctionTreeClass) throws ClassCastException {
        if (!IJunctionTree.class.isAssignableFrom(junctionTreeClass)) {
            throw new ClassCastException(junctionTreeClass + " incompatible with " + IJunctionTree.class);
        }
        this.junctionTreeClass = junctionTreeClass;
    }
}

