/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.bn;

import java.util.ArrayList;
import java.util.List;
import unbbayes.prs.Graph;
import unbbayes.prs.INode;
import unbbayes.prs.bn.ILikelihoodExtractor;
import unbbayes.prs.bn.IProbabilityFunction;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.TreeVariable;
import unbbayes.prs.bn.cpt.IArbitraryConditionalProbabilityExtractor;
import unbbayes.prs.bn.cpt.impl.InCliqueConditionalProbabilityExtractor;
import unbbayes.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JeffreyRuleLikelihoodExtractor
implements ILikelihoodExtractor {
    private IArbitraryConditionalProbabilityExtractor conditionalProbabilityExtractor = InCliqueConditionalProbabilityExtractor.newInstance(true);

    protected JeffreyRuleLikelihoodExtractor() {
    }

    public static ILikelihoodExtractor newInstance() {
        return new JeffreyRuleLikelihoodExtractor();
    }

    @Override
    public float[] extractLikelihoodRatio(Graph graph, INode node) {
        if (node == null) {
            throw new IllegalArgumentException("nodes == null || nodes.isEmpty()");
        }
        TreeVariable mainNode = (TreeVariable)node;
        float[] expectedProbability = mainNode.getLikelihood();
        float total = 0.0f;
        float[] fArray = expectedProbability;
        int n = expectedProbability.length;
        int n2 = 0;
        while (n2 < n) {
            float prob = fArray[n2];
            total += prob;
            ++n2;
        }
        int i = 0;
        while (i < expectedProbability.length) {
            int n3 = i++;
            expectedProbability[n3] = expectedProbability[n3] / total;
        }
        float[] ratio = new float[expectedProbability.length];
        float[] currentProbability = this.getCurrentProbability(graph, mainNode);
        if (currentProbability == null) {
            throw new RuntimeException("Could not extract current probability from " + node + " in " + graph);
        }
        total = 0.0f;
        int i2 = 0;
        while (i2 < ratio.length) {
            ratio[i2] = expectedProbability[i2] == 0.0f && currentProbability[i2] == 0.0f ? 1.0f : expectedProbability[i2] / currentProbability[i2];
            total += ratio[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < ratio.length) {
            int n4 = i2++;
            ratio[n4] = ratio[n4] / total;
        }
        return ratio;
    }

    protected float[] getCurrentProbability(Graph graph, TreeVariable node) {
        float[] ret;
        block3: {
            block2: {
                ret = null;
                if (node.getLikelihoodParents() != null && !node.getLikelihoodParents().isEmpty()) break block2;
                ret = new float[node.getStatesSize()];
                int i = 0;
                while (i < ret.length) {
                    ret[i] = node.getMarginalAt(i);
                    ++i;
                }
                break block3;
            }
            IProbabilityFunction table = this.getConditionalProbabilityExtractor().buildCondicionalProbability(node, this.extractLikelihoodParents(graph, node), graph, null);
            if (!(table instanceof PotentialTable)) break block3;
            PotentialTable potTable = (PotentialTable)table;
            ret = new float[potTable.tableSize()];
            int i = 0;
            while (i < ret.length) {
                ret[i] = potTable.getValue(i);
                ++i;
            }
        }
        return ret;
    }

    @Override
    public List<INode> extractLikelihoodParents(Graph graph, INode node) {
        ArrayList<INode> ret = null;
        try {
            ret = new ArrayList<INode>(((TreeVariable)node).getLikelihoodParents());
        }
        catch (ClassCastException e) {
            Debug.println(this.getClass(), e.getMessage(), e);
        }
        if (ret == null) {
            ret = new ArrayList();
        }
        return ret;
    }

    public void setConditionalProbabilityExtractor(IArbitraryConditionalProbabilityExtractor conditionalProbabilityExtractor) {
        this.conditionalProbabilityExtractor = conditionalProbabilityExtractor;
    }

    public IArbitraryConditionalProbabilityExtractor getConditionalProbabilityExtractor() {
        return this.conditionalProbabilityExtractor;
    }
}

