/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.bn;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import unbbayes.prs.INode;
import unbbayes.prs.Node;
import unbbayes.prs.bn.Clique;
import unbbayes.prs.bn.IJunctionTree;
import unbbayes.prs.bn.IRandomVariable;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.bn.Separator;
import unbbayes.prs.bn.TreeVariable;
import unbbayes.prs.id.UtilityNode;
import unbbayes.util.Debug;
import unbbayes.util.SetToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JunctionTree
implements Serializable,
IJunctionTree {
    private static final long serialVersionUID = 0L;
    private boolean initialized = false;
    private float totalEstimatedProb;
    private List<Clique> cliques;
    private Collection<Separator> separators = new ArrayList<Separator>();
    private Map<Clique, Set<Separator>> separatorsMap = new HashMap<Clique, Set<Separator>>();
    private boolean isUsingSafeOrdering = true;
    private static boolean isToUseSingletonListsInAbsorb = true;
    private static List<Node> singletonListForAbsorb = new ArrayList<Node>(7);

    public JunctionTree() {
        this.cliques = new ArrayList<Clique>();
    }

    @Override
    public float getN() {
        return this.totalEstimatedProb;
    }

    @Override
    public void addSeparator(Separator sep) {
        this.separators.add(sep);
        Set<Separator> seps = this.separatorsMap.get(sep.getClique1());
        if (seps == null) {
            seps = new HashSet<Separator>();
            seps.add(sep);
            this.separatorsMap.put(sep.getClique1(), seps);
        } else {
            seps.add(sep);
        }
        seps = this.separatorsMap.get(sep.getClique2());
        if (seps == null) {
            seps = new HashSet<Separator>();
            seps.add(sep);
            this.separatorsMap.put(sep.getClique2(), seps);
        } else {
            seps.add(sep);
        }
    }

    @Override
    public void removeSeparator(Separator sep) {
        if (sep != null) {
            Set<Separator> seps = this.separatorsMap.get(sep.getClique1());
            if (seps != null) {
                seps.remove(sep);
                if (seps.isEmpty()) {
                    this.separatorsMap.remove(sep.getClique1());
                }
            }
            if ((seps = this.separatorsMap.get(sep.getClique2())) != null) {
                seps.remove(sep);
                if (seps.isEmpty()) {
                    this.separatorsMap.remove(sep.getClique2());
                }
            }
        }
        this.separators.remove(sep);
    }

    @Override
    public List<Clique> getCliques() {
        return this.cliques;
    }

    @Override
    public void consistency() throws Exception {
        this.consistency(this.cliques.get(0), true);
    }

    protected void initConsistency() throws Exception {
        Clique rootClique = this.cliques.get(0);
        this.totalEstimatedProb = 1.0f;
        this.collectEvidence(rootClique, true, true);
        this.distributeEvidences(rootClique, true);
    }

    @Override
    public void consistency(Clique rootClique, boolean isToContinueOnEmptySep) throws Exception {
        if (rootClique == null) {
            rootClique = this.cliques.get(0);
        }
        this.totalEstimatedProb = 1.0f;
        this.collectEvidence(rootClique, isToContinueOnEmptySep);
        this.distributeEvidences(rootClique, isToContinueOnEmptySep);
    }

    @Deprecated
    protected void coleteEvidencia(Clique clique) throws Exception {
        this.collectEvidence(clique, true);
    }

    protected void collectEvidence(Clique clique, boolean isToContinueOnEmptySep) throws Exception {
        this.collectEvidence(clique, isToContinueOnEmptySep, false);
    }

    private void collectEvidence(Clique clique, boolean isToContinueOnEmptySep, boolean isInitialization) throws Exception {
        for (Clique auxClique : clique.getChildren()) {
            if (isToContinueOnEmptySep) {
                this.collectEvidence(auxClique, isToContinueOnEmptySep, isInitialization);
                this.absorb(clique, auxClique);
                if (!isInitialization) continue;
                clique.normalize();
                continue;
            }
            Separator sep = this.getSeparator(clique, auxClique);
            if (sep.getProbabilityFunction().tableSize() <= 1) continue;
            this.collectEvidence(auxClique, isToContinueOnEmptySep, isInitialization);
            this.absorb(clique, auxClique);
            if (!isInitialization) continue;
            clique.normalize();
        }
        if (!isInitialization) {
            this.totalEstimatedProb *= clique.normalize();
        } else if (clique.getChildren().isEmpty()) {
            clique.normalize();
        }
    }

    @Deprecated
    protected void distributeEvidences(Clique clique) {
        this.distributeEvidences(clique, true);
    }

    protected void distributeEvidences(Clique clique, boolean isToContinueOnEmptySep) {
        for (Clique auxClique : clique.getChildren()) {
            this.absorb(auxClique, clique);
            if (isToContinueOnEmptySep) {
                this.distributeEvidences(auxClique, isToContinueOnEmptySep);
                continue;
            }
            Separator sep = this.getSeparator(clique, auxClique);
            if (sep.getProbabilityFunction().tableSize() <= 1) continue;
            this.distributeEvidences(auxClique, isToContinueOnEmptySep);
        }
    }

    protected void absorb(Clique clique1, Clique clique2) {
        Separator sep = this.getSeparator(clique1, clique2);
        if (sep == null) {
            return;
        }
        PotentialTable sepTab = sep.getProbabilityFunction();
        if (sepTab.tableSize() <= 0) {
            return;
        }
        List<Node> nodesInClique2NotInSeparator = null;
        if (isToUseSingletonListsInAbsorb) {
            nodesInClique2NotInSeparator = singletonListForAbsorb;
            nodesInClique2NotInSeparator.clear();
            nodesInClique2NotInSeparator.addAll(clique2.getNodesList());
            nodesInClique2NotInSeparator.removeAll(sep.getNodes());
        } else {
            nodesInClique2NotInSeparator = new ArrayList<Node>(clique2.getNodesList());
            nodesInClique2NotInSeparator.removeAll(sep.getNodes());
        }
        PotentialTable dummyTable = clique2.getProbabilityFunction().getTemporaryClone();
        for (Node nodeToRemove : nodesInClique2NotInSeparator) {
            dummyTable.removeVariable(nodeToRemove);
        }
        PotentialTable originalSeparatorTable = sepTab.getTemporaryClone();
        if (originalSeparatorTable == dummyTable) {
            Debug.println(this.getClass(), "[CAUTION] PotentialTable#getTemporaryClone() is not returning 2 singleton instances alternately.");
            dummyTable = (PotentialTable)clique2.getProbabilityFunction().clone();
            for (Node nodeToRemove : nodesInClique2NotInSeparator) {
                dummyTable.removeVariable(nodeToRemove);
            }
        }
        if (this.isUsingSafeOrdering) {
            System.arraycopy(dummyTable.getValues(), 0, sepTab.getValues(), 0, sepTab.tableSize());
        } else {
            boolean isOrdered = true;
            int numVars = sepTab.variableCount();
            int i = 0;
            while (i < numVars) {
                if (!sepTab.getVariableAt(i).equals(dummyTable.getVariableAt(i))) {
                    isOrdered = false;
                    break;
                }
                ++i;
            }
            if (isOrdered) {
                System.arraycopy(dummyTable.getValues(), 0, sepTab.getValues(), 0, sepTab.tableSize());
            } else {
                sepTab.fillTable(1.0f);
                sepTab.directOpTab(dummyTable, 0);
            }
        }
        dummyTable.directOpTab(originalSeparatorTable, 1);
        clique1.getProbabilityFunction().opTab(dummyTable, 0);
    }

    @Override
    public void initBeliefs() throws Exception {
        if (!this.isInitialized()) {
            int sizeCliques = this.cliques.size();
            int k = 0;
            while (k < sizeCliques) {
                Clique auxClique = this.cliques.get(k);
                auxClique.setInternalIdentificator(k);
                this.initBelief(auxClique);
                ++k;
            }
            int separatorId = -1;
            for (Separator auxSep : this.getSeparators()) {
                auxSep.setInternalIdentificator(separatorId--);
                this.initBelief(auxSep);
            }
            this.initConsistency();
            this.copyTableData();
            this.setInitialized(true);
        } else {
            this.restoreTableData();
        }
    }

    @Override
    public void initBelief(IRandomVariable rv) {
        if (rv instanceof Clique) {
            this.initBelief((Clique)rv);
            return;
        }
        if (rv instanceof Separator) {
            this.initBelief((Separator)rv);
            return;
        }
        throw new IllegalArgumentException(rv + " != " + Clique.class.getName() + " && " + rv + " != " + Separator.class.getName());
    }

    public void initBelief(Separator auxSep) {
        PotentialTable auxTabPot = auxSep.getProbabilityFunction();
        auxTabPot.fillTable(1.0f);
        PotentialTable auxUtilTab = auxSep.getUtilityTable();
        auxUtilTab.fillTable(0.0f);
    }

    public void initBelief(Clique clique) {
        PotentialTable auxTabPot = clique.getProbabilityFunction();
        PotentialTable auxUtilTab = clique.getUtilityTable();
        int tableSize = auxTabPot.tableSize();
        int c = 0;
        while (c < tableSize) {
            auxTabPot.setValue(c, 1.0f);
            ++c;
        }
        int sizeAssociados = clique.getAssociatedProbabilisticNodes().size();
        int c2 = 0;
        while (c2 < sizeAssociados) {
            ProbabilisticNode auxVP = (ProbabilisticNode)clique.getAssociatedProbabilisticNodes().get(c2);
            auxTabPot.opTab(auxVP.getProbabilityFunction(), 0);
            ++c2;
        }
        tableSize = auxUtilTab.tableSize();
        int i = 0;
        while (i < tableSize) {
            auxUtilTab.setValue(i, 0.0f);
            ++i;
        }
        sizeAssociados = clique.getAssociatedUtilityNodes().size();
        int i2 = 0;
        while (i2 < sizeAssociados) {
            UtilityNode utilNode = (UtilityNode)clique.getAssociatedUtilityNodes().get(i2);
            auxUtilTab.opTab(utilNode.getProbabilityFunction(), 2);
            ++i2;
        }
    }

    private void restoreTableData() {
        int sizeCliques = this.cliques.size();
        int k = 0;
        while (k < sizeCliques) {
            Clique auxClique = this.cliques.get(k);
            auxClique.getProbabilityFunction().restoreData();
            auxClique.getUtilityTable().restoreData();
            ++k;
        }
        for (Separator auxSep : this.getSeparators()) {
            auxSep.getProbabilityFunction().restoreData();
            auxSep.getUtilityTable().restoreData();
        }
    }

    private void copyTableData() {
        int sizeCliques = this.cliques.size();
        int k = 0;
        while (k < sizeCliques) {
            Clique auxClique = this.cliques.get(k);
            auxClique.getProbabilityFunction().copyData();
            auxClique.getUtilityTable().copyData();
            ++k;
        }
        for (Separator auxSep : this.getSeparators()) {
            auxSep.getProbabilityFunction().copyData();
            auxSep.getUtilityTable().copyData();
        }
    }

    @Override
    public Separator getSeparator(Clique clique1, Clique clique2) {
        Set<Separator> seps = this.separatorsMap.get(clique1);
        if (seps == null) {
            seps = Collections.emptySet();
        }
        Clique theOtherClique = clique2;
        Set<Separator> seps2 = this.separatorsMap.get(clique2);
        if (seps2 == null) {
            seps2 = Collections.emptySet();
        }
        if (seps2.size() < seps.size()) {
            seps = seps2;
            theOtherClique = clique1;
        }
        for (Separator separator : seps) {
            if (separator.getClique2().getInternalIdentificator() != theOtherClique.getInternalIdentificator() && separator.getClique1().getInternalIdentificator() != theOtherClique.getInternalIdentificator()) continue;
            return separator;
        }
        return null;
    }

    @Override
    public Collection<Separator> getSeparators() {
        return this.separators;
    }

    protected void setSeparators(Collection<Separator> separators) {
        this.separators = separators;
    }

    public Collection<List<Clique>> getPaths(Clique from, Clique to) {
        if (from == null || to == null) {
            return Collections.emptySet();
        }
        if (from.equals(to)) {
            return Collections.singleton(Collections.singletonList(from));
        }
        return this.getRoutesRec(from, to, new ArrayList<Clique>(), new HashSet<Clique>());
    }

    protected Collection<List<Clique>> getRoutesRec(Clique from, Clique to, List<Clique> processingPath, Set<Clique> deadCliques) {
        Collection<List<Clique>> rec;
        ArrayList<Clique> path;
        HashSet<List<Clique>> ret = new HashSet<List<Clique>>();
        ArrayList<Clique> processingPathCurrentScope = new ArrayList<Clique>(processingPath);
        processingPathCurrentScope.add(from);
        HashSet<Clique> deadNodesForMyScope = new HashSet<Clique>(deadCliques);
        for (Clique parent : this.getParents(from)) {
            if (deadCliques.contains(parent) || processingPathCurrentScope.contains(parent)) continue;
            if (to.equals(parent)) {
                path = new ArrayList<Clique>(processingPathCurrentScope);
                path.add(parent);
                ret.add(path);
                continue;
            }
            rec = this.getRoutesRec(parent, to, processingPathCurrentScope, deadNodesForMyScope);
            if (rec.isEmpty()) {
                deadNodesForMyScope.add(parent);
            }
            ret.addAll(rec);
        }
        for (Clique child : from.getChildren()) {
            if (deadCliques.contains(child) || processingPathCurrentScope.contains(child)) continue;
            if (to.equals(child)) {
                path = new ArrayList<Clique>(processingPathCurrentScope);
                path.add(child);
                ret.add(path);
                continue;
            }
            rec = this.getRoutesRec(child, to, processingPathCurrentScope, deadNodesForMyScope);
            if (rec.isEmpty()) {
                deadNodesForMyScope.add(child);
            }
            ret.addAll(rec);
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public List<Clique> getPath(Clique from, Clique to) {
        pathToRoot /* !! */  = new ArrayList<Clique>();
        pathToRoot /* !! */ .add(to);
        if (!to.equals(from)) ** GOTO lbl12
        return pathToRoot /* !! */ ;
lbl-1000:
        // 1 sources

        {
            to = to.getParent();
            pathToRoot /* !! */ .add(to);
            if (!to.equals(from)) continue;
            Collections.reverse(pathToRoot /* !! */ );
            return pathToRoot /* !! */ ;
lbl12:
            // 2 sources

            ** while (to.getParent() != null)
        }
lbl13:
        // 1 sources

        ret = new ArrayList<Clique>();
        indexOfFirstMatchInPath = -1;
        do {
            ret.add(from);
        } while ((from = from.getParent()) != null && (indexOfFirstMatchInPath = pathToRoot /* !! */ .indexOf(from)) < 0);
        if (from == null || indexOfFirstMatchInPath < 0) {
            throw new IllegalArgumentException("The junction tree is expected to be a single tree (possibly with empty separators), but cliques " + from + " and " + to + " did not have a common root.");
        }
        pathToRoot /* !! */  = pathToRoot /* !! */ .subList(0, indexOfFirstMatchInPath + 1);
        Collections.reverse(pathToRoot /* !! */ );
        ret.addAll(pathToRoot /* !! */ );
        return ret;
    }

    @Override
    public List<Clique> getCliquesContainingAllNodes(Collection<INode> nodes, int maxCount) {
        if (maxCount <= 0) {
            return new ArrayList<Clique>();
        }
        if (nodes == null || nodes.isEmpty()) {
            return new ArrayList<Clique>(this.getCliques());
        }
        ArrayList<IRandomVariable> ret = new ArrayList<IRandomVariable>();
        TreeVariable pivot = (TreeVariable)nodes.iterator().next();
        IRandomVariable cliqueOrSeparatorPivot = pivot.getAssociatedClique();
        if (cliqueOrSeparatorPivot instanceof Separator) {
            HashSet<Clique> visited = new HashSet<Clique>();
            maxCount -= this.visitCliquesSeparatorsContainingAllNodesRecursive(((Separator)cliqueOrSeparatorPivot).getClique1(), nodes, maxCount, ret, false, visited);
        } else if (cliqueOrSeparatorPivot instanceof Clique) {
            this.visitCliquesSeparatorsContainingAllNodesRecursive((Clique)cliqueOrSeparatorPivot, nodes, maxCount, ret, false, new HashSet<Clique>());
        }
        return ret;
    }

    protected int visitCliquesSeparatorsContainingAllNodesRecursive(Clique pivot, Collection<INode> nodesToContain, int maxCount, List<IRandomVariable> output, boolean isToVisitSeparators, Set<Clique> visitedCliques) {
        int addedQuantity;
        block16: {
            block15: {
                Separator separator;
                if (maxCount <= 0) {
                    return 0;
                }
                if (!visitedCliques.add(pivot)) {
                    return 0;
                }
                ArrayList<INode> intersection = new ArrayList<INode>(nodesToContain);
                intersection.retainAll(pivot.getNodes());
                if (intersection.isEmpty()) {
                    return 0;
                }
                addedQuantity = 0;
                if (!isToVisitSeparators) break block15;
                if (pivot.getParent() != null && !visitedCliques.contains(pivot.getParent()) && (separator = this.getSeparator(pivot, pivot.getParent())) != null && !SetToolkit.containsExact(output, separator)) {
                    if (separator.getNodes().containsAll(nodesToContain)) {
                        output.add(separator);
                        if (maxCount - ++addedQuantity <= 0) {
                            return addedQuantity;
                        }
                    }
                    if (maxCount - (addedQuantity += this.visitCliquesSeparatorsContainingAllNodesRecursive(pivot.getParent(), nodesToContain, maxCount - addedQuantity, output, isToVisitSeparators, visitedCliques)) <= 0) {
                        return addedQuantity;
                    }
                }
                if (pivot.getChildren() == null) break block16;
                for (Clique child : pivot.getChildren()) {
                    Separator separator2;
                    if (visitedCliques.contains(child) || (separator2 = this.getSeparator(pivot, child)) == null || SetToolkit.containsExact(output, separator2)) continue;
                    if (separator2.getNodes().containsAll(nodesToContain)) {
                        output.add(separator2);
                        if (maxCount - ++addedQuantity <= 0) {
                            return addedQuantity;
                        }
                    }
                    if (maxCount - (addedQuantity += this.visitCliquesSeparatorsContainingAllNodesRecursive(child, nodesToContain, maxCount - addedQuantity, output, isToVisitSeparators, visitedCliques)) > 0) continue;
                    return addedQuantity;
                }
                break block16;
            }
            if (pivot.getNodes() != null && pivot.getNodes().containsAll(nodesToContain)) {
                output.add(pivot);
                if (maxCount - ++addedQuantity <= 0) {
                    return addedQuantity;
                }
            }
            if (pivot.getParent() != null && !visitedCliques.contains(pivot.getParent()) && !SetToolkit.containsExact(output, pivot.getParent()) && maxCount - (addedQuantity += this.visitCliquesSeparatorsContainingAllNodesRecursive(pivot.getParent(), nodesToContain, maxCount - addedQuantity, output, isToVisitSeparators, visitedCliques)) <= 0) {
                return addedQuantity;
            }
            if (pivot.getChildren() != null) {
                for (Clique child : pivot.getChildren()) {
                    if (visitedCliques.contains(child) || SetToolkit.containsExact(output, child) || maxCount - (addedQuantity += this.visitCliquesSeparatorsContainingAllNodesRecursive(child, nodesToContain, maxCount - addedQuantity, output, isToVisitSeparators, visitedCliques)) > 0) continue;
                    return addedQuantity;
                }
            }
        }
        return addedQuantity;
    }

    @Override
    public List<Separator> getSeparatorsContainingAllNodes(Collection<INode> nodes, int maxCount) {
        if (maxCount <= 0) {
            return new ArrayList<Separator>();
        }
        if (nodes == null || nodes.isEmpty()) {
            return new ArrayList<Separator>(this.getSeparators());
        }
        ArrayList<IRandomVariable> ret = new ArrayList<IRandomVariable>();
        TreeVariable pivot = (TreeVariable)nodes.iterator().next();
        IRandomVariable cliqueOrSeparator = pivot.getAssociatedClique();
        if (cliqueOrSeparator instanceof Separator) {
            if ((maxCount -= this.visitCliquesSeparatorsContainingAllNodesRecursive(((Separator)cliqueOrSeparator).getClique1(), nodes, maxCount, ret, true, new HashSet<Clique>())) > 0) {
                this.visitCliquesSeparatorsContainingAllNodesRecursive(((Separator)cliqueOrSeparator).getClique2(), nodes, maxCount, ret, true, new HashSet<Clique>());
            }
        } else if (cliqueOrSeparator instanceof Clique) {
            this.visitCliquesSeparatorsContainingAllNodesRecursive((Clique)cliqueOrSeparator, nodes, maxCount, ret, true, new HashSet<Clique>());
        }
        return ret;
    }

    protected Map<Clique, Set<Separator>> getSeparatorsMap() {
        return this.separatorsMap;
    }

    protected void setSeparatorsMap(Map<Clique, Set<Separator>> separatorsMap) {
        this.separatorsMap = separatorsMap;
    }

    public static boolean isToUseSingletonListsInAbsorb() {
        return isToUseSingletonListsInAbsorb;
    }

    public static void setToUseSingletonListsInAbsorb(boolean isToUseSingletonListsInAbsorb) {
        JunctionTree.isToUseSingletonListsInAbsorb = isToUseSingletonListsInAbsorb;
    }

    @Override
    public List<Clique> getCliquesContainingMostOfNodes(Collection<INode> nodes) {
        if (nodes == null || nodes.isEmpty() || this.getCliques() == null) {
            return Collections.emptyList();
        }
        ArrayList<Clique> ret = new ArrayList<Clique>();
        int sizeOfIntersection = 0;
        for (Clique clique : this.getCliques()) {
            ArrayList<INode> intersection = new ArrayList<INode>(nodes);
            intersection.retainAll(clique.getNodesList());
            if (intersection.size() < sizeOfIntersection) continue;
            if (intersection.size() > sizeOfIntersection) {
                ret.clear();
            }
            ret.add(clique);
            sizeOfIntersection = intersection.size();
        }
        return ret;
    }

    @Override
    public int getSeparatorsSize() {
        return this.getSeparators().size();
    }

    @Override
    public Separator getSeparatorAt(int index) {
        if (this.separators instanceof List) {
            return (Separator)((List)this.separators).get(index);
        }
        for (Separator separator : this.separators) {
            int id = separator.getInternalIdentificator();
            if (id >= 0 && id == index) {
                return separator;
            }
            if (id >= 0 || -(id + 1) != index) continue;
            return separator;
        }
        int i = 0;
        for (Separator separator : this.separators) {
            if (i == index) {
                return separator;
            }
            ++i;
        }
        return null;
    }

    public void moveCliqueToRoot(Clique cliqueToBecomeRoot) {
        if (cliqueToBecomeRoot == null || cliqueToBecomeRoot.getParent() == null) {
            return;
        }
        Clique parentClique = cliqueToBecomeRoot.getParent();
        this.moveCliqueToRoot(parentClique);
        parentClique.removeChild(cliqueToBecomeRoot);
        cliqueToBecomeRoot.addChild(parentClique);
        parentClique.setParent(cliqueToBecomeRoot);
        Separator oldSeparator = this.getSeparator(parentClique, cliqueToBecomeRoot);
        this.removeSeparator(oldSeparator);
        Separator newSeparator = new Separator(cliqueToBecomeRoot, parentClique, false);
        newSeparator.setInternalIdentificator(oldSeparator.getInternalIdentificator());
        newSeparator.setNodes(oldSeparator.getNodes());
        newSeparator.setProbabilityFunction(oldSeparator.getProbabilityFunction());
        this.addSeparator(newSeparator);
        for (Node node : newSeparator.getNodes()) {
            if (!(node instanceof TreeVariable) || ((TreeVariable)node).getAssociatedClique() != oldSeparator) continue;
            ((TreeVariable)node).setAssociatedClique(newSeparator);
        }
        cliqueToBecomeRoot.setParent(null);
    }

    public void updateCliqueAndSeparatorInternalIdentificators() {
        if (this.cliques != null && !this.cliques.isEmpty()) {
            Clique root = this.cliques.get(0);
            while (root.getParent() != null) {
                root = root.getParent();
            }
            int indexOfRoot = this.cliques.indexOf(root);
            if (indexOfRoot > 0) {
                Collections.swap(this.cliques, 0, indexOfRoot);
            }
            int i = 0;
            while (i < this.cliques.size()) {
                this.cliques.get(i).setIndex(i);
                this.cliques.get(i).setInternalIdentificator(i);
                ++i;
            }
        }
        int separatorIndex = -1;
        for (Separator sep : this.separators) {
            sep.setInternalIdentificator(separatorIndex--);
        }
    }

    public boolean addParent(Clique parent, Clique child) {
        Clique oldParent = child.getParent();
        child.setParent(parent);
        return parent == oldParent;
    }

    @Override
    public boolean removeCliques(Collection<Clique> cliques) {
        return this.removeCliques(cliques, true);
    }

    @Override
    public boolean removeCliques(Collection<Clique> cliques, boolean isToUpdateIndexes) {
        if (cliques == null || cliques.isEmpty()) {
            return false;
        }
        boolean ret = false;
        HashSet<Clique> removedCliques = new HashSet<Clique>();
        for (Clique cliqueToRemove : cliques) {
            if (cliqueToRemove == null || removedCliques.contains(cliqueToRemove)) continue;
            List<Clique> children = cliqueToRemove.getChildren();
            if (children == null) {
                children = Collections.emptyList();
            }
            ArrayList<Clique> parents = new ArrayList<Clique>(this.getParents(cliqueToRemove));
            for (Clique parent : parents) {
                if (parent == null || removedCliques.contains(parent)) continue;
                parent.removeChild(cliqueToRemove);
                this.removeSeparator(this.getSeparator(parent, cliqueToRemove));
                if (children.isEmpty()) continue;
                for (Clique child : children) {
                    if (child == null || removedCliques.contains(child)) continue;
                    Separator separatorToRemove = this.getSeparator(cliqueToRemove, child);
                    if (separatorToRemove == null) {
                        if (this.getParents(child).contains(cliqueToRemove)) {
                            throw new NullPointerException("Unable to find separator from + " + cliqueToRemove + " and " + child);
                        }
                        System.err.println("Unable to find separator from " + cliqueToRemove + " and " + child);
                        continue;
                    }
                    Separator separatorToInclude = null;
                    if (!this.isUsingApproximation() || this.getSeparator(parent, child) == null) {
                        separatorToInclude = new Separator(parent, child, false);
                        separatorToInclude.setInternalIdentificator(separatorToRemove.getInternalIdentificator());
                    }
                    this.removeSeparator(separatorToRemove);
                    if (separatorToInclude == null) continue;
                    this.addParent(parent, child);
                    parent.addChild(child);
                    this.addSeparator(separatorToInclude);
                }
            }
            if (parents.isEmpty() && !children.isEmpty()) {
                Clique newRoot = null;
                for (Clique candidateForRoot : children) {
                    if (candidateForRoot == null || removedCliques.contains(candidateForRoot) || this.getParents(candidateForRoot).size() > 1) continue;
                    newRoot = candidateForRoot;
                    break;
                }
                if (newRoot == null) {
                    throw new NullPointerException(cliqueToRemove + " was expected to be a unique a root, but all its children had more than 1 parent: " + children);
                }
                this.clearParents(newRoot);
                this.removeSeparator(this.getSeparator(cliqueToRemove, newRoot));
                for (Clique child : children) {
                    if (child == null || removedCliques.contains(child) || child == newRoot) continue;
                    Separator separatorToRemove = this.getSeparator(cliqueToRemove, child);
                    if (separatorToRemove == null) {
                        throw new NullPointerException("Unable to find separator from + " + cliqueToRemove + " and " + child);
                    }
                    Separator separatorToInclude = null;
                    if (!this.isUsingApproximation() || this.getSeparator(newRoot, child) == null) {
                        separatorToInclude = new Separator(newRoot, child, false);
                        separatorToInclude.setInternalIdentificator(separatorToRemove.getInternalIdentificator());
                    }
                    this.removeSeparator(separatorToRemove);
                    if (separatorToInclude == null) continue;
                    this.addParent(newRoot, child);
                    newRoot.addChild(child);
                    this.addSeparator(separatorToInclude);
                }
                int indexOfNewRoot = this.getCliques().indexOf(newRoot);
                if (indexOfNewRoot > 0) {
                    Collections.swap(this.getCliques(), 0, indexOfNewRoot);
                }
            }
            if (children != null) {
                for (Clique child : children) {
                    this.removeParent(cliqueToRemove, child);
                }
            }
            if (this.getCliques().remove(cliqueToRemove)) {
                ret = true;
            }
            removedCliques.add(cliqueToRemove);
        }
        if (isToUpdateIndexes) {
            this.updateCliqueAndSeparatorInternalIdentificators();
        }
        return ret;
    }

    public boolean removeParent(Clique parent, Clique child) {
        if (child != null && child.getParent().equals(parent)) {
            child.setParent(null);
            return true;
        }
        return false;
    }

    public void clearParents(Clique child) {
        if (child == null) {
            return;
        }
        child.setParent(null);
    }

    @Override
    public boolean isPredecessor(Clique predecessorToTest, Clique clique) {
        if (clique == null || predecessorToTest == null) {
            return false;
        }
        List<Clique> parents = this.getParents(clique);
        if (parents != null) {
            for (Clique parent : parents) {
                if (parent.equals(predecessorToTest)) {
                    return true;
                }
                if (!this.isPredecessor(predecessorToTest, parent)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Clique> getParents(Clique clique) {
        if (clique == null || clique.getParent() == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(clique.getParent());
    }

    public boolean isUsingSafeOrdering() {
        return this.isUsingSafeOrdering;
    }

    public void setUsingSafeOrdering(boolean isUsingSafeOrdering) {
        this.isUsingSafeOrdering = isUsingSafeOrdering;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    protected void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    @Override
    public Collection<Clique> getCliquesConnectedToNodes(Collection<INode> nodes, Collection<Clique> cliquesToIgnore) {
        if (nodes == null || nodes.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        if (cliquesToIgnore == null) {
            cliquesToIgnore = Collections.EMPTY_SET;
        }
        HashSet<Clique> ret = new HashSet<Clique>();
        if (nodes.size() == 1) {
            INode node = nodes.iterator().next();
            Clique pivot = null;
            for (Clique clique : this.getCliques()) {
                if (!clique.getNodesList().contains(node)) continue;
                pivot = clique;
                break;
            }
            ret.addAll(cliquesToIgnore);
            this.visitConnectedCliquesRecursive(pivot, ret);
            ret.removeAll(cliquesToIgnore);
        } else {
            cliquesToIgnore = new HashSet<Clique>(cliquesToIgnore);
            for (INode node : nodes) {
                Collection<Clique> cliquesCurrentIteration = this.getCliquesConnectedToNodes(Collections.singletonList(node), cliquesToIgnore);
                ret.addAll(cliquesCurrentIteration);
                cliquesToIgnore.addAll(cliquesCurrentIteration);
            }
        }
        return ret;
    }

    private void visitConnectedCliquesRecursive(Clique pivot, Collection<Clique> visitedCliques) {
        List<Clique> children;
        if (pivot == null) {
            return;
        }
        if (visitedCliques == null || visitedCliques.contains(pivot)) {
            return;
        }
        visitedCliques.add(pivot);
        List<Clique> parents = this.getParents(pivot);
        if (parents != null) {
            for (Clique parent : parents) {
                Separator separator = this.getSeparator(parent, pivot);
                if (separator == null || separator.getNodesList() == null || separator.getNodesList().isEmpty()) continue;
                this.visitConnectedCliquesRecursive(parent, visitedCliques);
            }
        }
        if ((children = pivot.getChildren()) != null) {
            for (Clique child : children) {
                Separator separator = this.getSeparator(pivot, child);
                if (separator == null || separator.getNodesList() == null || separator.getNodesList().isEmpty()) continue;
                this.visitConnectedCliquesRecursive(child, visitedCliques);
            }
        }
    }

    public List<Clique> getPathContainingNodes(Clique from, Clique to, Collection<INode> nodesInPath) {
        ArrayList<Clique> path;
        if (nodesInPath == null) {
            nodesInPath = Collections.emptyList();
        }
        if (this.hasPathContainingNodesRecursive(from, to, nodesInPath, path = new ArrayList<Clique>())) {
            return path;
        }
        return Collections.emptyList();
    }

    protected boolean hasPathContainingNodesRecursive(Clique from, Clique to, Collection<INode> nodesInPath, List<Clique> currentPath) {
        if (from == null || to == null) {
            return false;
        }
        currentPath.add(from);
        if (from.equals(to)) {
            return true;
        }
        for (Clique parent : this.getParents(from)) {
            ArrayList<Clique> newPath;
            Separator separator = this.getSeparator(parent, from);
            if (separator == null || !separator.getNodesList().containsAll(nodesInPath) || currentPath.contains(parent) || !this.hasPathContainingNodesRecursive(parent, to, nodesInPath, newPath = new ArrayList<Clique>(currentPath))) continue;
            currentPath.addAll(newPath.subList(currentPath.size(), newPath.size()));
            return true;
        }
        ArrayList<Clique> newPath = new ArrayList<Clique>();
        for (Clique child : from.getChildren()) {
            Separator separator = this.getSeparator(from, child);
            if (separator == null || !separator.getNodesList().containsAll(nodesInPath) || currentPath.contains(child)) continue;
            newPath.clear();
            newPath.addAll(currentPath);
            if (!this.hasPathContainingNodesRecursive(child, to, nodesInPath, newPath)) continue;
            currentPath.addAll(newPath.subList(currentPath.size(), newPath.size()));
            return true;
        }
        return false;
    }

    @Override
    public boolean isUsingApproximation() {
        return false;
    }
}

