/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.bn;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import unbbayes.controller.INetworkMediator;
import unbbayes.controller.resources.ControllerResources;
import unbbayes.gui.PNCompilationPane;
import unbbayes.prs.Edge;
import unbbayes.prs.Graph;
import unbbayes.prs.INode;
import unbbayes.prs.Node;
import unbbayes.prs.bn.Clique;
import unbbayes.prs.bn.DefaultJunctionTreeBuilder;
import unbbayes.prs.bn.IJunctionTree;
import unbbayes.prs.bn.IJunctionTreeBuilder;
import unbbayes.prs.bn.ILikelihoodExtractor;
import unbbayes.prs.bn.IRandomVariable;
import unbbayes.prs.bn.JunctionTree;
import unbbayes.prs.bn.LikelihoodExtractor;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.bn.ProbabilisticTable;
import unbbayes.prs.bn.Separator;
import unbbayes.prs.bn.SingleEntityNetwork;
import unbbayes.prs.bn.TreeVariable;
import unbbayes.prs.bn.cpt.impl.InCliqueConditionalProbabilityExtractor;
import unbbayes.prs.bn.cpt.impl.NormalizeTableFunction;
import unbbayes.prs.bn.resources.BnResources;
import unbbayes.prs.exception.InvalidParentException;
import unbbayes.prs.id.DecisionNode;
import unbbayes.prs.id.IInfluenceDiagramInferenceAlgorithm;
import unbbayes.util.Debug;
import unbbayes.util.ResourceController;
import unbbayes.util.SetToolkit;
import unbbayes.util.dseparation.impl.MSeparationUtility;
import unbbayes.util.extension.bn.inference.IInferenceAlgorithm;
import unbbayes.util.extension.bn.inference.IInferenceAlgorithmListener;
import unbbayes.util.extension.bn.inference.IPermanentEvidenceInferenceAlgorithm;
import unbbayes.util.extension.bn.inference.IRandomVariableAwareInferenceAlgorithm;
import unbbayes.util.extension.bn.inference.InferenceAlgorithmOptionPanel;
import unbbayes.util.resources.UtilResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JunctionTreeAlgorithm
implements IRandomVariableAwareInferenceAlgorithm,
IPermanentEvidenceInferenceAlgorithm,
IInfluenceDiagramInferenceAlgorithm {
    private static ResourceBundle generalResource = ResourceController.newInstance().getBundle(ControllerResources.class.getName(), Locale.getDefault(), JunctionTreeAlgorithm.class.getClassLoader());
    private ProbabilisticNetwork net;
    private InferenceAlgorithmOptionPanel optionPanel;
    public static final IJunctionTreeBuilder DEFAULT_JUNCTION_TREE_BUILDER = new DefaultJunctionTreeBuilder();
    private IJunctionTreeBuilder junctionTreeBuilder = DEFAULT_JUNCTION_TREE_BUILDER;
    private static ResourceBundle utilResource = ResourceController.newInstance().getBundle(UtilResources.class.getName());
    protected static ResourceBundle resource = ResourceController.newInstance().getBundle(BnResources.class.getName());
    private List<IJunctionTreeCommand> verifyConsistencyCommandList;
    private List<INode> sortedDecisionNodes = new ArrayList<INode>(0);
    private List<IInferenceAlgorithmListener> inferenceAlgorithmListeners = new ArrayList<IInferenceAlgorithmListener>(0);
    private String virtualNodePrefix = "V_";
    private Map<INode, Collection<IRandomVariable>> virtualNodesToCliquesAndSeparatorsMap = new HashMap<INode, Collection<IRandomVariable>>();
    private float virtualNodePositionRandomness = 400.0f;
    public static final ILikelihoodExtractor DEFAULT_LIKELIHOOD_EXTRACTOR = LikelihoodExtractor.newInstance();
    private ILikelihoodExtractor likelihoodExtractor = DEFAULT_LIKELIHOOD_EXTRACTOR;
    private boolean isToCalculateJointProbabilityLocally = true;
    private boolean isToUseEstimatedTotalProbability = true;
    private boolean isToConnectParentsWhenAbsorbingNode = true;
    public static final MSeparationUtility DEFAULT_MSEPARATION_UTILITY = MSeparationUtility.newInstance();
    private MSeparationUtility mseparationUtility = DEFAULT_MSEPARATION_UTILITY;
    private boolean isToDeleteEmptyCliques = false;
    private boolean isDecisionTotalOrderRequired = true;
    public static final float ERROR_MARGIN = 5.0E-5f;
    public static final ProbabilisticNode ONE_STATE_PROBNODE = new ProbabilisticNode(){
        private static final long serialVersionUID = -433609923386089166L;

        public ProbabilisticNode clone(double radius) {
            return this;
        }

        public Object clone() {
            return this;
        }

        public ProbabilisticNode basicClone() {
            return this;
        }
    };
    public static final IInferenceAlgorithmListener CLEAR_VIRTUAL_NODES_ALGORITHM_LISTENER;
    public static final IInferenceAlgorithmListener DEFAULT_INFERENCE_ALGORITHM_LISTENER;
    public static final IInferenceAlgorithmListener PRINT_MARGINALS_ALGORITHM_LISTENER;

    static {
        ONE_STATE_PROBNODE.setName("PROB_NODE_WITH_SINGLE_STATE");
        ONE_STATE_PROBNODE.appendState("VIRTUAL_STATE");
        ONE_STATE_PROBNODE.initMarginalList();
        ONE_STATE_PROBNODE.setMarginalAt(0, 1.0f);
        CLEAR_VIRTUAL_NODES_ALGORITHM_LISTENER = new IInferenceAlgorithmListener(){

            public void onBeforeRun(IInferenceAlgorithm algorithm) {
                SingleEntityNetwork net;
                if (algorithm == null) {
                    Debug.println(this.getClass(), "Algorithm == null");
                    return;
                }
                if (algorithm.getNetwork() != null && algorithm.getNetwork() instanceof SingleEntityNetwork && (net = (SingleEntityNetwork)algorithm.getNetwork()).isHybridBN()) {
                    throw new IllegalArgumentException(String.valueOf(algorithm.getName()) + " cannot handle continuous nodes. \n\n Please, go to the Global Options and choose another inference algorithm.");
                }
            }

            public void onBeforeReset(IInferenceAlgorithm algorithm) {
            }

            public void onBeforePropagate(IInferenceAlgorithm algorithm) {
                if (algorithm.getNetwork() != null && algorithm.getNetwork() instanceof SingleEntityNetwork) {
                    SingleEntityNetwork net = (SingleEntityNetwork)algorithm.getNetwork();
                    for (Node n : new ArrayList(net.getNodes())) {
                        TreeVariable node;
                        if (!(n instanceof TreeVariable) || !(node = (TreeVariable)n).hasEvidence() || !node.hasLikelihood() || !(algorithm instanceof JunctionTreeAlgorithm)) continue;
                        JunctionTreeAlgorithm jt = (JunctionTreeAlgorithm)algorithm;
                        try {
                            ArrayList<INode> evidenceNodes = new ArrayList<INode>();
                            evidenceNodes.add(node);
                            evidenceNodes.addAll(jt.getLikelihoodExtractor().extractLikelihoodParents(algorithm.getNetwork(), node));
                            jt.addVirtualNode(algorithm.getNetwork(), evidenceNodes);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }

            public void onAfterRun(IInferenceAlgorithm algorithm) {
            }

            public void onAfterReset(IInferenceAlgorithm algorithm) {
            }

            public void onAfterPropagate(IInferenceAlgorithm algorithm) {
                SingleEntityNetwork network;
                if (algorithm == null) {
                    Debug.println(this.getClass(), "Algorithm == null");
                    return;
                }
                if (algorithm.getNetwork() != null && algorithm.getNetwork() instanceof SingleEntityNetwork && !(network = (SingleEntityNetwork)algorithm.getNetwork()).isConnected() && network.getJunctionTree() != null) {
                    for (Clique clique : network.getJunctionTree().getCliques()) {
                        try {
                            clique.normalize();
                            for (Node node : clique.getAssociatedProbabilisticNodes()) {
                                if (!(node instanceof TreeVariable)) continue;
                                ((TreeVariable)node).updateMarginal();
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                if (algorithm instanceof JunctionTreeAlgorithm) {
                    ((JunctionTreeAlgorithm)algorithm).clearVirtualNodes();
                }
            }
        };
        DEFAULT_INFERENCE_ALGORITHM_LISTENER = new IInferenceAlgorithmListener(){

            public void onBeforeRun(IInferenceAlgorithm algorithm) {
                SingleEntityNetwork net;
                if (algorithm == null) {
                    Debug.println(this.getClass(), "Algorithm == null");
                    return;
                }
                if (algorithm.getNetwork() != null && algorithm.getNetwork() instanceof SingleEntityNetwork && (net = (SingleEntityNetwork)algorithm.getNetwork()).isHybridBN()) {
                    throw new IllegalArgumentException(String.valueOf(algorithm.getName()) + " cannot handle continuous nodes. \n\n Please, go to the Global Options and choose another inference algorithm.");
                }
            }

            public void onBeforeReset(IInferenceAlgorithm algorithm) {
            }

            public void onBeforePropagate(IInferenceAlgorithm algorithm) {
                HashMap<String, Integer> evidenceMap = new HashMap<String, Integer>();
                HashSet<String> negativeEvidenceNodeNames = new HashSet<String>();
                HashMap<String, float[]> likelihoodMap = new HashMap<String, float[]>();
                if (algorithm.getNetwork() != null && algorithm.getNetwork() instanceof SingleEntityNetwork) {
                    SingleEntityNetwork net = (SingleEntityNetwork)algorithm.getNetwork();
                    for (Node n : new ArrayList(net.getNodes())) {
                        TreeVariable node;
                        if (!(n instanceof TreeVariable) || !(node = (TreeVariable)n).hasEvidence()) continue;
                        if (node.hasLikelihood()) {
                            if (!(algorithm instanceof JunctionTreeAlgorithm)) continue;
                            JunctionTreeAlgorithm jt = (JunctionTreeAlgorithm)algorithm;
                            try {
                                ArrayList<INode> evidenceNodes = new ArrayList<INode>();
                                evidenceNodes.add(node);
                                evidenceNodes.addAll(jt.getLikelihoodExtractor().extractLikelihoodParents(algorithm.getNetwork(), node));
                                INode virtual = null;
                                try {
                                    virtual = jt.addVirtualNode(algorithm.getNetwork(), evidenceNodes);
                                    if (virtual == null) continue;
                                    evidenceMap.put(virtual.getName(), ((TreeVariable)virtual).getEvidence());
                                }
                                catch (Exception e) {
                                    Debug.println(this.getClass(), "Could not create virtual node for " + node, e);
                                    likelihoodMap.put(node.getName(), node.getLikelihood());
                                    evidenceMap.put(node.getName(), 0);
                                }
                                continue;
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                        int evidenceIndex = node.getEvidence();
                        if (node.getMarginalAt(evidenceIndex) == 0.0f) {
                            negativeEvidenceNodeNames.add(node.getName());
                        }
                        evidenceMap.put(node.getName(), evidenceIndex);
                    }
                    algorithm.reset();
                    for (String name : evidenceMap.keySet()) {
                        ((TreeVariable)net.getNode(name)).addFinding((Integer)evidenceMap.get(name), negativeEvidenceNodeNames.contains(name));
                        if (!likelihoodMap.containsKey(name)) continue;
                        ((TreeVariable)net.getNode(name)).setMarginalProbabilities((float[])likelihoodMap.get(name));
                    }
                }
            }

            public void onAfterRun(IInferenceAlgorithm algorithm) {
            }

            public void onAfterReset(IInferenceAlgorithm algorithm) {
            }

            public void onAfterPropagate(IInferenceAlgorithm algorithm) {
                SingleEntityNetwork network;
                if (algorithm == null) {
                    Debug.println(this.getClass(), "Algorithm == null");
                    return;
                }
                if (algorithm.getNetwork() != null && algorithm.getNetwork() instanceof SingleEntityNetwork && !(network = (SingleEntityNetwork)algorithm.getNetwork()).isConnected() && network.getJunctionTree() != null) {
                    for (Clique clique : network.getJunctionTree().getCliques()) {
                        try {
                            clique.normalize();
                            for (Node node : clique.getAssociatedProbabilisticNodes()) {
                                if (!(node instanceof TreeVariable)) continue;
                                ((TreeVariable)node).updateMarginal();
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
        };
        PRINT_MARGINALS_ALGORITHM_LISTENER = new IInferenceAlgorithmListener(){

            public void onBeforeRun(IInferenceAlgorithm algorithm) {
            }

            public void onAfterRun(IInferenceAlgorithm algorithm) {
            }

            public void onBeforeReset(IInferenceAlgorithm algorithm) {
            }

            public void onAfterReset(IInferenceAlgorithm algorithm) {
            }

            public void onBeforePropagate(IInferenceAlgorithm algorithm) {
            }

            public void onAfterPropagate(IInferenceAlgorithm algorithm) {
                if (algorithm == null || algorithm.getNetwork() == null) {
                    return;
                }
                try {
                    System.out.println(new Date().toString());
                    for (Node node : algorithm.getNetwork().getNodes()) {
                        if (node instanceof TreeVariable) {
                            System.out.println(node + ": ");
                            TreeVariable treeVariable = (TreeVariable)node;
                            int i = 0;
                            while (i < treeVariable.getStatesSize()) {
                                System.out.println("\t" + treeVariable.getStateAt(i) + " = " + treeVariable.getMarginalAt(i));
                                ++i;
                            }
                        }
                        System.out.println();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
    }

    public JunctionTreeAlgorithm() {
        this.setVerifyConsistencyCommandList(this.initConsistencyCommandList());
        this.getInferenceAlgorithmListeners().add(DEFAULT_INFERENCE_ALGORITHM_LISTENER);
    }

    @Override
    public void initInternalIdentificators() {
        ProbabilisticNetwork probabilisticNetwork = this.getNet();
        if (probabilisticNetwork != null) {
            int nodeCount = probabilisticNetwork.getNodeCount();
            int i = 0;
            while (i < nodeCount) {
                Node node = probabilisticNetwork.getNodeAt(i);
                if (node instanceof IRandomVariable) {
                    ((IRandomVariable)((Object)node)).setInternalIdentificator(i);
                }
                ++i;
            }
        }
    }

    protected List<IJunctionTreeCommand> initConsistencyCommandList() {
        ArrayList<IJunctionTreeCommand> ret = new ArrayList<IJunctionTreeCommand>();
        ret.add(new IJunctionTreeCommand(){

            public void undoAction(IInferenceAlgorithm algorithm, Graph graph) throws UndoableJTCommandException {
                throw new UndoableJTCommandException();
            }

            public void doAction(IInferenceAlgorithm algorithm, Graph graph) {
                if (graph == null || graph.getNodeCount() == 0) {
                    throw new RuntimeException(resource.getString("EmptyNetException"));
                }
                if (graph instanceof ProbabilisticNetwork) {
                    ProbabilisticNetwork net = (ProbabilisticNetwork)graph;
                    if (net.getNodeIndexes() == null) {
                        net.setNodeIndexes(new HashMap<String, Integer>());
                    } else {
                        net.getNodeIndexes().clear();
                    }
                    int i = ((ArrayList)net.getNodes()).size() - 1;
                    while (i >= 0) {
                        net.getNodeIndexes().put(((Node)((ArrayList)net.getNodes()).get(i)).getName(), new Integer(i));
                        --i;
                    }
                }
            }
        });
        ret.add(new IJunctionTreeCommand(){

            public void undoAction(IInferenceAlgorithm algorithm, Graph graph) throws UndoableJTCommandException {
                throw new UndoableJTCommandException();
            }

            public void doAction(IInferenceAlgorithm algorithm, Graph graph) {
                if (graph.getNodeCount() > 0) {
                    try {
                        JunctionTreeAlgorithm.this.verifyUtility(graph);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        ret.add(new IJunctionTreeCommand(){

            public void undoAction(IInferenceAlgorithm algorithm, Graph graph) throws UndoableJTCommandException {
                throw new UndoableJTCommandException();
            }

            public void doAction(IInferenceAlgorithm algorithm, Graph graph) {
                if (graph instanceof ProbabilisticNetwork && graph.getNodeCount() > 0) {
                    ProbabilisticNetwork net = (ProbabilisticNetwork)graph;
                    try {
                        net.verifyCycles();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        ret.add(new IJunctionTreeCommand(){

            public void undoAction(IInferenceAlgorithm algorithm, Graph graph) throws UndoableJTCommandException {
                throw new UndoableJTCommandException();
            }

            public void doAction(IInferenceAlgorithm algorithm, Graph graph) {
                try {
                    JunctionTreeAlgorithm.this.verifyPotentialTables(graph);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        ret.add(new IJunctionTreeCommand(){

            public void undoAction(IInferenceAlgorithm algorithm, Graph graph) throws UndoableJTCommandException {
                throw new UndoableJTCommandException();
            }

            public void doAction(IInferenceAlgorithm algorithm, Graph graph) {
                try {
                    JunctionTreeAlgorithm.this.setSortedDecisionNodes(JunctionTreeAlgorithm.this.sortDecisionNodes(graph));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return ret;
    }

    @Override
    public List<INode> sortDecisionNodes(Graph graph) throws Exception {
        int i;
        if (!(graph instanceof ProbabilisticNetwork)) {
            return null;
        }
        ProbabilisticNetwork net = (ProbabilisticNetwork)graph;
        List nodeList = net.getNodes();
        for (Node node : nodeList) {
            node.clearAdjacents();
        }
        ArrayList<INode> decisionNodes = new ArrayList<INode>();
        int numNodes = nodeList.size();
        int i2 = 0;
        while (i2 < numNodes) {
            if (((Node)nodeList.get(i2)).getType() == 2) {
                decisionNodes.add((INode)nodeList.get(i2));
            }
            ++i2;
        }
        int numDecisionNodes = decisionNodes.size();
        if (numDecisionNodes > 0) {
            ArrayList<Node> queue = new ArrayList<Node>();
            queue.ensureCapacity(nodeList.size());
            i = 0;
            while (i < numDecisionNodes) {
                boolean[] isVisited = new boolean[nodeList.size()];
                Node firstInQueue = (Node)decisionNodes.get(i);
                queue.clear();
                queue.add(firstInQueue);
                while (queue.size() != 0) {
                    INode currentInQueue = (INode)queue.remove(0);
                    isVisited[nodeList.indexOf((Object)currentInQueue)] = true;
                    int numChildren = currentInQueue.getChildNodes().size();
                    int k = 0;
                    while (k < numChildren) {
                        Node child = (Node)currentInQueue.getChildNodes().get(k);
                        if (!isVisited[nodeList.indexOf(child)]) {
                            if (child.getType() == 2 && !firstInQueue.getAdjacents().contains(child)) {
                                firstInQueue.getAdjacents().add(child);
                            }
                            queue.add(child);
                        }
                        ++k;
                    }
                }
                ++i;
            }
        }
        boolean hasSwap = true;
        while (hasSwap) {
            hasSwap = false;
            i = 0;
            while (i < decisionNodes.size() - 1) {
                block24: {
                    Node node1 = (Node)decisionNodes.get(i);
                    Node node2 = (Node)decisionNodes.get(i + 1);
                    try {
                        node1 = (Node)decisionNodes.get(i);
                        node2 = (Node)decisionNodes.get(i + 1);
                    }
                    catch (ClassCastException e) {
                        try {
                            Debug.println(this.getClass(), e.getMessage(), e);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                        break block24;
                    }
                    if (node1 != null && node2 != null && node1.getAdjacents().size() < node2.getAdjacents().size()) {
                        decisionNodes.set(i + 1, node1);
                        decisionNodes.set(i, node2);
                        hasSwap = true;
                    }
                }
                ++i;
            }
        }
        boolean isTotalOrderRequired = this.isDecisionTotalOrderRequired();
        int i3 = 0;
        while (i3 < decisionNodes.size()) {
            block25: {
                Node decisionNode = null;
                try {
                    decisionNode = (Node)decisionNodes.get(i3);
                }
                catch (ClassCastException e) {
                    try {
                        Debug.println(this.getClass(), e.getMessage(), e);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    break block25;
                }
                if (decisionNode != null && decisionNode.getAdjacents().size() != decisionNodes.size() - i3 - 1 && isTotalOrderRequired) {
                    throw new Exception(resource.getString("DecisionOrderException"));
                }
            }
            ++i3;
        }
        for (Node node : nodeList) {
            node.clearAdjacents();
        }
        return decisionNodes;
    }

    protected void verifyPotentialTables(Graph graph) throws Exception {
        if (graph instanceof ProbabilisticNetwork) {
            for (Node node : ((ProbabilisticNetwork)graph).getNodes()) {
                PotentialTable probabilityFunction;
                if (!(node instanceof ProbabilisticNode) || !((probabilityFunction = ((ProbabilisticNode)node).getProbabilityFunction()) instanceof ProbabilisticTable)) continue;
                ((ProbabilisticTable)probabilityFunction).verifyConsistency();
            }
        }
    }

    public JunctionTreeAlgorithm(ProbabilisticNetwork net) {
        this();
        this.setNet(net);
    }

    @Override
    public String getDescription() {
        return utilResource.getString("junctionTreeAlgorithmDescription");
    }

    @Override
    public String getName() {
        return utilResource.getString("junctionTreeAlgorithmName");
    }

    @Override
    public void run() throws IllegalStateException {
        this.initInternalIdentificators();
        for (IInferenceAlgorithmListener listener : this.getInferenceAlgorithmListeners()) {
            listener.onBeforeRun(this);
        }
        if (this.getNet() == null || ((ArrayList)this.getNet().getNodes()).size() == 0) {
            throw new IllegalStateException(resource.getString("EmptyNetException"));
        }
        try {
            this.verifyConsistency(this.getNet());
            this.moralize(this.getNet());
            List<INode> nodeEliminationOrder = this.triangulate(this.getNet());
            IJunctionTree junctionTree = this.buildJunctionTree(this.getNet(), nodeEliminationOrder);
            this.getNet().setJunctionTree(junctionTree);
            this.setSortedDecisionNodes(null);
            if (this.getMediator() != null) {
                PNCompilationPane component = this.getMediator().getScreen().getNetWindowCompilation();
                if (component == null) {
                    throw new NullPointerException("No compilation pane for " + this.getName() + " could be obtained.");
                }
                this.getMediator().getScreen().getContentPane().remove(component);
                this.getMediator().getScreen().getCardLayout().removeLayoutComponent(component);
                Container container = this.getMediator().getScreen().getContentPane();
                this.getMediator().getScreen();
                container.add((Component)component, "pnCompilationPane");
                CardLayout cardLayout = this.getMediator().getScreen().getCardLayout();
                this.getMediator().getScreen();
                cardLayout.addLayoutComponent(component, "pnCompilationPane");
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        for (IInferenceAlgorithmListener listener : this.getInferenceAlgorithmListeners()) {
            listener.onAfterRun(this);
        }
    }

    public void updateCliqueAndSeparatorInternalIdentificators(IJunctionTree junctionTree) {
        if (junctionTree == null) {
            return;
        }
        if (junctionTree instanceof JunctionTree) {
            ((JunctionTree)junctionTree).updateCliqueAndSeparatorInternalIdentificators();
            return;
        }
        if (junctionTree.getCliques() != null && !junctionTree.getCliques().isEmpty()) {
            Clique root = junctionTree.getCliques().get(0);
            while (root.getParent() != null) {
                root = root.getParent();
            }
            int indexOfRoot = junctionTree.getCliques().indexOf(root);
            if (indexOfRoot > 0) {
                Collections.swap(junctionTree.getCliques(), 0, indexOfRoot);
            }
            int i = 0;
            while (i < junctionTree.getCliques().size()) {
                junctionTree.getCliques().get(i).setIndex(i);
                junctionTree.getCliques().get(i).setInternalIdentificator(i);
                ++i;
            }
        }
        int separatorIndex = -1;
        for (Separator sep : junctionTree.getSeparators()) {
            sep.setInternalIdentificator(separatorIndex--);
        }
    }

    public void moralize(ProbabilisticNetwork net) {
        int sizeArcos;
        for (Node node : net.getNodes()) {
            node.clearAdjacents();
        }
        if (net.isCreateLog()) {
            net.getLogManager().append(resource.getString("moralizeLabel"));
        }
        net.getMarkovArcs().clear();
        Collection<Edge> markovArcsToBeForced = net.getMarkovArcsToBeForced();
        if (markovArcsToBeForced != null && !markovArcsToBeForced.isEmpty()) {
            net.getMarkovArcs().addAll(markovArcsToBeForced);
        }
        net.setEdgesCopy(SetToolkit.clone(net.getEdges()));
        int i = sizeArcos = net.getMarkovArcs().size() - 1;
        while (i >= 0) {
            Edge edge = net.getMarkovArcs().get(i);
            if (edge.getDestinationNode().getType() == 2) {
                net.getMarkovArcs().remove(i);
            }
            --i;
        }
        int sizeNos = ((ArrayList)net.getNodes()).size();
        int n = 0;
        while (n < sizeNos) {
            Node currentNode = (Node)((ArrayList)net.getNodes()).get(n);
            if (currentNode.getType() != 2 && currentNode.getParents().size() > 1) {
                int sizePais = currentNode.getParents().size();
                int j = 0;
                while (j < sizePais - 1) {
                    Node parent1 = currentNode.getParents().get(j);
                    int k = j + 1;
                    while (k < sizePais) {
                        Node parent2 = currentNode.getParents().get(k);
                        if (net.hasEdge(parent1, parent2, net.getEdgesCopy()) < 0 && net.hasEdge(parent1, parent2, net.getMarkovArcs()) < 0) {
                            Edge moralizationEdge = new Edge(parent1, parent2);
                            if (net.isCreateLog()) {
                                net.getLogManager().append(String.valueOf(parent1.getName()) + " - " + parent2.getName() + "\n");
                            }
                            net.getMarkovArcs().add(moralizationEdge);
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++n;
        }
        this.makeAdjacents(net);
        if (net.isCreateLog()) {
            net.getLogManager().append("\n");
        }
    }

    public List<INode> triangulate(ProbabilisticNetwork net) {
        List nodeList = net.getNodes();
        if (net.isCreateLog()) {
            net.getLogManager().append(resource.getString("triangulateLabel"));
        }
        ArrayList<Node> auxNodes = SetToolkit.clone(nodeList);
        HashSet<Node> nodesToRemove = new HashSet<Node>();
        for (Node node : auxNodes) {
            if (node.getType() != 1) continue;
            nodesToRemove.add(node);
        }
        auxNodes.removeAll(nodesToRemove);
        net.getNodesCopy().clear();
        net.getNodesCopy().addAll(SetToolkit.clone((Collection)auxNodes));
        ArrayList<Node> nodesCopy = net.getNodesCopy();
        List<INode> decisionNodes = this.getSortedDecisionNodes();
        if (decisionNodes == null) {
            try {
                decisionNodes = this.sortDecisionNodes(net);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        for (INode node : decisionNodes) {
            auxNodes.remove(node);
            auxNodes.removeAll(node.getParentNodes());
        }
        ArrayList<INode> nodeEliminationOrder = new ArrayList<INode>(nodesCopy.size());
        while (this.minimumWeightElimination((List<Node>)auxNodes, net, nodeEliminationOrder)) {
        }
        int i = decisionNodes.size() - 1;
        while (i >= 0) {
            Node decisionNode = (Node)decisionNodes.get(i);
            nodeEliminationOrder.add(decisionNode);
            int sizeAdjacentes = decisionNode.getAdjacents().size();
            int j = 0;
            while (j < sizeAdjacentes) {
                Node v = decisionNode.getAdjacents().get(j);
                v.getAdjacents().remove(decisionNode);
                ++j;
            }
            if (net.isCreateLog()) {
                net.getLogManager().append("\t" + nodeEliminationOrder.size() + " " + decisionNode.getName() + "\n");
            }
            auxNodes = SetToolkit.clone(decisionNode.getParents());
            auxNodes.removeAll(decisionNodes);
            auxNodes.removeAll(nodeEliminationOrder);
            j = 0;
            while (j < i) {
                Node decision = (Node)decisionNodes.get(j);
                auxNodes.removeAll(decision.getParents());
                ++j;
            }
            while (this.minimumWeightElimination(auxNodes, net, nodeEliminationOrder)) {
            }
            --i;
        }
        this.makeAdjacents(net);
        return nodeEliminationOrder;
    }

    public void resetEvidences(SingleEntityNetwork net) {
        for (Node node : net.getNodesCopy()) {
            if (!(node instanceof TreeVariable)) continue;
            ((TreeVariable)node).resetEvidence();
        }
    }

    protected IJunctionTree buildJunctionTree(final ProbabilisticNetwork net, List<INode> nodeEliminationOrder) throws InstantiationException, IllegalAccessException {
        IJunctionTreeBuilder jtBuilder = this.getJunctionTreeBuilder();
        if (jtBuilder == null) {
            jtBuilder = new DefaultJunctionTreeBuilder();
            this.setJunctionTreeBuilder(jtBuilder);
        }
        IJunctionTree junctionTree = jtBuilder.buildJunctionTree(this.getNet());
        this.resetEvidences(net);
        this.cliques(net, nodeEliminationOrder, junctionTree);
        this.strongTreeMethod(net, nodeEliminationOrder, junctionTree);
        this.sortCliqueNodes(net, nodeEliminationOrder, junctionTree);
        this.addVariablesToCliqueAndSeparatorTables(net, junctionTree);
        this.associateCliques(net, junctionTree);
        try {
            junctionTree.initBeliefs();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.updateMarginals(net);
        if (net.isCreateLog()) {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    net.makeLog();
                    System.out.println("**Log ended**");
                }
            });
            t.setPriority(1);
            t.start();
        }
        return junctionTree;
    }

    public void updateMarginals(ProbabilisticNetwork net) {
        ArrayList<Node> nodesCopy = net.getNodesCopy();
        if (nodesCopy != null) {
            for (Node node : nodesCopy) {
                if (node.getStatesSize() == 0) continue;
                ((TreeVariable)node).marginal();
            }
        }
    }

    protected void addVariablesToCliqueAndSeparatorTables(ProbabilisticNetwork net, IJunctionTree junctionTree) {
        PotentialTable auxUtilTab;
        PotentialTable auxTable;
        int i = junctionTree.getCliques().size() - 1;
        while (i >= 0) {
            Clique auxClique = junctionTree.getCliques().get(i);
            auxTable = auxClique.getProbabilityFunction();
            auxUtilTab = auxClique.getUtilityTable();
            int numNodes = auxClique.getNodesList().size();
            int c = 0;
            while (c < numNodes) {
                auxTable.addVariable(auxClique.getNodesList().get(c));
                auxUtilTab.addVariable(auxClique.getNodesList().get(c));
                ++c;
            }
            --i;
        }
        for (Separator auxSep : junctionTree.getSeparators()) {
            auxTable = auxSep.getProbabilityFunction();
            auxUtilTab = auxSep.getUtilityTable();
            int numNodes = auxSep.getNodesList().size();
            int c = 0;
            while (c < numNodes) {
                auxTable.addVariable(auxSep.getNodesList().get(c));
                auxUtilTab.addVariable(auxSep.getNodesList().get(c));
                ++c;
            }
        }
    }

    protected void associateCliques(ProbabilisticNetwork net, IJunctionTree junctionTree) {
        Clique smallestClique = null;
        for (Clique clique : junctionTree.getCliques()) {
            clique.getAssociatedProbabilisticNodesList().clear();
            clique.getAssociatedUtilityNodesList().clear();
        }
        int numNodes = net.getNodeCount();
        int n = 0;
        while (n < numNodes) {
            if (((Node)((ArrayList)net.getNodes()).get(n)).getType() != 2) {
                int min = Integer.MAX_VALUE;
                Node auxNode = (Node)((ArrayList)net.getNodes()).get(n);
                int numCliques = junctionTree.getCliques().size();
                int c = 0;
                while (c < numCliques) {
                    Clique auxClique = junctionTree.getCliques().get(c);
                    if (auxClique.getProbabilityFunction().tableSize() < min && SetToolkit.containsAllExact(auxClique.getNodesList(), auxNode.getParents()) && (auxNode.getType() != 0 || SetToolkit.containsExact(auxClique.getNodesList(), auxNode))) {
                        smallestClique = auxClique;
                        min = smallestClique.getProbabilityFunction().tableSize();
                    }
                    ++c;
                }
                if (auxNode instanceof ProbabilisticNode) {
                    smallestClique.getAssociatedProbabilisticNodesList().add(auxNode);
                } else {
                    smallestClique.getAssociatedUtilityNodesList().add(auxNode);
                }
            }
            ++n;
        }
        block3: for (Node node : net.getNodesCopy()) {
            int smallestTableSize = Integer.MAX_VALUE;
            if (node instanceof ProbabilisticNode) {
                for (Separator separator : junctionTree.getSeparators()) {
                    if (!separator.getNodesList().contains(node) || separator.getProbabilityFunction().tableSize() >= smallestTableSize) continue;
                    if (!separator.getClique1().getNodesList().contains(node) || !separator.getClique2().getNodesList().contains(node)) {
                        Debug.println(this.getClass(), "Separator " + separator + " is not an intersection between the cliques it connects.");
                        continue;
                    }
                    ((ProbabilisticNode)node).setAssociatedClique(separator);
                    smallestTableSize = separator.getProbabilityFunction().tableSize();
                }
            }
            if (smallestTableSize != Integer.MAX_VALUE) continue;
            for (Clique clique : junctionTree.getCliques()) {
                if (!clique.getNodesList().contains(node) || clique.getProbabilityFunction().tableSize() >= smallestTableSize) continue;
                if (!(node instanceof ProbabilisticNode)) {
                    ((DecisionNode)node).setAssociatedClique(clique);
                    continue block3;
                }
                ((ProbabilisticNode)node).setAssociatedClique(clique);
                smallestTableSize = clique.getProbabilityFunction().tableSize();
            }
        }
    }

    protected void sortCliqueNodes(ProbabilisticNetwork net, List<INode> nodeEliminationOrder, IJunctionTree junctionTree) {
        Node node2;
        Node node1;
        int i;
        boolean hasSwapped;
        List<Clique> cliqueList = junctionTree.getCliques();
        boolean isID = net.isID();
        int k = 0;
        while (k < cliqueList.size()) {
            Clique clique = cliqueList.get(k);
            ArrayList<Node> nodesInClique = clique.getNodes();
            hasSwapped = true;
            while (hasSwapped) {
                hasSwapped = false;
                i = 0;
                while (i < nodesInClique.size() - 1) {
                    node1 = nodesInClique.get(i);
                    node2 = nodesInClique.get(i + 1);
                    if (isID) {
                        if (nodeEliminationOrder.indexOf(node1) > nodeEliminationOrder.indexOf(node2)) {
                            nodesInClique.set(i + 1, node1);
                            nodesInClique.set(i, node2);
                            hasSwapped = true;
                        }
                    } else if (node1.getName().compareToIgnoreCase(node2.getName()) > 0) {
                        nodesInClique.set(i + 1, node1);
                        nodesInClique.set(i, node2);
                        hasSwapped = true;
                    }
                    ++i;
                }
            }
            ++k;
        }
        for (Separator separator : junctionTree.getSeparators()) {
            ArrayList<Node> nodesInSeparator = separator.getNodes();
            hasSwapped = true;
            while (hasSwapped) {
                hasSwapped = false;
                i = 0;
                while (i < nodesInSeparator.size() - 1) {
                    node1 = nodesInSeparator.get(i);
                    node2 = nodesInSeparator.get(i + 1);
                    if (isID) {
                        if (nodeEliminationOrder.indexOf(node1) > nodeEliminationOrder.indexOf(node2)) {
                            nodesInSeparator.set(i + 1, node1);
                            nodesInSeparator.set(i, node2);
                            hasSwapped = true;
                        }
                    } else if (node1.getName().compareToIgnoreCase(node2.getName()) > 0) {
                        nodesInSeparator.set(i + 1, node1);
                        nodesInSeparator.set(i, node2);
                        hasSwapped = true;
                    }
                    ++i;
                }
            }
        }
    }

    protected int getCliqueIndexFromAlphaOrder(List<Node> nodesInClique, List<Node> ordering) {
        int maxIndex = -1;
        Node nodeWithMaxIndex = null;
        for (Node node : nodesInClique) {
            int currentIndex = ordering.indexOf(node);
            if (maxIndex >= currentIndex) continue;
            maxIndex = currentIndex;
            nodeWithMaxIndex = node;
        }
        nodesInClique.remove(nodeWithMaxIndex);
        if (nodesInClique.isEmpty()) {
            return maxIndex;
        }
        List<Node> neighbors = SetToolkit.clone(nodesInClique.get(0).getAdjacents());
        int numNodes = nodesInClique.size();
        int i = 1;
        while (i < numNodes) {
            List intersection = SetToolkit.intersection(neighbors, nodesInClique.get(i).getAdjacents());
            neighbors = intersection;
            ++i;
        }
        neighbors.remove(nodeWithMaxIndex);
        int neighborIndex = 0;
        for (Node neighbor : neighbors) {
            if (nodesInClique.contains(neighbor) || ordering.indexOf(neighbor) > maxIndex) continue;
            neighborIndex = maxIndex;
            break;
        }
        return neighborIndex;
    }

    protected void strongTreeMethod(ProbabilisticNetwork net, List<INode> nodeEliminationOrder, IJunctionTree junctionTree) {
        ArrayList<Node> alpha = new ArrayList<Node>();
        int i = nodeEliminationOrder.size() - 1;
        while (i >= 0) {
            alpha.add((Node)nodeEliminationOrder.get(i));
            --i;
        }
        if (net.getNodesCopy().size() > 1) {
            Clique auxClique;
            int sizeCliques = junctionTree.getCliques().size();
            int i2 = 0;
            while (i2 < sizeCliques) {
                int ndx;
                auxClique = junctionTree.getCliques().get(i2);
                List listaNos = SetToolkit.clone(auxClique.getNodesList());
                while ((ndx = this.getCliqueIndexFromAlphaOrder(listaNos, alpha)) <= 0 && listaNos.size() > 1) {
                }
                if (ndx < 0) {
                    ndx = 0;
                }
                auxClique.setIndex(ndx);
                listaNos.clear();
                ++i2;
            }
            alpha.clear();
            Comparator<Clique> comparador = new Comparator<Clique>(){

                @Override
                public int compare(Clique o1, Clique o2) {
                    Clique c1 = o1;
                    Clique c2 = o2;
                    if (c1.getIndex() > c2.getIndex()) {
                        return 1;
                    }
                    if (c1.getIndex() < c2.getIndex()) {
                        return -1;
                    }
                    return 0;
                }
            };
            Collections.sort(junctionTree.getCliques(), comparador);
            auxClique = junctionTree.getCliques().get(0);
            List uni = SetToolkit.clone(auxClique.getNodesList());
            int sizeCliques1 = junctionTree.getCliques().size();
            int i3 = 1;
            while (i3 < sizeCliques1) {
                auxClique = junctionTree.getCliques().get(i3);
                List inter = SetToolkit.intersection(auxClique.getNodesList(), uni);
                int j = 0;
                while (j < i3) {
                    Clique auxClique2 = junctionTree.getCliques().get(j);
                    if (auxClique2.getNodesList().containsAll(inter)) {
                        Separator sep = new Separator(auxClique2, auxClique);
                        sep.setNodes(inter);
                        junctionTree.addSeparator(sep);
                        List auxList = SetToolkit.union(auxClique.getNodes(), uni);
                        uni.clear();
                        uni = auxList;
                        break;
                    }
                    ++j;
                }
                ++i3;
            }
        }
    }

    protected void cliques(ProbabilisticNetwork net, List<INode> nodeEliminationOrder, IJunctionTree junctionTree) {
        ArrayList<Clique> generatedCliques = new ArrayList<Clique>();
        for (Node node : net.getNodesCopy()) {
            int eliminationOrderIndex = nodeEliminationOrder.indexOf(node);
            Clique newClique = new Clique();
            newClique.getNodesList().add(node);
            for (Node adjacentNode : node.getAdjacents()) {
                if (nodeEliminationOrder.indexOf(adjacentNode) <= eliminationOrderIndex) continue;
                newClique.getNodesList().add(adjacentNode);
            }
            generatedCliques.add(newClique);
        }
        if (!generatedCliques.isEmpty()) {
            Collections.sort(generatedCliques, new Comparator<Clique>(){

                @Override
                public int compare(Clique clique1, Clique clique2) {
                    return clique1.getNodesList().size() - clique2.getNodesList().size();
                }
            });
        }
        int numCliques = generatedCliques.size();
        int i = 0;
        while (i < numCliques) {
            block6: {
                Clique clique1 = (Clique)generatedCliques.get(i);
                int j = i + 1;
                while (j < numCliques) {
                    Clique clique2 = (Clique)generatedCliques.get(j);
                    if (!clique2.getNodesList().containsAll(clique1.getNodesList())) {
                        ++j;
                        continue;
                    }
                    break block6;
                }
                junctionTree.getCliques().add(clique1);
            }
            ++i;
        }
    }

    public void makeAdjacents(ProbabilisticNetwork net) {
        for (Node node : net.getNodes()) {
            node.clearAdjacents();
        }
        int z = net.getMarkovArcs().size() - 1;
        while (z >= 0) {
            Edge arc = net.getMarkovArcs().get(z);
            arc.getOriginNode().getAdjacents().add(arc.getDestinationNode());
            arc.getDestinationNode().getAdjacents().add(arc.getOriginNode());
            --z;
        }
        List<Edge> edgesCopy = net.getEdgesCopy();
        int z2 = edgesCopy.size() - 1;
        while (z2 >= 0) {
            Edge auxArco = edgesCopy.get(z2);
            if (auxArco.getDestinationNode().getType() == 1) {
                edgesCopy.remove(z2);
            } else {
                auxArco.getOriginNode().getAdjacents().add(auxArco.getDestinationNode());
                auxArco.getDestinationNode().getAdjacents().add(auxArco.getOriginNode());
            }
            --z2;
        }
    }

    protected boolean minimumWeightElimination(List<Node> nodes, ProbabilisticNetwork net, List<INode> nodeEliminationOrder) {
        if (nodeEliminationOrder == null) {
            nodeEliminationOrder = new ArrayList<INode>();
        }
        boolean hasSome = true;
        while (hasSome) {
            hasSome = false;
            int i = nodes.size() - 1;
            while (i >= 0) {
                Node auxNode = nodes.get(i);
                if (!this.isNeedingMoreArc(auxNode, net)) {
                    int j = auxNode.getAdjacents().size() - 1;
                    while (j >= 0) {
                        Node v = auxNode.getAdjacents().get(j);
                        v.getAdjacents().remove(auxNode);
                        --j;
                    }
                    nodes.remove(auxNode);
                    hasSome = true;
                    nodeEliminationOrder.add(auxNode);
                    if (net.isCreateLog()) {
                        net.getLogManager().append("\t" + nodeEliminationOrder.size() + " " + auxNode.getName() + "\n");
                    }
                }
                --i;
            }
        }
        if (nodes.size() > 0) {
            Node auxNo = this.weight(nodes);
            nodeEliminationOrder.add(auxNo);
            if (net.isCreateLog()) {
                net.getLogManager().append("\t" + nodeEliminationOrder.size() + " " + auxNo.getName() + "\n");
            }
            this.addChordAndEliminateNode(auxNo, nodes, net);
            return true;
        }
        return false;
    }

    private Node weight(List<Node> nodes) {
        Node noMin = null;
        double pmin = Double.MAX_VALUE;
        int i = nodes.size() - 1;
        while (i >= 0) {
            Node auxNode = nodes.get(i);
            double p = Math.log(auxNode.getStatesSize());
            int j = auxNode.getAdjacents().size() - 1;
            while (j >= 0) {
                Node v = auxNode.getAdjacents().get(j);
                p += Math.log(v.getStatesSize());
                --j;
            }
            if (p < pmin) {
                pmin = p;
                noMin = auxNode;
            }
            --i;
        }
        return noMin;
    }

    protected void addChordAndEliminateNode(Node node, List<Node> nodes, ProbabilisticNetwork net) {
        int i = node.getAdjacents().size() - 1;
        while (i > 0) {
            Node auxNode1 = node.getAdjacents().get(i);
            int j = i - 1;
            while (j >= 0) {
                Node auxNode2 = node.getAdjacents().get(j);
                if (!auxNode2.getAdjacents().contains(auxNode1)) {
                    Edge auxArco = new Edge(auxNode1, auxNode2);
                    if (net.isCreateLog()) {
                        net.getLogManager().append(String.valueOf(auxNode1.getName()) + resource.getString("linkedName") + auxNode2.getName() + "\n");
                    }
                    net.getMarkovArcs().add(auxArco);
                    auxNode1.getAdjacents().add(auxNode2);
                    auxNode2.getAdjacents().add(auxNode1);
                }
                --j;
            }
            --i;
        }
        i = node.getAdjacents().size() - 1;
        while (i >= 0) {
            Node auxNo1 = node.getAdjacents().get(i);
            auxNo1.getAdjacents().remove(node);
            --i;
        }
        nodes.remove(node);
    }

    protected boolean isNeedingMoreArc(Node node, ProbabilisticNetwork net) {
        if (node.getAdjacents().size() < 2) {
            return false;
        }
        int i = node.getAdjacents().size() - 1;
        while (i > 0) {
            Node auxNo1 = node.getAdjacents().get(i);
            int j = i - 1;
            while (j >= 0) {
                Node auxNo2 = node.getAdjacents().get(j);
                if (!auxNo2.getAdjacents().contains(auxNo1)) {
                    return true;
                }
                --j;
            }
            --i;
        }
        return false;
    }

    protected void verifyConsistency(Graph net) {
        if (this.getVerifyConsistencyCommandList() != null) {
            for (IJunctionTreeCommand command : this.getVerifyConsistencyCommandList()) {
                command.doAction(this, net);
            }
        }
    }

    protected void verifyUtility(Graph graph) throws Exception {
        if (graph instanceof ProbabilisticNetwork) {
            ProbabilisticNetwork net = (ProbabilisticNetwork)graph;
            for (Node node : net.getNodes()) {
                if (node.getType() != 1 || node.getChildren().size() == 0) continue;
                throw new Exception(String.valueOf(resource.getString("variableName")) + node + resource.getString("hasChildName"));
            }
        }
    }

    @Override
    public void setNetwork(Graph g) throws IllegalArgumentException {
        this.setNet((ProbabilisticNetwork)g);
    }

    @Override
    public Graph getNetwork() {
        return this.getNet();
    }

    public ProbabilisticNetwork getNet() {
        return this.net;
    }

    public void setNet(ProbabilisticNetwork net) {
        this.net = net;
    }

    @Override
    public void reset() {
        for (IInferenceAlgorithmListener listener : this.getInferenceAlgorithmListeners()) {
            listener.onBeforeReset(this);
        }
        try {
            this.getNet().initialize();
            if (this.getMediator() != null) {
                float totalEstimateProb = this.getNet().PET();
                this.getMediator().getScreen().setStatus(JunctionTreeAlgorithm.getResource().getString("statusReady"));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        for (IInferenceAlgorithmListener listener : this.getInferenceAlgorithmListeners()) {
            listener.onAfterReset(this);
        }
    }

    @Override
    public void propagate() {
        this.propagate(null, true);
    }

    public void propagate(Clique rootOfSubtree, boolean isToUpdateMarginals) {
        for (IInferenceAlgorithmListener listener : this.getInferenceAlgorithmListeners()) {
            listener.onBeforePropagate(this);
        }
        try {
            if (rootOfSubtree != null) {
                this.getNet().updateEvidences(rootOfSubtree, isToUpdateMarginals);
            } else {
                this.getNet().updateEvidences();
            }
            if (this.getMediator() != null) {
                float totalEstimateProb = this.getNet().PET();
                this.getMediator().getScreen().setStatus(String.valueOf(JunctionTreeAlgorithm.getResource().getString("statusEvidenceProbabilistic")) + (double)totalEstimateProb * 100.0 + "%");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (IInferenceAlgorithmListener listener : this.getInferenceAlgorithmListeners()) {
            listener.onAfterPropagate(this);
        }
    }

    public INode addVirtualNode(Graph graph, List<INode> parentNodes) throws Exception {
        if (parentNodes == null || parentNodes.size() <= 0) {
            throw new IllegalArgumentException("parentNodes == null");
        }
        ProbabilisticNetwork net = this.getNet();
        if (net == null) {
            throw new IllegalStateException("Network == null");
        }
        if (net.isID()) {
            throw new IllegalArgumentException("Virtual nodes for influence diagrams not supported yet.");
        }
        float[] likelihood = this.getLikelihoodExtractor().extractLikelihoodRatio(graph, parentNodes.get(0));
        ((TreeVariable)parentNodes.get(0)).resetLikelihood();
        ProbabilisticNode virtualNode = new ProbabilisticNode();
        Point2D.Double position = ((Node)parentNodes.get(0)).getPosition();
        virtualNode.setPosition(position.getX() + (double)this.virtualNodePositionRandomness * Math.random(), position.getY() + (double)this.virtualNodePositionRandomness * Math.random());
        String newName = this.getVirtualNodePrefix();
        for (INode node : parentNodes) {
            newName = String.valueOf(newName) + node.getName();
        }
        if (likelihood.length <= parentNodes.get(0).getStatesSize()) {
            float[] fArray = likelihood;
            int n = likelihood.length;
            int n2 = 0;
            while (n2 < n) {
                float f = fArray[n2];
                newName = String.valueOf(newName) + "_" + f;
                ++n2;
            }
        }
        if (net.getNodeIndex(newName) >= 0) {
            int i = 1;
            while (i < Integer.MAX_VALUE) {
                if (net.getNodeIndex(String.valueOf(newName) + "_" + i) < 0) {
                    newName = String.valueOf(newName) + "_" + i;
                    break;
                }
                ++i;
            }
        }
        virtualNode.setName(newName);
        virtualNode.setInternalIdentificator(net.getNodeCount());
        virtualNode.appendState(JunctionTreeAlgorithm.getResource().getString("softEvidenceState"));
        virtualNode.appendState(JunctionTreeAlgorithm.getResource().getString("dummyState"));
        net.addNode(virtualNode);
        PotentialTable virtualNodeCPT = virtualNode.getProbabilityFunction();
        if (virtualNodeCPT.getVariablesSize() <= 0) {
            virtualNodeCPT.addVariable(virtualNode);
        }
        for (INode parentNode : parentNodes) {
            net.addEdge(new Edge((Node)parentNode, virtualNode));
        }
        try {
            int i = 0;
            while (i < virtualNodeCPT.tableSize() / 2) {
                virtualNodeCPT.setValue(2 * i, likelihood[i]);
                virtualNodeCPT.setValue(2 * i + 1, 1.0f - likelihood[i]);
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException(String.valueOf(JunctionTreeAlgorithm.getResource().getString("sizeOfLikelihoodException")) + JunctionTreeAlgorithm.getResource().getString("expectedSize") + virtualNodeCPT.tableSize() / 2, e);
        }
        virtualNode.initMarginalList();
        virtualNode.addFinding(0);
        Collection<IRandomVariable> sepAndCliqueSet = this.createCliqueAndSeparatorForVirtualNode(virtualNode, parentNodes, net);
        this.getVirtualNodesToCliquesAndSeparatorsMap().put(virtualNode, sepAndCliqueSet);
        return virtualNode;
    }

    protected Collection<IRandomVariable> createCliqueAndSeparatorForVirtualNode(ProbabilisticNode virtualNode, List<INode> parentNodes, SingleEntityNetwork net) {
        IJunctionTree junctionTree = net.getJunctionTree();
        int smallestSize = Integer.MAX_VALUE;
        Clique smallestCliqueContainingAllParents = null;
        for (Clique clique : junctionTree.getCliquesContainingAllNodes(parentNodes, Integer.MAX_VALUE)) {
            if (clique.getNodesList().contains(virtualNode) || clique.getProbabilityFunction().tableSize() >= smallestSize) continue;
            smallestCliqueContainingAllParents = clique;
            smallestSize = clique.getProbabilityFunction().tableSize();
        }
        if (smallestCliqueContainingAllParents == null) {
            throw new IllegalArgumentException(String.valueOf(JunctionTreeAlgorithm.getResource().getString("noCliqueForNodes")) + parentNodes);
        }
        ArrayList<INode> orderedParentNodes = new ArrayList<INode>(parentNodes.size());
        for (INode iNode : smallestCliqueContainingAllParents.getProbabilityFunction().variableList) {
            if (!parentNodes.contains(iNode)) continue;
            orderedParentNodes.add(iNode);
        }
        Clique clique = new Clique();
        clique.getNodesList().add(virtualNode);
        clique.getNodesList().addAll(orderedParentNodes);
        clique.getProbabilityFunction().addVariable(virtualNode);
        for (INode parentNode : orderedParentNodes) {
            clique.getProbabilityFunction().addVariable(parentNode);
        }
        clique.setInternalIdentificator(junctionTree.getCliques().size());
        junctionTree.getCliques().add(clique);
        Separator separatorOfVirtualCliqueAndParents = new Separator(smallestCliqueContainingAllParents, clique);
        separatorOfVirtualCliqueAndParents.setNodes(new ArrayList<Node>(orderedParentNodes));
        for (INode parentNode : orderedParentNodes) {
            separatorOfVirtualCliqueAndParents.getProbabilityFunction().addVariable(parentNode);
        }
        junctionTree.addSeparator(separatorOfVirtualCliqueAndParents);
        separatorOfVirtualCliqueAndParents.setInternalIdentificator(-(junctionTree.getSeparators().size() + 1));
        net.resetNodesCopy();
        clique.getAssociatedProbabilisticNodesList().add(virtualNode);
        virtualNode.setAssociatedClique(clique);
        net.getJunctionTree().initBelief(clique);
        net.getJunctionTree().initBelief(separatorOfVirtualCliqueAndParents);
        clique.getProbabilityFunction().copyData();
        separatorOfVirtualCliqueAndParents.getProbabilityFunction().copyData();
        HashSet<IRandomVariable> sepAndCliqueSet = new HashSet<IRandomVariable>();
        sepAndCliqueSet.add(clique);
        sepAndCliqueSet.add(separatorOfVirtualCliqueAndParents);
        return sepAndCliqueSet;
    }

    public void clearVirtualNodes() {
        for (INode virtualNode : this.getVirtualNodesToCliquesAndSeparatorsMap().keySet()) {
            this.getNet().removeNode((Node)virtualNode, false);
            if (this.getNet().getJunctionTree() == null) continue;
            ArrayList<Separator> separatorsToRemove = new ArrayList<Separator>(this.getVirtualNodesToCliquesAndSeparatorsMap().size() / 2);
            for (IRandomVariable cliqueOrSep : this.getVirtualNodesToCliquesAndSeparatorsMap().get(virtualNode)) {
                if (cliqueOrSep instanceof Clique) {
                    Clique clique = (Clique)cliqueOrSep;
                    if (clique.getParent() != null) {
                        int indexToRemove = 0;
                        for (Clique child : clique.getParent().getChildren()) {
                            if (child.getInternalIdentificator() == clique.getInternalIdentificator()) break;
                            ++indexToRemove;
                        }
                        clique.getParent().getChildren().remove(indexToRemove);
                    }
                    List<Clique> cliques = this.getNet().getJunctionTree().getCliques();
                    int indexToRemove = 0;
                    for (Clique cliqueToCompare : this.getNet().getJunctionTree().getCliques()) {
                        if (cliqueToCompare.getInternalIdentificator() == cliqueOrSep.getInternalIdentificator()) break;
                        ++indexToRemove;
                    }
                    cliques.remove(indexToRemove);
                    continue;
                }
                separatorsToRemove.add((Separator)cliqueOrSep);
            }
            for (Separator separator : separatorsToRemove) {
                this.getNet().getJunctionTree().removeSeparator(separator);
            }
        }
        this.getVirtualNodesToCliquesAndSeparatorsMap().clear();
    }

    public float getJointProbability(Map<ProbabilisticNode, Integer> nodesAndStatesToConsider) {
        List<Clique> cliques;
        if (nodesAndStatesToConsider == null || nodesAndStatesToConsider.isEmpty()) {
            throw new IllegalArgumentException("This method cannot calculate joint probability without specifying the nodes && states");
        }
        if (nodesAndStatesToConsider.size() == 1) {
            ProbabilisticNode node = nodesAndStatesToConsider.keySet().iterator().next();
            Integer state = nodesAndStatesToConsider.get(node);
            if (state < 0) {
                return 1.0f - node.getMarginalAt(Math.abs(state + 1));
            }
            return node.getMarginalAt(state);
        }
        if (this.isToCalculateJointProbabilityLocally() && (cliques = this.getNet().getJunctionTree().getCliquesContainingAllNodes(nodesAndStatesToConsider.keySet(), 1)) != null && !cliques.isEmpty()) {
            PotentialTable cliqueTable = (PotentialTable)cliques.get(0).getProbabilityFunction().clone();
            ArrayList<Node> nodesToMarginalizeOut = new ArrayList<Node>(cliques.get(0).getNodes());
            nodesToMarginalizeOut.removeAll(nodesAndStatesToConsider.keySet());
            for (Node node : nodesToMarginalizeOut) {
                cliqueTable.removeVariable(node);
            }
            int[] coordinate = new int[cliqueTable.getVariablesSize()];
            boolean hasNegativeState = false;
            for (ProbabilisticNode node : nodesAndStatesToConsider.keySet()) {
                int state = nodesAndStatesToConsider.get(node);
                if (state < 0) {
                    hasNegativeState = true;
                    break;
                }
                coordinate[cliqueTable.indexOfVariable((Node)node)] = state;
            }
            if (!hasNegativeState) {
                return cliqueTable.getValue(coordinate);
            }
            double sum = 0.0;
            int i = 0;
            while (i < cliqueTable.tableSize()) {
                coordinate = cliqueTable.getMultidimensionalCoord(i);
                boolean isExactMatch = true;
                for (ProbabilisticNode node : nodesAndStatesToConsider.keySet()) {
                    Integer state = nodesAndStatesToConsider.get(node);
                    if (state >= 0 && coordinate[cliqueTable.indexOfVariable(node)] != state) {
                        isExactMatch = false;
                        break;
                    }
                    if (state >= 0 || coordinate[cliqueTable.indexOfVariable(node)] != Math.abs(state + 1)) continue;
                    isExactMatch = false;
                    break;
                }
                if (isExactMatch) {
                    sum += (double)cliqueTable.getValue(i);
                }
                ++i;
            }
            return (float)sum;
        }
        ProbabilisticNetwork originalNetwork = this.getNet();
        ProbabilisticNetwork clonedNetwork = this.cloneProbabilisticNetwork(this.getNet());
        this.setNet(clonedNetwork);
        double ret = 1.0;
        try {
            for (ProbabilisticNode origNode : nodesAndStatesToConsider.keySet()) {
                Integer stateIndex = nodesAndStatesToConsider.get(origNode);
                if (stateIndex == null) continue;
                ProbabilisticNode clonedNode = (ProbabilisticNode)clonedNetwork.getNode(origNode.getName());
                if (stateIndex < 0) {
                    if (!this.isToUseEstimatedTotalProbability()) {
                        int i = 0;
                        while (i < clonedNode.getStatesSize()) {
                            if (i != Math.abs(stateIndex + 1)) {
                                ret *= (double)clonedNode.getMarginalAt(i);
                            }
                            ++i;
                        }
                    }
                    clonedNode.addFinding(Math.abs(stateIndex + 1), true);
                } else {
                    if (!this.isToUseEstimatedTotalProbability()) {
                        ret *= (double)clonedNode.getMarginalAt(stateIndex);
                    }
                    clonedNode.addFinding(stateIndex);
                }
                if (this.isToUseEstimatedTotalProbability()) continue;
                this.propagate();
            }
            if (this.isToUseEstimatedTotalProbability()) {
                this.propagate();
                ret = this.getJunctionTree().getN();
            }
        }
        catch (Throwable t) {
            this.setNet(originalNetwork);
            throw new RuntimeException(t.getMessage(), t);
        }
        this.setNet(originalNetwork);
        return (float)ret;
    }

    public boolean isUnspecifiedProb(Float value) {
        return value == null || Float.isInfinite(value.floatValue()) || Float.isNaN(value.floatValue()) || value.floatValue() < 0.0f || value.floatValue() > 1.0f;
    }

    public Integer getResolvedState(List<Float> prob) {
        if (prob == null || prob.isEmpty()) {
            throw new IllegalArgumentException("Could not verify whether the specified probability is a hard evidence, soft evidence, or ; \"negative\" hard evidence; because nothing was provided.");
        }
        float sum = 0.0f;
        boolean hasSpecifiedProb = false;
        boolean hasUnspecifiedProb = false;
        boolean hasSoftEvidence = false;
        boolean hasZeros = false;
        int index1stState0 = -1;
        int index1stState1 = -1;
        int i = 0;
        while (i < prob.size()) {
            Float value = prob.get(i);
            if (this.isUnspecifiedProb(value)) {
                hasUnspecifiedProb = true;
            } else {
                sum += value.floatValue();
                if (value.floatValue() > 5.0E-5f && value.floatValue() < 0.99995f) {
                    hasSoftEvidence = true;
                } else if (Math.abs(value.floatValue()) < 5.0E-5f) {
                    hasZeros = true;
                    if (index1stState0 < 0) {
                        index1stState0 = i;
                    }
                } else if (index1stState1 < 0) {
                    index1stState1 = i;
                }
                hasSpecifiedProb = true;
            }
            ++i;
        }
        if (!hasSpecifiedProb) {
            throw new IllegalArgumentException("No probability was explicited in the argument. Please specify the probabability of at least 1 state");
        }
        if (hasSoftEvidence) {
            if (Math.abs(1.0f - sum) > 5.0E-5f) {
                throw new IllegalArgumentException("The soft evidence " + prob + " does not seem to sum up to 1.");
            }
            if (hasUnspecifiedProb) {
                throw new IllegalArgumentException("In a soft evidence, all values must be explicitly specified.");
            }
            return null;
        }
        if (Math.abs(1.0f - sum) < 5.0E-5f) {
            if (index1stState1 < 0) {
                throw new RuntimeException(prob + " was detected to be a hard evidence, but no state settled to 1 was found.");
            }
            return index1stState1;
        }
        if (hasZeros) {
            if (index1stState0 < 0) {
                throw new RuntimeException(prob + " was detected to be a negative evidence, but no state settled to 0% was found.");
            }
            return -index1stState0 - 1;
        }
        throw new IllegalArgumentException("The specified list " + prob + ", is likely to be specifying a negative finding, but could not infer from it which state to set to 0%.");
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void setAsPermanentEvidence(Map<INode, List<Float>> evidences, boolean isToDeleteNode) {
        block35: {
            if (evidences == null || evidences.isEmpty()) {
                return;
            }
            hardEvidenceEntry = new HashMap<INode, List<Float>>();
            entriesToBeDeleted = new HashMap<INode, List<Float>>();
            nodesToResetEvidenceAtTheEnd = new ArrayList<ProbabilisticNode>(evidences.size());
            hasProbChange = false;
            for (Map.Entry<INode, List<Float>> entry : evidences.entrySet()) {
                node = entry.getKey();
                probNode = (ProbabilisticNode)this.getNet().getNode(node.getName());
                if (probNode == null) {
                    throw new IllegalArgumentException("Probabilistic node " + node + " was not found in probabilistic network.");
                }
                prob = evidences.get(node);
                if (prob == null) {
                    Debug.println(this.getClass(), "Evidence of node " + node + " was null");
                    entriesToBeDeleted.put(entry.getKey(), entry.getValue());
                    continue;
                }
                isNegativeHardEvidence = true;
                resolvedState = this.getResolvedState(prob);
                if (resolvedState == null) {
                    sum = 0.0f;
                    likelihood = new float[prob.size()];
                    i = 0;
                    while (i < prob.size()) {
                        value = prob.get(i);
                        if (this.isUnspecifiedProb(value)) {
                            value = Float.valueOf(0.0f);
                        }
                        sum += value.floatValue();
                        likelihood[i] = value.floatValue();
                        ++i;
                    }
                    if (Math.abs(sum - 1.0f) > 5.0E-5f) {
                        throw new IllegalArgumentException("Soft evidence of question " + node + " doesn't look normalized, because its sum was " + sum);
                    }
                    probNode.addLikeliHood(likelihood);
                    hasProbChange = true;
                    entriesToBeDeleted.put(entry.getKey(), entry.getValue());
                    nodesToResetEvidenceAtTheEnd.add(probNode);
                    continue;
                }
                if (resolvedState >= 0) {
                    isNegativeHardEvidence = false;
                    entriesToBeDeleted.put(entry.getKey(), entry.getValue());
                } else {
                    isNegativeHardEvidence = true;
                    resolvedState = -resolvedState.intValue() - 1;
                    nodesToResetEvidenceAtTheEnd.add(probNode);
                }
                i = 0;
                while (i < prob.size()) {
                    if (this.isUnspecifiedProb(prob.get(i))) {
                        prob.set(i, Float.valueOf(isNegativeHardEvidence != false ? 1.0f : 0.0f));
                    }
                    ++i;
                }
                probNode.addFinding(resolvedState, isNegativeHardEvidence);
                hasProbChange = true;
                newMarginalToSet = new float[prob.size()];
                i = 0;
                while (i < prob.size()) {
                    newMarginalToSet[i] = prob.get(i).floatValue();
                    ++i;
                }
                probNode.setMarginalProbabilities(newMarginalToSet);
                hardEvidenceEntry.put(entry.getKey(), entry.getValue());
            }
            if (hasProbChange) {
                try {
                    this.propagate();
                    break block35;
                }
                catch (RuntimeException e) {
                    ** for (node : this.getNet().getNodes())
                }
lbl-1000:
                // 1 sources

                {
                    if (!(node instanceof TreeVariable)) continue;
                    ((TreeVariable)node).resetEvidence();
                    continue;
                }
lbl78:
                // 1 sources

                throw e;
            }
        }
        if (isToDeleteNode) {
            for (INode node : entriesToBeDeleted.keySet()) {
                if (this.isToConnectParentsWhenAbsorbingNode()) {
                    i = 0;
                    while (i < node.getParentNodes().size() - 1) {
                        j = i + 1;
                        while (j < node.getParentNodes().size()) {
                            parent1 = (Node)node.getParentNodes().get(i);
                            parent2 = (Node)node.getParentNodes().get(j);
                            if (!parent1.getParents().contains(parent2) && !parent2.getParents().contains(parent1)) {
                                if (this.getMSeparationUtility().getRoutes((INode)parent1, parent2, null, null, 1).isEmpty()) {
                                    edge = new Edge(parent2, parent1);
                                    try {
                                        this.getNet().addEdge(edge);
                                    }
                                    catch (Exception e) {
                                        throw new RuntimeException("Could not add edge from " + parent2 + " to " + parent1 + " while absorbing " + node, e);
                                    }
                                    new NormalizeTableFunction().applyFunction((ProbabilisticTable)((ProbabilisticNode)parent1).getProbabilityFunction());
                                } else {
                                    edge = new Edge(parent1, parent2);
                                    try {
                                        this.getNet().addEdge(edge);
                                    }
                                    catch (Exception e) {
                                        throw new RuntimeException("Could not add edge from " + parent1 + " to " + parent2 + " while absorbing " + node, e);
                                    }
                                    new NormalizeTableFunction().applyFunction((ProbabilisticTable)((ProbabilisticNode)parent2).getProbabilityFunction());
                                }
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                this.getNet().removeNode((Node)node);
            }
            emptyCliques = new ArrayList<Clique>();
            for (Clique clique : this.getNet().getJunctionTree().getCliques()) {
                if (clique.getProbabilityFunction().tableSize() > 0) continue;
                clique.getProbabilityFunction().addVariable(JunctionTreeAlgorithm.ONE_STATE_PROBNODE);
                clique.getProbabilityFunction().setValue(0, 1.0f);
                emptyCliques.add(clique);
            }
            if (this.isToDeleteEmptyCliques() && !emptyCliques.isEmpty()) {
                jt = this.getNet().getJunctionTree();
                jt.removeCliques(emptyCliques);
            }
        }
        if (!isToDeleteNode) {
            for (Clique clique : this.getNet().getJunctionTree().getCliques()) {
                clique.getProbabilityFunction().copyData();
            }
            for (Separator sep : this.getNet().getJunctionTree().getSeparators()) {
                sep.getProbabilityFunction().copyData();
            }
        }
        for (INode node : nodesToResetEvidenceAtTheEnd) {
            node.resetEvidence();
        }
    }

    public InferenceAlgorithmOptionPanel getOptionPanel() {
        return this.optionPanel;
    }

    public void setOptionPanel(InferenceAlgorithmOptionPanel optionPanel) {
        this.optionPanel = optionPanel;
    }

    @Override
    public INetworkMediator getMediator() {
        if (this.getOptionPanel() != null) {
            return this.getOptionPanel().getMediator();
        }
        return null;
    }

    public static ResourceBundle getResource() {
        return generalResource;
    }

    public static void setResource(ResourceBundle resource) {
        generalResource = resource;
    }

    public IJunctionTree getJunctionTree() {
        return this.getNet().getJunctionTree();
    }

    public IJunctionTreeBuilder getJunctionTreeBuilder() {
        if (this.getNet() != null) {
            this.junctionTreeBuilder = this.getNet().getJunctionTreeBuilder();
        }
        return this.junctionTreeBuilder;
    }

    public void setJunctionTreeBuilder(IJunctionTreeBuilder junctionTreeBuilder) {
        this.junctionTreeBuilder = junctionTreeBuilder;
        if (this.getNet() != null) {
            this.getNet().setJunctionTreeBuilder(junctionTreeBuilder);
        }
    }

    public List<IJunctionTreeCommand> getVerifyConsistencyCommandList() {
        return this.verifyConsistencyCommandList;
    }

    public void setVerifyConsistencyCommandList(List<IJunctionTreeCommand> verifyConsistencyCommandList) {
        this.verifyConsistencyCommandList = verifyConsistencyCommandList;
    }

    public List<INode> getSortedDecisionNodes() {
        return this.sortedDecisionNodes;
    }

    public void setSortedDecisionNodes(List<INode> orderedDecisionNodes) {
        this.sortedDecisionNodes = orderedDecisionNodes;
    }

    @Override
    public void addInferencceAlgorithmListener(IInferenceAlgorithmListener listener) {
        this.getInferenceAlgorithmListeners().add(listener);
    }

    public List<IInferenceAlgorithmListener> getInferenceAlgorithmListeners() {
        return this.inferenceAlgorithmListeners;
    }

    public void setInferenceAlgorithmListeners(List<IInferenceAlgorithmListener> inferenceAlgorithmListeners) {
        this.inferenceAlgorithmListeners = inferenceAlgorithmListeners;
    }

    @Override
    public void removeInferencceAlgorithmListener(IInferenceAlgorithmListener listener) {
        if (listener == null) {
            if (this.getInferenceAlgorithmListeners() == null) {
                this.setInferenceAlgorithmListeners(new ArrayList<IInferenceAlgorithmListener>());
            } else {
                this.getInferenceAlgorithmListeners().clear();
            }
        } else if (this.getInferenceAlgorithmListeners() != null) {
            this.getInferenceAlgorithmListeners().remove(listener);
        }
    }

    @Override
    public void setMediator(INetworkMediator mediator) {
        if (!mediator.equals(this.getMediator())) {
            throw new IllegalArgumentException("Change the mediator from the option panel instead of from algorithm");
        }
    }

    public String getVirtualNodePrefix() {
        return this.virtualNodePrefix;
    }

    public void setVirtualNodePrefix(String virtualNodePrefix) {
        this.virtualNodePrefix = virtualNodePrefix;
    }

    public Map<INode, Collection<IRandomVariable>> getVirtualNodesToCliquesAndSeparatorsMap() {
        return this.virtualNodesToCliquesAndSeparatorsMap;
    }

    public void setVirtualNodesToCliquesAndSeparatorsMap(Map<INode, Collection<IRandomVariable>> virtualNodes) {
        this.virtualNodesToCliquesAndSeparatorsMap = virtualNodes;
    }

    public float getVirtualNodePositionRandomness() {
        return this.virtualNodePositionRandomness;
    }

    public void setVirtualNodePositionRandomness(float virtualNodePositionRandomness) {
        this.virtualNodePositionRandomness = virtualNodePositionRandomness;
    }

    public void setLikelihoodExtractor(ILikelihoodExtractor likelihoodExtractor) {
        this.likelihoodExtractor = likelihoodExtractor;
    }

    public ILikelihoodExtractor getLikelihoodExtractor() {
        return this.likelihoodExtractor;
    }

    public boolean isAlgorithmWithNormalization() {
        return true;
    }

    public ProbabilisticNetwork cloneProbabilisticNetwork(ProbabilisticNetwork originalProbabilisticNetwork) {
        return new ProbabilisticNetworkClone(this, originalProbabilisticNetwork);
    }

    public void setToCalculateJointProbabilityLocally(boolean isToCalculateJointProbabilityLocally) {
        this.isToCalculateJointProbabilityLocally = isToCalculateJointProbabilityLocally;
    }

    public boolean isToCalculateJointProbabilityLocally() {
        return this.isToCalculateJointProbabilityLocally;
    }

    public void setToUseEstimatedTotalProbability(boolean isToUseEstimatedTotalProbability) {
        this.isToUseEstimatedTotalProbability = isToUseEstimatedTotalProbability;
    }

    public boolean isToUseEstimatedTotalProbability() {
        return this.isToUseEstimatedTotalProbability;
    }

    public ProbabilisticNetwork updateCPTBasedOnCliques() {
        InCliqueConditionalProbabilityExtractor cptExtractor = (InCliqueConditionalProbabilityExtractor)InCliqueConditionalProbabilityExtractor.newInstance();
        cptExtractor.setToJoinCliquesWhenNoCliqueFound(true);
        NormalizeTableFunction normalizer = new NormalizeTableFunction();
        for (Node node : this.getNet().getNodes()) {
            if (!(node instanceof ProbabilisticNode)) continue;
            PotentialTable oldCPT = ((ProbabilisticNode)node).getProbabilityFunction();
            PotentialTable newCPT = (PotentialTable)cptExtractor.buildCondicionalProbability(node, oldCPT.variableList.subList(1, oldCPT.variableList.size()), this.getNet(), null);
            int indexOf1stCellOfColumn = 0;
            while (indexOf1stCellOfColumn < oldCPT.tableSize()) {
                boolean isImpossibleState = true;
                int stateIndex = 0;
                while (stateIndex < oldCPT.getVariableAt(0).getStatesSize()) {
                    if (newCPT.getValue(indexOf1stCellOfColumn + stateIndex) > 5.0E-5f) {
                        isImpossibleState = false;
                        break;
                    }
                    ++stateIndex;
                }
                int statesSize = oldCPT.getVariableAt(0).getStatesSize();
                if (isImpossibleState) {
                    float value = 1.0f / (float)statesSize;
                    int stateIndex2 = 0;
                    while (stateIndex2 < statesSize) {
                        oldCPT.setValue(indexOf1stCellOfColumn + stateIndex2, value);
                        ++stateIndex2;
                    }
                } else {
                    int stateIndex3 = 0;
                    while (stateIndex3 < statesSize) {
                        oldCPT.setValue(indexOf1stCellOfColumn + stateIndex3, newCPT.getValue(indexOf1stCellOfColumn + stateIndex3));
                        ++stateIndex3;
                    }
                }
                indexOf1stCellOfColumn += oldCPT.getVariableAt(0).getStatesSize();
            }
            normalizer.applyFunction((ProbabilisticTable)oldCPT);
        }
        return this.getNet();
    }

    public double getMutualInformation(ProbabilisticNode node1, ProbabilisticNode node2) {
        if (node1 == null || node2 == null) {
            return Double.NaN;
        }
        if (node1.equals(node2)) {
            return this.getEntropy(node1);
        }
        double ret = 0.0;
        HashMap<ProbabilisticNode, Integer> nodesAndStatesForJointProb = new HashMap<ProbabilisticNode, Integer>();
        int numStatesNode1 = node1.getStatesSize();
        int numStatesNode2 = node2.getStatesSize();
        int stateNode1 = 0;
        while (stateNode1 < numStatesNode1) {
            nodesAndStatesForJointProb.put(node1, stateNode1);
            int stateNode2 = 0;
            while (stateNode2 < numStatesNode2) {
                nodesAndStatesForJointProb.put(node2, stateNode2);
                float joint = this.getJointProbability(nodesAndStatesForJointProb);
                double factorCurrentState = (double)joint * (Math.log(joint) - Math.log(node1.getMarginalAt(stateNode1)) - Math.log(node2.getMarginalAt(stateNode2)));
                if (!Double.isNaN(factorCurrentState)) {
                    ret += factorCurrentState;
                }
                ++stateNode2;
            }
            ++stateNode1;
        }
        return Math.abs(ret);
    }

    public double getEntropy(ProbabilisticNode node) {
        if (node == null) {
            return Double.NaN;
        }
        double sum = 0.0;
        int numStates = node.getStatesSize();
        int state = 0;
        while (state < numStates) {
            float marginal = node.getMarginalAt(state);
            if (marginal > 0.0f) {
                sum += (double)marginal * Math.log(marginal);
            }
            ++state;
        }
        return -sum;
    }

    public boolean isToConnectParentsWhenAbsorbingNode() {
        return this.isToConnectParentsWhenAbsorbingNode;
    }

    public void setToConnectParentsWhenAbsorbingNode(boolean isToConnectParentsWhenAbsorbingNode) {
        this.isToConnectParentsWhenAbsorbingNode = isToConnectParentsWhenAbsorbingNode;
    }

    public MSeparationUtility getMSeparationUtility() {
        return this.mseparationUtility;
    }

    public void setMSeparationUtility(MSeparationUtility mseparationUtility) {
        this.mseparationUtility = mseparationUtility;
    }

    public boolean isToDeleteEmptyCliques() {
        return this.isToDeleteEmptyCliques;
    }

    public void setToDeleteEmptyCliques(boolean isToDeleteEmptyCliques) {
        this.isToDeleteEmptyCliques = isToDeleteEmptyCliques;
    }

    @Override
    public boolean isDecisionTotalOrderRequired() {
        return this.isDecisionTotalOrderRequired;
    }

    public void setDecisionTotalOrderRequired(boolean isDecisionTotalOrderRequired) {
        this.isDecisionTotalOrderRequired = isDecisionTotalOrderRequired;
    }

    public static interface IJunctionTreeCommand {
        public void doAction(IInferenceAlgorithm var1, Graph var2);

        public void undoAction(IInferenceAlgorithm var1, Graph var2) throws UndoableJTCommandException;
    }

    /*
     * Exception performing whole class analysis.
     */
    public class ProbabilisticNetworkClone
    extends ProbabilisticNetwork {
        private static final long serialVersionUID = 2863527797831091610L;
        private final ProbabilisticNetwork originalNet;
        final /* synthetic */ JunctionTreeAlgorithm this$0;

        /*
         * Unable to fully structure code
         */
        public ProbabilisticNetworkClone(JunctionTreeAlgorithm var1_1, ProbabilisticNetwork originalNet) {
            this.this$0 = var1_1;
            super(originalNet.getName());
            this.originalNet = originalNet;
            this.setCreateLog(originalNet.isCreateLog());
            for (Node node : originalNet.getNodes()) {
                if (!(node instanceof ProbabilisticNode)) {
                    Debug.println(this.getClass(), node + " is not a ProbabilisticNode and will not be copied.");
                    continue;
                }
                newNode = ((ProbabilisticNode)node).basicClone();
                if (newNode.getProbabilityFunction().getVariablesSize() <= 0) {
                    newNode.getProbabilityFunction().addVariable(newNode);
                }
                this.addNode(newNode);
            }
            for (Node node : originalNet.getNodes()) {
                if (!(node instanceof ProbabilisticNode)) {
                    Debug.println(this.getClass(), node + " is not a ProbabilisticNode and will not be copied.");
                    continue;
                }
                oldNode = (ProbabilisticNode)node;
                newNode = (ProbabilisticNode)this.getNode(oldNode.getName());
                i = 1;
                varSize = oldNode.getProbabilityFunction().getVariablesSize();
                while (i < varSize) {
                    newParent = this.getNode(oldNode.getProbabilityFunction().getVariableAt(i).getName());
                    newEdge = new Edge(newParent, newNode);
                    try {
                        this.addEdge(newEdge);
                    }
                    catch (InvalidParentException e) {
                        throw new RuntimeException("Could not clone edge from " + oldNode.getProbabilityFunction().getVariableAt(i) + " to " + oldNode + " of network " + originalNet, e);
                    }
                    ++i;
                }
            }
            for (Node node : originalNet.getNodes()) {
                if (!(node instanceof ProbabilisticNode)) continue;
                oldCPT = ((ProbabilisticNode)node).getProbabilityFunction();
                newCPT = ((ProbabilisticNode)this.getNode(node.getName())).getProbabilityFunction();
                newCPT.setValues(oldCPT.getValues());
            }
            this.setJunctionTreeBuilder(originalNet.getJunctionTreeBuilder());
            if (originalNet.getJunctionTree() != null) {
                try {
                    this.setJunctionTree(this.getJunctionTreeBuilder().buildJunctionTree(this));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            oldCliqueToNewCliqueMap = new HashMap<IRandomVariable, IRandomVariable>();
            if (originalNet.getJunctionTree() != null && originalNet.getJunctionTree().getCliques() != null) {
                for (Clique origClique : originalNet.getJunctionTree().getCliques()) {
                    newClique = origClique.clone(this);
                    this.getJunctionTree().getCliques().add(newClique);
                    oldCliqueToNewCliqueMap.put(origClique, newClique);
                }
            }
            if (originalNet.getJunctionTree() != null && originalNet.getJunctionTree().getSeparators() != null) {
                for (Separator origSeparator : originalNet.getJunctionTree().getSeparators()) {
                    hasInvalidNode = false;
                    newClique1 = (Clique)oldCliqueToNewCliqueMap.get(origSeparator.getClique1());
                    newClique2 = (Clique)oldCliqueToNewCliqueMap.get(origSeparator.getClique2());
                    if (newClique1 == null || newClique2 == null) {
                        try {
                            Debug.println(this.getClass(), "Could not clone separator between " + origSeparator.getClique1() + " and " + origSeparator.getClique2());
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                        continue;
                    }
                    newSeparator = new Separator(newClique1, newClique2);
                    newSeparator.setInternalIdentificator(origSeparator.getInternalIdentificator());
                    for (Node origNode : origSeparator.getNodes()) {
                        newNode = this.getNode(origNode.getName());
                        if (newNode == null) {
                            hasInvalidNode = true;
                            break;
                        }
                        newSeparator.getNodes().add(newNode);
                    }
                    if (hasInvalidNode) continue;
                    origPotential = origSeparator.getProbabilityFunction();
                    newPotential = newSeparator.getProbabilityFunction();
                    j = 0;
                    while (j < origPotential.getVariablesSize()) {
                        newNode = this.getNode(origPotential.getVariableAt(j).getName());
                        if (newNode == null) {
                            hasInvalidNode = true;
                            break;
                        }
                        newPotential.addVariable(newNode);
                        ++j;
                    }
                    if (hasInvalidNode) continue;
                    newPotential.setValues(origPotential.getValues());
                    this.getJunctionTree().addSeparator(newSeparator);
                    oldCliqueToNewCliqueMap.put(origSeparator, newSeparator);
                }
            }
            block18: for (Node origNode : originalNet.getNodes()) {
                newNode = (ProbabilisticNode)this.getNode(origNode.getName());
                if (newNode == null) {
                    try {
                        Debug.println(this.getClass(), "Could not find node copied from " + origNode);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    continue;
                }
                newNode.setAssociatedClique((IRandomVariable)oldCliqueToNewCliqueMap.get(((TreeVariable)origNode).getAssociatedClique()));
                newNode.initMarginalList();
                if (!(origNode instanceof TreeVariable)) continue;
                try {
                    newNode.setMarginalProbabilities(((TreeVariable)origNode).marginalList);
                    continue;
                }
                catch (Throwable e) {
                    statesSize = newNode.getStatesSize();
                    i = 0;
                    ** while (i < statesSize)
                }
lbl-1000:
                // 1 sources

                {
                    newNode.setMarginalAt(i, newNode.getMarginalAt(i));
                    ++i;
                    continue;
lbl117:
                    // 1 sources

                }
            }
        }

        public ProbabilisticNetwork getOriginalNet() {
            return this.originalNet;
        }

        public boolean equals(Object obj) {
            if (super.equals(obj)) {
                return true;
            }
            if (this.getOriginalNet().equals(obj)) {
                return true;
            }
            if (obj instanceof ProbabilisticNetworkClone) {
                ProbabilisticNetworkClone probabilisticNetworkClone = (ProbabilisticNetworkClone)obj;
                return this.getOriginalNet().equals(probabilisticNetworkClone.getOriginalNet());
            }
            return false;
        }
    }

    public class UndoableJTCommandException
    extends Exception {
        public UndoableJTCommandException() {
        }

        public UndoableJTCommandException(String message, Throwable cause) {
            super(message, cause);
        }

        public UndoableJTCommandException(String message) {
            super(message);
        }

        public UndoableJTCommandException(Throwable cause) {
            super(cause);
        }
    }
}

