/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.bn;

import java.util.ArrayList;
import java.util.List;
import unbbayes.prs.Node;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.util.SetToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LearningNode
extends ProbabilisticNode
implements Cloneable {
    private static final long serialVersionUID = 0L;
    private ArrayList<Node> predecessores;
    private LearningNode variavelAux;
    private int numeroMaximoPais;
    private int pos;
    private boolean rep;
    private boolean participa;

    public LearningNode(String nome, int pos) {
        this.setName(nome);
        this.predecessores = new ArrayList();
        this.numeroMaximoPais = 10;
        this.participa = true;
        this.pos = pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public void isRep(boolean rep) {
        this.rep = rep;
    }

    public boolean getRep() {
        return this.rep;
    }

    @Override
    public Object clone() {
        LearningNode variavel = new LearningNode(this.name, this.pos);
        variavel.setPais(SetToolkit.clone(this.parents));
        variavel.setEstados(SetToolkit.clone(this.states));
        variavel.setPredecessores(SetToolkit.clone(this.predecessores));
        variavel.setNumeroMaximoPais(this.numeroMaximoPais);
        return variavel;
    }

    public int getPos() {
        return this.pos;
    }

    public void setNumeroMaximoPais(int numero) {
        this.numeroMaximoPais = numero;
    }

    public int getNumeroMaximoPais() {
        return this.numeroMaximoPais;
    }

    public List<String> getEstados() {
        return this.states;
    }

    public ArrayList<Node> getPredecessores() {
        return this.predecessores;
    }

    public ArrayList<Node> getPais() {
        return this.parents;
    }

    public PotentialTable getProbabilidades() {
        return this.getProbabilityFunction();
    }

    public int getTamanhoPredecessores() {
        return this.predecessores.size();
    }

    public int getTamanhoPais() {
        if (this.parents == null) {
            this.parents = new ArrayList();
        }
        return this.parents.size();
    }

    public String getEstado(int index) {
        return (String)this.states.get(index);
    }

    public int getEstadoTamanho() {
        return this.states.size();
    }

    public void adicionaPredecessor(LearningNode predecessor) {
        this.predecessores.add(predecessor);
    }

    public void adicionaEstado(String estado) {
        this.states.add(estado);
    }

    public String getPai(String nome) {
        int i = 0;
        while (i < this.parents.size()) {
            this.variavelAux = (LearningNode)this.parents.get(i);
            if (this.variavelAux.getName().equals(nome)) {
                return nome;
            }
            if (this.variavelAux.getPai(nome).equals(nome)) {
                return nome;
            }
            ++i;
        }
        return "";
    }

    public void adicionaPai(LearningNode pai) {
        this.parents.add(pai);
    }

    public boolean existeEstado(String nomeEstado) {
        int tamanho = this.states.size();
        int tamanhoEstado = 0;
        while (tamanhoEstado < tamanho) {
            if (((String)this.states.get(tamanhoEstado)).equals(nomeEstado)) {
                return true;
            }
            ++tamanhoEstado;
        }
        return false;
    }

    public int getEstadoPosicao(String nomeEstado) {
        int tamanho = this.states.size();
        int tamanhoEstado = 0;
        while (tamanhoEstado < tamanho) {
            if (((String)this.states.get(tamanhoEstado)).equals(nomeEstado)) {
                return tamanhoEstado;
            }
            ++tamanhoEstado;
        }
        return 0;
    }

    public void setParticipa(boolean estado) {
        this.participa = estado;
    }

    public boolean getParticipa() {
        return this.participa;
    }

    private void setPais(Object parents) {
        this.parents = (ArrayList)parents;
    }

    private void setEstados(List<String> states) {
        this.states = states;
    }

    private void setPredecessores(Object predecessores) {
        this.predecessores = (ArrayList)predecessores;
    }
}

