/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.bn;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import unbbayes.prs.INode;
import unbbayes.prs.Node;
import unbbayes.prs.bn.IProbabilityFunction;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.bn.resources.BnResources;
import unbbayes.util.FloatCollection;
import unbbayes.util.ResourceController;
import unbbayes.util.SetToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PotentialTable
implements Cloneable,
Serializable,
IProbabilityFunction {
    public static final int PRODUCT_OPERATOR = 0;
    public static final int DIVISION_OPERATOR = 1;
    public static final int PLUS_OPERATOR = 2;
    public static final int MINUS_OPERATOR = 3;
    public static final ISumOperation DEFAULT_MARGINALIZATION_OP = new PotentialTable(){

        public void removeVariable(INode variable) {
        }

        public void removeVariable(INode variable, boolean normalize) {
        }

        public void purgeVariable(INode variable, boolean normalize) {
        }

        public PotentialTable newInstance() {
            return null;
        }

        public PotentialTable getTemporaryClone() {
            return null;
        }
    }.new SumOperation();
    private boolean modified = true;
    private static ResourceBundle resource = ResourceController.newInstance().getBundle(BnResources.class.getName());
    protected List<Node> variableList;
    protected FloatCollection dataPT = new FloatCollection();
    protected FloatCollection dataCopy = new FloatCollection();
    protected int[] factorsPT;
    protected int[] factorsMarginal;
    private ISumOperation sumOperation;
    private boolean[] isRemovedCellInDataPT = null;
    private static boolean[] singletonArrayOfRemovedCellInDataPT;
    private static boolean isToUseSingletonArrayOfRemovedCellInDataPT;

    static {
        isToUseSingletonArrayOfRemovedCellInDataPT = true;
    }

    public PotentialTable() {
        this.variableList = new ArrayList<Node>();
        this.setSumOperation(DEFAULT_MARGINALIZATION_OP);
    }

    public void copyData() {
        this.dataCopy.size = this.dataPT.size;
        if (this.dataCopy.data.length < this.dataPT.size) {
            this.dataCopy.data = new float[this.dataPT.size];
        }
        System.arraycopy(this.dataPT.data, 0, this.dataCopy.data, 0, this.dataPT.size);
    }

    public float getCopiedValue(int index) {
        return this.dataCopy.data[index];
    }

    public float getCopiedValue(int[] coordinate) {
        return this.dataCopy.data[this.getLinearCoord(coordinate)];
    }

    public void restoreData() {
        System.arraycopy(this.dataCopy.data, 0, this.dataPT.data, 0, this.dataPT.size);
    }

    @Override
    public void notifyModification() {
        this.modified = true;
    }

    public List<Node> cloneVariables() {
        return SetToolkit.clone(this.variableList);
    }

    public int indexOfVariable(Node node) {
        return this.variableList.indexOf(node);
    }

    public int indexOfVariable(String nodeName) {
        int i = 0;
        while (i < this.variableList.size()) {
            if (this.variableList.get(i).getName().equals(nodeName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int variableCount() {
        return this.variableList.size();
    }

    @Override
    public void setVariableAt(int index, INode node) {
        this.notifyModification();
        this.variableList.set(index, (Node)node);
    }

    @Override
    public INode getVariableAt(int index) {
        return this.variableList.get(index);
    }

    public int getVariableIndex(Node variable) {
        int i = 0;
        while (i < this.variableList.size()) {
            if (this.variableList.get(i).equals(variable)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void addValueAt(int index, float value) {
        this.dataPT.add(index, value);
    }

    public void removeValueAt(int index) {
        this.dataPT.remove(index);
    }

    public int tableSize() {
        return this.dataPT.size;
    }

    @Deprecated
    public void setTableSize(int size) {
        this.dataPT.size = size;
    }

    public Object clone() {
        PotentialTable auxTab = this.newInstance();
        auxTab.variableList = new ArrayList<Node>(this.variableList);
        auxTab.dataPT.size = this.dataPT.size;
        auxTab.dataPT.data = new float[this.dataPT.size];
        System.arraycopy(this.dataPT.data, 0, auxTab.dataPT.data, 0, this.dataPT.size);
        auxTab.setSumOperation(this.getSumOperation());
        return auxTab;
    }

    public abstract PotentialTable getTemporaryClone();

    public Object clone(ProbabilisticNode newNode) {
        PotentialTable auxTab = this.newInstance();
        auxTab.addVariable(newNode);
        for (Node node : newNode.getParents()) {
            auxTab.addVariable(node);
        }
        int sizeDados = this.dataPT.size;
        int c = 0;
        while (c < sizeDados) {
            auxTab.dataPT.add(this.dataPT.data[c]);
            ++c;
        }
        return auxTab;
    }

    public void setValue(int[] coord, float value) {
        this.dataPT.data[this.getLinearCoord((int[])coord)] = value;
    }

    public void setValue(int index, float value) {
        this.dataPT.data[index] = value;
    }

    public void setValues(float[] values) {
        this.dataPT.data = new float[values.length];
        System.arraycopy(values, 0, this.dataPT.data, 0, values.length);
    }

    public float getValue(int index) {
        return this.dataPT.data[index];
    }

    @Deprecated
    public float[] getValues() {
        return this.dataPT.data;
    }

    public float getValue(int[] coordinate) {
        return this.dataPT.data[this.getLinearCoord(coordinate)];
    }

    @Override
    public void addVariable(INode newVariable) {
        this.notifyModification();
        int numStatesOfNewVar = newVariable.getStatesSize();
        if (this.variableList.size() == 0) {
            this.dataPT.size = numStatesOfNewVar;
            this.dataPT.data = new float[numStatesOfNewVar];
            int i = 0;
            while (i < numStatesOfNewVar) {
                this.dataPT.data[i] = 0.0f;
                ++i;
            }
        } else {
            int newTableSize = numStatesOfNewVar * this.dataPT.size;
            int oldSize = this.dataPT.size;
            float[] oldValues = this.dataPT.data;
            this.dataPT.size = newTableSize;
            this.dataPT.data = new float[newTableSize];
            int i = 0;
            while (i < numStatesOfNewVar) {
                System.arraycopy(oldValues, 0, this.dataPT.data, i * oldSize, oldSize);
                ++i;
            }
        }
        this.variableList.add((Node)newVariable);
    }

    public void moveVariableWithoutMoveData(int initialPosition, int destinationPosition) {
        Node nodeToMove = this.variableList.remove(initialPosition);
        this.variableList.add(destinationPosition, nodeToMove);
    }

    public int getVariablesSize() {
        return this.variableList.size();
    }

    @Override
    public abstract void removeVariable(INode var1, boolean var2);

    @Override
    public abstract void purgeVariable(INode var1, boolean var2);

    @Override
    public abstract void removeVariable(INode var1);

    public abstract PotentialTable newInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void sum(int index) {
        block14: {
            block12: {
                block13: {
                    block10: {
                        block11: {
                            if (!PotentialTable.isToUseSingletonArrayOfRemovedCellInDataPT) break block10;
                            if (PotentialTable.singletonArrayOfRemovedCellInDataPT == null) {
                                var2_2 = PotentialTable.class;
                                // MONITORENTER : unbbayes.prs.bn.PotentialTable.class
                                if (PotentialTable.singletonArrayOfRemovedCellInDataPT == null) {
                                    PotentialTable.singletonArrayOfRemovedCellInDataPT = new boolean[this.dataPT.size];
                                }
                                // MONITOREXIT : var2_2
                            }
                            if (PotentialTable.singletonArrayOfRemovedCellInDataPT.length >= this.dataPT.size) break block11;
                            PotentialTable.singletonArrayOfRemovedCellInDataPT = new boolean[this.dataPT.size];
                            break block12;
                        }
                        i = 0;
                        if (true) ** GOTO lbl29
                    }
                    if (this.isRemovedCellInDataPT != null && this.isRemovedCellInDataPT.length >= this.dataPT.size) break block13;
                    this.isRemovedCellInDataPT = new boolean[this.dataPT.size];
                    break block14;
                }
                i = 0;
                if (true) ** GOTO lbl36
                do {
                    PotentialTable.singletonArrayOfRemovedCellInDataPT[i] = false;
                    ++i;
lbl29:
                    // 2 sources

                } while (i < PotentialTable.singletonArrayOfRemovedCellInDataPT.length);
            }
            this.isRemovedCellInDataPT = PotentialTable.singletonArrayOfRemovedCellInDataPT;
            break block14;
            do {
                this.isRemovedCellInDataPT[i] = false;
                ++i;
lbl36:
                // 2 sources

            } while (i < this.isRemovedCellInDataPT.length);
        }
        if (this.sumOperation == null) {
            this.sumOperation = PotentialTable.DEFAULT_MARGINALIZATION_OP;
        }
        this.sumAux(this.variableList.size() - 1, index, 0, 0, this.isRemovedCellInDataPT);
        j = 0;
        i = 0;
        while (i < this.dataPT.size) {
            if (!this.isRemovedCellInDataPT[i]) {
                this.dataPT.data[j++] = this.dataPT.data[i];
            }
            ++i;
        }
        this.dataPT.size = j;
    }

    private void sumAux(int control, int index, int coord, int base, boolean[] marked) {
        if (control == -1) {
            float value;
            int linearCoordDestination = coord - base;
            this.dataPT.data[linearCoordDestination] = value = this.sumOperation.operate(this.dataPT.data[linearCoordDestination], this.dataPT.data[coord]);
            marked[coord] = true;
            return;
        }
        int controlNodeStateSize = this.variableList.get(control).getStatesSize();
        int factorPTControl = this.factorsPT[control];
        if (control == index) {
            int factorPTIndex = this.factorsPT[index];
            int i = controlNodeStateSize - 1;
            while (i >= 1) {
                this.sumAux(control - 1, index, coord + i * factorPTControl, i * factorPTIndex, marked);
                --i;
            }
        } else {
            int i = controlNodeStateSize - 1;
            while (i >= 0) {
                this.sumAux(control - 1, index, coord + i * factorPTControl, base, marked);
                --i;
            }
        }
    }

    protected void finding(int control, int index, int[] coord, int state) {
        if (control == -1) {
            int linearCoordToKill = this.getLinearCoord(coord);
            if (coord[index] == state) {
                float value;
                int linearCoordDestination = linearCoordToKill - coord[index] * this.factorsPT[index];
                this.dataPT.data[linearCoordDestination] = value = this.dataPT.data[linearCoordToKill];
            }
            this.dataPT.remove(linearCoordToKill);
            return;
        }
        int fim = index == control ? 1 : 0;
        Node node = this.variableList.get(control);
        int i = node.getStatesSize() - 1;
        while (i >= fim) {
            coord[control] = i--;
            this.finding(control - 1, index, coord, state);
        }
    }

    public int getLinearCoord(int[] multidimensionalCoord) {
        this.computeFactors();
        int coordLinear = 0;
        int sizeVariaveis = this.variableList.size();
        int v = 0;
        while (v < sizeVariaveis) {
            coordLinear += multidimensionalCoord[v] * this.factorsPT[v];
            ++v;
        }
        return coordLinear;
    }

    protected void computeFactors() {
        if (!this.modified) {
            return;
        }
        this.modified = false;
        int sizeVariaveis = this.variableList.size();
        if (this.factorsPT == null || this.factorsPT.length < sizeVariaveis) {
            this.factorsPT = new int[sizeVariaveis];
        }
        this.factorsPT[0] = 1;
        int i = 1;
        while (i < sizeVariaveis) {
            Node auxNo = this.variableList.get(i - 1);
            this.factorsPT[i] = this.factorsPT[i - 1] * auxNo.getStatesSize();
            ++i;
        }
    }

    public int[] getMultidimensionalCoord(int linearCoord) {
        if (this.modified) {
            this.computeFactors();
        }
        int sizeVariaveis = this.variableList.size();
        int[] coord = new int[sizeVariaveis];
        int i = sizeVariaveis - 1;
        while (linearCoord != 0) {
            int fatorI = this.factorsPT[i];
            coord[i--] = linearCoord / fatorI;
            linearCoord %= fatorI;
        }
        return coord;
    }

    public int[] getMultidimensionalCoord(int linearCoord, int[] coord) {
        if (this.modified) {
            this.computeFactors();
        }
        int sizeVariaveis = this.variableList.size();
        int i = 0;
        while (i < coord.length) {
            coord[i] = 0;
            ++i;
        }
        i = sizeVariaveis - 1;
        while (linearCoord != 0) {
            int fatorI = this.factorsPT[i];
            coord[i--] = linearCoord / fatorI;
            linearCoord %= fatorI;
        }
        return coord;
    }

    @Deprecated
    public int getLinearCoordMarginal(int[] multidimensionalCoord) {
        this.computeFactorsMarginal();
        int coordLinear = 0;
        int sizeVariaveis = this.variableList.size();
        int v = 0;
        while (v < sizeVariaveis) {
            coordLinear += multidimensionalCoord[v] * this.factorsPT[v];
            ++v;
        }
        return coordLinear;
    }

    protected void computeFactorsMarginal() {
        if (!this.modified) {
            return;
        }
        this.modified = false;
        int sizeVariaveis = this.variableList.size();
        if (this.factorsPT == null || this.factorsPT.length < sizeVariaveis) {
            this.factorsPT = new int[sizeVariaveis];
        }
        this.factorsPT[0] = 1;
        int i = 1;
        while (i < sizeVariaveis) {
            Node auxNo = this.variableList.get(i - 1);
            this.factorsPT[i] = this.factorsPT[i - 1] * auxNo.getStatesSize();
            ++i;
        }
    }

    @Deprecated
    public int[] getMultidimensionalCoordMarginal(int linearCoord) {
        this.computeFactors();
        int sizeVariaveis = this.variableList.size();
        int[] coord = new int[sizeVariaveis];
        int i = sizeVariaveis - 1;
        while (linearCoord != 0) {
            int fatorI = this.factorsPT[i];
            coord[i--] = linearCoord / fatorI;
            linearCoord %= fatorI;
        }
        return coord;
    }

    public void directOpTab(PotentialTable tab, int operator) {
        if (this.tableSize() != tab.tableSize()) {
            throw new RuntimeException(String.valueOf(resource.getString("TableSizeException")) + ": " + this.tableSize() + " " + tab.tableSize());
        }
        switch (operator) {
            case 0: {
                int k = this.tableSize() - 1;
                while (k >= 0) {
                    int n = k;
                    this.dataPT.data[n] = this.dataPT.data[n] * tab.dataPT.data[k];
                    --k;
                }
                break;
            }
            case 1: {
                int k = this.tableSize() - 1;
                while (k >= 0) {
                    if (tab.dataPT.data[k] != 0.0f) {
                        int n = k;
                        this.dataPT.data[n] = this.dataPT.data[n] / tab.dataPT.data[k];
                    } else {
                        this.dataPT.data[k] = 0.0f;
                    }
                    --k;
                }
                break;
            }
            case 3: {
                int k = this.tableSize() - 1;
                while (k >= 0) {
                    int n = k;
                    this.dataPT.data[n] = this.dataPT.data[n] - tab.dataPT.data[k];
                    --k;
                }
                break;
            }
            case 2: {
                int k = this.tableSize() - 1;
                while (k >= 0) {
                    int n = k;
                    this.dataPT.data[n] = this.dataPT.data[n] + tab.dataPT.data[k];
                    --k;
                }
                break;
            }
        }
    }

    public void opTab(PotentialTable tab, int operator) {
        int[] index = new int[this.variableList.size()];
        int c = this.variableList.size() - 1;
        while (c >= 0) {
            index[c] = tab.variableList.indexOf(this.variableList.get(c));
            --c;
        }
        this.computeFactors();
        tab.computeFactors();
        switch (operator) {
            case 0: {
                this.fastOpTabProd(0, 0, 0, index, tab);
                break;
            }
            case 2: {
                this.fastOpTabPlus(0, 0, 0, index, tab);
                break;
            }
            case 1: {
                this.fastOpTabDiv(0, 0, 0, index, tab);
            }
        }
    }

    private void fastOpTabPlus(int c, int linearA, int linearB, int[] index, PotentialTable tab) {
        if (c >= this.variableList.size()) {
            int n = linearA;
            this.dataPT.data[n] = this.dataPT.data[n] + tab.dataPT.data[linearB];
            return;
        }
        int currentFactor = this.factorsPT[c];
        if (index[c] == -1) {
            int i = this.variableList.get(c).getStatesSize() - 1;
            while (i >= 0) {
                this.fastOpTabPlus(c + 1, linearA + i * currentFactor, linearB, index, tab);
                --i;
            }
        } else {
            int currentTableFactor = tab.factorsPT[index[c]];
            int i = this.variableList.get(c).getStatesSize() - 1;
            while (i >= 0) {
                this.fastOpTabPlus(c + 1, linearA + i * currentFactor, linearB + i * currentTableFactor, index, tab);
                --i;
            }
        }
    }

    private void fastOpTabProd(int c, int linearA, int linearB, int[] index, PotentialTable tab) {
        if (c >= this.variableList.size()) {
            int n = linearA;
            this.dataPT.data[n] = this.dataPT.data[n] * tab.dataPT.data[linearB];
            return;
        }
        if (index[c] == -1) {
            int i = this.variableList.get(c).getStatesSize() - 1;
            while (i >= 0) {
                this.fastOpTabProd(c + 1, linearA + i * this.factorsPT[c], linearB, index, tab);
                --i;
            }
        } else {
            int i = this.variableList.get(c).getStatesSize() - 1;
            while (i >= 0) {
                this.fastOpTabProd(c + 1, linearA + i * this.factorsPT[c], linearB + i * tab.factorsPT[index[c]], index, tab);
                --i;
            }
        }
    }

    private void fastOpTabDiv(int c, int linearA, int linearB, int[] index, PotentialTable tab) {
        if (c >= this.variableList.size()) {
            int n = linearA;
            this.dataPT.data[n] = this.dataPT.data[n] / tab.dataPT.data[linearB];
            return;
        }
        if (index[c] == -1) {
            int i = this.variableList.get(c).getStatesSize() - 1;
            while (i >= 0) {
                this.fastOpTabDiv(c + 1, linearA + i * this.factorsPT[c], linearB, index, tab);
                --i;
            }
        } else {
            int i = this.variableList.get(c).getStatesSize() - 1;
            while (i >= 0) {
                this.fastOpTabDiv(c + 1, linearA + i * this.factorsPT[c], linearB + i * tab.factorsPT[index[c]], index, tab);
                --i;
            }
        }
    }

    public void setSumOperation(ISumOperation sumOperation) {
        this.sumOperation = sumOperation;
    }

    public ISumOperation getSumOperation() {
        return this.sumOperation;
    }

    protected void updateRecursive(float[] marginalList, int c, int linear, int index, int state) {
        if (index < 0) {
            return;
        }
        if (c >= this.variableList.size()) {
            int n = linear;
            this.dataPT.data[n] = this.dataPT.data[n] * marginalList[state];
            return;
        }
        if (c == 0 && linear == 0 && state == 0) {
            state = this.variableList.get(index).getStatesSize();
            c = this.factorsPT[index];
            linear = 0;
            while (linear < this.dataPT.size) {
                int n = linear;
                this.dataPT.data[n] = this.dataPT.data[n] * marginalList[linear / c % state];
                ++linear;
            }
        } else {
            int currentFactor = this.factorsPT[c];
            if (index == c) {
                int i = this.variableList.get(c).getStatesSize() - 1;
                while (i >= 0) {
                    this.updateRecursive(marginalList, c + 1, linear + i * currentFactor, index, i);
                    --i;
                }
            } else {
                int i = this.variableList.get(c).getStatesSize() - 1;
                while (i >= 0) {
                    this.updateRecursive(marginalList, c + 1, linear + i * currentFactor, index, state);
                    --i;
                }
            }
        }
    }

    public void updateEvidences(float[] marginalList, int index) {
        this.computeFactors();
        int numStates = this.variableList.get(index).getStatesSize();
        int factor = this.factorsPT[index];
        int linear = 0;
        while (linear < this.dataPT.size) {
            int n = linear;
            this.dataPT.data[n] = this.dataPT.data[n] * marginalList[linear / factor % numStates];
            ++linear;
        }
    }

    public float normalize() {
        float n = 0.0f;
        int dataSize = this.tableSize();
        int c = 0;
        while (c < dataSize) {
            n += this.getValue(c);
            ++c;
        }
        if (Math.abs((double)n - 1.0) > 5.0E-5) {
            c = 0;
            while (c < dataSize) {
                float valor = this.getValue(c);
                if ((double)valor != 0.0) {
                    if ((double)n == 0.0) {
                        throw new IllegalStateException(resource.getString("InconsistencyUnderflowException"));
                    }
                    this.setValue(c, valor /= n);
                }
                ++c;
            }
        }
        return n;
    }

    public void fillTable(float value) {
        Arrays.fill(this.dataPT.data, 0, this.dataPT.size, value);
    }

    protected boolean isModified() {
        return this.modified;
    }

    protected void setModified(boolean modified) {
        this.modified = modified;
    }

    protected boolean[] isRemovedCellInDataPT() {
        return this.isRemovedCellInDataPT;
    }

    protected void setRemovedCellInDataPT(boolean[] isRemovedCellInDataPT) {
        this.isRemovedCellInDataPT = isRemovedCellInDataPT;
    }

    public static boolean isToUseSingletonArrayOfRemovedCellInDataPT() {
        return isToUseSingletonArrayOfRemovedCellInDataPT;
    }

    public static void setToUseSingletonArrayOfRemovedCellInDataPT(boolean isToUseSingletonArrayOfRemovedCellInDataPT) {
        PotentialTable.isToUseSingletonArrayOfRemovedCellInDataPT = isToUseSingletonArrayOfRemovedCellInDataPT;
    }

    public double getMutualInformation(int indexNode1, int indexNode2) {
        if (indexNode1 < 0 || indexNode1 >= this.getVariablesSize()) {
            throw new ArrayIndexOutOfBoundsException(indexNode1);
        }
        if (indexNode2 < 0 || indexNode2 >= this.getVariablesSize()) {
            throw new ArrayIndexOutOfBoundsException(indexNode2);
        }
        if (indexNode1 == indexNode2) {
            return this.getEntropy(indexNode1);
        }
        INode node1 = this.getVariableAt(indexNode1);
        if (node1 == null) {
            throw new NullPointerException("Found null node at index " + indexNode1);
        }
        INode node2 = this.getVariableAt(indexNode2);
        if (node2 == null) {
            throw new NullPointerException("Found null node at index " + indexNode2);
        }
        double ret = 0.0;
        PotentialTable marginal1 = (PotentialTable)this.clone();
        marginal1.retainVariables(Collections.singletonList(node1));
        PotentialTable marginal2 = (PotentialTable)this.clone();
        marginal2.retainVariables(Collections.singletonList(node2));
        PotentialTable joint = (PotentialTable)this.clone();
        ArrayList<INode> nodes = new ArrayList<INode>(2);
        nodes.add(node1);
        nodes.add(node2);
        joint.retainVariables(nodes);
        if (joint.getVariablesSize() != nodes.size()) {
            throw new RuntimeException("Retaining nodes " + nodes + "from table " + this + " resulted in a table with size " + joint.getVariablesSize());
        }
        marginal1.normalize();
        marginal2.normalize();
        joint.normalize();
        int[] coord = joint.getMultidimensionalCoord(0);
        int stateNode1 = 0;
        while (stateNode1 < marginal1.tableSize()) {
            coord[joint.indexOfVariable((Node)((Node)node1))] = stateNode1;
            int stateNode2 = 0;
            while (stateNode2 < marginal2.tableSize()) {
                coord[joint.indexOfVariable((Node)((Node)node2))] = stateNode2;
                float jointProb = joint.getValue(coord);
                double factorCurrentState = (double)jointProb * (Math.log(jointProb) - Math.log(marginal1.getValue(stateNode1)) - Math.log(marginal2.getValue(stateNode2)));
                if (!Double.isNaN(factorCurrentState)) {
                    ret += factorCurrentState;
                }
                ++stateNode2;
            }
            ++stateNode1;
        }
        return Math.abs(ret);
    }

    public double getEntropy(int nodeIndex) {
        if (nodeIndex < 0 || nodeIndex >= this.getVariablesSize()) {
            throw new ArrayIndexOutOfBoundsException(nodeIndex);
        }
        double sum = 0.0;
        INode node = this.getVariableAt(nodeIndex);
        if (node == null) {
            throw new IllegalArgumentException("Found null at index " + nodeIndex);
        }
        PotentialTable marginalTable = this.getTemporaryClone();
        marginalTable.retainVariables(Collections.singletonList(node));
        marginalTable.normalize();
        if (marginalTable.tableSize() != node.getStatesSize()) {
            throw new RuntimeException("Marginalized table " + marginalTable + " has size " + marginalTable.tableSize() + ", but number of states of node " + node + " was " + node.getStatesSize());
        }
        int state = 0;
        while (state < marginalTable.tableSize()) {
            float marginal = marginalTable.getValue(state);
            if (marginal > 0.0f) {
                sum += (double)marginal * Math.log(marginal);
            }
            ++state;
        }
        return -sum;
    }

    public void retainVariables(Collection<INode> nodes) {
        if (nodes == null) {
            nodes = Collections.EMPTY_LIST;
        }
        ArrayList<INode> nodesToRemove = new ArrayList<INode>(this.getVariablesSize());
        int i = 0;
        while (i < this.getVariablesSize()) {
            INode nodeToRemove = this.getVariableAt(i);
            if (!nodes.contains(nodeToRemove)) {
                nodesToRemove.add(nodeToRemove);
            }
            ++i;
        }
        for (INode nodeToRemove : nodesToRemove) {
            this.removeVariable(nodeToRemove, false);
        }
    }

    public double getSum() {
        float sum = 0.0f;
        int i = 0;
        while (i < this.tableSize()) {
            sum += this.getValue(i);
            ++i;
        }
        return sum;
    }

    public double getKLDivergence(PotentialTable q) {
        if (this.tableSize() == 0 && q.tableSize() == 0) {
            return 0.0;
        }
        if (q == null || this.tableSize() != q.tableSize()) {
            return Double.POSITIVE_INFINITY;
        }
        double sum = 0.0;
        int i = 0;
        while (i < this.tableSize()) {
            if (this.getValue(i) > 0.0f) {
                sum += (double)this.getValue(i) * Math.log(this.getValue(i) / q.getValue(i));
            }
            ++i;
        }
        return sum;
    }

    public static interface ISumOperation {
        public float operate(float var1, float var2);
    }

    public class MaxOperation
    implements ISumOperation {
        public float operate(float arg1, float arg2) {
            return arg1 > arg2 ? arg1 : arg2;
        }
    }

    public class SumOperation
    implements ISumOperation {
        public float operate(float arg1, float arg2) {
            return arg1 + arg2;
        }
    }
}

