/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.bn;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.ResourceBundle;
import unbbayes.prs.INode;
import unbbayes.prs.Node;
import unbbayes.prs.bn.IProbabilityFunction;
import unbbayes.prs.bn.IRandomVariable;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticTable;
import unbbayes.prs.bn.TreeVariable;
import unbbayes.prs.bn.cpt.IProbabilityFunctionAdapter;
import unbbayes.prs.bn.resources.BnResources;
import unbbayes.util.Debug;
import unbbayes.util.ResourceController;
import unbbayes.util.SetToolkit;

public class ProbabilisticNode
extends TreeVariable
implements IRandomVariable,
IProbabilityFunctionAdapter,
Serializable {
    private static final long serialVersionUID = -8362313890037632119L;
    private ProbabilisticTable tabelaPot;
    private static Color descriptionColor = Color.yellow;
    private static Color explanationColor = Color.green;
    private static ResourceBundle resource = ResourceController.newInstance().getBundle(BnResources.class.getName());
    private int internalIdentificator = Integer.MIN_VALUE;

    public ProbabilisticNode() {
        this.tabelaPot = new ProbabilisticTable();
        this.setColor(descriptionColor);
    }

    public int getType() {
        return 0;
    }

    public ProbabilisticNode clone(double radius) {
        ProbabilisticNode no = new ProbabilisticNode();
        int i = 0;
        while (i < this.getStatesSize()) {
            no.appendState(this.getStateAt(i));
            ++i;
        }
        ProbabilisticNode.setDescriptionColor(ProbabilisticNode.getDescriptionColor().getRGB());
        ProbabilisticNode.setExplanationColor(ProbabilisticNode.getExplanationColor().getRGB());
        no.setPosition(this.getPosition().getX() + 1.3 * radius, this.getPosition().getY() + 1.3 * radius);
        no.setName(String.valueOf(resource.getString("copyName")) + this.getName());
        no.setDescription(String.valueOf(resource.getString("copyName")) + this.getDescription());
        no.tabelaPot = (ProbabilisticTable)this.tabelaPot.clone();
        return no;
    }

    public ProbabilisticNode getClone() {
        ProbabilisticNode clone = new ProbabilisticNode();
        super.clone(clone);
        clone.tabelaPot = (ProbabilisticTable)this.tabelaPot.clone();
        return clone;
    }

    public Object clone() {
        ProbabilisticNode cloned = new ProbabilisticNode();
        cloned.tabelaPot = (ProbabilisticTable)this.tabelaPot.clone();
        ProbabilisticNode.setDescriptionColor(ProbabilisticNode.getDescriptionColor().getRGB());
        ProbabilisticNode.setExplanationColor(ProbabilisticNode.getExplanationColor().getRGB());
        cloned.setDescription(this.getDescription());
        cloned.setName(this.getName());
        cloned.setPosition(this.getPosition().getX(), this.getPosition().getY());
        cloned.setParents(SetToolkit.clone(this.parents));
        cloned.setChildren(SetToolkit.clone(this.getChildren()));
        cloned.setStates(SetToolkit.clone(this.states));
        cloned.setAdjacents(SetToolkit.clone(this.getAdjacents()));
        cloned.setSelected(this.isSelected());
        cloned.setExplanationDescription(this.getExplanationDescription());
        cloned.setPhrasesMap(this.getPhrasesMap());
        cloned.setInformationType(this.getInformationType());
        if (this.isMarginalList()) {
            float[] marginais = new float[this.marginalList.length];
            System.arraycopy(this.marginalList, 0, marginais, 0, marginais.length);
            cloned.marginalList = marginais;
            cloned.setInternalIdentificator(this.getInternalIdentificator());
        }
        return cloned;
    }

    public ProbabilisticNode basicClone() {
        ProbabilisticNode cloned = new ProbabilisticNode();
        cloned.setDescription(this.getDescription());
        cloned.setName(this.getName());
        cloned.setStates(SetToolkit.clone(this.states));
        if (this.marginalList != null) {
            float[] marginais = new float[this.marginalList.length];
            System.arraycopy(this.marginalList, 0, marginais, 0, marginais.length);
            cloned.marginalList = marginais;
            cloned.copyMarginal();
        }
        if (this.hasEvidence()) {
            cloned.addFinding(this.getEvidence());
        }
        cloned.setInternalIdentificator(this.getInternalIdentificator());
        return cloned;
    }

    public PotentialTable getProbabilityFunction() {
        return this.tabelaPot;
    }

    protected void marginal() {
        this.initMarginalList();
        if (this.cliqueAssociado == null) {
            try {
                Debug.println(this.getClass(), "Attempted to calculate marginal probability of node " + this + " from a junction tree, but junction tree was not properly initialized.");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return;
        }
        PotentialTable auxTab = ((PotentialTable)this.cliqueAssociado.getProbabilityFunction()).getTemporaryClone();
        int index = auxTab.indexOfVariable(this);
        int size = this.cliqueAssociado.getProbabilityFunction().variableCount();
        int i = 0;
        while (i < size) {
            if (i != index) {
                auxTab.removeVariable(this.cliqueAssociado.getProbabilityFunction().getVariableAt(i));
            }
            ++i;
        }
        int tableSize = auxTab.tableSize();
        if (this.marginalList.length <= 0 && tableSize > 0) {
            throw new IllegalStateException("Inconsistent quantity of marginal states. This may be caused by a node which cannot be handled by the selected algorithm.");
        }
        int i2 = 0;
        while (i2 < tableSize) {
            this.marginalList[i2] = auxTab.getValue(i2);
            ++i2;
        }
    }

    public void appendState(String state) {
        this.updateState(state, true);
    }

    public void removeAllStates() {
        while (this.states.size() > 1) {
            this.removeLastState();
        }
    }

    public void removeLastState() {
        if (this.states.size() > 1) {
            this.updateState(null, false);
        }
    }

    private void updateState(String state, boolean isInsertion) {
        int k;
        ArrayList auxList;
        IProbabilityFunction auxTab;
        int d = this.getStatesSize();
        if (d > 0) {
            while (d <= this.tabelaPot.tableSize()) {
                if (isInsertion) {
                    this.tabelaPot.addValueAt(d++, 0.0f);
                } else {
                    this.tabelaPot.removeValueAt(--d);
                }
                d += this.getStatesSize();
            }
        } else if (isInsertion && d == 0) {
            this.tabelaPot.addValueAt(d++, 0.0f);
        }
        ArrayList[] clones = new ArrayList[this.getChildren().size()];
        int[] indexes = new int[this.getChildren().size()];
        int i = 0;
        while (i < this.getChildren().size()) {
            if (this.getChildren().get(i).getType() != 2 && this.getChildren().get(i).getType() != 5) {
                IRandomVariable randomVar = (IRandomVariable)((Object)this.getChildren().get(i));
                PotentialTable auxTab2 = (PotentialTable)randomVar.getProbabilityFunction();
                clones[i] = auxTab2.cloneVariables();
                indexes[i] = auxTab2.indexOfVariable(this);
            }
            ++i;
        }
        i = 0;
        while (i < this.getChildren().size()) {
            if (this.getChildren().get(i).getType() != 2 && this.getChildren().get(i).getType() != 5) {
                auxTab = (PotentialTable)((IRandomVariable)((Object)this.getChildren().get(i))).getProbabilityFunction();
                int l = indexes[i];
                auxList = clones[i];
                k = auxList.size() - 1;
                while (k >= l) {
                    Node node = (Node)auxList.get(k);
                    ((PotentialTable)auxTab).removeVariable(node, true);
                    --k;
                }
            }
            ++i;
        }
        if (isInsertion) {
            super.appendState(state);
        } else {
            super.removeLastState();
        }
        i = 0;
        while (i < this.getChildren().size()) {
            if (this.getChildren().get(i).getType() != 2 && this.getChildren().get(i).getType() != 5) {
                auxTab = ((IRandomVariable)((Object)this.getChildren().get(i))).getProbabilityFunction();
                int l = indexes[i];
                auxList = clones[i];
                k = l;
                while (k < auxList.size()) {
                    auxTab.addVariable((INode)auxList.get(k));
                    ++k;
                }
            }
            ++i;
        }
    }

    public static Color getDescriptionColor() {
        return descriptionColor;
    }

    public static void setDescriptionColor(int c) {
        descriptionColor = new Color(c);
    }

    public static void setExplanationColor(int c) {
        explanationColor = new Color(c);
    }

    public static Color getExplanationColor() {
        return explanationColor;
    }

    public int getInternalIdentificator() {
        return this.internalIdentificator;
    }

    public void setInternalIdentificator(int internalIdentificator) {
        this.internalIdentificator = internalIdentificator;
    }

    public void removeStates() {
        while (this.states.size() > 0) {
            this.removeStateAt(0);
        }
    }

    public void removeStateAt(int index) {
        while (this.getStatesSize() > index) {
            this.updateState(null, false);
            this.states.remove(index);
        }
    }

    public void loadProbabilityFunction(IProbabilityFunction probabilityFunction) {
        if (probabilityFunction instanceof PotentialTable) {
            PotentialTable cpt = ((PotentialTable)probabilityFunction).getTemporaryClone();
            PotentialTable myCPT = this.getProbabilityFunction();
            if (this.equals(cpt.getVariableAt(0))) {
                int i = 0;
                while (i < cpt.getVariablesSize()) {
                    Node var = (Node)cpt.getVariableAt(i);
                    if (this.getProbabilityFunction().getVariableIndex(var) < 0) {
                        cpt.removeVariable(var, true);
                        --i;
                    }
                    ++i;
                }
                if (cpt.tableSize() == myCPT.tableSize()) {
                    myCPT.setValues(cpt.getValues());
                } else {
                    i = 0;
                    while (i < myCPT.tableSize()) {
                        myCPT.setValue(i, 1.0f);
                        ++i;
                    }
                    myCPT.opTab(cpt, 0);
                }
            } else {
                System.arraycopy(cpt.getValues(), 0, myCPT.dataPT.data, 0, myCPT.tableSize());
            }
        }
    }
}

