/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.bn;

import java.io.Serializable;
import java.util.ResourceBundle;
import unbbayes.prs.INode;
import unbbayes.prs.Node;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.resources.BnResources;
import unbbayes.prs.id.DecisionNode;
import unbbayes.util.ResourceController;

public class ProbabilisticTable
extends PotentialTable
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static ResourceBundle resource = ResourceController.newInstance().getBundle(BnResources.class.getName());
    private static PotentialTable temporarySingletonClone1 = null;
    private static PotentialTable temporarySingletonClone2 = null;
    private static boolean temporarySingletonCloneSwitch = true;
    private static boolean isToUseSingletonInstanceAsTemporaryClone = true;

    public void removeVariable(INode variavel) {
        this.computeFactors();
        int index = this.variableList.indexOf(variavel);
        if (variavel.getType() == 2) {
            DecisionNode decision = (DecisionNode)variavel;
            int statesSize = variavel.getStatesSize();
            if (decision.hasEvidence()) {
                this.finding(this.variableList.size() - 1, index, new int[this.variableList.size()], decision.getEvidence());
            } else {
                this.sum(index);
                int i = this.dataPT.size - 1;
                while (i >= 0) {
                    this.dataPT.data[i] = this.dataPT.data[i] / (float)statesSize;
                    --i;
                }
            }
        } else {
            this.sum(index);
        }
        this.notifyModification();
        this.variableList.remove(index);
    }

    public void removeVariable(INode variable, boolean normalize) {
        int index = this.variableList.indexOf(variable);
        if (index < 0) {
            return;
        }
        this.computeFactors();
        if (variable.getType() == 2) {
            DecisionNode decision = (DecisionNode)variable;
            int statesSize = variable.getStatesSize();
            if (decision.hasEvidence()) {
                this.finding(this.variableList.size() - 1, index, new int[this.variableList.size()], decision.getEvidence());
            } else {
                this.sum(index);
                if (normalize) {
                    int i = this.dataPT.size - 1;
                    while (i >= 0) {
                        this.dataPT.data[i] = this.dataPT.data[i] / (float)statesSize;
                        --i;
                    }
                }
            }
        } else if (this.variableList.size() <= 1) {
            this.dataPT.size = 0;
        } else {
            this.sum(index);
            if (normalize) {
                int statesSize = variable.getStatesSize();
                int i = this.dataPT.size - 1;
                while (i >= 0) {
                    this.dataPT.data[i] = this.dataPT.data[i] / (float)statesSize;
                    --i;
                }
            }
        }
        this.notifyModification();
        this.variableList.remove(index);
    }

    public void verifyConsistency() throws Exception {
        Node currentNode = (Node)this.variableList.get(0);
        int numerOfLinesInCPT = currentNode.getStatesSize();
        if (numerOfLinesInCPT == 0) {
            return;
        }
        int numberOfColumnsInCPT = 1;
        int numberOfVariables = this.variableList.size();
        int k = 1;
        while (k < numberOfVariables) {
            currentNode = (Node)this.variableList.get(k);
            numberOfColumnsInCPT *= currentNode.getStatesSize();
            ++k;
        }
        int j = 0;
        while (j < numberOfColumnsInCPT) {
            float sum = 0.0f;
            int i = 0;
            while (i < numerOfLinesInCPT) {
                sum += this.dataPT.data[j * numerOfLinesInCPT + i] * 100.0f;
                ++i;
            }
            if (Math.abs((double)sum - 100.0) > 0.01) {
                throw new Exception(String.valueOf(resource.getString("variableTableName")) + this.variableList.get(0) + resource.getString("inconsistencyName") + sum + "%\n");
            }
            ++j;
        }
    }

    public PotentialTable newInstance() {
        return new ProbabilisticTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public PotentialTable getTemporaryClone() {
        PotentialTable auxTab;
        if (!isToUseSingletonInstanceAsTemporaryClone) return (PotentialTable)this.clone();
        if (temporarySingletonCloneSwitch) {
            if (temporarySingletonClone1 == null) {
                Class<PotentialTable> clazz = PotentialTable.class;
                // MONITORENTER : unbbayes.prs.bn.PotentialTable.class
                if (temporarySingletonClone1 == null) {
                    temporarySingletonClone1 = this.newInstance();
                }
                // MONITOREXIT : clazz
            }
            auxTab = temporarySingletonClone1;
        } else {
            if (temporarySingletonClone2 == null) {
                Class<PotentialTable> clazz = PotentialTable.class;
                // MONITORENTER : unbbayes.prs.bn.PotentialTable.class
                if (temporarySingletonClone2 == null) {
                    temporarySingletonClone2 = this.newInstance();
                }
                // MONITOREXIT : clazz
            }
            auxTab = temporarySingletonClone2;
        }
        temporarySingletonCloneSwitch = !temporarySingletonCloneSwitch;
        auxTab.variableList.clear();
        auxTab.variableList.addAll(this.variableList);
        auxTab.dataPT.size = this.dataPT.size;
        if (auxTab.dataPT.data.length < this.dataPT.size) {
            auxTab.dataPT.data = new float[this.dataPT.size];
        }
        System.arraycopy(this.dataPT.data, 0, auxTab.dataPT.data, 0, this.dataPT.size);
        if (this.factorsPT != null) {
            if (auxTab.factorsPT == null || auxTab.factorsPT.length < this.factorsPT.length) {
                auxTab.factorsPT = new int[this.factorsPT.length];
            }
            System.arraycopy(this.factorsPT, 0, auxTab.factorsPT, 0, this.factorsPT.length);
        }
        auxTab.notifyModification();
        auxTab.setSumOperation(this.getSumOperation());
        return auxTab;
    }

    public String toString() {
        return this.variableList + "@" + super.toString();
    }

    public void purgeVariable(INode variable, boolean normalize) {
        this.removeVariable(variable, normalize);
        float[] aux = this.dataPT.data;
        this.dataPT.data = new float[this.dataPT.size];
        System.arraycopy(aux, 0, this.dataPT.data, 0, this.dataPT.size);
    }

    public static boolean isToUseSingletonInstanceAsTemporaryClone() {
        return isToUseSingletonInstanceAsTemporaryClone;
    }

    public static void setToUseSingletonInstanceAsTemporaryClone(boolean isToUseSingletonInstanceAsTemporaryClone) {
        ProbabilisticTable.isToUseSingletonInstanceAsTemporaryClone = isToUseSingletonInstanceAsTemporaryClone;
    }
}

