/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.bn;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import unbbayes.prs.Edge;
import unbbayes.prs.INode;
import unbbayes.prs.Node;
import unbbayes.prs.bn.Clique;
import unbbayes.prs.bn.IRandomVariable;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticTable;
import unbbayes.prs.id.UtilityTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Separator
implements IRandomVariable,
Serializable {
    private static final long serialVersionUID = 0L;
    private PotentialTable tabelaPot;
    private int internalIdentificator = Integer.MIN_VALUE;
    private PotentialTable utilityTable;
    private List<Node> nodes = new ArrayList<Node>(1);
    private Clique clique1;
    private Clique clique2;

    private Separator() {
        this.tabelaPot = new ProbabilisticTable();
        this.utilityTable = new UtilityTable();
    }

    public Separator(Clique clique1, Clique clique2) {
        this(clique1, clique2, new ProbabilisticTable(), new UtilityTable(), true);
    }

    public Separator(Clique clique1, Clique clique2, boolean updateCliques) {
        this(clique1, clique2, new ProbabilisticTable(), new UtilityTable(), updateCliques);
    }

    public Separator(Clique clique1, Clique clique2, PotentialTable table) {
        this(clique1, clique2, table, new UtilityTable(), true);
    }

    public Separator(Clique assetClique1, Clique assetClique2, PotentialTable probTable, PotentialTable utilTable) {
        this(assetClique1, assetClique2, probTable, utilTable, true);
    }

    public Separator(Clique clique1, Clique clique2, PotentialTable probTable, PotentialTable utilTable, boolean updateCliques) {
        this();
        this.clique1 = clique1;
        this.clique2 = clique2;
        if (probTable != null) {
            this.tabelaPot = probTable;
        }
        if (utilTable != null) {
            this.utilityTable = utilTable;
        }
        if (updateCliques) {
            clique2.setParent(clique1);
            clique1.addChild(clique2);
        }
    }

    public void setNodes(List<Node> nodeList) {
        this.nodes = nodeList;
    }

    @Override
    public PotentialTable getProbabilityFunction() {
        return this.tabelaPot;
    }

    protected void setProbabilityFunction(PotentialTable probabilityFunction) {
        this.tabelaPot = probabilityFunction;
    }

    public PotentialTable getUtilityTable() {
        return this.utilityTable;
    }

    public ArrayList<Node> getNodes() {
        if (this.nodes instanceof ArrayList) {
            return (ArrayList)this.nodes;
        }
        return new ArrayList<Node>(this.nodes);
    }

    public List<Node> getNodesList() {
        return this.nodes;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof IRandomVariable) {
            return this.getInternalIdentificator() == ((IRandomVariable)obj).getInternalIdentificator();
        }
        return super.equals(obj);
    }

    public Clique getClique1() {
        return this.clique1;
    }

    public Clique getClique2() {
        return this.clique2;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("S{");
        int j = this.nodes.size() - 1;
        while (j >= 0) {
            sb.append(this.nodes.get(j) + " ");
            --j;
        }
        sb.append("}");
        sb.append(this.getClique1());
        sb.append("-");
        sb.append(this.getClique2());
        return sb.toString();
    }

    public static boolean isConnectingNodes(INode node1, INode node2, boolean isToIgnoreDirection, Collection<Edge> edges) {
        boolean isIgnoredArc = false;
        if (edges != null) {
            for (Edge ignoredEdge : edges) {
                if (!ignoredEdge.isConnectingNodes(node1, node2, isToIgnoreDirection)) continue;
                isIgnoredArc = true;
                break;
            }
        }
        return isIgnoredArc;
    }

    public boolean isComplete(Collection<Edge> edgesToIgnore) {
        ArrayList<Node> nodesInSeparator = this.getNodes();
        if (nodesInSeparator == null || nodesInSeparator.size() <= 1) {
            return true;
        }
        int separatorSize = nodesInSeparator.size();
        int i = 0;
        while (i < separatorSize - 1) {
            Node node1 = nodesInSeparator.get(i);
            int j = i + 1;
            while (j < separatorSize) {
                Node node2 = nodesInSeparator.get(j);
                if (Separator.isConnectingNodes(node1, node2, true, edgesToIgnore) || !node1.isParentOf(node2) && !node2.isParentOf(node1)) {
                    boolean hasCommonChild = false;
                    for (Node child : node1.getChildren()) {
                        if (Separator.isConnectingNodes(node1, child, false, edgesToIgnore) || !node2.isParentOf(child)) continue;
                        hasCommonChild = true;
                        break;
                    }
                    if (!hasCommonChild) {
                        return false;
                    }
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public boolean isComplete() {
        return this.isComplete(null);
    }

    @Override
    public int getInternalIdentificator() {
        return this.internalIdentificator;
    }

    @Override
    public void setInternalIdentificator(int internalIdentificator) {
        this.internalIdentificator = internalIdentificator;
    }
}

