/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.bn;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import unbbayes.gui.HierarchicTree;
import unbbayes.io.NetworkCompilationLogManager;
import unbbayes.prs.Edge;
import unbbayes.prs.Network;
import unbbayes.prs.Node;
import unbbayes.prs.bn.Clique;
import unbbayes.prs.bn.IJunctionTree;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.bn.ProbabilisticTable;
import unbbayes.prs.bn.Separator;
import unbbayes.prs.bn.TreeVariable;
import unbbayes.prs.bn.resources.BnResources;
import unbbayes.prs.id.DecisionNode;
import unbbayes.util.Debug;
import unbbayes.util.ResourceController;
import unbbayes.util.SetToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleEntityNetwork
extends Network
implements Serializable {
    private static final long serialVersionUID = 0L;
    protected static ResourceBundle resource = ResourceController.newInstance().getBundle(BnResources.class.getName());
    protected HierarchicTree hierarchicTree;
    protected boolean firstInitialization;
    protected ArrayList<Node> decisionNodes;
    protected double radius;
    protected NetworkCompilationLogManager logManager;
    protected List<Edge> arcosMarkov = new ArrayList<Edge>();
    protected boolean createLog;
    protected ArrayList<Node> nodeEliminationOrder;
    protected ArrayList<Node> copiaNos;
    protected List<Edge> copiaArcos;
    protected IJunctionTree junctionTree;
    private Collection<Edge> markovArcsToBeForced = null;

    public SingleEntityNetwork(String name) {
        super(name);
        this.logManager = new NetworkCompilationLogManager();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        DefaultTreeModel model = new DefaultTreeModel(root);
        this.hierarchicTree = new HierarchicTree(model);
    }

    public ArrayList<Node> getDescriptionNodes() {
        ArrayList<Node> descriptionNodes = new ArrayList<Node>();
        int size = this.nodeList.size();
        int i = 0;
        while (i < size) {
            Node node = this.getNodeAt(i);
            if (node.getType() == 0 && node.getInformationType() == 3) {
                descriptionNodes.add(node);
            }
            ++i;
        }
        return descriptionNodes;
    }

    public ArrayList<Node> getExplanationNodes() {
        ArrayList<Node> explanationNodes = new ArrayList<Node>();
        int size = this.nodeList.size();
        int i = 0;
        while (i < size) {
            Node node = this.getNodeAt(i);
            if (node.getType() == 0 && node.getInformationType() == 4) {
                explanationNodes.add(node);
            }
            ++i;
        }
        return explanationNodes;
    }

    protected void makeAdjacentsListForNodeListElements() {
        this.clearAdjacents();
        int qnos = 0;
        while (qnos < this.nodeList.size()) {
            ((Node)this.nodeList.get(qnos)).makeAdjacents();
            ++qnos;
        }
    }

    protected void makeAdjacents() {
        Edge auxArco;
        this.clearAdjacents();
        int z = this.arcosMarkov.size() - 1;
        while (z >= 0) {
            auxArco = this.arcosMarkov.get(z);
            auxArco.getOriginNode().getAdjacents().add(auxArco.getDestinationNode());
            auxArco.getDestinationNode().getAdjacents().add(auxArco.getOriginNode());
            --z;
        }
        z = this.copiaArcos.size() - 1;
        while (z >= 0) {
            auxArco = this.copiaArcos.get(z);
            if (auxArco.getDestinationNode().getType() == 1) {
                this.copiaArcos.remove(z);
            } else {
                auxArco.getOriginNode().getAdjacents().add(auxArco.getDestinationNode());
                auxArco.getDestinationNode().getAdjacents().add(auxArco.getOriginNode());
            }
            --z;
        }
    }

    protected void clearAdjacents() {
        int size = this.nodeList.size();
        int qnos = 0;
        while (qnos < size) {
            ((Node)this.nodeList.get(qnos)).clearAdjacents();
            ++qnos;
        }
    }

    public void verifyCycles() throws Exception {
        int nodeSize = this.nodeList.size();
        byte[] visited = new byte[nodeSize];
        int[] pi = new int[nodeSize];
        int i = 0;
        while (i < nodeSize) {
            this.dfsCycle(i, visited, pi);
            ++i;
        }
    }

    public boolean hasCycle() {
        try {
            this.verifyCycles();
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    private void dfsCycle(int nodeIndex, byte[] visited, int[] pi) throws Exception {
        if (visited[nodeIndex] != 0) {
            if (visited[nodeIndex] == 1) {
                throw new Exception(String.valueOf(resource.getString("CicleNetException")) + " " + this.createPath(nodeIndex, nodeIndex, pi, true));
            }
            return;
        }
        visited[nodeIndex] = 1;
        Node node = (Node)this.nodeList.get(nodeIndex);
        int i = node.getChildren().size() - 1;
        while (i >= 0) {
            int newIndex = this.getNodeIndex(node.getChildren().get(i).getName());
            pi[newIndex] = nodeIndex;
            this.dfsCycle(newIndex, visited, pi);
            --i;
        }
        visited[nodeIndex] = 2;
    }

    private String createPath(int currentIndex, int nodeIndex, int[] pi, boolean first) {
        if (currentIndex == nodeIndex && !first) {
            return ((Node)this.nodeList.get(currentIndex)).getName();
        }
        return String.valueOf(this.createPath(pi[currentIndex], nodeIndex, pi, false)) + " " + ((Node)this.nodeList.get(currentIndex)).getName();
    }

    public void verifyConectivity() throws Exception {
        ArrayList<Node> visitados = new ArrayList<Node>(this.nodeList.size());
        if (this.nodeList.size() <= 1) {
            return;
        }
        this.makeAdjacentsListForNodeListElements();
        this.dfsConnectivity((Node)this.nodeList.get(0), visitados);
        this.clearAdjacents();
        if (visitados.size() != this.nodeList.size()) {
            throw new Exception(resource.getString("DisconectedNetException"));
        }
    }

    public boolean isConnected() {
        try {
            this.verifyConectivity();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void dfsConnectivity(Node no, List<Node> visitados) {
        visitados.add(no);
        int i = 0;
        while (i < no.getAdjacents().size()) {
            Node aux = no.getAdjacents().get(i);
            if (!visitados.contains(aux)) {
                this.dfsConnectivity(aux, visitados);
            }
            ++i;
        }
    }

    protected void moralize() {
        Edge auxArco;
        int sizeArcos;
        this.clearAdjacents();
        if (this.createLog) {
            this.logManager.append(resource.getString("moralizeLabel"));
        }
        this.arcosMarkov.clear();
        Collection<Edge> markovArcsToBeForced = this.getMarkovArcsToBeForced();
        if (markovArcsToBeForced != null && !markovArcsToBeForced.isEmpty()) {
            this.arcosMarkov.addAll(markovArcsToBeForced);
        }
        this.copiaArcos = (ArrayList)SetToolkit.clone(this.edgeList);
        int i = sizeArcos = this.copiaArcos.size() - 1;
        while (i >= 0) {
            auxArco = this.copiaArcos.get(i);
            if (auxArco.getDestinationNode().getType() == 2) {
                this.copiaArcos.remove(i);
            }
            --i;
        }
        int sizeNos = this.nodeList.size();
        int n = 0;
        while (n < sizeNos) {
            Node auxNo = (Node)this.nodeList.get(n);
            if (auxNo.getType() != 2 && auxNo.getParents().size() > 1) {
                int sizePais = auxNo.getParents().size();
                int j = 0;
                while (j < sizePais - 1) {
                    Node auxPai1 = auxNo.getParents().get(j);
                    int k = j + 1;
                    while (k < sizePais) {
                        Node auxPai2 = auxNo.getParents().get(k);
                        if (this.hasEdge(auxPai1, auxPai2, this.copiaArcos) == -1 && this.hasEdge(auxPai1, auxPai2, this.arcosMarkov) == -1) {
                            auxArco = new Edge(auxPai1, auxPai2);
                            if (this.createLog) {
                                this.logManager.append(String.valueOf(auxPai1.getName()) + " - " + auxPai2.getName() + "\n");
                            }
                            this.arcosMarkov.add(auxArco);
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++n;
        }
        this.makeAdjacents();
        if (this.createLog) {
            this.logManager.append("\n");
        }
    }

    public void setCreateLog(boolean createLog) {
        this.createLog = createLog;
    }

    protected void compileJT(IJunctionTree jt) throws Exception {
        this.resetEvidences();
        this.junctionTree = jt;
        this.cliques();
        this.arvoreForte();
        this.sortCliqueNodes();
        this.associateCliques();
        this.junctionTree.initBeliefs();
        int sizeNos = this.copiaNos.size();
        int c = 0;
        while (c < sizeNos) {
            Node auxNode = this.copiaNos.get(c);
            int menor = Integer.MAX_VALUE;
            if (auxNode.getType() == 0) {
                for (Separator auxSep : this.junctionTree.getSeparators()) {
                    if (!auxSep.getNodes().contains(auxNode) || auxSep.getProbabilityFunction().tableSize() >= menor) continue;
                    ((ProbabilisticNode)auxNode).setAssociatedClique(auxSep);
                    menor = auxSep.getProbabilityFunction().tableSize();
                }
            }
            if (menor == Integer.MAX_VALUE) {
                int sizeCliques = this.junctionTree.getCliques().size();
                int c2 = 0;
                while (c2 < sizeCliques) {
                    Clique auxClique = this.junctionTree.getCliques().get(c2);
                    if (auxClique.getNodes().contains(auxNode) && auxClique.getProbabilityFunction().tableSize() < menor) {
                        if (!(auxNode instanceof ProbabilisticNode)) {
                            ((DecisionNode)auxNode).setAssociatedClique(auxClique);
                            break;
                        }
                        ((ProbabilisticNode)auxNode).setAssociatedClique(auxClique);
                        menor = auxClique.getProbabilityFunction().tableSize();
                    }
                    ++c2;
                }
            }
            ++c;
        }
        this.updateMarginals();
        if (this.createLog) {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    SingleEntityNetwork.this.makeLog();
                    System.out.println("**Log ended**");
                }
            });
            t.setPriority(1);
            t.start();
        }
    }

    public void resetEvidences() {
        for (Node node : this.getNodesCopy()) {
            if (!(node instanceof TreeVariable)) continue;
            ((TreeVariable)node).resetEvidence();
        }
    }

    public void resetLikelihoods() {
        for (Node node : this.getNodesCopy()) {
            if (!(node instanceof TreeVariable)) continue;
            ((TreeVariable)node).resetLikelihood();
        }
    }

    public boolean isID() {
        int i = 0;
        while (i < this.nodeList.size()) {
            if (((Node)this.nodeList.get(i)).getType() == 2 || ((Node)this.nodeList.get(i)).getType() == 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isHybridBN() {
        int i = 0;
        while (i < this.nodeList.size()) {
            if (((Node)this.nodeList.get(i)).getType() == 5) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isBN() {
        int i = 0;
        while (i < this.nodeList.size()) {
            if (((Node)this.nodeList.get(i)).getType() != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Deprecated
    protected void updateMarginais() {
        this.updateMarginals();
    }

    protected void updateMarginals() {
        for (Node node : this.copiaNos) {
            if (node.getStatesSize() == 0) continue;
            ((TreeVariable)node).marginal();
        }
    }

    protected void cliques() {
        Clique auxClique2;
        int j;
        Clique auxClique;
        ArrayList<Clique> listaCliques = new ArrayList<Clique>();
        int sizeNos = this.copiaNos.size();
        int i = 0;
        while (i < sizeNos) {
            Node auxNo = this.copiaNos.get(i);
            int e = this.nodeEliminationOrder.indexOf(auxNo);
            auxClique = new Clique();
            auxClique.getNodes().add(auxNo);
            int sizeAdjacentes = auxNo.getAdjacents().size();
            j = 0;
            while (j < sizeAdjacentes) {
                Node auxNo2 = auxNo.getAdjacents().get(j);
                if (this.nodeEliminationOrder.indexOf(auxNo2) > e) {
                    auxClique.getNodes().add(auxNo2);
                }
                ++j;
            }
            listaCliques.add(auxClique);
            ++i;
        }
        boolean haTroca = true;
        while (haTroca) {
            haTroca = false;
            i = 0;
            while (i < listaCliques.size() - 1) {
                auxClique = (Clique)listaCliques.get(i);
                auxClique2 = (Clique)listaCliques.get(i + 1);
                if (auxClique.getNodes().size() > auxClique2.getNodes().size()) {
                    listaCliques.set(i + 1, auxClique);
                    listaCliques.set(i, auxClique2);
                    haTroca = true;
                }
                ++i;
            }
        }
        int sizeCliques = listaCliques.size();
        i = 0;
        while (i < sizeCliques) {
            block9: {
                auxClique = (Clique)listaCliques.get(i);
                j = i + 1;
                while (j < sizeCliques) {
                    auxClique2 = (Clique)listaCliques.get(j);
                    if (!auxClique2.getNodes().containsAll(auxClique.getNodes())) {
                        ++j;
                        continue;
                    }
                    break block9;
                }
                this.junctionTree.getCliques().add(auxClique);
            }
            ++i;
        }
        listaCliques.clear();
    }

    protected void sortCliqueNodes() {
        Node node2;
        Node node1;
        int i;
        boolean haTroca;
        List<Clique> listaCliques = this.junctionTree.getCliques();
        boolean isID = this.isID();
        int k = 0;
        while (k < listaCliques.size()) {
            Clique clique = listaCliques.get(k);
            ArrayList<Node> nosClique = clique.getNodes();
            haTroca = true;
            while (haTroca) {
                haTroca = false;
                i = 0;
                while (i < nosClique.size() - 1) {
                    node1 = nosClique.get(i);
                    node2 = nosClique.get(i + 1);
                    if (isID) {
                        if (this.nodeEliminationOrder.indexOf(node1) > this.nodeEliminationOrder.indexOf(node2)) {
                            nosClique.set(i + 1, node1);
                            nosClique.set(i, node2);
                            haTroca = true;
                        }
                    } else if (node1.getName().compareToIgnoreCase(node2.getName()) > 0) {
                        nosClique.set(i + 1, node1);
                        nosClique.set(i, node2);
                        haTroca = true;
                    }
                    ++i;
                }
            }
            ++k;
        }
        for (Separator separator : this.junctionTree.getSeparators()) {
            ArrayList<Node> nosSeparator = separator.getNodes();
            haTroca = true;
            while (haTroca) {
                haTroca = false;
                i = 0;
                while (i < nosSeparator.size() - 1) {
                    node1 = nosSeparator.get(i);
                    node2 = nosSeparator.get(i + 1);
                    if (node1.getName().compareToIgnoreCase(node2.getName()) > 0) {
                        nosSeparator.set(i + 1, node1);
                        nosSeparator.set(i, node2);
                        haTroca = true;
                    }
                    ++i;
                }
            }
        }
    }

    protected void makeLog() {
        long in = System.currentTimeMillis();
        try {
            this.logManager.finishLog(this.junctionTree, this.nodeList);
            if (this.id != null) {
                this.logManager.writeToDisk(String.valueOf(this.id) + ".txt", false);
            } else {
                this.logManager.writeToDisk("aj.txt", false);
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
        System.out.println("Log file generated in " + (System.currentTimeMillis() - in) + " ms");
    }

    protected void associateCliques() {
        int c;
        PotentialTable auxUtilTab;
        PotentialTable auxTabPot;
        Clique auxClique;
        Clique cliqueMin = null;
        int i = this.junctionTree.getCliques().size() - 1;
        while (i >= 0) {
            auxClique = this.junctionTree.getCliques().get(i);
            auxTabPot = auxClique.getProbabilityFunction();
            auxUtilTab = auxClique.getUtilityTable();
            int sizeNos = auxClique.getNodes().size();
            int c2 = 0;
            while (c2 < sizeNos) {
                auxTabPot.addVariable(auxClique.getNodes().get(c2));
                auxUtilTab.addVariable(auxClique.getNodes().get(c2));
                ++c2;
            }
            --i;
        }
        for (Separator auxSep : this.junctionTree.getSeparators()) {
            auxTabPot = auxSep.getProbabilityFunction();
            auxUtilTab = auxSep.getUtilityTable();
            int sizeNos = auxSep.getNodes().size();
            c = 0;
            while (c < sizeNos) {
                auxTabPot.addVariable(auxSep.getNodes().get(c));
                auxUtilTab.addVariable(auxSep.getNodes().get(c));
                ++c;
            }
        }
        int sizeNos = this.nodeList.size();
        int n = 0;
        while (n < sizeNos) {
            if (((Node)this.nodeList.get(n)).getType() != 2) {
                int min = Integer.MAX_VALUE;
                Node auxNo = (Node)this.nodeList.get(n);
                int sizeCliques = this.junctionTree.getCliques().size();
                c = 0;
                while (c < sizeCliques) {
                    auxClique = this.junctionTree.getCliques().get(c);
                    if (auxClique.getProbabilityFunction().tableSize() < min && SetToolkit.containsAllExact(auxClique.getNodes(), auxNo.getParents()) && (auxNo.getType() != 0 || SetToolkit.containsExact(auxClique.getNodes(), auxNo))) {
                        cliqueMin = auxClique;
                        min = cliqueMin.getProbabilityFunction().tableSize();
                    }
                    ++c;
                }
                if (auxNo instanceof ProbabilisticNode) {
                    cliqueMin.getAssociatedProbabilisticNodes().add(auxNo);
                } else {
                    cliqueMin.getAssociatedUtilityNodes().add(auxNo);
                }
            }
            ++n;
        }
    }

    protected void arvoreForte() {
        ArrayList<Node> alpha = new ArrayList<Node>();
        int i = this.nodeEliminationOrder.size() - 1;
        while (i >= 0) {
            alpha.add(this.nodeEliminationOrder.get(i));
            --i;
        }
        if (this.copiaNos.size() > 1) {
            Clique auxClique;
            int sizeCliques = this.junctionTree.getCliques().size();
            int i2 = 0;
            while (i2 < sizeCliques) {
                int ndx;
                auxClique = this.junctionTree.getCliques().get(i2);
                ArrayList<Node> listaNos = SetToolkit.clone(auxClique.getNodes());
                while ((ndx = this.getCliqueIndex(listaNos, alpha)) <= 0 && listaNos.size() > 1) {
                }
                if (ndx < 0) {
                    ndx = 0;
                }
                auxClique.setIndex(ndx);
                listaNos.clear();
                ++i2;
            }
            alpha.clear();
            Comparator<Clique> comparador = new Comparator<Clique>(){

                @Override
                public int compare(Clique o1, Clique o2) {
                    Clique c1 = o1;
                    Clique c2 = o2;
                    if (c1.getIndex() > c2.getIndex()) {
                        return 1;
                    }
                    if (c1.getIndex() < c2.getIndex()) {
                        return -1;
                    }
                    return 0;
                }
            };
            Collections.sort(this.junctionTree.getCliques(), comparador);
            auxClique = this.junctionTree.getCliques().get(0);
            ArrayList<Node> uni = SetToolkit.clone(auxClique.getNodes());
            int sizeCliques1 = this.junctionTree.getCliques().size();
            int i3 = 1;
            while (i3 < sizeCliques1) {
                auxClique = this.junctionTree.getCliques().get(i3);
                ArrayList<Node> inter = SetToolkit.intersection(auxClique.getNodes(), uni);
                int j = 0;
                while (j < i3) {
                    Clique auxClique2 = this.junctionTree.getCliques().get(j);
                    if (auxClique2.getNodes().containsAll(inter)) {
                        Separator sep = new Separator(auxClique2, auxClique);
                        sep.setNodes(inter);
                        this.junctionTree.addSeparator(sep);
                        ArrayList<Node> auxList = SetToolkit.union(auxClique.getNodes(), uni);
                        uni.clear();
                        uni = auxList;
                        break;
                    }
                    ++j;
                }
                ++i3;
            }
        }
    }

    protected int getCliqueIndex(ArrayList<Node> listaNos, ArrayList<Node> alpha) {
        int ndx;
        Node auxNo;
        Node noMax = null;
        ArrayList<Node> auxList = null;
        int mx = -1;
        int sizeNos = listaNos.size();
        int i = 0;
        while (i < sizeNos) {
            auxNo = listaNos.get(i);
            ndx = alpha.indexOf(auxNo);
            if (mx < ndx) {
                mx = ndx;
                noMax = auxNo;
            }
            ++i;
        }
        listaNos.remove(noMax);
        if (listaNos.isEmpty()) {
            return mx;
        }
        auxNo = listaNos.get(0);
        ArrayList<Node> vizinhos = SetToolkit.clone(auxNo.getAdjacents());
        int sizeNos1 = listaNos.size();
        int i2 = 1;
        while (i2 < sizeNos1) {
            auxNo = listaNos.get(i2);
            auxList = SetToolkit.intersection(vizinhos, auxNo.getAdjacents());
            vizinhos.clear();
            vizinhos = auxList;
            ++i2;
        }
        vizinhos.remove(noMax);
        ndx = 0;
        int sizeVizinhos = vizinhos.size();
        int i3 = 0;
        while (i3 < sizeVizinhos) {
            auxNo = vizinhos.get(i3);
            if (!listaNos.contains(auxNo) && alpha.indexOf(auxNo) <= mx) {
                ndx = mx;
                break;
            }
            ++i3;
        }
        return ndx;
    }

    protected boolean minimumWeightElimination(ArrayList<Node> auxNos) {
        boolean algum = true;
        while (algum) {
            algum = false;
            int i = auxNos.size() - 1;
            while (i >= 0) {
                Node auxNo = auxNos.get(i);
                if (!this.cordas(auxNo)) {
                    int j = auxNo.getAdjacents().size() - 1;
                    while (j >= 0) {
                        Node v = auxNo.getAdjacents().get(j);
                        v.getAdjacents().remove(auxNo);
                        --j;
                    }
                    auxNos.remove(auxNo);
                    algum = true;
                    this.nodeEliminationOrder.add(auxNo);
                    if (this.createLog) {
                        this.logManager.append("\t" + this.nodeEliminationOrder.size() + " " + auxNo.getName() + "\n");
                    }
                }
                --i;
            }
        }
        if (auxNos.size() > 0) {
            Node auxNo = this.weight(auxNos);
            this.nodeEliminationOrder.add(auxNo);
            if (this.createLog) {
                this.logManager.append("\t" + this.nodeEliminationOrder.size() + " " + auxNo.getName() + "\n");
            }
            this.elimine(auxNo, auxNos);
            return true;
        }
        return false;
    }

    private void elimine(Node no, ArrayList<Node> auxNos) {
        Node auxNo1;
        int i = no.getAdjacents().size() - 1;
        while (i > 0) {
            auxNo1 = no.getAdjacents().get(i);
            int j = i - 1;
            while (j >= 0) {
                Node auxNo2 = no.getAdjacents().get(j);
                if (!auxNo2.getAdjacents().contains(auxNo1)) {
                    Edge auxArco = new Edge(auxNo1, auxNo2);
                    if (this.createLog) {
                        this.logManager.append(String.valueOf(auxNo1.getName()) + resource.getString("linkedName") + auxNo2.getName() + "\n");
                    }
                    this.arcosMarkov.add(auxArco);
                    auxNo1.getAdjacents().add(auxNo2);
                    auxNo2.getAdjacents().add(auxNo1);
                    Debug.println(this.getClass(), "" + auxArco);
                }
                --j;
            }
            --i;
        }
        i = no.getAdjacents().size() - 1;
        while (i >= 0) {
            auxNo1 = no.getAdjacents().get(i);
            auxNo1.getAdjacents().remove(no);
            --i;
        }
        auxNos.remove(no);
    }

    private Node weight(ArrayList<Node> auxNos) {
        Node noMin = null;
        double pmin = Double.MAX_VALUE;
        int i = auxNos.size() - 1;
        while (i >= 0) {
            Node auxNo = auxNos.get(i);
            double p = Math.log(auxNo.getStatesSize());
            int j = auxNo.getAdjacents().size() - 1;
            while (j >= 0) {
                Node v = auxNo.getAdjacents().get(j);
                p += Math.log(v.getStatesSize());
                --j;
            }
            if (p < pmin) {
                pmin = p;
                noMin = auxNo;
            }
            --i;
        }
        return noMin;
    }

    private boolean cordas(Node no) {
        if (no.getAdjacents().size() < 2) {
            return false;
        }
        int i = no.getAdjacents().size() - 1;
        while (i > 0) {
            Node auxNo1 = no.getAdjacents().get(i);
            int j = i - 1;
            while (j >= 0) {
                Node auxNo2 = no.getAdjacents().get(j);
                if (!auxNo2.getAdjacents().contains(auxNo1)) {
                    return true;
                }
                --j;
            }
            --i;
        }
        return false;
    }

    protected void verifyConsistency() throws Exception {
        if (this.nodeList.size() != 0) {
            StringBuffer sb;
            Exception firstException;
            boolean hasError;
            block14: {
                block13: {
                    block12: {
                        block11: {
                            this.nodeIndexes.clear();
                            int i = this.nodeList.size() - 1;
                            while (i >= 0) {
                                this.nodeIndexes.put(((Node)this.nodeList.get(i)).getName(), new Integer(i));
                                --i;
                            }
                            hasError = false;
                            firstException = null;
                            sb = new StringBuffer();
                            try {
                                this.verifyUtility();
                            }
                            catch (Exception e) {
                                hasError = true;
                                sb.append(e.getMessage());
                                if (firstException != null) break block11;
                                firstException = e;
                            }
                        }
                        try {
                            this.verifyCycles();
                        }
                        catch (Exception e) {
                            hasError = true;
                            sb.append(String.valueOf('\n') + e.getMessage());
                            if (firstException != null) break block12;
                            firstException = e;
                        }
                    }
                    try {
                        this.verifyPotentialTables();
                    }
                    catch (Exception e) {
                        hasError = true;
                        sb.append(String.valueOf('\n') + e.getMessage());
                        if (firstException != null) break block13;
                        firstException = e;
                    }
                }
                try {
                    this.sortDecisions();
                }
                catch (Exception e) {
                    hasError = true;
                    sb.append(String.valueOf('\n') + e.getMessage());
                    if (firstException != null) break block14;
                    firstException = e;
                }
            }
            if (hasError) {
                throw new Exception(sb.toString(), firstException);
            }
        }
    }

    public HierarchicTree getHierarchicTree() {
        return this.hierarchicTree;
    }

    public void setHierarchicTree(HierarchicTree hierarchicTree) {
        this.hierarchicTree = hierarchicTree;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public double getRadius() {
        return this.radius;
    }

    protected void verifyPotentialTables() throws Exception {
        int sizeNos = this.nodeList.size();
        int c = 0;
        while (c < sizeNos) {
            Node auxNo = (Node)this.nodeList.get(c);
            if (auxNo.getType() == 0) {
                ProbabilisticNode auxVP = (ProbabilisticNode)auxNo;
                ProbabilisticTable auxTabPot = (ProbabilisticTable)auxVP.getProbabilityFunction();
                auxTabPot.verifyConsistency();
            }
            ++c;
        }
    }

    protected void verifyUtility() throws Exception {
        int sizeNos = this.nodeList.size();
        int i = 0;
        while (i < sizeNos) {
            Node aux = (Node)this.nodeList.get(i);
            if (aux.getType() == 1 && aux.getChildren().size() != 0) {
                throw new Exception(String.valueOf(resource.getString("variableName")) + aux + resource.getString("hasChildName"));
            }
            ++i;
        }
    }

    public void sortDecisions() throws Exception {
        Node aux;
        this.clearAdjacents();
        this.decisionNodes = new ArrayList();
        int sizeNos = this.nodeList.size();
        int i = 0;
        while (i < sizeNos) {
            if (((Node)this.nodeList.get(i)).getType() == 2) {
                this.decisionNodes.add((Node)this.nodeList.get(i));
            }
            ++i;
        }
        ArrayList<Node> fila = new ArrayList<Node>();
        fila.ensureCapacity(this.nodeList.size());
        int sizeDecisao = this.decisionNodes.size();
        int i2 = 0;
        while (i2 < sizeDecisao) {
            boolean[] visitados = new boolean[this.nodeList.size()];
            aux = this.decisionNodes.get(i2);
            fila.clear();
            fila.add(aux);
            while (fila.size() != 0) {
                Node aux2 = (Node)fila.remove(0);
                visitados[this.nodeList.indexOf((Object)aux2)] = true;
                int sizeFilhos = aux2.getChildren().size();
                int k = 0;
                while (k < sizeFilhos) {
                    Node aux3 = aux2.getChildren().get(k);
                    if (!visitados[this.nodeList.indexOf(aux3)]) {
                        if (aux3.getType() == 2 && !aux.getAdjacents().contains(aux3)) {
                            aux.getAdjacents().add(aux3);
                        }
                        fila.add(aux3);
                    }
                    ++k;
                }
            }
            ++i2;
        }
        boolean haTroca = true;
        while (haTroca) {
            haTroca = false;
            int i3 = 0;
            while (i3 < this.decisionNodes.size() - 1) {
                Node node1 = this.decisionNodes.get(i3);
                Node node2 = this.decisionNodes.get(i3 + 1);
                if (node1.getAdjacents().size() < node2.getAdjacents().size()) {
                    this.decisionNodes.set(i3 + 1, node1);
                    this.decisionNodes.set(i3, node2);
                    haTroca = true;
                }
                ++i3;
            }
        }
        int i4 = 0;
        while (i4 < this.decisionNodes.size()) {
            aux = this.decisionNodes.get(i4);
            if (aux.getAdjacents().size() != this.decisionNodes.size() - i4 - 1) {
                throw new Exception(resource.getString("DecisionOrderException"));
            }
            ++i4;
        }
        this.clearAdjacents();
    }

    public ArrayList<Node> getNodesCopy() {
        if (this.copiaNos == null) {
            this.copiaNos = (ArrayList)this.nodeList.clone();
        }
        return this.copiaNos;
    }

    public void resetNodesCopy() {
        this.copiaNos = (ArrayList)this.nodeList.clone();
    }

    public String getLog() {
        return this.logManager.getLog();
    }

    public boolean isCreateLog() {
        return this.createLog;
    }

    public void updateEvidences() throws Exception {
        this.updateEvidences(null, true);
    }

    public void updateEvidences(Clique rootClique, boolean isToUpdateMarginals) throws Exception {
        int numEvidences = 0;
        int sizeNos = this.getNodesCopy().size();
        int c = 0;
        while (c < sizeNos) {
            TreeVariable node = (TreeVariable)this.copiaNos.get(c);
            if (node.hasEvidence()) {
                node.updateEvidences();
                ++numEvidences;
            }
            ++c;
        }
        try {
            if (rootClique != null) {
                this.junctionTree.consistency(rootClique, numEvidences > 1);
            } else {
                this.junctionTree.consistency();
            }
        }
        catch (Exception e) {
            try {
                this.initialize();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            throw e;
        }
        if (isToUpdateMarginals) {
            this.updateMarginals();
        }
        this.resetLikelihoods();
    }

    public void initialize() throws Exception {
        this.resetEvidences();
        this.junctionTree.initBeliefs();
        if (this.firstInitialization) {
            this.updateMarginals();
            this.copyMarginal();
            this.firstInitialization = false;
        } else {
            this.restoreMarginais();
        }
    }

    protected void copyMarginal() {
        int i = 0;
        while (i < this.copiaNos.size()) {
            TreeVariable node = (TreeVariable)this.copiaNos.get(i);
            node.copyMarginal();
            ++i;
        }
    }

    protected void restoreMarginais() {
        int i = 0;
        while (i < this.copiaNos.size()) {
            TreeVariable node = (TreeVariable)this.copiaNos.get(i);
            node.restoreMarginal();
            ++i;
        }
    }

    public void setFirstInitialization(boolean firstInitialization) {
        this.firstInitialization = firstInitialization;
    }

    public float PET() {
        return this.junctionTree.getN();
    }

    public IJunctionTree getJunctionTree() {
        return this.junctionTree;
    }

    public void setJunctionTree(IJunctionTree junctionTree) {
        this.junctionTree = junctionTree;
    }

    public NetworkCompilationLogManager getLogManager() {
        return this.logManager;
    }

    public void setLogManager(NetworkCompilationLogManager logManager) {
        this.logManager = logManager;
    }

    public ArrayList<Node> getNodeEliminationOrder() {
        return this.nodeEliminationOrder;
    }

    public void setNodeEliminationOrder(ArrayList<Node> nodeEliminationOrder) {
        this.nodeEliminationOrder = nodeEliminationOrder;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.copiaNos != null) {
            this.copiaNos.clear();
        }
        this.setJunctionTree(null);
    }

    public Collection<Edge> getMarkovArcsToBeForced() {
        return this.markovArcsToBeForced;
    }

    public void setMarkovArcsToBeForced(Collection<Edge> markovArcsToBeForced) {
        this.markovArcsToBeForced = markovArcsToBeForced;
    }

    protected List<Edge> getMarkovArcs() {
        return this.arcosMarkov;
    }

    protected void setMarkovArcs(List<Edge> markovArcs) {
        this.arcosMarkov = markovArcs;
    }

    protected List<Edge> getEdgesCopy() {
        return this.copiaArcos;
    }

    protected void setEdgesCopy(List<Edge> edgesCopy) {
        this.copiaArcos = edgesCopy;
    }
}

