/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.bn;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import unbbayes.prs.INode;
import unbbayes.prs.Node;
import unbbayes.prs.bn.IRandomVariable;
import unbbayes.prs.bn.PotentialTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TreeVariable
extends Node
implements Serializable {
    protected IRandomVariable cliqueAssociado;
    protected float[] marginalList;
    private float[] marginalCopy;
    private int evidence = -1;
    private float[] likelihood = null;
    private List<INode> likelihoodParents = new ArrayList<INode>();

    protected abstract void marginal();

    public void updateMarginal() {
        this.marginal();
    }

    public void initMarginalList() {
        this.marginalList = new float[this.getStatesSize()];
    }

    public boolean isMarginalList() {
        return this.marginalList != null;
    }

    public void copyMarginal() {
        int size = this.marginalList.length;
        this.marginalCopy = new float[size];
        System.arraycopy(this.marginalList, 0, this.marginalCopy, 0, size);
    }

    public void restoreMarginal() {
        if (this.marginalCopy == null) {
            return;
        }
        int size = this.marginalList.length;
        System.arraycopy(this.marginalCopy, 0, this.marginalList, 0, size);
    }

    public float getMarginalAt(int index) {
        if (this.marginalList != null) {
            return this.marginalList[index];
        }
        return -0.0f;
    }

    public void setMarginalAt(int index, float value) {
        this.marginalList[index] = value;
    }

    public void setMarginalProbabilities(float[] marginalProbabilities) {
        System.arraycopy(marginalProbabilities, 0, this.marginalList, 0, marginalProbabilities.length);
    }

    public void resetEvidence() {
        this.evidence = -1;
        this.resetLikelihood();
    }

    public boolean hasEvidence() {
        return this.evidence != -1;
    }

    public int getEvidence() {
        return this.evidence;
    }

    public void resetLikelihood() {
        if (this.hasLikelihood()) {
            this.evidence = -1;
        }
        this.likelihood = null;
        if (this.getLikelihoodParents() != null) {
            this.getLikelihoodParents().clear();
        }
    }

    public boolean hasLikelihood() {
        return this.likelihood != null;
    }

    public void addFinding(int stateIndex) {
        this.addFinding(stateIndex, false);
    }

    public void addFinding(int stateIndex, boolean isNegative) {
        this.evidence = stateIndex;
        int i = 0;
        while (i < this.getStatesSize()) {
            this.setMarginalAt(i, (float)(i == stateIndex ? !isNegative : isNegative));
            ++i;
        }
    }

    public void addLikeliHood(float[] likelihood) {
        this.addLikeliHood(likelihood, null);
    }

    public void addLikeliHood(float[] likelihood, List<INode> dependencies) {
        this.likelihood = likelihood;
        if (dependencies != null) {
            this.setLikelihoodParents(new ArrayList<INode>(dependencies));
        } else {
            this.setLikelihoodParents(new ArrayList<INode>());
        }
        if (this.hasLikelihood()) {
            this.evidence = 0;
        }
    }

    public IRandomVariable getAssociatedClique() {
        return this.cliqueAssociado;
    }

    public void setAssociatedClique(IRandomVariable clique) {
        this.cliqueAssociado = clique;
    }

    protected void updateEvidences() {
        if (this.evidence != -1) {
            PotentialTable auxTab = (PotentialTable)this.cliqueAssociado.getProbabilityFunction();
            int index = auxTab.indexOfVariable(this);
            auxTab.updateEvidences(this.marginalList, index);
        }
    }

    public float[] getLikelihood() {
        return this.likelihood;
    }

    public List<INode> getLikelihoodParents() {
        return this.likelihoodParents;
    }

    protected void setLikelihoodParents(List<INode> likelihoodParents) {
        if (likelihoodParents != null) {
            this.likelihoodParents = likelihoodParents;
        } else if (this.likelihoodParents != null) {
            this.likelihoodParents.clear();
        } else {
            this.likelihoodParents = new ArrayList<INode>();
        }
    }
}

