/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.bn.cpt.impl;

import java.util.Locale;
import java.util.ResourceBundle;
import unbbayes.prs.bn.ProbabilisticTable;
import unbbayes.prs.bn.cpt.ITableFunction;
import unbbayes.prs.bn.cpt.impl.resources.Resources;
import unbbayes.util.ResourceController;

public class FillUniformTableFunction
implements ITableFunction {
    private ResourceBundle resource;

    public FillUniformTableFunction() {
        try {
            this.resource = ResourceController.newInstance().getBundle(Resources.class.getName(), Locale.getDefault(), this.getClass().getClassLoader());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void applyFunction(ProbabilisticTable table) {
        float value;
        float[] totalSum = new float[table.tableSize()];
        int[] nEmptyStates = new int[table.tableSize()];
        int[] coord = new int[table.variableCount()];
        int i = 0;
        while (i < table.tableSize()) {
            value = table.getValue(i);
            coord = table.getMultidimensionalCoord(i);
            coord[0] = 0;
            int n = table.getLinearCoord(coord);
            totalSum[n] = totalSum[n] + value;
            if (value == 0.0f) {
                int n2 = table.getLinearCoord(coord);
                nEmptyStates[n2] = nEmptyStates[n2] + 1;
            }
            ++i;
        }
        i = 0;
        while (i < table.tableSize()) {
            coord = table.getMultidimensionalCoord(i);
            coord[0] = 0;
            if (table.getValue(i) == 0.0f) {
                value = (1.0f - totalSum[table.getLinearCoord(coord)]) / (float)nEmptyStates[table.getLinearCoord(coord)];
                table.setValue(i, value);
            }
            ++i;
        }
    }

    public String getFunctionName() {
        return this.resource.getString("fillUniformFunction");
    }

    public String toString() {
        return this.getFunctionName();
    }

    public int compareTo(ITableFunction o) {
        return this.toString().compareTo(o.toString());
    }
}

