/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.bn.cpt.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import unbbayes.prs.Graph;
import unbbayes.prs.INode;
import unbbayes.prs.Network;
import unbbayes.prs.Node;
import unbbayes.prs.bn.Clique;
import unbbayes.prs.bn.IProbabilityFunction;
import unbbayes.prs.bn.IRandomVariable;
import unbbayes.prs.bn.JunctionTreeAlgorithm;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticTable;
import unbbayes.prs.bn.Separator;
import unbbayes.prs.bn.SingleEntityNetwork;
import unbbayes.prs.bn.TreeVariable;
import unbbayes.prs.bn.cpt.IArbitraryConditionalProbabilityExtractor;
import unbbayes.util.Debug;
import unbbayes.util.extension.bn.inference.IInferenceAlgorithm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InCliqueConditionalProbabilityExtractor
implements IArbitraryConditionalProbabilityExtractor {
    public static final CliqueEvidenceUpdater DEFAULT_CLIQUE_EVIDENCE_UPDATER = new CliqueEvidenceUpdater(){

        public void updateEvidenceWithinClique(Clique clique, PotentialTable cliqueTable, float[] marginalMultiplier, Node nodeWithEvidence) {
            cliqueTable.updateEvidences(marginalMultiplier, cliqueTable.indexOfVariable(nodeWithEvidence));
        }
    };
    private boolean isToOptimizeFullCliqueConditionalProbEvaluation = true;
    private boolean isToJoinCliquesWhenNoCliqueFound = false;

    protected InCliqueConditionalProbabilityExtractor() {
    }

    public static IArbitraryConditionalProbabilityExtractor newInstance() {
        return InCliqueConditionalProbabilityExtractor.newInstance(false);
    }

    public static IArbitraryConditionalProbabilityExtractor newInstance(boolean isToJoinCliquesWhenNoCliqueFound) {
        InCliqueConditionalProbabilityExtractor ret = new InCliqueConditionalProbabilityExtractor();
        ret.setToJoinCliquesWhenNoCliqueFound(isToJoinCliquesWhenNoCliqueFound);
        return ret;
    }

    @Override
    public IProbabilityFunction buildCondicionalProbability(INode mainNode, List<INode> parentNodes, Graph net, IInferenceAlgorithm algorithm) throws NoCliqueException {
        return this.buildCondicionalProbability(mainNode, parentNodes, net, algorithm, DEFAULT_CLIQUE_EVIDENCE_UPDATER);
    }

    public IProbabilityFunction buildCondicionalProbability(INode mainNode, List<INode> parentNodes, Graph net, IInferenceAlgorithm algorithm, CliqueEvidenceUpdater cliqueEvidenceUpdater) throws NoCliqueException {
        return this.buildCondicionalProbability(mainNode, parentNodes, net, algorithm, cliqueEvidenceUpdater, null);
    }

    public IProbabilityFunction buildCondicionalProbability(INode mainNode, List<INode> parentNodes, Graph net, IInferenceAlgorithm algorithm, CliqueEvidenceUpdater cliqueEvidenceUpdater, Clique clique) throws NoCliqueException {
        ProbabilisticTable ret;
        block39: {
            block38: {
                if (mainNode == null) {
                    throw new NullPointerException("mainNode == null");
                }
                if (parentNodes == null) {
                    parentNodes = new ArrayList<INode>();
                }
                if (!parentNodes.isEmpty()) {
                    HashSet<INode> setToCheckDuplicates = new HashSet<INode>();
                    setToCheckDuplicates.add(mainNode);
                    for (INode condition : parentNodes) {
                        if (setToCheckDuplicates.contains(condition)) {
                            throw new IllegalArgumentException(condition + " is a duplicate condition for " + mainNode);
                        }
                        setToCheckDuplicates.add(condition);
                    }
                }
                ret = new ProbabilisticTable();
                ret.addVariable(mainNode);
                if (parentNodes.size() <= 0) {
                    int i = 0;
                    while (i < ret.tableSize()) {
                        ret.setValue(i, ((TreeVariable)mainNode).getMarginalAt(i));
                        ++i;
                    }
                    return ret;
                }
                for (INode node : parentNodes) {
                    ret.addVariable(node);
                }
                if (clique == null) {
                    if (net instanceof SingleEntityNetwork) {
                        HashSet<INode> nodes = new HashSet<INode>(parentNodes);
                        nodes.add(mainNode);
                        nodes.remove(null);
                        clique = this.getCliqueContainingAllNodes((SingleEntityNetwork)net, nodes);
                    }
                } else if (!clique.getNodes().contains(mainNode) || !clique.getNodes().containsAll(parentNodes)) {
                    throw new NoCliqueException(clique + " should contain " + mainNode + " and " + parentNodes);
                }
                if (clique == null && this.isToJoinCliquesWhenNoCliqueFound() && !parentNodes.isEmpty()) {
                    Collection<Clique> cliquesWithMainNode = this.getCliquesContainingAllNodes((SingleEntityNetwork)net, Collections.singletonList(mainNode), Integer.MAX_VALUE);
                    ArrayList<Clique> cliquesAlsoWithSomeOfTheParents = new ArrayList<Clique>(cliquesWithMainNode.size());
                    ArrayList<INode> remainingParents = new ArrayList<INode>(parentNodes);
                    remainingParents.remove(null);
                    for (Clique candidateClique : cliquesWithMainNode) {
                        if (remainingParents.isEmpty()) break;
                        if (!remainingParents.removeAll(candidateClique.getNodesList())) continue;
                        cliquesAlsoWithSomeOfTheParents.add(candidateClique);
                    }
                    if (cliquesAlsoWithSomeOfTheParents.isEmpty() || !remainingParents.isEmpty()) {
                        if (!this.isToJoinCliquesWhenNoCliqueFound()) {
                            throw new IllegalStateException("There is no complete set of cliques containing main node " + mainNode + " and any of the parents  " + parentNodes + " simultaneously. " + (remainingParents == null ? "" : "Parents not found: " + remainingParents));
                        }
                        Debug.println("There is no complete set of cliques containing main node " + mainNode + " and any of the parents  " + parentNodes + " simultaneously. " + (remainingParents == null ? "" : "Parents not found: " + remainingParents));
                        if (cliquesAlsoWithSomeOfTheParents.isEmpty()) {
                            cliquesAlsoWithSomeOfTheParents.add(cliquesWithMainNode.iterator().next());
                        }
                        Iterator<Clique> iterator = remainingParents.iterator();
                        while (iterator.hasNext()) {
                            INode parent = (INode)((Object)iterator.next());
                            Clique cliqueWithParent = this.getCliqueContainingAllNodes((SingleEntityNetwork)net, Collections.singletonList(parent));
                            if (cliqueWithParent == null) {
                                throw new NullPointerException("Unable to find clique containing node " + parent + ", a parent of " + mainNode);
                            }
                            cliquesAlsoWithSomeOfTheParents.add(cliqueWithParent);
                        }
                    }
                    clique = net instanceof Network ? ((Clique)cliquesAlsoWithSomeOfTheParents.get(0)).clone((Network)net) : ((Clique)cliquesAlsoWithSomeOfTheParents.get(0)).clone(null);
                    cliquesAlsoWithSomeOfTheParents.remove(0);
                    for (Clique cliqueToJoin : cliquesAlsoWithSomeOfTheParents) {
                        clique.join(cliqueToJoin);
                    }
                }
                if (clique == null) {
                    String message = "No clique containing the following nodes simultaneously:\n " + mainNode;
                    for (INode node : parentNodes) {
                        message = String.valueOf(message) + ", " + node;
                    }
                    throw new NoCliqueException(message);
                }
                if (!this.isToOptimizeFullCliqueConditionalProbEvaluation || clique.getNodesList().size() != parentNodes.size() + 1) break block38;
                PotentialTable cliqueTable = clique.getProbabilityFunction();
                if (cliqueTable.tableSize() != ret.tableSize()) {
                    throw new RuntimeException("Inconsistency: attempted to generate conditional table of variable " + ret.getVariableAt(0) + " given " + parentNodes + " with table size = " + ret.tableSize() + ", but the clique table of associated clique " + clique + " had size = " + cliqueTable.tableSize() + ", although a table with same variables should have the same size.");
                }
                if (!ret.getVariableAt(0).equals(mainNode)) {
                    throw new RuntimeException("This class assumes that the 1st variable in the potential table is the main node (" + mainNode + "). This is not happening, so you may be using an incompatible version.");
                }
                int[] mappingOfIndexesOfRetToCliqueTable = new int[ret.variableCount()];
                int i = 0;
                while (i < mappingOfIndexesOfRetToCliqueTable.length) {
                    mappingOfIndexesOfRetToCliqueTable[i] = cliqueTable.indexOfVariable((Node)ret.getVariableAt(i));
                    ++i;
                }
                int[] statesInCliqueTable = new int[cliqueTable.variableCount()];
                int[] statesInNewTable = new int[ret.variableCount()];
                int i2 = 0;
                while (i2 < cliqueTable.tableSize()) {
                    statesInCliqueTable = cliqueTable.getMultidimensionalCoord(i2, statesInCliqueTable);
                    int j = 0;
                    while (j < statesInNewTable.length) {
                        statesInNewTable[j] = statesInCliqueTable[mappingOfIndexesOfRetToCliqueTable[j]];
                        ++j;
                    }
                    ret.setValue(statesInNewTable, cliqueTable.getValue(i2));
                    ++i2;
                }
                statesInCliqueTable = null;
                statesInNewTable = null;
                mappingOfIndexesOfRetToCliqueTable = null;
                if (algorithm != null && (!(algorithm instanceof JunctionTreeAlgorithm) || !((JunctionTreeAlgorithm)algorithm).isAlgorithmWithNormalization())) break block39;
                int statesSizeOfMainNode = mainNode.getStatesSize();
                float sumOfColumn = 0.0f;
                int i3 = 0;
                while (i3 < ret.tableSize()) {
                    sumOfColumn += ret.getValue(i3);
                    if ((i3 + 1) % statesSizeOfMainNode == 0) {
                        if (!(sumOfColumn <= 0.0f)) {
                            int indexWithinColumn = i3 - statesSizeOfMainNode + 1;
                            while (indexWithinColumn <= i3) {
                                ret.setValue(indexWithinColumn, ret.getValue(indexWithinColumn) / sumOfColumn);
                                ++indexWithinColumn;
                            }
                        }
                        sumOfColumn = 0.0f;
                    }
                    ++i3;
                }
                break block39;
            }
            int retIndex = 0;
            for (Integer[] evidenceIndexes : new SharedArrayParentStatesIndexIterator(parentNodes)) {
                PotentialTable cloneCliqueTable = clique.getProbabilityFunction().getTemporaryClone();
                int parentIndex = 0;
                while (parentIndex < evidenceIndexes.length) {
                    float[] evidenceMarginal = new float[parentNodes.get(parentIndex).getStatesSize()];
                    int i = 0;
                    while (i < evidenceMarginal.length) {
                        evidenceMarginal[i] = 0.0f;
                        ++i;
                    }
                    evidenceMarginal[evidenceIndexes[parentIndex].intValue()] = 1.0f;
                    cliqueEvidenceUpdater.updateEvidenceWithinClique(clique, cloneCliqueTable, evidenceMarginal, (Node)parentNodes.get(parentIndex));
                    ++parentIndex;
                }
                if (algorithm == null || algorithm instanceof JunctionTreeAlgorithm && ((JunctionTreeAlgorithm)algorithm).isAlgorithmWithNormalization()) {
                    cloneCliqueTable.normalize();
                }
                int indexOfMainNode = cloneCliqueTable.indexOfVariable((Node)mainNode);
                int indForMarginal = 0;
                while (indForMarginal < clique.getProbabilityFunction().getVariablesSize()) {
                    if (indForMarginal != indexOfMainNode) {
                        cloneCliqueTable.removeVariable(clique.getProbabilityFunction().getVariableAt(indForMarginal));
                    }
                    ++indForMarginal;
                }
                int i = 0;
                while (i < cloneCliqueTable.tableSize()) {
                    ret.setValue(retIndex, cloneCliqueTable.getValue(i));
                    ++retIndex;
                    ++i;
                }
            }
        }
        return ret;
    }

    private Set<INode> getValidConditionNodesRec(INode mainNode, List<INode> includedParentNodes, Clique currentClique, Set<Clique> visitedCliques) {
        HashSet<INode> ret = new HashSet<INode>();
        if (visitedCliques == null) {
            visitedCliques = new HashSet<Clique>();
        } else if (visitedCliques.contains(currentClique)) {
            return ret;
        }
        visitedCliques.add(currentClique);
        if (currentClique.getNodes() != null && currentClique.getNodes().contains(mainNode)) {
            if (currentClique.getNodes().containsAll(includedParentNodes)) {
                ret.addAll(currentClique.getNodes());
                ret.remove(mainNode);
            }
            if (currentClique.getParent() != null) {
                ret.addAll(this.getValidConditionNodesRec(mainNode, includedParentNodes, currentClique.getParent(), visitedCliques));
            }
            if (currentClique.getChildren() != null) {
                for (Clique childClique : currentClique.getChildren()) {
                    ret.addAll(this.getValidConditionNodesRec(mainNode, includedParentNodes, childClique, visitedCliques));
                }
            }
        }
        return ret;
    }

    @Override
    public List<INode> getValidConditionNodes(INode mainNode, List<INode> includedParentNodes, Graph net, IInferenceAlgorithm algorithm) {
        if (includedParentNodes != null && mainNode != null && includedParentNodes.contains(mainNode)) {
            throw new IllegalArgumentException(mainNode + " cannot be conditioned to itself.");
        }
        try {
            if (mainNode instanceof TreeVariable) {
                TreeVariable treeVar = (TreeVariable)mainNode;
                IRandomVariable cliqueOrSep = treeVar.getAssociatedClique();
                if (cliqueOrSep instanceof Separator) {
                    Separator separator = (Separator)cliqueOrSep;
                    Set<INode> conditionNodes = this.getValidConditionNodesRec(mainNode, includedParentNodes, separator.getClique1(), null);
                    conditionNodes.addAll(this.getValidConditionNodesRec(mainNode, includedParentNodes, separator.getClique2(), null));
                    return new ArrayList<INode>(conditionNodes);
                }
                if (cliqueOrSep instanceof Clique) {
                    return new ArrayList<INode>(this.getValidConditionNodesRec(mainNode, includedParentNodes, (Clique)cliqueOrSep, null));
                }
            }
        }
        catch (Exception e) {
            Debug.println(this.getClass(), e.getMessage(), e);
        }
        HashSet<Node> ret = new HashSet<Node>();
        if (net != null && net instanceof SingleEntityNetwork) {
            HashSet<INode> nodes = new HashSet<INode>();
            if (includedParentNodes != null) {
                nodes.addAll(includedParentNodes);
            }
            if (mainNode != null) {
                nodes.add(mainNode);
            }
            nodes.remove(null);
            Collection<Clique> cliques = this.getCliquesContainingAllNodes((SingleEntityNetwork)net, nodes, Integer.MAX_VALUE);
            if (cliques != null) {
                for (Clique clique : cliques) {
                    ret.addAll(clique.getNodes());
                }
            }
        }
        ret.remove(mainNode);
        return new ArrayList<INode>(ret);
    }

    public Clique getCliqueContainingAllNodes(SingleEntityNetwork singleEntityNetwork, Collection<INode> nodes) {
        Collection<Clique> cliques = this.getCliquesContainingAllNodes(singleEntityNetwork, nodes, 1);
        if (cliques == null || cliques.isEmpty()) {
            return null;
        }
        return cliques.iterator().next();
    }

    public Collection<Clique> getCliquesContainingAllNodes(SingleEntityNetwork singleEntityNetwork, Collection<INode> nodes, int maxCount) {
        return singleEntityNetwork.getJunctionTree().getCliquesContainingAllNodes(nodes, maxCount);
    }

    public boolean isToOptimizeFullCliqueConditionalProbEvaluation() {
        return this.isToOptimizeFullCliqueConditionalProbEvaluation;
    }

    public void setToOptimizeFullCliqueConditionalProbEvaluation(boolean isToOptimizeFullCliqueConditionalProbEvaluation) {
        this.isToOptimizeFullCliqueConditionalProbEvaluation = isToOptimizeFullCliqueConditionalProbEvaluation;
    }

    public boolean isToJoinCliquesWhenNoCliqueFound() {
        return this.isToJoinCliquesWhenNoCliqueFound;
    }

    public void setToJoinCliquesWhenNoCliqueFound(boolean isToJoinCliquesWhenNoCliqueFound) {
        this.isToJoinCliquesWhenNoCliqueFound = isToJoinCliquesWhenNoCliqueFound;
    }

    public static interface CliqueEvidenceUpdater {
        public void updateEvidenceWithinClique(Clique var1, PotentialTable var2, float[] var3, Node var4);
    }

    public class NoCliqueException
    extends IllegalArgumentException {
        private static final long serialVersionUID = -5056812711980844824L;

        public NoCliqueException() {
        }

        public NoCliqueException(String message, Throwable cause) {
            super(message, cause);
        }

        public NoCliqueException(String s) {
            super(s);
        }

        public NoCliqueException(Throwable cause) {
            super(cause);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SharedArrayParentStatesIndexIterator
    implements Iterator<Integer[]>,
    Iterable<Integer[]> {
        private Integer[] array;
        private final List<INode> parents;

        public SharedArrayParentStatesIndexIterator(List<INode> parentNodes) {
            if (parentNodes == null) {
                throw new NullPointerException("parents == null");
            }
            if (parentNodes.size() <= 0) {
                throw new IllegalArgumentException("parents.size() == 0");
            }
            this.parents = parentNodes;
            this.array = new Integer[parentNodes.size()];
            int i = 0;
            while (i < this.array.length) {
                this.array[i] = 0;
                ++i;
            }
            this.array[0] = -1;
        }

        @Override
        public boolean hasNext() {
            int i = 0;
            while (i < this.array.length) {
                if (this.array[i] < this.parents.get(i).getStatesSize() - 1) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        @Override
        public Integer[] next() {
            int i = 0;
            while (i < this.array.length) {
                int n = i;
                this.array[n] = this.array[n] + 1;
                if (this.array[i] < this.parents.get(i).getStatesSize()) break;
                this.array[i] = 0;
                ++i;
            }
            return this.array;
        }

        @Override
        public void remove() {
        }

        @Override
        public Iterator<Integer[]> iterator() {
            return this;
        }
    }
}

