/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.bn.cpt.impl;

import java.util.Locale;
import java.util.ResourceBundle;
import unbbayes.prs.bn.ProbabilisticTable;
import unbbayes.prs.bn.cpt.ITableFunction;
import unbbayes.prs.bn.cpt.impl.resources.Resources;
import unbbayes.util.ResourceController;

public class NormalizeTableFunction
implements ITableFunction {
    private ResourceBundle resource;

    public NormalizeTableFunction() {
        try {
            this.resource = ResourceController.newInstance().getBundle(Resources.class.getName(), Locale.getDefault(), this.getClass().getClassLoader());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void applyFunction(ProbabilisticTable table) {
        float value;
        float[] totalSum = new float[table.tableSize()];
        int[] coord = new int[table.variableCount()];
        int i = 0;
        while (i < table.tableSize()) {
            value = table.getValue(i);
            coord = table.getMultidimensionalCoord(i);
            coord[0] = 0;
            int n = table.getLinearCoord(coord);
            totalSum[n] = totalSum[n] + value;
            ++i;
        }
        i = 0;
        while (i < table.tableSize()) {
            coord = table.getMultidimensionalCoord(i);
            coord[0] = 0;
            value = (double)totalSum[table.getLinearCoord(coord)] == 0.0 ? 1.0f / (float)table.getVariableAt(0).getStatesSize() : table.getValue(i) / totalSum[table.getLinearCoord(coord)];
            table.setValue(i, value);
            ++i;
        }
    }

    public String getFunctionName() {
        return this.resource.getString("normalizeFunction");
    }

    public String toString() {
        return this.getFunctionName();
    }

    public int compareTo(ITableFunction o) {
        return this.toString().compareTo(o.toString());
    }
}

