/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.bn.cpt.impl;

import java.util.Locale;
import java.util.ResourceBundle;
import unbbayes.prs.bn.ProbabilisticTable;
import unbbayes.prs.bn.cpt.ITableFunction;
import unbbayes.prs.bn.cpt.impl.resources.Resources;
import unbbayes.util.ResourceController;

public class UniformTableFunction
implements ITableFunction {
    private ResourceBundle resource;

    public UniformTableFunction() {
        try {
            this.resource = ResourceController.newInstance().getBundle(Resources.class.getName(), Locale.getDefault(), this.getClass().getClassLoader());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void applyFunction(ProbabilisticTable table) {
        int nStates = table.getVariableAt(0).getStatesSize();
        float value = 1.0f / (float)nStates;
        int i = 0;
        while (i < table.tableSize()) {
            table.setValue(i, value);
            ++i;
        }
    }

    public String getFunctionName() {
        return this.resource.getString("uniformFunction");
    }

    public String toString() {
        return this.getFunctionName();
    }

    public int compareTo(ITableFunction o) {
        return this.toString().compareTo(o.toString());
    }
}

