/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.builder.impl;

import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.builder.INodeBuilder;
import unbbayes.prs.builder.IProbabilisticNetworkBuilder;
import unbbayes.prs.builder.impl.DefaultDecisionNodeBuilder;
import unbbayes.prs.builder.impl.DefaultProbabilisticNodeBuilder;
import unbbayes.prs.builder.impl.DefaultUtilityNodeBuilder;

public class DefaultProbabilisticNetworkBuilder
implements IProbabilisticNetworkBuilder {
    private INodeBuilder probabilisticNodeBuilder = DefaultProbabilisticNodeBuilder.newInstance();
    private INodeBuilder decisionNodeBuilder = DefaultDecisionNodeBuilder.newInstance();
    private INodeBuilder utilityNodeBuilder = DefaultUtilityNodeBuilder.newInstance();
    private INodeBuilder continuousNodeBuilder = null;

    protected DefaultProbabilisticNetworkBuilder() {
    }

    public static DefaultProbabilisticNetworkBuilder newInstance() {
        return new DefaultProbabilisticNetworkBuilder();
    }

    public static DefaultProbabilisticNetworkBuilder newInstance(INodeBuilder probabilisticNodeBuilder, INodeBuilder decisionNodeBuilder, INodeBuilder utilityNodeBuilder) {
        DefaultProbabilisticNetworkBuilder ret = new DefaultProbabilisticNetworkBuilder();
        if (decisionNodeBuilder != null) {
            ret.setDecisionNodeBuilder(decisionNodeBuilder);
        }
        if (probabilisticNodeBuilder != null) {
            ret.setProbabilisticNodeBuilder(probabilisticNodeBuilder);
        }
        if (utilityNodeBuilder != null) {
            ret.setUtilityNodeBuilder(utilityNodeBuilder);
        }
        return ret;
    }

    public ProbabilisticNetwork buildNetwork(String name) {
        return new ProbabilisticNetwork(name);
    }

    public INodeBuilder getDecisionNodeBuilder() {
        return this.decisionNodeBuilder;
    }

    public INodeBuilder getProbabilisticNodeBuilder() {
        return this.probabilisticNodeBuilder;
    }

    public INodeBuilder getUtilityNodeBuilder() {
        return this.utilityNodeBuilder;
    }

    public void setDecisionNodeBuilder(INodeBuilder builder) {
        this.decisionNodeBuilder = builder;
    }

    public void setProbabilisticNodeBuilder(INodeBuilder builder) {
        this.probabilisticNodeBuilder = builder;
    }

    public void setUtilityNodeBuilder(INodeBuilder builder) {
        this.utilityNodeBuilder = builder;
    }

    public INodeBuilder getContinuousNodeBuilder() {
        return this.continuousNodeBuilder;
    }

    public void setContinuousNodeBuilder(INodeBuilder builder) {
        this.continuousNodeBuilder = builder;
    }
}

