/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.hybridbn;

import java.awt.Color;
import java.io.Serializable;
import java.util.ResourceBundle;
import unbbayes.prs.Node;
import unbbayes.prs.bn.TreeVariable;
import unbbayes.prs.exception.InvalidParentException;
import unbbayes.prs.hybridbn.CNNormalDistribution;
import unbbayes.prs.hybridbn.resources.HybridBnResources;
import unbbayes.util.ResourceController;

public class ContinuousNode
extends TreeVariable
implements Serializable {
    public static final int MEAN_MARGINAL_INDEX = 0;
    public static final int VARIANCE_MARGINAL_INDEX = 1;
    private static Color staticColor = Color.GREEN;
    private static final long serialVersionUID = 1L;
    private CNNormalDistribution cnNormalDistribution;
    private ResourceBundle resource = ResourceController.newInstance().getBundle(HybridBnResources.class.getName());

    public int getType() {
        return 5;
    }

    public static Color getStaticColor() {
        return staticColor;
    }

    public ContinuousNode() {
        this.cnNormalDistribution = new CNNormalDistribution(this);
        this.appendState(this.resource.getString("meanName"));
        this.appendState(this.resource.getString("varianceName"));
        this.setColor(staticColor);
    }

    public CNNormalDistribution getCnNormalDistribution() {
        return this.cnNormalDistribution;
    }

    protected void marginal() {
    }

    public void addParent(Node parent) throws InvalidParentException {
        if (parent.getType() != 0 && parent.getType() != 5) {
            throw new InvalidParentException(this.resource.getString("continuousNodeInvalidParentException"));
        }
        super.addParent(parent);
        this.cnNormalDistribution.refreshParents();
    }

    public void removeParent(Node parent) {
        super.removeParent(parent);
        this.cnNormalDistribution.refreshParents();
    }

    public void addChild(Node child) throws InvalidParentException {
        if (child.getType() != 5) {
            throw new InvalidParentException(this.resource.getString("continuousNodeInvalidParentException"));
        }
        super.addChild(child);
        this.cnNormalDistribution.refreshParents();
    }

    public void removeChild(Node child) {
        super.removeChild(child);
        this.cnNormalDistribution.refreshParents();
    }

    public ContinuousNode getClone() {
        ContinuousNode node = new ContinuousNode();
        super.clone(node);
        return node;
    }
}

