/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.id;

import java.awt.Color;
import java.io.Serializable;
import java.util.ResourceBundle;
import unbbayes.prs.Node;
import unbbayes.prs.bn.IProbabilityFunction;
import unbbayes.prs.bn.IRandomVariable;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.cpt.IProbabilityFunctionAdapter;
import unbbayes.prs.bn.resources.BnResources;
import unbbayes.prs.id.UtilityTable;
import unbbayes.util.ResourceController;

public class UtilityNode
extends Node
implements IRandomVariable,
IProbabilityFunctionAdapter,
Serializable {
    private static final long serialVersionUID = 0L;
    private PotentialTable utilTable;
    private static Color color = Color.cyan;
    private static ResourceBundle resource = ResourceController.newInstance().getBundle(BnResources.class.getName());
    private int internalIdentificator = Integer.MIN_VALUE;

    public UtilityNode() {
        this.setColor(Color.cyan);
        this.utilTable = new UtilityTable();
        this.states.add(resource.getString("utilityName"));
    }

    public int getType() {
        return 1;
    }

    public void appendState(String state) {
        if (this.getStatesSize() < 1) {
            super.appendState(state);
        }
    }

    public void removeLastState() {
    }

    public PotentialTable getProbabilityFunction() {
        return this.utilTable;
    }

    public static Color getStaticColor() {
        return color;
    }

    public static void setStaticColor(int rgb) {
        color = new Color(rgb);
    }

    public int getInternalIdentificator() {
        return this.internalIdentificator;
    }

    public void setInternalIdentificator(int internalIdentificator) {
        this.internalIdentificator = internalIdentificator;
    }

    public void loadProbabilityFunction(IProbabilityFunction probabilityFunction) {
        if (probabilityFunction instanceof UtilityTable) {
            PotentialTable util = ((UtilityTable)probabilityFunction).getTemporaryClone();
            PotentialTable myTable = this.getProbabilityFunction();
            float[] temp = new float[myTable.tableSize()];
            System.arraycopy(util.getValues(), 0, temp, 0, myTable.tableSize());
            myTable.setValues(temp);
        }
    }

    public UtilityNode getClone() {
        UtilityNode clone = new UtilityNode();
        super.clone(clone);
        clone.loadProbabilityFunction(this.getProbabilityFunction());
        return clone;
    }
}

