/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.id;

import java.io.Serializable;
import unbbayes.prs.INode;
import unbbayes.prs.Node;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.id.DecisionNode;

public class UtilityTable
extends PotentialTable
implements Serializable {
    private static final long serialVersionUID = 0L;

    public PotentialTable newInstance() {
        return new UtilityTable();
    }

    public void removeVariable(INode variavel) {
        this.computeFactors();
        int index = this.variableList.indexOf(variavel);
        if (index < 0) {
            return;
        }
        if (variavel.getType() == 0) {
            this.sum(index);
        } else {
            DecisionNode decision = (DecisionNode)variavel;
            if (decision.hasEvidence()) {
                this.finding(this.variableList.size() - 1, index, new int[this.variableList.size()], decision.getEvidence());
            } else {
                this.argMax(this.variableList.size() - 1, index, new int[this.variableList.size()]);
            }
        }
        this.notifyModification();
        this.variableList.remove(index);
    }

    public void removeVariable(INode variable, boolean normalize) {
        this.removeVariable(variable);
    }

    public void purgeVariable(INode variable, boolean normalize) {
        this.removeVariable(variable);
    }

    protected void argMax(int control, int index, int[] coord) {
        if (control == -1) {
            float value;
            int linearCoordToKill = this.getLinearCoord(coord);
            int linearCoordDestination = linearCoordToKill - coord[index] * this.factorsPT[index];
            this.dataPT.data[linearCoordDestination] = value = Math.max(this.dataPT.data[linearCoordDestination], this.dataPT.data[linearCoordToKill]);
            this.dataPT.remove(linearCoordToKill);
            return;
        }
        int fim = index == control ? 1 : 0;
        Node node = (Node)this.variableList.get(control);
        int i = node.getStatesSize() - 1;
        while (i >= fim) {
            coord[control] = i--;
            this.argMax(control - 1, index, coord);
        }
    }

    public PotentialTable getTemporaryClone() {
        return (PotentialTable)this.clone();
    }
}

