/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.simulation.likelihoodweighting.sampling;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.simulation.likelihoodweighting.ILikelihoodWeightingSampling;
import unbbayes.simulation.montecarlo.sampling.MatrixMonteCarloSampling;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LikelihoodWeightingSampling
extends MatrixMonteCarloSampling
implements ILikelihoodWeightingSampling {
    protected List<Node> evidenceNodeList;
    protected float[] probabilityEvidenceGivenParentList;

    @Override
    public float[] getFullStatesSetWeight() {
        return this.probabilityEvidenceGivenParentList;
    }

    @Override
    public void start(ProbabilisticNetwork pn, int nTrials) {
        this.probabilityEvidenceGivenParentList = new float[nTrials];
        int i = 0;
        while (i < this.probabilityEvidenceGivenParentList.length) {
            this.probabilityEvidenceGivenParentList[i] = 1.0f;
            ++i;
        }
        super.start(pn, nTrials);
    }

    @Override
    protected void simulate(int nTrial) {
        ArrayList<Integer> parentsIndexes = new ArrayList();
        int[] sampledStates = new int[this.samplingNodeOrderQueue.size()];
        int i = 0;
        while (i < this.samplingNodeOrderQueue.size()) {
            ProbabilisticNode node = (ProbabilisticNode)this.samplingNodeOrderQueue.get(i);
            parentsIndexes = this.getParentsIndexesInQueue(node);
            double[] pmf = this.getProbabilityMassFunction(sampledStates, parentsIndexes, node);
            if (node.hasEvidence()) {
                sampledStates[i] = node.getEvidence();
                int n = nTrial;
                this.probabilityEvidenceGivenParentList[n] = (float)((double)this.probabilityEvidenceGivenParentList[n] * pmf[sampledStates[i]]);
            } else {
                sampledStates[i] = this.getState(pmf);
            }
            this.sampledStatesMatrix[nTrial][i] = (byte)sampledStates[i];
            ++i;
        }
    }

    @Override
    public float[] getCompactStatesSetWeight() {
        return null;
    }

    @Override
    public Map<Integer, Float> getMapStatesSetWeight() {
        return null;
    }
}

