/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.simulation.montecarlo.sampling;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import unbbayes.prs.Node;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.simulation.montecarlo.sampling.IMonteCarloSampling;
import unbbayes.util.longtask.ILongTaskProgressObserver;
import unbbayes.util.longtask.LongTaskProgressChangedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AMonteCarloSampling
implements IMonteCarloSampling {
    private List<ILongTaskProgressObserver> observers = new ArrayList<ILongTaskProgressObserver>();
    protected int maxProgress = 100;
    protected int currentProgress = 0;
    protected String currentProgressStatus = "";
    protected ProbabilisticNetwork pn;
    protected int nTrials;
    protected List<Node> samplingNodeOrderQueue;
    protected Map<Integer, Integer> sampledStatesMap;
    private long elapsedTimeMillis = Long.MAX_VALUE;
    protected byte[][] sampledStatesMatrix = null;
    protected int[] timesSampled = null;
    protected int[] factors;

    @Override
    public void registerObserver(ILongTaskProgressObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void removeObserver(ILongTaskProgressObserver observer) {
        this.observers.remove(observer);
    }

    @Override
    public void notityObservers(LongTaskProgressChangedEvent event) {
        for (ILongTaskProgressObserver observer : this.observers) {
            observer.update(event);
        }
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    @Override
    public int getCurrentProgress() {
        return this.currentProgress;
    }

    @Override
    public int getPercentageDone() {
        return Math.round((float)this.currentProgress / (float)this.maxProgress * 10000.0f);
    }

    @Override
    public String getCurrentProgressStatus() {
        return this.currentProgressStatus;
    }

    protected void updateProgress(int progress, String progressStatus) {
        this.currentProgress = progress;
        this.currentProgressStatus = progressStatus;
        int step = (int)((double)this.maxProgress * 0.01 / 3.0);
        if (step > 0 && this.currentProgress % step == 0 && this.getPercentageDone() < 9800) {
            LongTaskProgressChangedEvent event = new LongTaskProgressChangedEvent(this.getCurrentProgressStatus(), this.getPercentageDone());
            this.notityObservers(event);
        }
    }

    protected void updateProgress(int progress) {
        this.updateProgress(progress, "");
    }

    @Override
    public abstract byte[][] getSampledStatesMatrix();

    @Override
    public abstract byte[][] getSampledStatesCompactMatrix();

    @Override
    public abstract int[] getStatesSetTimesSampled();

    @Override
    public abstract Map<Integer, Integer> getSampledStatesMap();

    @Override
    public abstract void start(ProbabilisticNetwork var1, int var2);

    public void start(ProbabilisticNetwork pn, int nTrials, long elapsedTimeMillis) {
        this.start(pn, nTrials);
    }

    @Override
    public List<Node> getSamplingNodeOrderQueue() {
        return this.samplingNodeOrderQueue;
    }

    protected void createSamplingOrderQueue() {
        boolean[] nodeAddedList = new boolean[this.pn.getNodeCount()];
        boolean allNodesInQueue = false;
        this.initSamplingOrderQueue(nodeAddedList);
        while (!allNodesInQueue) {
            allNodesInQueue = true;
            int i = 0;
            while (i < this.pn.getNodeCount()) {
                if (!nodeAddedList[i]) {
                    Node node = this.pn.getNodeAt(i);
                    boolean allParentsInQueue = true;
                    for (Node parent : node.getParents()) {
                        int j = 0;
                        while (j < this.pn.getNodeCount()) {
                            Node testNode = this.pn.getNodeAt(j);
                            if (parent.getName().equals(testNode.getName()) && !nodeAddedList[j]) {
                                allParentsInQueue = false;
                                break;
                            }
                            ++j;
                        }
                        if (!allParentsInQueue) break;
                    }
                    if (allParentsInQueue) {
                        int j = 0;
                        while (j < this.pn.getNodeCount()) {
                            Node testNode = this.pn.getNodeAt(j);
                            if (node.getName().equals(testNode.getName())) {
                                nodeAddedList[i] = true;
                                this.samplingNodeOrderQueue.add(node);
                            }
                            ++j;
                        }
                    } else {
                        allNodesInQueue = false;
                    }
                }
                ++i;
            }
        }
    }

    protected void initSamplingOrderQueue(boolean[] nodeAddedList) {
        int i = 0;
        while (i < this.pn.getNodeCount()) {
            if (this.pn.getNodeAt(i).getParents().size() == 0) {
                nodeAddedList[i] = true;
                this.samplingNodeOrderQueue.add(this.pn.getNodeAt(i));
                System.out.println(this.pn.getNodeAt(i));
            }
            ++i;
        }
    }

    protected void addToSamplingOrderQueue(ArrayList<Node> children, boolean[] nodeAddedList) {
        int i = 0;
        while (i < children.size()) {
            Node n1 = children.get(i);
            int j = 0;
            while (j < this.pn.getNodeCount()) {
                Node n2 = this.pn.getNodeAt(j);
                if (n1.getName().equals(n2.getName()) && !nodeAddedList[j]) {
                    this.samplingNodeOrderQueue.add(n1);
                    System.out.println(n1);
                    nodeAddedList[j] = true;
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    protected List<Integer> getParentsIndexesInQueue(ProbabilisticNode node) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        ArrayList<Node> parents = node.getParents();
        int i = 0;
        while (i < parents.size()) {
            Node parentNode = parents.get(i);
            indexes.add(this.getIndexInQueue(parentNode));
            ++i;
        }
        return indexes;
    }

    protected Integer getIndexInQueue(Node node) {
        int i = 0;
        while (i < this.samplingNodeOrderQueue.size()) {
            if (node.getName().equals(this.samplingNodeOrderQueue.get(i).getName())) {
                return i;
            }
            ++i;
        }
        return null;
    }

    protected byte getState(double[] pmf) {
        double numero = Math.random();
        double[][] cdf = this.getCumulativeDistributionFunction(pmf);
        byte i = 0;
        while (i < cdf.length) {
            if (i == 0 ? numero <= cdf[i][1] : (i == cdf.length - 1 ? numero > cdf[i][0] : numero <= cdf[i][1] && numero > cdf[i][0])) {
                return i;
            }
            i = (byte)(i + 1);
        }
        return -1;
    }

    protected double[][] getCumulativeDistributionFunction(double[] pmf) {
        double[][] cdf = new double[pmf.length][2];
        double atual = 0.0;
        int i = 0;
        while (i < pmf.length) {
            cdf[i][0] = atual;
            cdf[i][1] = pmf[i] + atual;
            atual = cdf[i][1];
            ++i;
        }
        return cdf;
    }

    protected double[] getProbabilityMassFunction(int[] sampledStates, List<Integer> parentsIndexes, ProbabilisticNode node) {
        PotentialTable pt = node.getProbabilityFunction();
        int statesSize = node.getStatesSize();
        double[] pmf = new double[statesSize];
        int[] coordinates = new int[parentsIndexes.size() + 1];
        int i = 0;
        while (i < node.getStatesSize()) {
            coordinates[0] = i;
            if (i == 0) {
                int j = 0;
                while (j < parentsIndexes.size()) {
                    int nodeIndex = parentsIndexes.get(j);
                    coordinates[pt.indexOfVariable((Node)this.samplingNodeOrderQueue.get((int)nodeIndex))] = sampledStates[nodeIndex];
                    ++j;
                }
            }
            pmf[i] = pt.getValue(coordinates);
            ++i;
        }
        return pmf;
    }

    protected void computeFactors() {
        int size = this.samplingNodeOrderQueue.size();
        if (this.factors == null || this.factors.length != size) {
            this.factors = new int[size];
        }
        this.factors[0] = 1;
        int i = 1;
        while (i < size) {
            Node node = this.samplingNodeOrderQueue.get(i - 1);
            this.factors[i] = this.factors[i - 1] * node.getStatesSize();
            ++i;
        }
    }

    @Override
    public int getLinearCoord(int[] multidimensionalCoord) {
        this.computeFactors();
        int coordLinear = 0;
        int size = this.samplingNodeOrderQueue.size();
        int v = 0;
        while (v < size) {
            coordLinear += multidimensionalCoord[v] * this.factors[v];
            ++v;
        }
        return coordLinear;
    }

    @Override
    public byte[] getMultidimensionalCoord(int linearCoord) {
        this.computeFactors();
        int size = this.samplingNodeOrderQueue.size();
        byte[] multidimensionalCoord = new byte[size];
        int i = size - 1;
        while (linearCoord != 0) {
            int factorI = this.factors[i];
            multidimensionalCoord[i--] = (byte)(linearCoord / factorI);
            linearCoord %= factorI;
        }
        return multidimensionalCoord;
    }

    public long getElapsedTimeMillis() {
        return this.elapsedTimeMillis;
    }

    public void setElapsedTimeMillis(long elapsedTimeMillis) {
        this.elapsedTimeMillis = elapsedTimeMillis;
    }
}

