/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.simulation.montecarlo.sampling;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.simulation.montecarlo.sampling.AMonteCarloSampling;
import unbbayes.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapMonteCarloSampling
extends AMonteCarloSampling {
    @Override
    public byte[][] getSampledStatesMatrix() {
        byte[][] sampledStatesMatrix = new byte[this.nTrials][this.samplingNodeOrderQueue.size()];
        int index = 0;
        Set keySet = this.sampledStatesMap.keySet();
        for (Integer key : keySet) {
            byte[] sampledStates = this.getMultidimensionalCoord(key);
            int value = (Integer)this.sampledStatesMap.get(key);
            int i = 0;
            while (i < value) {
                int j = 0;
                while (j < sampledStates.length) {
                    sampledStatesMatrix[index][j] = sampledStates[j];
                    ++j;
                }
                ++index;
                ++i;
            }
        }
        return sampledStatesMatrix;
    }

    @Override
    public byte[][] getSampledStatesCompactMatrix() {
        if (this.sampledStatesMatrix == null) {
            this.sampledStatesMatrix = new byte[this.sampledStatesMap.size()][this.samplingNodeOrderQueue.size()];
            this.timesSampled = new int[this.sampledStatesMap.size()];
            int index = 0;
            Set keySet = this.sampledStatesMap.keySet();
            for (Integer key : keySet) {
                byte[] sampledStates = this.getMultidimensionalCoord(key);
                int value = (Integer)this.sampledStatesMap.get(key);
                int j = 0;
                while (j < sampledStates.length) {
                    this.sampledStatesMatrix[index][j] = sampledStates[j];
                    ++j;
                }
                this.timesSampled[index++] = value;
            }
        }
        return this.sampledStatesMatrix;
    }

    @Override
    public int[] getStatesSetTimesSampled() {
        if (this.sampledStatesMatrix == null) {
            this.getSampledStatesCompactMatrix();
        }
        return this.timesSampled;
    }

    @Override
    public Map<Integer, Integer> getSampledStatesMap() {
        return this.sampledStatesMap;
    }

    @Override
    public void start(ProbabilisticNetwork pn, int nTrials) {
        this.start(pn, nTrials, Long.MAX_VALUE);
    }

    @Override
    public void start(ProbabilisticNetwork pn, int nTrials, long elapsedTimeMillis) {
        this.pn = pn;
        this.nTrials = nTrials;
        this.sampledStatesMap = new HashMap();
        this.samplingNodeOrderQueue = new ArrayList();
        this.createSamplingOrderQueue();
        int[] sampledStates = null;
        long timeBeforeExecution = System.currentTimeMillis();
        int i = 0;
        while (i < nTrials) {
            sampledStates = this.simulate();
            int key = this.getLinearCoord(sampledStates);
            Integer value = (Integer)this.sampledStatesMap.get(key);
            if (value != null) {
                value = value + 1;
                this.sampledStatesMap.put(key, value);
            } else {
                this.sampledStatesMap.put(key, 1);
            }
            if (System.currentTimeMillis() - timeBeforeExecution > elapsedTimeMillis) {
                Debug.println(this.getClass(), "Finished sampling, because exceeded " + elapsedTimeMillis + " ms.");
                break;
            }
            ++i;
        }
    }

    protected int[] simulate() {
        ArrayList<Integer> parentsIndexes = new ArrayList();
        int[] sampledStates = new int[this.samplingNodeOrderQueue.size()];
        int i = 0;
        while (i < this.samplingNodeOrderQueue.size()) {
            ProbabilisticNode node = (ProbabilisticNode)this.samplingNodeOrderQueue.get(i);
            parentsIndexes = this.getParentsIndexesInQueue(node);
            double[] pmf = this.getProbabilityMassFunction(sampledStates, parentsIndexes, node);
            sampledStates[i] = this.getState(pmf);
            ++i;
        }
        return sampledStates;
    }
}

