/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.simulation.montecarlo.sampling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.simulation.montecarlo.sampling.AMonteCarloSampling;
import unbbayes.simulation.montecarlo.sampling.SampleGenerationListener;
import unbbayes.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatrixMonteCarloSampling
extends AMonteCarloSampling {
    private List<SampleGenerationListener> sampleGenerationListener = null;

    @Override
    public byte[][] getSampledStatesCompactMatrix() {
        return null;
    }

    @Override
    public int[] getStatesSetTimesSampled() {
        return null;
    }

    @Override
    public Map<Integer, Integer> getSampledStatesMap() {
        return null;
    }

    @Override
    public byte[][] getSampledStatesMatrix() {
        return this.sampledStatesMatrix;
    }

    @Override
    public void start(ProbabilisticNetwork pn, int nTrials) {
        this.start(pn, nTrials, Long.MAX_VALUE);
    }

    @Override
    public void start(ProbabilisticNetwork pn, int nTrials, long elapsedTimeMillis) {
        this.pn = pn;
        this.nTrials = nTrials;
        this.maxProgress = nTrials;
        this.samplingNodeOrderQueue = new ArrayList();
        this.createSamplingOrderQueue();
        this.sampledStatesMatrix = new byte[nTrials][pn.getNodeCount()];
        long startingTimeMillis = System.currentTimeMillis();
        int i = 0;
        while (i < nTrials) {
            this.updateProgress(i);
            this.simulate(i);
            if (System.currentTimeMillis() - startingTimeMillis > elapsedTimeMillis) {
                Debug.println(this.getClass(), "Stopping simulation because it exeeded time limit of " + elapsedTimeMillis + " ms.");
                break;
            }
            if (this.sampleGenerationListener != null) {
                for (SampleGenerationListener listener : this.sampleGenerationListener) {
                    if (listener.onSampleGenerated(this, i)) continue;
                    i = nTrials;
                }
            }
            ++i;
        }
    }

    protected void simulate(int nTrial) {
        ArrayList<Integer> parentsIndexes = new ArrayList();
        int[] sampledStates = new int[this.samplingNodeOrderQueue.size()];
        int i = 0;
        while (i < this.samplingNodeOrderQueue.size()) {
            ProbabilisticNode node = (ProbabilisticNode)this.samplingNodeOrderQueue.get(i);
            parentsIndexes = this.getParentsIndexesInQueue(node);
            double[] pmf = this.getProbabilityMassFunction(sampledStates, parentsIndexes, node);
            sampledStates[i] = this.getState(pmf);
            this.sampledStatesMatrix[nTrial][i] = (byte)sampledStates[i];
            ++i;
        }
    }

    public List<SampleGenerationListener> getSampleGenerationListener() {
        if (this.sampleGenerationListener == null) {
            return Collections.emptyList();
        }
        return new ArrayList<SampleGenerationListener>(this.sampleGenerationListener);
    }

    public void addSampleGenerationListener(SampleGenerationListener listener) {
        if (this.sampleGenerationListener == null) {
            this.sampleGenerationListener = new ArrayList<SampleGenerationListener>();
        }
        this.sampleGenerationListener.add(listener);
    }

    public boolean removeSampleGenerationListener(SampleGenerationListener listener) {
        if (this.sampleGenerationListener != null) {
            return this.sampleGenerationListener.remove(listener);
        }
        return false;
    }

    protected void setSampleGenerationListener(List<SampleGenerationListener> sampleGenerationListener) {
        this.sampleGenerationListener = sampleGenerationListener;
    }
}

