/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import unbbayes.prs.Network;
import unbbayes.prs.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphLayoutUtil {
    protected Network network;
    protected List<List<Node>> graphLevelMatrix;
    protected HashMap<Node, Integer> nodeIndexMap;
    protected boolean[] nodeAddedList;
    protected int[] nodeLevelList;

    public GraphLayoutUtil(Network network) {
        this.network = network;
        this.graphLevelMatrix = new ArrayList<List<Node>>();
        this.createGraphLevelMatrix();
    }

    public void doLayout() {
        int i = 0;
        while (i < this.graphLevelMatrix.size()) {
            List<Node> nodeList = this.graphLevelMatrix.get(i);
            double y = i * 150 + 20;
            int j = 0;
            while (j < nodeList.size()) {
                double x = j * 300 + 50;
                nodeList.get(j).setPosition(x, y);
                ++j;
            }
            ++i;
        }
    }

    protected void createGraphLevelMatrix() {
        this.nodeIndexMap = new HashMap();
        this.nodeAddedList = new boolean[this.network.getNodeCount()];
        this.nodeLevelList = new int[this.network.getNodeCount()];
        this.initGraphLevelMatrix();
        do {
            List<Node> currentLevelList = this.graphLevelMatrix.get(this.graphLevelMatrix.size() - 1);
            ArrayList<Node> nextLevelList = new ArrayList<Node>();
            int i = 0;
            while (i < currentLevelList.size()) {
                Node node = currentLevelList.get(i);
                this.addChildrenToNextLevel(node.getChildren(), nextLevelList);
                ++i;
            }
            if (nextLevelList.size() <= 0) continue;
            this.graphLevelMatrix.add(nextLevelList);
        } while (!this.wereAllNodesAdded());
    }

    protected boolean wereAllNodesAdded() {
        int i = 0;
        while (i < this.network.getNodeCount()) {
            if (!this.nodeAddedList[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void initGraphLevelMatrix() {
        ArrayList<Node> nodeList = new ArrayList<Node>();
        int i = 0;
        while (i < this.network.getNodeCount()) {
            Node node = this.network.getNodeAt(i);
            this.nodeIndexMap.put(node, i);
            if (node.getParents().size() == 0) {
                this.nodeAddedList[i] = true;
                this.nodeLevelList[i] = 0;
                nodeList.add(this.network.getNodeAt(i));
            }
            ++i;
        }
        this.graphLevelMatrix.add(nodeList);
    }

    protected boolean addChildrenToNextLevel(ArrayList<Node> children, List<Node> nodeList) {
        boolean wasNodeAdded = false;
        int currentLevel = this.graphLevelMatrix.size();
        int i = 0;
        while (i < children.size()) {
            Node child = children.get(i);
            int childIndex = this.nodeIndexMap.get(child);
            if (!this.nodeAddedList[childIndex]) {
                ArrayList<Node> allParents = child.getParents();
                boolean allParentsAdded = true;
                boolean allParentsInDifferentLevels = true;
                int j = 0;
                while (j < allParents.size()) {
                    int parentIndex = this.nodeIndexMap.get(allParents.get(j));
                    if (!this.nodeAddedList[parentIndex]) {
                        allParentsAdded = false;
                        break;
                    }
                    if (this.nodeLevelList[parentIndex] == currentLevel) {
                        allParentsInDifferentLevels = false;
                        break;
                    }
                    ++j;
                }
                if (allParentsAdded && allParentsInDifferentLevels) {
                    nodeList.add(child);
                    this.nodeAddedList[childIndex] = true;
                    this.nodeLevelList[childIndex] = currentLevel;
                    wasNodeAdded = true;
                }
            }
            ++i;
        }
        return wasNodeAdded;
    }
}

