/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;
import unbbayes.gui.resources.GuiResources;
import unbbayes.util.Debug;
import unbbayes.util.extension.manager.UnBBayesPluginContextHolder;

public class ResourceController {
    public static ResourceBundle RS_GUI = ResourceController.newInstance().getBundle(GuiResources.class.getName());
    private UnBBayesPluginContextHolder unbbayesPluginContextHolder = UnBBayesPluginContextHolder.newInstance();
    private ClassLoader defaultClassLoader = this.getClass().getClassLoader();
    private Locale defaultLocale = Locale.getDefault();
    private String extensionPointID = "ResourceBundle";

    protected ResourceController() {
        this.setDefaultClassLoader(this.loadPluginClassLoader());
        UnBBayesPluginContextHolder.newInstance().addListener(new UnBBayesPluginContextHolder.OnReloadActionListener(){

            public void onReload(EventObject eventObject) {
                ResourceController.newInstance().setDefaultClassLoader(ResourceController.newInstance().loadPluginClassLoader());
            }
        });
    }

    protected synchronized ClassLoader loadPluginClassLoader() {
        try {
            if (!this.getUnBBayesPluginContextHolder().isInitialized()) {
                this.getUnBBayesPluginContextHolder().publishPlugins();
            }
            PluginDescriptor core = this.getUnBBayesPluginContextHolder().getPluginManager().getRegistry().getPluginDescriptor(this.getUnBBayesPluginContextHolder().getPluginCoreID());
            ListClassLoaderDelegator ret = new ListClassLoaderDelegator(new ArrayList<ClassLoader>());
            for (ExtensionPoint point : core.getExtensionPoints()) {
                try {
                    for (Extension ext : point.getConnectedExtensions()) {
                        PluginDescriptor descr = null;
                        try {
                            descr = ext.getDeclaringPluginDescriptor();
                            this.getUnBBayesPluginContextHolder().getPluginManager().activatePlugin(descr.getId());
                            PluginClassLoader loader = this.getUnBBayesPluginContextHolder().getPluginManager().getPluginClassLoader(descr);
                            if (loader == null) continue;
                            ret.getListOfLoaders().add((ClassLoader)loader);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            if (ret.getListOfLoaders().isEmpty()) {
                ret.getListOfLoaders().add(this.getClass().getClassLoader());
            }
            return ret;
        }
        catch (Throwable e) {
            Debug.println(this.getClass(), "Exception loading plugin resources", e);
            return this.getDefaultClassLoader();
        }
    }

    public static ResourceController newInstance() {
        return SingletonHolder.INSTANCE;
    }

    public ClassLoader getDefaultClassLoader() {
        return this.defaultClassLoader;
    }

    public void setDefaultClassLoader(ClassLoader defaultClassLoader) {
        this.defaultClassLoader = defaultClassLoader;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public ResourceBundle getBundle(String baseName) {
        return ResourceBundle.getBundle(baseName, this.getDefaultLocale(), this.getDefaultClassLoader());
    }

    public ResourceBundle getBundle(String baseName, Locale locale, ClassLoader classLoader) {
        return ResourceBundle.getBundle(baseName, locale, classLoader);
    }

    public String getExtensionPointID() {
        return this.extensionPointID;
    }

    public void setExtensionPointID(String extensionPointID) {
        this.extensionPointID = extensionPointID;
    }

    public UnBBayesPluginContextHolder getUnBBayesPluginContextHolder() {
        return this.unbbayesPluginContextHolder;
    }

    public void setUnBBayesPluginContextHolder(UnBBayesPluginContextHolder unbbayesPluginContextHolder) {
        this.unbbayesPluginContextHolder = unbbayesPluginContextHolder;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ListClassLoaderDelegator
    extends ClassLoader {
        private List<ClassLoader> listOfLoaders;

        public ListClassLoaderDelegator(List<ClassLoader> listOfLoaders) {
            this.setListOfLoaders(listOfLoaders);
        }

        public List<ClassLoader> getListOfLoaders() {
            return this.listOfLoaders;
        }

        public void setListOfLoaders(List<ClassLoader> listOfLoaders) {
            this.listOfLoaders = listOfLoaders;
        }

        @Override
        public synchronized void clearAssertionStatus() {
            for (ClassLoader loader : this.getListOfLoaders()) {
                loader.clearAssertionStatus();
            }
            this.getClass().getClassLoader().clearAssertionStatus();
        }

        @Override
        public URL getResource(String name) {
            for (ClassLoader loader : this.getListOfLoaders()) {
                try {
                    URL ret = loader.getResource(name);
                    if (ret == null) continue;
                    return ret;
                }
                catch (Exception e) {
                    Debug.println(this.getClass(), "Error at getResource()", e);
                }
            }
            return this.getClass().getClassLoader().getResource(name);
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            for (ClassLoader loader : this.getListOfLoaders()) {
                try {
                    InputStream ret = loader.getResourceAsStream(name);
                    if (ret == null) continue;
                    return ret;
                }
                catch (Exception e) {
                    Debug.println(this.getClass(), "Error at getResourceAsStream", e);
                }
            }
            return this.getClass().getClassLoader().getResourceAsStream(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            for (ClassLoader loader : this.getListOfLoaders()) {
                try {
                    Enumeration<URL> ret = loader.getResources(name);
                    if (ret == null || !ret.hasMoreElements()) continue;
                    return ret;
                }
                catch (Exception e) {
                    Debug.println(this.getClass(), "Error at getResources", e);
                }
            }
            return this.getClass().getClassLoader().getResources(name);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            for (ClassLoader loader : this.getListOfLoaders()) {
                try {
                    Class<?> ret = loader.loadClass(name);
                    if (ret == null) continue;
                    return ret;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.getClass().getClassLoader().loadClass(name);
        }

        @Override
        public synchronized void setClassAssertionStatus(String className, boolean enabled) {
            for (ClassLoader loader : this.getListOfLoaders()) {
                loader.setClassAssertionStatus(className, enabled);
            }
            this.getClass().getClassLoader().setClassAssertionStatus(className, enabled);
        }

        @Override
        public synchronized void setDefaultAssertionStatus(boolean enabled) {
            for (ClassLoader loader : this.getListOfLoaders()) {
                loader.setDefaultAssertionStatus(enabled);
            }
            this.getClass().getClassLoader().setDefaultAssertionStatus(enabled);
        }

        @Override
        public synchronized void setPackageAssertionStatus(String packageName, boolean enabled) {
            for (ClassLoader loader : this.getListOfLoaders()) {
                loader.setPackageAssertionStatus(packageName, enabled);
            }
            this.getClass().getClassLoader().setPackageAssertionStatus(packageName, enabled);
        }
    }

    private static class SingletonHolder {
        private static final ResourceController INSTANCE = new ResourceController();

        private SingletonHolder() {
        }
    }
}

