/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleValueList<E>
implements List<E> {
    private E value = null;
    private int size = 0;

    private SingleValueList() {
    }

    public SingleValueList(E value, int size) {
        this.value = value;
        if (size < 0) {
            throw new IndexOutOfBoundsException("Size: " + size);
        }
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.size > 0 && this.value.equals(o);
    }

    @Override
    public Iterator<E> iterator() {
        return new SingleValueListIterator();
    }

    @Override
    public Object[] toArray() {
        Object[] ret = new Object[this.size];
        Arrays.fill(ret, this.value);
        return ret;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.toArray();
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException("This is an immutable list containing only " + this.size + " copies of " + this.value);
    }

    @Override
    public boolean remove(Object o) {
        if (this.contains(o)) {
            this.clear();
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        boolean ret = true;
        for (Object object : c) {
            boolean bl = ret = ret && this.contains(object);
            if (!ret) break;
        }
        return ret;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException("This is an immutable list containing only " + this.size + " copies of " + this.value);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException("This is an immutable list containing only " + this.size + " copies of " + this.value);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.isEmpty()) {
            return false;
        }
        if (c.contains(this.value)) {
            this.clear();
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.isEmpty()) {
            return false;
        }
        if (!c.contains(this.value)) {
            this.clear();
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.value = null;
        this.size = 0;
    }

    @Override
    public E get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.value;
    }

    @Override
    public E set(int index, E element) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        E oldValue = this.value;
        this.value = element;
        return oldValue;
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException("This is an immutable list containing only " + this.size + " copies of " + this.value);
    }

    @Override
    public E remove(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        E oldValue = this.value;
        --this.size;
        if (this.size <= 0) {
            this.clear();
        }
        return oldValue;
    }

    @Override
    public int indexOf(Object o) {
        if (this.contains(o)) {
            return 0;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (this.contains(o)) {
            return this.size - 1;
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return new SingleValueListIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new SingleValueListIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        if (fromIndex >= this.size || fromIndex < 0 || toIndex > this.size || toIndex < 0 || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("From: " + fromIndex + ", To: " + toIndex + ", Size: " + this.size);
        }
        return new SingleValueList<E>(this.value, toIndex - fromIndex);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SingleValueListIterator
    implements ListIterator<E> {
        private int index = 0;

        public SingleValueListIterator() {
            this(0);
        }

        public SingleValueListIterator(int index) {
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return this.index < SingleValueList.this.size;
        }

        @Override
        public E next() {
            ++this.index;
            return SingleValueList.this.value;
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public E previous() {
            --this.index;
            return SingleValueList.this.value;
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index;
        }

        @Override
        public void remove() {
            SingleValueList.this.remove(this.index--);
        }

        @Override
        public void set(E e) {
            SingleValueList.this.set(0, e);
        }

        @Override
        public void add(E e) {
            SingleValueList.this.add(this.index, e);
        }
    }
}

