/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.util.datastructure;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node<T> {
    public T data;
    public List<Node<T>> children;
    public Node<T> parent = null;

    public Node() {
    }

    public Node(T data) {
        this();
        this.setData(data);
    }

    public void setParent(Node<T> p) {
        this.parent = p;
    }

    public Node<T> getParent() {
        return this.parent;
    }

    public List<Node<T>> getChildren() {
        if (this.children == null) {
            return new ArrayList<Node<T>>();
        }
        return this.children;
    }

    public void setChildren(List<Node<T>> children) {
        this.children = children;
    }

    public int getNumberOfChildren() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public Node<T> getChild(int index) {
        return this.children.get(index);
    }

    public void addChild(Node<T> child) {
        if (this.children == null) {
            this.children = new ArrayList<Node<T>>();
        }
        this.children.add(child);
        child.setParent(this);
    }

    public void insertChildAt(int index, Node<T> child) throws IndexOutOfBoundsException {
        if (index == this.getNumberOfChildren()) {
            this.addChild(child);
            return;
        }
        this.children.get(index);
        this.children.add(index, child);
    }

    public void removeChildAt(int index) throws IndexOutOfBoundsException {
        this.children.remove(index);
    }

    public void removeAll() {
        if (this.children != null) {
            this.children.removeAll(this.children);
        }
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append(this.getData().toString()).append(",[");
        int i = 0;
        for (Node<T> e : this.getChildren()) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(e.getData().toString());
            ++i;
        }
        sb.append("]").append("}");
        return sb.toString();
    }
}

