/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.util.dseparation.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import unbbayes.prs.INode;
import unbbayes.util.Debug;
import unbbayes.util.dseparation.IDSeparationUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSeparationUtility
implements IDSeparationUtility {
    protected MSeparationUtility() {
    }

    public static MSeparationUtility newInstance() {
        MSeparationUtility ret = new MSeparationUtility();
        return ret;
    }

    public Map<INode, Set<INode>> buildClosedAdjacentNodeMap(Set<INode> allKeys) {
        HashMap<INode, Set<INode>> ret = new HashMap<INode, Set<INode>>();
        for (INode key : allKeys) {
            HashSet<INode> adjacents = new HashSet<INode>();
            for (INode node : key.getParentNodes()) {
                if (!allKeys.contains(node)) continue;
                adjacents.add(node);
            }
            for (INode node : key.getChildNodes()) {
                if (!allKeys.contains(node)) continue;
                adjacents.add(node);
            }
            ret.put(key, adjacents);
        }
        return ret;
    }

    public Map<INode, Set<INode>> makeItMoral(Map<INode, Set<INode>> closedAdjacentNodeMap) {
        for (INode key : closedAdjacentNodeMap.keySet()) {
            List<INode> parents = key.getParentNodes();
            int i = 0;
            while (i < parents.size() - 1) {
                INode parent1 = parents.get(i);
                Set<INode> setForParent1 = closedAdjacentNodeMap.get(parent1);
                if (setForParent1 != null) {
                    int j = i + 1;
                    while (j < parents.size()) {
                        INode parent2 = parents.get(j);
                        Set<INode> setForParent2 = closedAdjacentNodeMap.get(parent2);
                        if (setForParent2 != null) {
                            setForParent1.add(parent2);
                            setForParent2.add(parent1);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return closedAdjacentNodeMap;
    }

    private Set<List<INode>> getRoutesRec(INode from, Set<INode> setTo, Map<INode, Set<INode>> closedAdjacentNodeMap, List<INode> processedPath, Set<INode> nodesNotToContain, int maxRoutes, Set<INode> deadNodes) {
        HashSet<List<INode>> ret = new HashSet<List<INode>>();
        if (maxRoutes <= 0) {
            return ret;
        }
        ArrayList<INode> processingPath = new ArrayList<INode>(processedPath);
        processingPath.add(from);
        Set<INode> adjacentSet = null;
        adjacentSet = closedAdjacentNodeMap != null ? closedAdjacentNodeMap.get(from) : new HashSet<INode>(from.getChildNodes());
        HashSet<INode> deadNodesForMyScope = new HashSet<INode>(deadNodes);
        for (INode adjacent : adjacentSet) {
            if (deadNodes.contains(adjacent) || processingPath.contains(adjacent) || nodesNotToContain.contains(adjacent)) continue;
            if (setTo.contains(adjacent)) {
                ArrayList<INode> path = new ArrayList<INode>(processingPath);
                path.add(adjacent);
                ret.add(path);
                if (--maxRoutes <= 0) break;
                continue;
            }
            Set<List<INode>> rec = this.getRoutesRec(adjacent, setTo, closedAdjacentNodeMap, processingPath, nodesNotToContain, maxRoutes, deadNodesForMyScope);
            if (rec.size() <= 0) {
                deadNodesForMyScope.add(adjacent);
            } else {
                maxRoutes -= rec.size();
            }
            ret.addAll(rec);
        }
        return ret;
    }

    public Set<List<INode>> getRoutes(INode from, INode to, Map<INode, Set<INode>> closedAdjacentNodeMap, Set<INode> nodesNotToContain, int maxRoutes) {
        HashSet<INode> singleSet = new HashSet<INode>(1);
        singleSet.add(to);
        return this.getRoutes(from, singleSet, closedAdjacentNodeMap, nodesNotToContain, maxRoutes);
    }

    public Set<List<INode>> getRoutes(INode from, Set<INode> setTo, Map<INode, Set<INode>> closedAdjacentNodeMap, Set<INode> nodesNotToContain, int maxRoutes) {
        if (setTo.contains(from)) {
            throw new RuntimeException("from == to");
        }
        if (nodesNotToContain == null) {
            nodesNotToContain = new HashSet<INode>();
        }
        return this.getRoutesRec(from, setTo, closedAdjacentNodeMap, new ArrayList<INode>(), nodesNotToContain, maxRoutes, new HashSet<INode>());
    }

    public Set<List<INode>> getRoutes(INode from, INode to, Map<INode, Set<INode>> closedAdjacentNodeMap) {
        return this.getRoutes(from, to, closedAdjacentNodeMap, null, Integer.MAX_VALUE);
    }

    public Set<List<INode>> getRoutes(INode from, INode to) {
        return this.getRoutes(from, to, null, null, Integer.MAX_VALUE);
    }

    private Set<INode> getAllAncestorsRec(INode node, Set<INode> nodesToStop, Set<INode> visited) {
        HashSet<INode> ret = new HashSet<INode>();
        try {
            if (visited.contains(node)) {
                throw new IllegalArgumentException("Cycle found at " + node + ". Visited: " + visited);
            }
            visited.add(node);
            for (INode parent : node.getParentNodes()) {
                if (nodesToStop.contains(parent)) continue;
                ret.add(parent);
                ret.addAll(this.getAllAncestorsRec(parent, nodesToStop, new HashSet<INode>(visited)));
            }
        }
        catch (NullPointerException npe) {
            Debug.println(this.getClass(), npe.getMessage(), npe);
        }
        return ret;
    }

    private Set<INode> getAllDescendantsRec(INode node, Set<INode> nodesToStop, MSeparationUtilityNodeVisitor visitor) {
        HashSet<INode> ret = new HashSet<INode>();
        try {
            for (INode child : node.getChildNodes()) {
                Collection c;
                if (!nodesToStop.contains(child)) {
                    ret.add(child);
                    ret.addAll(this.getAllDescendantsRec(child, nodesToStop, visitor));
                    continue;
                }
                if (visitor == null || (c = visitor.visit(child)) == null) continue;
                ret.addAll(c);
            }
        }
        catch (NullPointerException npe) {
            Debug.println(this.getClass(), npe.getMessage(), npe);
        }
        return ret;
    }

    public Set<INode> getAllAncestors(Set<INode> nodes) {
        return this.getAllAncestors(nodes, null);
    }

    protected Set<INode> getAllAncestors(Set<INode> nodes, Set<INode> nodesToStop) {
        HashSet<INode> ret = new HashSet<INode>();
        if (nodesToStop == null) {
            nodesToStop = new HashSet<INode>(0);
        }
        for (INode node : nodes) {
            ret.addAll(this.getAllAncestorsRec(node, nodesToStop, new HashSet<INode>()));
        }
        return ret;
    }

    public Set<INode> getAllDescendants(Set<INode> nodes) {
        return this.getAllDescendants(nodes, null, null);
    }

    protected Set<INode> getAllDescendants(Set<INode> nodes, Set<INode> nodesToStop, MSeparationUtilityNodeVisitor visitor) {
        HashSet<INode> ret = new HashSet<INode>();
        if (nodesToStop == null) {
            nodesToStop = new HashSet<INode>(0);
        }
        for (INode node : nodes) {
            ret.addAll(this.getAllDescendantsRec(node, nodesToStop, visitor));
        }
        return ret;
    }

    private boolean containsAtLeastOneOf(Collection container, Collection contents) {
        for (Object content : contents) {
            if (!container.contains(content)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDSeparated(Set<INode> consideredNodes, Set<INode> from, Set<INode> to, Set<INode> separators) {
        from = from != null ? new HashSet<INode>(from) : new HashSet<INode>(0);
        to = to != null ? new HashSet<INode>(to) : new HashSet<INode>(0);
        consideredNodes = consideredNodes != null ? new HashSet<INode>(consideredNodes) : new HashSet<INode>(0);
        separators = separators != null ? new HashSet<INode>(separators) : new HashSet<INode>(0);
        if (from.isEmpty()) {
            return false;
        }
        if (to.isEmpty()) {
            return false;
        }
        HashSet<INode> usedNodes = new HashSet<INode>();
        usedNodes.addAll(from);
        usedNodes.addAll(to);
        usedNodes.addAll(separators);
        usedNodes.addAll(this.getAllAncestors(from));
        usedNodes.addAll(this.getAllAncestors(to));
        usedNodes.addAll(this.getAllAncestors(separators));
        Map<INode, Set<INode>> mapRepresentingNonOrientedGraph = this.buildClosedAdjacentNodeMap(usedNodes);
        mapRepresentingNonOrientedGraph = this.makeItMoral(mapRepresentingNonOrientedGraph);
        to.addAll(this.getAllAncestors(to, separators));
        HashSet<INode> reachableSeparators = new HashSet<INode>();
        to.addAll(this.getAllDescendants(to, separators, new MSeparationUtilityNodeVisitor(this, reachableSeparators){

            public Collection visit(Object ... param) {
                ((Set)this.attribute).add(param[0]);
                return null;
            }
        }));
        to.addAll(this.getAllAncestors(reachableSeparators, separators));
        if (this.containsAtLeastOneOf(to, from)) {
            return false;
        }
        for (INode nodeFrom : from) {
            if (this.getRoutes(nodeFrom, to, mapRepresentingNonOrientedGraph, separators, 1).size() <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<INode> getAllDSeparatedNodes(Set<INode> consideredNodes, Set<INode> from, Set<INode> separators) {
        HashSet<INode> ret = new HashSet<INode>();
        from = from != null ? new HashSet<INode>(from) : new HashSet<INode>(0);
        consideredNodes = consideredNodes != null ? new HashSet<INode>(consideredNodes) : new HashSet<INode>(0);
        separators = separators != null ? new HashSet<INode>(separators) : new HashSet<INode>(0);
        if (from.isEmpty()) {
            return ret;
        }
        if (consideredNodes.isEmpty()) {
            return ret;
        }
        HashSet<INode> usedNodes = new HashSet<INode>();
        usedNodes.addAll(from);
        usedNodes.addAll(consideredNodes);
        usedNodes.addAll(separators);
        usedNodes.addAll(this.getAllAncestors(from));
        usedNodes.addAll(this.getAllAncestors(consideredNodes));
        usedNodes.addAll(this.getAllAncestors(separators));
        Map<INode, Set<INode>> mapRepresentingNonOrientedGraph = this.buildClosedAdjacentNodeMap(usedNodes);
        mapRepresentingNonOrientedGraph = this.makeItMoral(mapRepresentingNonOrientedGraph);
        from.addAll(this.getAllAncestors(from, separators));
        HashSet<INode> reachableSeparators = new HashSet<INode>();
        from.addAll(this.getAllDescendants(from, separators, new MSeparationUtilityNodeVisitor(this, reachableSeparators){

            public Collection visit(Object ... param) {
                ((Set)this.attribute).add(param[0]);
                return null;
            }
        }));
        from.addAll(this.getAllAncestors(reachableSeparators, separators));
        consideredNodes.removeAll(from);
        consideredNodes.removeAll(separators);
        for (INode consideredNode : consideredNodes) {
            if (this.getRoutes(consideredNode, from, mapRepresentingNonOrientedGraph, separators, 1).size() <= 0) {
                ret.add(consideredNode);
                continue;
            }
            from.add(consideredNode);
        }
        return ret;
    }

    public abstract class MSeparationUtilityNodeVisitor {
        protected Object attribute;

        public MSeparationUtilityNodeVisitor() {
        }

        public MSeparationUtilityNodeVisitor(Object attribute) {
            this.attribute = attribute;
        }

        public abstract Collection visit(Object ... var1);
    }
}

