/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.util.extension.manager;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ImageIcon;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;
import unbbayes.gui.table.extension.IProbabilityFunctionPanelBuilder;
import unbbayes.util.ApplicationPropertyHolder;
import unbbayes.util.extension.dto.INodeClassDataTransferObject;
import unbbayes.util.extension.dto.impl.NodeDto;
import unbbayes.util.extension.manager.UnBBayesPluginContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreCPFPluginManager {
    private Map<String, Collection<INodeClassDataTransferObject>> nodeNameToDtoMap = new HashMap<String, Collection<INodeClassDataTransferObject>>();
    private UnBBayesPluginContextHolder unbbayesPluginContextHolder = UnBBayesPluginContextHolder.newInstance();
    private String mainExtensionPointID;
    public static final String PARAMETER_CLASS = "class";
    public static final String PARAMETER_NAME = "name";
    public static final String PARAMETER_DESCRIPTION = "description";
    public static final String PARAMETER_ICON = "icon";
    public static final String PARAMETER_PANEL_BUILDER = "panelBuilder";

    protected CoreCPFPluginManager() {
        this.setMainExtensionPointID(ApplicationPropertyHolder.getProperty().getProperty("unbbayes.util.extension.manager.CoreCPFPluginManager.cpfExtensionPointID"));
        if (this.getMainExtensionPointID() == null) {
            System.err.println("Error reading CPF extension point from application.properties. Using default.");
            this.setMainExtensionPointID("ProbabilityFunctionPanel");
        }
        this.getUnbbayesPluginContextHolder().addListener(new UnBBayesPluginContextHolder.OnReloadActionListener(){

            public void onReload(EventObject eventObject) {
                try {
                    CoreCPFPluginManager.this.reloadPlugin();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static CoreCPFPluginManager newInstance() {
        return SingletonHolder.INSTANCE;
    }

    public UnBBayesPluginContextHolder getUnbbayesPluginContextHolder() {
        return this.unbbayesPluginContextHolder;
    }

    public void setUnbbayesPluginContextHolder(UnBBayesPluginContextHolder unbbayesPluginContextHolder) {
        this.unbbayesPluginContextHolder = unbbayesPluginContextHolder;
    }

    public Collection<INodeClassDataTransferObject> getAllLoadedPluginNodes() {
        HashSet<INodeClassDataTransferObject> ret = new HashSet<INodeClassDataTransferObject>();
        for (Collection<INodeClassDataTransferObject> collection : this.getNodeNameToDtoMap().values()) {
            ret.addAll(collection);
        }
        return ret;
    }

    public Collection<INodeClassDataTransferObject> getPluginInformation(String nodeClassName) {
        Collection<INodeClassDataTransferObject> ret = this.getNodeNameToDtoMap().get(nodeClassName);
        if (ret == null) {
            return Collections.EMPTY_LIST;
        }
        return ret;
    }

    public void loadPlugin() throws IOException {
        this.reloadPlugin();
    }

    public void reloadPlugin() throws IOException {
        this.setNodeNameToDtoMap(new HashMap<String, Collection<INodeClassDataTransferObject>>());
        if (!this.getUnbbayesPluginContextHolder().isInitialized()) {
            this.getUnbbayesPluginContextHolder().publishPlugins();
        }
        PluginDescriptor core = this.getUnbbayesPluginContextHolder().getPluginManager().getRegistry().getPluginDescriptor(this.getUnbbayesPluginContextHolder().getPluginCoreID());
        ExtensionPoint point = this.getUnbbayesPluginContextHolder().getPluginManager().getRegistry().getExtensionPoint(core.getId(), this.getMainExtensionPointID());
        Iterator it = point.getConnectedExtensions().iterator();
        while (it.hasNext()) {
            try {
                Collection<INodeClassDataTransferObject> collection;
                Extension ext = (Extension)it.next();
                PluginDescriptor descr = ext.getDeclaringPluginDescriptor();
                this.getUnbbayesPluginContextHolder().getPluginManager().activatePlugin(descr.getId());
                PluginClassLoader classLoader = this.getUnbbayesPluginContextHolder().getPluginManager().getPluginClassLoader(descr);
                Extension.Parameter classParam = ext.getParameter(PARAMETER_CLASS);
                Extension.Parameter descParam = ext.getParameter(PARAMETER_DESCRIPTION);
                Extension.Parameter iconParam = ext.getParameter(PARAMETER_ICON);
                Extension.Parameter nameParam = ext.getParameter(PARAMETER_NAME);
                Extension.Parameter panelParam = ext.getParameter(PARAMETER_PANEL_BUILDER);
                Class<?> panelClass = null;
                panelClass = classLoader.loadClass(panelParam.valueAsString());
                IProbabilityFunctionPanelBuilder panelBuilder = null;
                panelBuilder = (IProbabilityFunctionPanelBuilder)panelClass.newInstance();
                ImageIcon icon = null;
                if (iconParam != null) {
                    URL url = this.getUnbbayesPluginContextHolder().getPluginManager().getPluginClassLoader(ext.getDeclaringPluginDescriptor()).getResource(iconParam.valueAsString());
                    icon = url != null ? new ImageIcon(url) : null;
                }
                NodeDto dto = NodeDto.newInstance();
                dto.setIcon(icon);
                dto.setProbabilityFunctionPanelBuilder(panelBuilder);
                if (nameParam != null) {
                    dto.setName(nameParam.valueAsString());
                }
                if (descParam != null) {
                    dto.setDescription(descParam.valueAsString());
                }
                if ((collection = this.getNodeNameToDtoMap().get(classParam.valueAsString())) == null) {
                    collection = new HashSet<INodeClassDataTransferObject>();
                    this.getNodeNameToDtoMap().put(classParam.valueAsString(), collection);
                }
                collection.add(dto);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    protected void setMainExtensionPointID(String mainExtensionPointID) {
        this.mainExtensionPointID = mainExtensionPointID;
    }

    protected Map<String, Collection<INodeClassDataTransferObject>> getNodeNameToDtoMap() {
        return this.nodeNameToDtoMap;
    }

    protected void setNodeNameToDtoMap(Map<String, Collection<INodeClassDataTransferObject>> nodeNameToDtoMap) {
        this.nodeNameToDtoMap = nodeNameToDtoMap;
    }

    public String getMainExtensionPointID() {
        return this.mainExtensionPointID;
    }

    private static class SingletonHolder {
        private static final CoreCPFPluginManager INSTANCE = new CoreCPFPluginManager();

        private SingletonHolder() {
        }
    }
}

